/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.actions.cslForm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.IBgCslForm;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormAuditIdeaEditUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslViewListAuditProcessUI;
import com.kingdee.eas.ma.bgcsl.client.cslForm.BgCslViewListFormContextManager;
import com.kingdee.eas.ma.mbg.BgAuditIdeaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.utils.MBgExamineClientUtils;
import com.kingdee.eas.ma.mbg.client.utils.MbgCHelper;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class ActionAudit
extends AbstractAction {
    private static final long serialVersionUID = 7160332419757191018L;
    private boolean hasExamineCheck = false;

    protected String getName() {
        return BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"audit");
    }

    protected boolean hasIcon() {
        return true;
    }

    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_audit");
    }

    public void actionPerformed(ActionEvent e) {
        try {
            this.audit();
        }
        catch (Exception ex) {
            this.uiObj.handUIException((Throwable)ex);
        }
    }

    protected void audit() throws Exception {
        Component component = (Component)this.uiObj;
        BgCslViewListAuditProcessUI baseUI = (BgCslViewListAuditProcessUI)this.uiObj;
        BgCslViewListFormContextManager contextManager = (BgCslViewListFormContextManager)baseUI.getContextManager();
        BgCslFormInfo editData = (BgCslFormInfo)contextManager.getProvider().getEditValue();
        String billId = editData.getId().toString();
        int re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"isAuditCsl"));
        if (re == 1 || re == 2) {
            return;
        }
        this.setHasExamineCheck(false);
        MBgExamineClientUtils utils = MBgExamineClientUtils.getInstance();
        if (utils.canExamine(billId)) {
            utils.examineCheck(component, billId, "afterCslAudit", true);
        } else {
            this.setHasExamineCheck(true);
            ArrayList<String> billIds = new ArrayList<String>();
            billIds.add(billId);
            this.afterCslAudit(billIds, null);
        }
    }

    public void afterCslAudit(Object billIds, Object[] params) throws Exception {
        if (billIds == null || !this.isHasExamineCheck() || !(billIds instanceof List)) {
            return;
        }
        List _billIds = (List)billIds;
        UIContext uiContext = new UIContext((Object)this.uiObj);
        uiContext.put((Object)"BGFORM_AUDIT_TYPE", (Object)"BGFORM_AUDIT");
        IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCslFormAuditIdeaEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        ui.show();
        BgCslFormAuditIdeaEditUI editUi = (BgCslFormAuditIdeaEditUI)ui.getUIObject();
        if (editUi.isCancel()) {
            return;
        }
        BgAuditIdeaInfo ideaInfo = (BgAuditIdeaInfo)editUi.getDataObject();
        if (1 == ideaInfo.getState().getValue()) {
            BgAuditIdeaInfo tmpIdea = null;
            CoreBaseCollection ideas = new CoreBaseCollection();
            for (String billId : _billIds) {
                tmpIdea = ideaInfo.getClone();
                tmpIdea.setFormId(BOSUuid.read((String)billId));
                tmpIdea.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                tmpIdea.setCreateTime(tmpIdea.getLastUpdateTime());
                ideas.add((CoreBaseInfo)tmpIdea);
            }
            BgAuditIdeaFactory.getRemoteInstance().addnewBatchData(ideas);
            MsgBox.showInfo((Component)((Component)this.uiObj), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslApproveSetNoPass"));
            return;
        }
        Component component = (Component)this.uiObj;
        Map result = this.getCslInterface().audit(_billIds, editUi.getDataObject(), null);
        Map mutexMap = (Map)result.get("CHECK_NETMUTEX");
        Map workFlowMap = (Map)result.get("CHECK_WORKFLOW");
        Map stateMap = (Map)result.get("CHECK_STATE");
        Map templateSetMap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET");
        Map templateExSetMap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX");
        if (!(mutexMap != null && !mutexMap.isEmpty() || workFlowMap != null && !workFlowMap.isEmpty() || stateMap != null && !stateMap.isEmpty() || templateExSetMap != null && !templateExSetMap.isEmpty() || templateSetMap != null && !templateSetMap.isEmpty())) {
            MsgBox.showInfo((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslApprove"));
            this.uiObj.getUIWindow().close();
            MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)this.uiObj);
        } else {
            int i;
            Object[] msgArr;
            String[] otherStr;
            Object otherMsg;
            int size = 0;
            String detail = "";
            if (mutexMap != null) {
                size = mutexMap.size();
                for (Object[] cslForm : mutexMap.values()) {
                    detail = detail + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslMutex", (Object[])cslForm) + "\r\n";
                }
            }
            if (workFlowMap != null) {
                size += workFlowMap.size();
                for (Object[] cslForm : workFlowMap.values()) {
                    detail = detail + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslWorkFlow", (Object[])cslForm) + "\r\n";
                }
            }
            if (stateMap != null) {
                size += stateMap.size();
                for (Object[] cslForm : stateMap.values()) {
                    detail = detail + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslState", (Object[])cslForm) + "\r\n";
                }
            }
            if (templateSetMap != null) {
                size += templateSetMap.size();
                for (Object[] cslForm : templateSetMap.values()) {
                    otherMsg = cslForm[5];
                    if (((String)otherMsg).indexOf("#") <= 0) continue;
                    otherStr = ((String)otherMsg).split("#");
                    msgArr = new String[2 + otherStr.length];
                    msgArr[0] = cslForm[4];
                    msgArr[1] = cslForm[0];
                    for (i = 0; i < otherStr.length; ++i) {
                        msgArr[i + 2] = otherStr[i];
                    }
                    detail = detail + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"checkBgTemplate_Sequence", (Object[])msgArr) + "\r\n";
                }
            }
            if (templateExSetMap != null) {
                size += templateExSetMap.size();
                for (Object[] cslForm : templateExSetMap.values()) {
                    otherMsg = cslForm[5];
                    if (((String)otherMsg).indexOf("#") <= 0) continue;
                    otherStr = ((String)otherMsg).split("#");
                    msgArr = new String[2 + otherStr.length];
                    msgArr[0] = cslForm[4];
                    msgArr[1] = cslForm[0];
                    for (i = 0; i < otherStr.length; ++i) {
                        msgArr[i + 2] = otherStr[i];
                    }
                    detail = detail + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"checkBgTemplate_Sequence_Ex", (Object[])msgArr) + "\r\n";
                }
            }
            AdvMsgBox msgBox = AdvMsgBox.createAdvMsgBox((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"audit"), (String)(_billIds.size() > size ? BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslPartialApproval") : BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslPartialApprovalNoPass")), (String)detail, (int)2, (int)8188);
            msgBox.show();
        }
    }

    protected IBgCslForm getCslInterface() throws BOSException {
        return BgCslFormFactory.getRemoteInstance();
    }

    public void setHasExamineCheck(boolean hasExamineCheck) {
        this.hasExamineCheck = hasExamineCheck;
    }

    public boolean isHasExamineCheck() {
        return this.hasExamineCheck;
    }
}

