/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.cslTemplate;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.fi.newrpt.client.designer.io.WizzardIO;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.common.IBgCslSpecialInfo;
import com.kingdee.eas.ma.bgcsl.utils.BgSpecialCommonHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpecialWizzardIO
extends WizzardIO {
    private static final long serialVersionUID = 9087912830357671400L;
    private static final Logger logger = CoreUIObject.getLogger(SpecialWizzardIO.class);
    private static final String RESOURCE = "com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource";
    protected BgSchemeDimensionHelper bgSchemeHelper = null;
    protected IBgCslSpecialInfo bgTemplate = null;

    public BgSchemeDimensionHelper getBgSchemeHelper() {
        return this.bgSchemeHelper;
    }

    public IBgCslSpecialInfo getBgTemplate() {
        return this.bgTemplate;
    }

    public SpecialWizzardIO(Dialog parent, SpreadContext context, BgSchemeDimensionHelper bgSchemeHelper, IBgCslSpecialInfo bgTemplate) {
        super(parent, context);
        this.bgSchemeHelper = bgSchemeHelper;
        this.bgTemplate = bgTemplate;
    }

    public SpecialWizzardIO(Frame parent, SpreadContext context, BgSchemeDimensionHelper bgSchemeHelper, IBgCslSpecialInfo bgTemplate) {
        super(parent, context);
        this.bgSchemeHelper = bgSchemeHelper;
        this.bgTemplate = bgTemplate;
    }

    protected boolean checkBgSpeciaItems(Book book) {
        UserObject obj = book.getUserObject("bgSpecialItems");
        if (obj == null) {
            return false;
        }
        List importItemList = (List)obj.getValue();
        Map importItemMap = (Map)importItemList.get(0);
        BgCslSpecialItemsInfo importItem = new BgCslSpecialItemsInfo();
        importItem.setDimensionNumber((String)importItemMap.get("dimensionNumber"));
        importItem.setDimensionName((String)importItemMap.get("dimensionName"));
        importItem.setMemberName(importItemMap.get("memberName").toString());
        importItem.setMemberDisplayName((String)importItemMap.get("memberDisplayName"));
        List<BgDimensionInfo> importDims = BgSpecialCommonHelper.getBgDimensionsBySpecialItems(importItem, this.getBgSchemeHelper());
        HashMap<String, BgDimensionInfo> importMap = new HashMap<String, BgDimensionInfo>();
        for (BgDimensionInfo dim : importDims) {
            importMap.put(dim.getNumber(), dim);
        }
        List<BgDimensionInfo> specialDims = BgSpecialCommonHelper.getBgDimensions(this.getBgTemplate(), this.getBgSchemeHelper());
        HashMap<String, BgDimensionInfo> specialMap = new HashMap<String, BgDimensionInfo>();
        for (Object dim : specialDims) {
            specialMap.put(dim.getNumber(), (BgDimensionInfo)dim);
        }
        if (importMap.size() != specialMap.size()) {
            return false;
        }
        if (!importMap.keySet().containsAll(specialMap.keySet())) {
            return false;
        }
        for (Object dim : importMap.keySet()) {
            BgDimensionInfo importDim = (BgDimensionInfo)importMap.get(dim);
            BgDimensionInfo specialDim = (BgDimensionInfo)specialMap.get(dim);
            if (importDim.getMember().size() != specialDim.getMember().size()) {
                return false;
            }
            if (importDim.getMember().size() == 0 || ((BgDimensionMember)importDim.getMember().get(0)).getNumber().equals(((BgDimensionMember)specialDim.getMember().get(0)).getNumber())) continue;
            return false;
        }
        return true;
    }

    protected void overWriteImport() {
        String clzNameStr = "com.kingdee.eas.fi.newrpt.client.designer.io.WizzardIO$SheetListPanel";
        String filedNameStr = "_book";
        Class<?> pnlClz = null;
        Field bookField = null;
        Class<?>[] clz = WizzardIO.class.getDeclaredClasses();
        for (int i = 0; i < clz.length; ++i) {
            if (!clz[i].getName().equals(clzNameStr)) continue;
            pnlClz = clz[i];
            break;
        }
        if (pnlClz != null) {
            Field[] fields = null;
            fields = pnlClz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(filedNameStr)) continue;
                bookField = fields[i];
                break;
            }
        }
        if (bookField != null) {
            Book book = null;
            bookField.setAccessible(true);
            try {
                book = (Book)bookField.get(this._pnlSheet);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"", (Throwable)e);
            }
            if (!this.checkBgSpeciaItems(book)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"pageitem.unmatch"));
                SysUtil.abort();
            }
            super.overWriteImport();
        }
    }
}

