/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.cslWorkTable;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.uiframe.client.IUIManager;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.ReportProcessException;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialog;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.framework.client.mutex.VOChangeEvent;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberCHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormCollection;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormStateEnum;
import com.kingdee.eas.ma.bgcsl.BgCslQueryPanelCondition;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsCollection;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsFactory;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupCollection;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgEliminationHelper;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperCollection;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperFacadeFactory;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperFactory;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperStateEnum;
import com.kingdee.eas.ma.bgcsl.client.BgCslAdjFormEditUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslAdjFormSpecialProcessUi;
import com.kingdee.eas.ma.bgcsl.client.BgCslEditingNumberUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormEditUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormProcessUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormQueryPanelUI;
import com.kingdee.eas.ma.bgcsl.client.BgCslFormSpecialProcessUi;
import com.kingdee.eas.ma.bgcsl.client.BgCslViewListFormProcessUI;
import com.kingdee.eas.ma.bgcsl.client.MbgWorkPaperProcessUI;
import com.kingdee.eas.ma.bgcsl.client.cslForm.BgCslViewListFormContextManager;
import com.kingdee.eas.ma.bgcsl.client.cslWorkTable.BgMultiRptPropertiesManager;
import com.kingdee.eas.ma.bgcsl.client.cslWorkTable.BgSingleRptProperties;
import com.kingdee.eas.ma.bgcsl.client.cslWorkTable.KDTabbedPaneExt;
import com.kingdee.eas.ma.bgcsl.client.cslWorkTable.KingdeeTabbedPaneExtUI;
import com.kingdee.eas.ma.bgcsl.client.utils.BgCslClientHelper;
import com.kingdee.eas.ma.bgcsl.client.workPaper.MbgWorkPaperContextManager;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.bgcsl.common.BgCslTemplateHelper;
import com.kingdee.eas.ma.bgcsl.common.IBgCslSpecialInfo;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.template.ViewListBookContextManager;
import com.kingdee.eas.ma.mbg.designer.IActionManager;
import com.kingdee.eas.ma.mbg.designer.IContextManager;
import com.kingdee.eas.ma.mbg.designer.IMenuManager;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BgCslWorkTableProcessUI
extends BgSpreadCoreViewUI {
    private static final long serialVersionUID = 665231860798258030L;
    private KDSplitPane splitpane;
    private BgCslFormQueryPanelUI queryPanel;
    protected KDTabbedPaneExt tabpane = null;
    private MbgWorkPaperProcessUI mbgWorkPaper = null;
    private BgCslFormProcessUI bgCslForm = null;
    private BgCslViewListFormProcessUI bgCslViewListForm = null;
    private BgCslFormSpecialProcessUi bgCslFormSpecial = null;
    protected BgCslAdjFormSpecialProcessUi bgCslAdjFormSpecial = null;
    protected int type;
    private boolean isOnLoad = false;
    private final BgMultiRptPropertiesManager manager = new BgMultiRptPropertiesManager();
    protected KDToolBar preToolBar;
    private Component closeBtn;
    private final int limited = 10;
    BgSingleRptProperties rptpro = null;
    private int tabid = -1;
    private BgSchemeDimensionHelper schemeHelper = null;

    protected void initTabbledPane() throws Exception {
        this.tabpane = new KDTabbedPaneExt();
        this.initSplitPane();
    }

    private void initSplitPane() throws Exception {
        this.createFormQueryPanelUI();
        this.splitpane = new KDSplitPane(1, (Component)((Object)this.queryPanel), (Component)((Object)this.tabpane));
        this.splitpane.setOneTouchExpandable(true);
        this.splitpane.setArrowType(1);
        this.splitpane.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.splitpane.setDividerLocation(280);
        this.add((Component)this.splitpane, "Center");
        this.removeClashKeyStroke();
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    public int getRptProSize() {
        if (this.manager != null && this.manager.getBgMultiRptPro() != null) {
            return this.manager.getBgMultiRptPro().size();
        }
        return 0;
    }

    public void onLoad() throws Exception {
        this.initLayout();
        this.initTabbledPane();
        this.initEventListener();
        this.addNewTab();
        if (!this.isOnLoad) {
            this.initRptSelfProperties(true);
        }
        this.isOnLoad = true;
    }

    private void addNewTab() throws Exception {
        this.rptpro = new BgSingleRptProperties();
        this.init();
        this.initBar();
        if (this.type == 1 || this.type == 3) {
            this.initCslWTSpreadProcessUI();
        } else {
            this.initReoprtLayout();
            this.setCommonBgCslRptTitle();
        }
    }

    private void createFormQueryPanelUI() throws Exception {
        if (null == this.queryPanel) {
            BgCslQueryPanelCondition condition = new BgCslQueryPanelCondition();
            condition.setOwner(this);
            condition.setOrgTreeInfo((OrgTreeInfo)this.getUIContext().get("orgTreeInfo"));
            condition.setSchemeInfo((BgSchemeInfo)this.getUIContext().get("BGSCHEME_INFO"));
            condition.setOrgUnitInfo((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
            condition.setBgPeriodInfo((BgPeriodInfo)this.getUIContext().get("CSL_BGPERIOD"));
            condition.setCurrencyInfo((CurrencyInfo)this.getUIContext().get("CSL_CURRENCY"));
            condition.setBgVersionInfo((BgVersionInfo)this.getUIContext().get("CSL_BGVERSION"));
            this.queryPanel = new BgCslFormQueryPanelUI(condition);
        }
    }

    public void removeClashKeyStroke() {
        this.splitpane.getInputMap(1).getParent().remove(KeyStroke.getKeyStroke("F8"));
    }

    public void openForm() {
        ReportBaseInfo info;
        int state;
        BgCslQueryPanelCondition condition = this.queryPanel.getCurrentCondition();
        ReportBaseInfo reportBaseInfo = null;
        try {
            reportBaseInfo = this.queryFormByCondition(condition);
            if (null == reportBaseInfo) {
                BgCslClientHelper.checkFilled(condition.getSchemeInfo().getId().toString());
                reportBaseInfo = this.createFormByCondition(condition);
            }
        }
        catch (Exception var) {
            this.handUIException(var);
        }
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(reportBaseInfo.getId().toString());
        ArrayList<String> tmplTypes = new ArrayList<String>(1);
        BgTemFormTypeEnum formType = null;
        if (reportBaseInfo instanceof MbgWorkPaperInfo) {
            state = ((MbgWorkPaperInfo)reportBaseInfo).getBizState();
            tmplTypes.add("worktemplate");
        } else if (reportBaseInfo instanceof BgCslFormInfo) {
            info = (BgCslFormInfo)reportBaseInfo;
            formType = info.getFormType();
            state = info.getBizState();
            tmplTypes.add("csltemplate");
        } else {
            info = (BgCslAdjFormInfo)reportBaseInfo;
            formType = info.getFormType();
            state = info.getBizState();
            tmplTypes.add("csladjtemplate");
        }
        ArrayList<BgTemFormTypeEnum> formTypes = new ArrayList<BgTemFormTypeEnum>(1);
        if (null != formType) {
            formTypes.add(formType);
        }
        this.openReportsFromListUI(ids, tmplTypes, formTypes, new ArrayList(), true, this.getOprtStatusByPermission(state, condition, ids), condition.getBgPeriodInfo().getNumber());
    }

    private String getOprtStatusByPermission(int state, BgCslQueryPanelCondition condition, List<String> ids) {
        String oprtState;
        block4: {
            oprtState = OprtState.EDIT;
            OrgUnitInfo orgUnitInfo = condition.getOrgUnitInfo();
            if (1 == state) {
                try {
                    BgPermissionUtil.checkPermission((OrgUnitInfo)orgUnitInfo, (String)"csl_bgCslWorkTable03_edit");
                    BgCslClientHelper.checkFilled(condition.getSchemeInfo().getId().toString());
                    if (!MBgCheckHelper.requestMutex(null, ids, (boolean)true).isEmpty()) {
                        return OprtState.VIEW;
                    }
                    break block4;
                }
                catch (Exception var0) {
                    return this.checkViewPermission(orgUnitInfo);
                }
            }
            return this.checkViewPermission(orgUnitInfo);
        }
        return oprtState;
    }

    private String checkViewPermission(OrgUnitInfo orgUnitInfo) {
        try {
            BgPermissionUtil.checkPermission((OrgUnitInfo)orgUnitInfo, (String)"csl_bgCslWorkTable02_view");
        }
        catch (Exception var1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslWorkTableResource", (String)"notViewPermission"));
            SysUtil.abort();
        }
        return OprtState.VIEW;
    }

    private ReportBaseInfo createFormByCondition(BgCslQueryPanelCondition condition) throws Exception {
        VirtualSheetParamInfo templateInfo = condition.getTemplateInfo();
        String bgSchemeId = condition.getSchemeInfo().getId().toString();
        String orgUnitId = condition.getOrgUnitInfo().getId().toString();
        String currencyId = condition.getCurrencyInfo().getId().toString();
        String bgVersionId = condition.getBgVersionInfo().getId().toString();
        String bgPeriodId = condition.getBgPeriodInfo().getId().toString();
        BgPermissionUtil.checkPermission((OrgUnitInfo)condition.getOrgUnitInfo(), (String)"csl_bgCslWorkTable11_addNew");
        if (templateInfo instanceof BgNWorkTemplateInfo) {
            return this.createWorkPaperFormByCondition(condition);
        }
        if (templateInfo instanceof BgCslTemplateInfo) {
            String itemNumber = this.getSpecialItemsNumber(condition);
            BgCslFormEditUI.checkRepeat((CoreUI)this, bgSchemeId, orgUnitId, templateInfo.getId().toString(), bgPeriodId, currencyId, bgVersionId, itemNumber);
            return this.createBgCslFormByCondition(condition);
        }
        String itemNumber = this.getSpecialItemsNumber(condition);
        BgCslAdjFormEditUI.checkRepeat((CoreUI)this, bgSchemeId, orgUnitId, templateInfo.getId().toString(), bgPeriodId, currencyId, bgVersionId, itemNumber);
        return this.createBgCslAdjFormByCondition(condition);
    }

    private String getSpecialItemsNumber(BgCslQueryPanelCondition condition) {
        BgCslSpecialItemsCollection bgSpecialItems = condition.getBgSpecialItems();
        String itemNumber = null;
        if (bgSpecialItems != null && !bgSpecialItems.isEmpty() && bgSpecialItems.get(0) != null) {
            itemNumber = bgSpecialItems.get(0).getDimensionNumber();
        }
        return itemNumber;
    }

    public BgSchemeDimensionHelper getSchemeHelper(String schemeId) throws EASBizException, BOSException {
        if (this.schemeHelper == null && schemeId != null) {
            this.schemeHelper = new BgCslSchemeDimensionHelper(schemeId);
        }
        return this.schemeHelper;
    }

    private String setTxtName(BgCslQueryPanelCondition condition, int txtNameMaxLength) {
        String name = condition.getBgPeriodInfo().getName() + "-" + condition.getTemplateInfo().getName() + "-" + condition.getBgVersionInfo().getName();
        if (name.length() > txtNameMaxLength) {
            name = name.substring(0, txtNameMaxLength);
        }
        return name;
    }

    private ReportBaseInfo createBgCslAdjFormByCondition(BgCslQueryPanelCondition condition) throws Exception {
        Book book;
        BgCslAdjFormInfo info = new BgCslAdjFormInfo();
        this.setBasePojo(condition, info);
        info.setOrgTree(condition.getOrgTreeInfo());
        info.setOrgUnit(condition.getOrgUnitInfo().castToFullOrgUnitInfo());
        info.setBgScheme(condition.getSchemeInfo());
        info.setBgPeriod(condition.getBgPeriodInfo());
        info.setBgVersion(condition.getBgVersionInfo());
        info.setState(BgCslFormStateEnum.EDIT);
        CompanyOrgUnitInfo companyInfo = null;
        try {
            companyInfo = BgCslTemplateHelper.getCompanyByOrgUnit(null, (OrgUnitInfo)info.getOrgUnit());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (companyInfo != null) {
            info.setCompany(companyInfo);
        } else {
            companyInfo = SysContext.getSysContext().getCurrentFIUnit();
            if (companyInfo != null) {
                info.setCompany(companyInfo);
            }
        }
        info.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        info.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        info.setPeriodType(RptPeriodTypeEnum.YEARLY);
        info.setOrgType(OrgType.UnionDebt);
        BgCslAdjTemplateInfo templateInfo = (BgCslAdjTemplateInfo)condition.getTemplateInfo();
        info.setBgCslTemplate(templateInfo);
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)info.getBgCslTemplate().getFormType())) {
            BgCslSpecialItemsCollection bgSpecialItems = this.getNewBgSpecialItems(condition, info);
            info.getBgSpecialItems().addCollection(bgSpecialItems);
        }
        if ((book = templateInfo.getBook()) != null) {
            BgNExpressionHelper.dealAcctExpressionAtAddNew(null, (Book)book, (IObjectValue)info, (int)0);
            BgCslFormHelper.processNewBook(book, info, this.getSchemeHelper(condition.getSchemeInfo().getId().toString()));
            info.setData(IOHelper.packBook((Book)book));
        }
        info.setDimensionData(templateInfo.getDimensionData());
        if (info.getBgPeriod() != null) {
            info.setBgPeriod(BgPeriodFactory.getRemoteInstance().getBgPeriodInfo((IObjectPK)new ObjectUuidPK(info.getBgPeriod().getId())));
        }
        BgNFSHelper.synPeriod((ReportBaseInfo)info, (BgPeriodInfo)info.getBgPeriod());
        BgCslAdjFormEditUI.setMeasureUnit(templateInfo, info);
        BgCslAdjFormFactory.getRemoteInstance().submit((CoreBaseInfo)info);
        return info;
    }

    private BgCslSpecialItemsCollection getNewBgSpecialItems(BgCslQueryPanelCondition condition, IBgCslSpecialInfo info) {
        BgCslSpecialItemsCollection bgSpecialItems = condition.getBgSpecialItems();
        Iterator iterator = bgSpecialItems.iterator();
        while (iterator.hasNext()) {
            BgCslSpecialItemsInfo specialItemsInfo = (BgCslSpecialItemsInfo)iterator.next();
            specialItemsInfo.setId(BOSUuid.create((BOSObjectType)specialItemsInfo.getBOSType()));
            specialItemsInfo.setBgAdjTemplate(null);
            specialItemsInfo.setBgTemplate(null);
            info.setRefObject(specialItemsInfo);
            BgCslSpecialRelationGroupCollection dimRelaGroupRef = specialItemsInfo.getDimRelaGroupRef();
            int in = dimRelaGroupRef.size();
            for (int i = 0; i < in; ++i) {
                BgCslSpecialRelationGroupInfo bgCslSpecialRelationGroupInfo = dimRelaGroupRef.get(i);
                bgCslSpecialRelationGroupInfo.setId(BOSUuid.create((BOSObjectType)bgCslSpecialRelationGroupInfo.getBOSType()));
                bgCslSpecialRelationGroupInfo.setBgSpecialItems(specialItemsInfo);
            }
        }
        return bgSpecialItems;
    }

    private ReportBaseInfo createBgCslFormByCondition(BgCslQueryPanelCondition condition) throws Exception {
        BgCslFormInfo info = new BgCslFormInfo();
        this.setBasePojo(condition, info);
        info.setOrgTree(condition.getOrgTreeInfo());
        info.setOrgUnit(condition.getOrgUnitInfo().castToFullOrgUnitInfo());
        info.setBgScheme(condition.getSchemeInfo());
        info.setBgPeriod(condition.getBgPeriodInfo());
        info.setBgVersion(condition.getBgVersionInfo());
        info.setState(BgCslFormStateEnum.EDIT);
        CompanyOrgUnitInfo companyInfo = null;
        try {
            companyInfo = BgCslTemplateHelper.getCompanyByOrgUnit(null, (OrgUnitInfo)info.getOrgUnit());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (companyInfo != null) {
            info.setCompany(companyInfo);
        } else {
            companyInfo = SysContext.getSysContext().getCurrentFIUnit();
            if (companyInfo != null) {
                info.setCompany(companyInfo);
            }
        }
        info.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        info.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        info.setPeriodType(RptPeriodTypeEnum.YEARLY);
        info.setOrgType(OrgType.UnionDebt);
        BgCslTemplateInfo templateInfo = (BgCslTemplateInfo)condition.getTemplateInfo();
        info.setBgCslTemplate(templateInfo);
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)info.getBgCslTemplate().getFormType())) {
            BgCslSpecialItemsCollection bgSpecialItems = this.getNewBgSpecialItems(condition, info);
            info.getBgSpecialItems().addCollection(bgSpecialItems);
        }
        BgCslFormEditUI.setBookAndPeriod(templateInfo, info);
        BgCslFormEditUI.setMeasureUnit(templateInfo, info);
        BgCslFormEditUI.setDimensionData4ViewList(templateInfo, info);
        BgCslFormFactory.getRemoteInstance().submit((CoreBaseInfo)info);
        return info;
    }

    private ReportBaseInfo createWorkPaperFormByCondition(BgCslQueryPanelCondition condition) throws BOSException, EASBizException {
        MbgWorkPaperInfo info = new MbgWorkPaperInfo();
        this.setBasePojo(condition, info);
        info.setOrgTree(condition.getOrgTreeInfo());
        info.setBgScheme(condition.getSchemeInfo());
        info.setBgPeriod(condition.getBgPeriodInfo());
        info.setBgNWorkTemplate((BgNWorkTemplateInfo)condition.getTemplateInfo());
        info.setBgVersion(condition.getBgVersionInfo());
        info.setCurrency(condition.getCurrencyInfo());
        BgNFSHelper.synPeriod((ReportBaseInfo)info, (BgPeriodInfo)condition.getBgPeriodInfo());
        info.setState(MbgWorkPaperStateEnum.EDIT);
        info.setOrgUnit(condition.getOrgUnitInfo().castToFullOrgUnitInfo());
        DefaultKingdeeTreeNode rootNode = BgEliminationHelper.getUnionDebtTree(condition.getOrgUnitInfo(), condition.getOrgTreeInfo(), false, false);
        List orgList = this.traceOrgTree(rootNode, null);
        MbgWorkPaperFacadeFactory.getRemoteInstance().addNewMbgWorkPaper(info, orgList);
        return info;
    }

    private List traceOrgTree(DefaultKingdeeTreeNode node, List orgList) {
        if (orgList == null) {
            orgList = new ArrayList<FullOrgUnitInfo>();
        }
        DefaultKingdeeTreeNode sub = null;
        OrgStructureInfo orgStruct = null;
        if (!node.isLeaf()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                sub = (DefaultKingdeeTreeNode)node.getChildAt(i);
                orgStruct = (OrgStructureInfo)sub.getUserObject();
                orgList.add(orgStruct.getUnit());
            }
        }
        return orgList;
    }

    private void setBasePojo(BgCslQueryPanelCondition condition, ReportBaseInfo info) throws BOSException {
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setName(this.setTxtName(condition, 80));
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setSourceType(RptSrcTypeEnum.PT_BUDGET_REPORT);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setStartDate(new Date());
        info.setAuditTime(new Timestamp(System.currentTimeMillis()));
        info.setEndDate(info.getStartDate());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setCurrency(condition.getCurrencyInfo());
        this.applyCodeNumber(condition, info);
    }

    private void applyCodeNumber(BgCslQueryPanelCondition condition, ReportBaseInfo info) throws BOSException {
        try {
            BgCodeNumberHelper numberCodeHelper = new BgCodeNumberHelper(null, null, "sourceType");
            BgCodeNumberHelper nameCodeHelper = new BgCodeNumberHelper(null, "name", "sourceType");
            String orgUnitId = condition.getOrgUnitInfo().getId().toString();
            numberCodeHelper.init((IObjectValue)info, orgUnitId);
            nameCodeHelper.init((IObjectValue)info, orgUnitId);
            if (numberCodeHelper.isHasCodeNumber() && StringUtils.isEmpty((String)info.getNumber())) {
                try {
                    this.getNumberByCodingRule((IObjectValue)info, orgUnitId, numberCodeHelper, nameCodeHelper);
                }
                catch (Exception e) {
                    this.showUI(condition, info);
                }
            } else {
                this.showUI(condition, info);
            }
        }
        catch (Exception e) {
            SysUtil.abort();
        }
    }

    private void showUI(BgCslQueryPanelCondition condition, ReportBaseInfo info) {
        int choice = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslWorkTableResource", (String)"notFoundCodeNumber"));
        if (MsgBox.isYes((int)choice)) {
            this.showEditingNumberUI(condition, info);
        } else {
            SysUtil.abort();
        }
    }

    private void showEditingNumberUI(BgCslQueryPanelCondition condition, ReportBaseInfo info) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"condition", (Object)condition);
        IUIWindow ui = null;
        try {
            ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCslEditingNumberUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        }
        catch (UIException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        ui.show();
        if (((BgCslEditingNumberUI)ui.getUIObject()).isCancle()) {
            SysUtil.abort();
        }
        VirtualSheetParamInfo data = ((BgCslEditingNumberUI)ui.getUIObject()).getData();
        info.setName(data.getName());
        info.setNumber(data.getNumber());
        info.setDescription(data.getDescription());
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId, BgCodeNumberHelper numberCodeHelper, BgCodeNumberHelper nameCodeHelper) throws EASBizException, BOSException {
        BgCodeNumberCHelper.getNumberByCodingRule(null, (IObjectValue)caller, (String)orgId, (BgCodeNumberHelper)numberCodeHelper);
        BgCodeNumberCHelper.getNumberByCodingRule(null, (IObjectValue)caller, (String)orgId, (BgCodeNumberHelper)nameCodeHelper);
    }

    private ReportBaseInfo queryFormByCondition(BgCslQueryPanelCondition condition) throws BOSException {
        VirtualSheetParamInfo templateInfo = condition.getTemplateInfo();
        EntityViewInfo viewInfo = this.retrunEntityViewInfo(condition);
        String templateId = condition.getTemplateInfo().getId().toString();
        if (templateInfo instanceof BgNWorkTemplateInfo) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("bgNWorkTemplate.id", (Object)templateId, CompareType.EQUALS));
            MbgWorkPaperCollection col = MbgWorkPaperFactory.getRemoteInstance().getMbgWorkPaperCollection(viewInfo);
            if (null == col || col.isEmpty()) {
                return null;
            }
            return col.get(0);
        }
        if (templateInfo instanceof BgCslTemplateInfo) {
            if (StringUtils.isEmpty((String)this.getSpecialItemsNumber(condition))) {
                viewInfo.getSelector().add("bgCslTemplate.formType");
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("bgCslTemplate.id", (Object)templateId, CompareType.EQUALS));
                BgCslFormCollection col = BgCslFormFactory.getRemoteInstance().getBgCslFormCollection(viewInfo);
                if (null == col || col.isEmpty()) {
                    return null;
                }
                return col.get(0);
            }
            return this.getSpecialForm(condition, false);
        }
        if (StringUtils.isEmpty((String)this.getSpecialItemsNumber(condition))) {
            viewInfo.getSelector().add("bgCslTemplate.formType");
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("bgCslTemplate.id", (Object)templateId, CompareType.EQUALS));
            BgCslAdjFormCollection col = BgCslAdjFormFactory.getRemoteInstance().getBgCslAdjFormCollection(viewInfo);
            if (null == col || col.isEmpty()) {
                return null;
            }
            return col.get(0);
        }
        return this.getSpecialForm(condition, true);
    }

    private ReportBaseInfo getSpecialForm(BgCslQueryPanelCondition condition, boolean isBgCslAdjForm) throws BOSException {
        String bgSchemeId = condition.getSchemeInfo().getId().toString();
        String orgUnitId = condition.getOrgUnitInfo().getId().toString();
        String templateId = condition.getTemplateInfo().getId().toString();
        String bgPeriodId = condition.getBgPeriodInfo().getId().toString();
        String currencyId = condition.getCurrencyInfo().getId().toString();
        String bgVersionId = condition.getBgVersionInfo().getId().toString();
        if (isBgCslAdjForm) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add("bgAdjForm.id");
            viewInfo.getSelector().add("bgAdjForm.state");
            viewInfo.getSelector().add("bgAdjForm.bgCslTemplate.formType");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgAdjForm.bgScheme.id", (Object)bgSchemeId));
            filter.getFilterItems().add(new FilterItemInfo("bgAdjForm.orgUnit.id", (Object)orgUnitId));
            filter.getFilterItems().add(new FilterItemInfo("bgAdjForm.bgCslTemplate.id", (Object)templateId));
            filter.getFilterItems().add(new FilterItemInfo("bgAdjForm.bgPeriod.id", (Object)bgPeriodId));
            filter.getFilterItems().add(new FilterItemInfo("bgAdjForm.currency.id", (Object)currencyId));
            filter.getFilterItems().add(new FilterItemInfo("bgAdjForm.bgVersion.id", (Object)bgVersionId));
            filter.getFilterItems().add(new FilterItemInfo("dimensionNumber", (Object)this.getSpecialItemsNumber(condition)));
            viewInfo.setFilter(filter);
            BgCslSpecialItemsCollection col = BgCslSpecialItemsFactory.getRemoteInstance().getBgCslSpecialItemsCollection(viewInfo);
            if (null == col || col.isEmpty()) {
                return null;
            }
            return col.get(0).getBgAdjForm();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add("bgForm.id");
        viewInfo.getSelector().add("bgForm.state");
        viewInfo.getSelector().add("bgForm.bgCslTemplate.formType");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgForm.bgScheme.id", (Object)bgSchemeId));
        filter.getFilterItems().add(new FilterItemInfo("bgForm.orgUnit.id", (Object)orgUnitId));
        filter.getFilterItems().add(new FilterItemInfo("bgForm.bgCslTemplate.id", (Object)templateId));
        filter.getFilterItems().add(new FilterItemInfo("bgForm.bgPeriod.id", (Object)bgPeriodId));
        filter.getFilterItems().add(new FilterItemInfo("bgForm.currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("bgForm.bgVersion.id", (Object)bgVersionId));
        filter.getFilterItems().add(new FilterItemInfo("dimensionNumber", (Object)this.getSpecialItemsNumber(condition)));
        viewInfo.setFilter(filter);
        BgCslSpecialItemsCollection col = BgCslSpecialItemsFactory.getRemoteInstance().getBgCslSpecialItemsCollection(viewInfo);
        if (null == col || col.isEmpty()) {
            return null;
        }
        return col.get(0).getBgForm();
    }

    private EntityViewInfo retrunEntityViewInfo(BgCslQueryPanelCondition condition) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add("id");
        viewInfo.getSelector().add("state");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)condition.getSchemeInfo().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)condition.getBgVersionInfo().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)condition.getBgPeriodInfo().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyInfo().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)condition.getOrgTreeInfo().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)condition.getOrgUnitInfo().getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void initRptSelfProperties(boolean isNewRpt) throws Exception {
        if (isNewRpt) {
            this.manager.putRptPro(this.tabpane.getSeletedTabCtxId(), this.rptpro);
        } else {
            if (!this.manager.hasRptProperties(this.tabpane.getSeletedTabCtxId())) {
                this.manager.putRptPro(this.tabpane.getSeletedTabCtxId(), this.rptpro);
            }
            BgSingleRptProperties rptpro = this.manager.getRptProperties(this.tabpane.getSeletedTabCtxId());
            this.setOprtState(rptpro.getOprtStatus());
            this.initProcessUI(rptpro);
            this.changeBar(rptpro);
            this.setTitle();
            this.replaceCompanent(rptpro);
        }
    }

    private void replaceCompanent(BgSingleRptProperties rptpro) {
        if (rptpro.getPageDimensionPanel() == null) {
            this.tabpane.setSelectedComponent((Component)rptpro.getManage().getSpreadContainer());
        } else {
            this.tabpane.setSelectedComponent(rptpro.getPageDimensionPanel());
        }
    }

    private void changeBar(BgSingleRptProperties rptpro) {
        this.setUIMenuBar(rptpro.getMenuBar());
        this.setUIToolBar(rptpro.getToolBar());
        this.setStatusBar(rptpro.getStatusBar());
        this.remove((Component)this.preToolBar);
        KDToolBar toolBar = rptpro.getSpreadToolBar();
        this.add((Component)toolBar, "North");
        toolBar.validate();
        this.preToolBar = toolBar;
        this.initCommToolBarManager();
    }

    private void initProcessUI(BgSingleRptProperties rptpro) {
        this.type = rptpro.getType();
        Object processui = rptpro.getProcessUI();
        if (this.type == 1) {
            this.mbgWorkPaper = (MbgWorkPaperProcessUI)processui;
        } else if (this.type == 2) {
            this.bgCslForm = (BgCslFormProcessUI)processui;
        } else if (this.type == 3) {
            this.bgCslViewListForm = (BgCslViewListFormProcessUI)processui;
        } else if (this.type == 4) {
            this.bgCslFormSpecial = (BgCslFormSpecialProcessUi)processui;
        } else if (this.type == 5) {
            this.bgCslAdjFormSpecial = (BgCslAdjFormSpecialProcessUi)processui;
        }
    }

    private void init() throws Exception {
        String tmplType = (String)this.getUIContext().get("tmplType");
        if ("worktemplate".equals(tmplType)) {
            this.initWorkPaper();
        } else if ("csltemplate".equals(tmplType)) {
            this.initCslRpt();
        } else {
            this.initAdjCslRpt();
        }
        String period = (String)this.getUIContext().get("period");
        this.rptpro.setTmplType(tmplType);
        this.rptpro.setPeriod(period);
    }

    private void initWorkPaper() throws Exception {
        this.type = 1;
        this.mbgWorkPaper = new MbgWorkPaperProcessUI();
        this.mbgWorkPaper.getUIContext().put("Owner", this);
        this.mbgWorkPaper.getUIContext().put("BGSCHEME_INFO", this.getUIContext().get("BGSCHEME_INFO"));
        this.mbgWorkPaper.getUIContext().put("BGSCHEME_ID", this.getUIContext().get("BGSCHEME_ID"));
        this.mbgWorkPaper.getUIContext().put("ID", this.getUIContext().get("ID"));
        this.mbgWorkPaper.getUIContext().put(BgBaseConstants.ORGUNIT_INFO, this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        this.mbgWorkPaper.getUIContext().put("orgTreeInfo", this.getUIContext().get("orgTreeInfo"));
        this.mbgWorkPaper.getUIContext().put("processDialog", true);
        this.mbgWorkPaper.getUIContext().put("ifRefresh", true);
        this.mbgWorkPaper.setOprtState(this.getOprtState());
        this.mbgWorkPaper.initLayout();
        this.mbgWorkPaper.onLoad();
        this.registParentCom((CoreUI)this.mbgWorkPaper);
        this.rptpro.setOprtStatus(this.getOprtState());
        this.rptpro.setProcessUI(this.mbgWorkPaper);
        this.rptpro.setType(this.type);
        this.rptpro.setRptid((String)this.getUIContext().get("ID"));
    }

    private void initCslRpt() throws Exception {
        BgTemFormTypeEnum formTypeEnum = (BgTemFormTypeEnum)this.getUIContext().get("formType");
        int formType = formTypeEnum.getValue();
        switch (formType) {
            case 0: {
                this.type = 2;
                this.bgCslForm = new BgCslFormProcessUI();
                this.bgCslForm.getUIContext().put("Owner", this);
                this.bgCslForm.getUIContext().put("BGSCHEME_INFO", this.getUIContext().get("BGSCHEME_INFO"));
                this.bgCslForm.getUIContext().put("BGSCHEME_ID", this.getUIContext().get("BGSCHEME_ID"));
                this.bgCslForm.getUIContext().put("ID", this.getUIContext().get("ID"));
                this.bgCslForm.getUIContext().put(BgBaseConstants.ORGUNIT_INFO, this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
                this.bgCslForm.getUIContext().put("orgTreeInfo", this.getUIContext().get("orgTreeInfo"));
                this.bgCslForm.getUIContext().put("ifRefresh", true);
                this.bgCslForm.setOprtState(this.getOprtState());
                this.bgCslForm.initLayout();
                this.bgCslForm.onLoad();
                this.registParentCom((CoreUI)this.bgCslForm);
                this.rptpro.setOprtStatus(this.getOprtState());
                this.rptpro.setProcessUI(this.bgCslForm);
                this.rptpro.setType(this.type);
                this.rptpro.setRptid((String)this.getUIContext().get("ID"));
                break;
            }
            case 2: {
                this.type = 3;
                this.bgCslViewListForm = new BgCslViewListFormProcessUI();
                this.bgCslViewListForm.getUIContext().put("Owner", this);
                this.bgCslViewListForm.getUIContext().put("BGSCHEME_INFO", this.getUIContext().get("BGSCHEME_INFO"));
                this.bgCslViewListForm.getUIContext().put("BGSCHEME_ID", this.getUIContext().get("BGSCHEME_ID"));
                this.bgCslViewListForm.getUIContext().put("ID", this.getUIContext().get("ID"));
                this.bgCslViewListForm.getUIContext().put(BgBaseConstants.ORGUNIT_INFO, this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
                this.bgCslViewListForm.getUIContext().put("orgTreeInfo", this.getUIContext().get("orgTreeInfo"));
                this.bgCslViewListForm.getUIContext().put("ifRefresh", true);
                this.bgCslViewListForm.setOprtState(this.getOprtState());
                this.bgCslViewListForm.initLayout();
                this.bgCslViewListForm.onLoad();
                this.registParentCom((CoreUI)this.bgCslViewListForm);
                this.rptpro.setOprtStatus(this.getOprtState());
                this.rptpro.setProcessUI(this.bgCslViewListForm);
                this.rptpro.setType(this.type);
                this.rptpro.setRptid((String)this.getUIContext().get("ID"));
                break;
            }
            case 8: {
                this.type = 4;
                this.bgCslFormSpecial = new BgCslFormSpecialProcessUi();
                this.bgCslFormSpecial.getUIContext().put("Owner", this);
                this.bgCslFormSpecial.getUIContext().put("BGSCHEME_INFO", this.getUIContext().get("BGSCHEME_INFO"));
                this.bgCslFormSpecial.getUIContext().put("BGSCHEME_ID", this.getUIContext().get("BGSCHEME_ID"));
                this.bgCslFormSpecial.getUIContext().put("ID", this.getUIContext().get("ID"));
                this.bgCslFormSpecial.getUIContext().put(BgBaseConstants.ORGUNIT_INFO, this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
                this.bgCslFormSpecial.getUIContext().put("orgTreeInfo", this.getUIContext().get("orgTreeInfo"));
                this.bgCslFormSpecial.getUIContext().put("ifRefresh", true);
                this.bgCslFormSpecial.setOprtState(this.getOprtState());
                this.bgCslFormSpecial.initLayout();
                this.bgCslFormSpecial.onLoad();
                this.registParentCom((CoreUI)this.bgCslFormSpecial);
                this.rptpro.setOprtStatus(this.getOprtState());
                this.rptpro.setProcessUI(this.bgCslFormSpecial);
                this.rptpro.setType(this.type);
                this.rptpro.setRptid((String)this.getUIContext().get("ID"));
                break;
            }
        }
    }

    private void initAdjCslRpt() throws Exception {
        this.type = 5;
        this.bgCslAdjFormSpecial = new BgCslAdjFormSpecialProcessUi();
        this.bgCslAdjFormSpecial.getUIContext().put("Owner", this);
        this.bgCslAdjFormSpecial.getUIContext().put("BGSCHEME_INFO", this.getUIContext().get("BGSCHEME_INFO"));
        this.bgCslAdjFormSpecial.getUIContext().put("BGSCHEME_ID", this.getUIContext().get("BGSCHEME_ID"));
        this.bgCslAdjFormSpecial.getUIContext().put("ID", this.getUIContext().get("ID"));
        this.bgCslAdjFormSpecial.getUIContext().put(BgBaseConstants.ORGUNIT_INFO, this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        this.bgCslAdjFormSpecial.getUIContext().put("orgTreeInfo", this.getUIContext().get("orgTreeInfo"));
        this.bgCslAdjFormSpecial.setOprtState(this.getOprtState());
        this.bgCslAdjFormSpecial.initLayout();
        this.bgCslAdjFormSpecial.onLoad();
        this.registParentCom((CoreUI)this.bgCslAdjFormSpecial);
        this.rptpro.setOprtStatus(this.getOprtState());
        this.rptpro.setProcessUI(this.bgCslAdjFormSpecial);
        this.rptpro.setType(this.type);
        this.rptpro.setRptid((String)this.getUIContext().get("ID"));
    }

    private void registParentCom(CoreUI ui) {
        if (ui.getParent() == null) {
            new UINewFrame((IUIObject)ui, (IUIManager)null);
            KDToolBar toolBar = ui.getUIToolBar();
            toolBar.remove(toolBar.countComponents() - 1);
        }
    }

    private void initCslWTSpreadProcessUI() throws Exception {
        ViewListBookContextManager bookContextManager = (ViewListBookContextManager)this.createContextManagerImpl();
        this.initDefaultSpreadSize(bookContextManager.getSpreadContext());
        if (this.type == 1) {
            MbgWorkPaperContextManager mbgWorkPaperContextManager = (MbgWorkPaperContextManager)bookContextManager;
            mbgWorkPaperContextManager.getSpreadContext();
            this.rptpro.setContextManager((IContextManager)mbgWorkPaperContextManager);
            this.setUITitle(mbgWorkPaperContextManager.getTitle());
            this.rptpro.setUiTitle(mbgWorkPaperContextManager.getTitle());
            ToolBarManager toolBarManager = mbgWorkPaperContextManager.getSpreadContext().getToolBarManager();
            if (this.preToolBar != null) {
                this.remove((Component)this.preToolBar);
            }
            KDToolBar toolBar = toolBarManager.getToolBar("style");
            this.rptpro.setSpreadToolBar(toolBar);
            this.getUIContentPane().add((Component)toolBar, "North");
            this.add((Component)toolBar, "North");
            this.preToolBar = toolBar;
            Component pageDimensionPanel = mbgWorkPaperContextManager.getPageDimensionPanel();
            this.rptpro.setPageDimensionPanel(pageDimensionPanel);
            int count = this.tabpane.getTabCount() + 1;
            this.tabpane.addTab(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"30_RptReportProcessNewUI"), null, pageDimensionPanel, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"30_RptReportProcessNewUI") + count, true);
            this.tabpane.setSelectedIndex(this.tabpane.getTabCount() - 1);
            int seleted = this.tabpane.getSelectedIndex();
            if (seleted != -1) {
                this.setTabColor(seleted);
                this.tabid = seleted;
                this.tabpane.setTitleAt(seleted, mbgWorkPaperContextManager.getTabTitle());
                this.tabpane.setToolTipTextAt(seleted, mbgWorkPaperContextManager.getTabTitle());
                this.rptpro.setTabTitle(mbgWorkPaperContextManager.getTabTitle());
            }
        } else if (this.type == 3) {
            BgCslViewListFormContextManager bgCslViewListFormContextManager = (BgCslViewListFormContextManager)bookContextManager;
            this.rptpro.setContextManager((IContextManager)bgCslViewListFormContextManager);
            this.setUITitle(bgCslViewListFormContextManager.getTitle());
            this.rptpro.setUiTitle(bgCslViewListFormContextManager.getTitle());
            if (this.preToolBar != null) {
                this.remove((Component)this.preToolBar);
            }
            ToolBarManager toolBarManager = bgCslViewListFormContextManager.getSpreadContext().getToolBarManager();
            KDToolBar toolBar = toolBarManager.getToolBar("style");
            this.rptpro.setSpreadToolBar(toolBar);
            this.add((Component)toolBar, "North");
            this.preToolBar = toolBar;
            Component pageDimensionPanel = bgCslViewListFormContextManager.getPageDimensionPanel();
            this.rptpro.setPageDimensionPanel(pageDimensionPanel);
            int count = this.tabpane.getTabCount() + 1;
            this.tabpane.addTab(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"30_RptReportProcessNewUI"), null, pageDimensionPanel, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"30_RptReportProcessNewUI") + count, true);
            this.tabpane.setSelectedIndex(this.tabpane.getTabCount() - 1);
            int seleted = this.tabpane.getSelectedIndex();
            if (seleted != -1) {
                this.setTabColor(seleted);
                this.tabid = seleted;
                this.tabpane.setTitleAt(seleted, bgCslViewListFormContextManager.getTabTitle());
                this.tabpane.setToolTipTextAt(seleted, bgCslViewListFormContextManager.getTabTitle());
                this.rptpro.setTabTitle(bgCslViewListFormContextManager.getTabTitle());
            }
        }
    }

    private void initBar() {
        if (this.type == 1) {
            this.setUIMenuBar(this.mbgWorkPaper.getUIMenuBar());
            this.rptpro.setMenuBar(this.mbgWorkPaper.getUIMenuBar());
            KDToolBar bar = this.mbgWorkPaper.getUIToolBar();
            bar.setTextIconDisStyle((short)3);
            this.setUIToolBar(bar);
            this.rptpro.setToolBar(bar);
            this.setStatusBar(this.mbgWorkPaper.getStatusBar());
            this.rptpro.setStatusBar(this.mbgWorkPaper.getStatusBar());
        } else if (this.type == 2) {
            this.setUIMenuBar(this.bgCslForm.getUIMenuBar());
            this.rptpro.setMenuBar(this.bgCslForm.getUIMenuBar());
            this.setUIToolBar(this.bgCslForm.getUIToolBar());
            this.rptpro.setToolBar(this.bgCslForm.getUIToolBar());
            this.setStatusBar(this.bgCslForm.getStatusBar());
            this.rptpro.setStatusBar(this.bgCslForm.getStatusBar());
        } else if (this.type == 3) {
            this.setUIMenuBar(this.bgCslViewListForm.getUIMenuBar());
            this.rptpro.setMenuBar(this.bgCslViewListForm.getUIMenuBar());
            KDToolBar bar = this.bgCslViewListForm.getUIToolBar();
            bar.setTextIconDisStyle((short)3);
            this.setUIToolBar(bar);
            this.rptpro.setToolBar(bar);
            this.setStatusBar(this.bgCslViewListForm.getStatusBar());
            this.rptpro.setStatusBar(this.bgCslViewListForm.getStatusBar());
        } else if (this.type == 4) {
            this.setUIMenuBar(this.bgCslFormSpecial.getUIMenuBar());
            this.rptpro.setMenuBar(this.bgCslFormSpecial.getUIMenuBar());
            this.setUIToolBar(this.bgCslFormSpecial.getUIToolBar());
            this.rptpro.setToolBar(this.bgCslFormSpecial.getUIToolBar());
            this.setStatusBar(this.bgCslFormSpecial.getStatusBar());
            this.rptpro.setStatusBar(this.bgCslFormSpecial.getStatusBar());
        } else if (this.type == 5) {
            this.setUIMenuBar(this.bgCslAdjFormSpecial.getUIMenuBar());
            this.rptpro.setMenuBar(this.bgCslAdjFormSpecial.getUIMenuBar());
            this.setUIToolBar(this.bgCslAdjFormSpecial.getUIToolBar());
            this.rptpro.setToolBar(this.bgCslAdjFormSpecial.getUIToolBar());
            this.setStatusBar(this.bgCslAdjFormSpecial.getStatusBar());
            this.rptpro.setStatusBar(this.bgCslAdjFormSpecial.getStatusBar());
        }
        this.initCommToolBarManager();
    }

    public void initSystem() throws Exception {
    }

    public void onShow() throws Exception {
        this.closeBtn = (Component)this.getUIContext().get("btnClose");
        if (this.type == 1) {
            this.mbgWorkPaper.onShow();
        } else if (this.type == 2) {
            this.bgCslForm.onShow();
        } else if (this.type == 3) {
            this.bgCslViewListForm.onShow();
        } else if (this.type == 4) {
            this.bgCslFormSpecial.onShow();
        } else if (this.type == 5) {
            this.bgCslAdjFormSpecial.onShow();
        }
    }

    private void setCommonBgCslRptTitle() {
        StringBuffer title;
        String titleStr = null;
        String tabTitle = null;
        if (this.type == 2) {
            title = new StringBuffer();
            title.append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"bgCslForm")).append(" - ").append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)this.getOprtState()));
            String _name = this.bgCslForm.getEditData().getName();
            if (!StringUtils.isEmpty((String)_name)) {
                title.append(" - ").append(_name);
            }
            titleStr = title.toString();
            tabTitle = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"bgCslForm") + " - " + _name;
        } else if (this.type == 4) {
            title = new StringBuffer();
            title.append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"bgCslForm")).append(" - ").append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)this.getOprtState()));
            String _name = this.bgCslFormSpecial.getEditData().getName();
            if (!StringUtils.isEmpty((String)_name)) {
                title.append(" - ").append(_name);
            }
            titleStr = title.toString();
            tabTitle = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"bgCslForm") + " - " + _name;
        } else if (this.type == 5) {
            title = new StringBuffer();
            title.append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateResource", (String)"bgCslForm")).append(" - ").append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)this.getOprtState()));
            String _name = this.bgCslAdjFormSpecial.getEditData().getName();
            if (!StringUtils.isEmpty((String)_name)) {
                title.append(" - ").append(_name);
            }
            titleStr = title.toString();
            tabTitle = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateResource", (String)"bgCslForm") + " - " + _name;
        }
        this.setUITitle(titleStr);
        this.rptpro.setUiTitle(titleStr);
        int seleted = this.tabpane.getSelectedIndex();
        if (seleted != -1) {
            this.setTabColor(seleted);
            this.tabid = seleted;
            this.tabpane.setTitleAt(seleted, tabTitle);
            this.tabpane.setToolTipTextAt(seleted, tabTitle);
            this.rptpro.setTabTitle(tabTitle);
        }
    }

    protected KDToolBar getSpreadStyleToolBar() {
        ToolBarManager toolBarManager = null;
        if (this.type == 2) {
            toolBarManager = this.createSpreadManager().getSpreadContainer().getToolBarManager();
        } else if (this.type == 4) {
            toolBarManager = this.createSpreadManager().getSpreadContainer().getToolBarManager();
        } else if (this.type == 5) {
            toolBarManager = this.createSpreadManager().getSpreadContainer().getToolBarManager();
        }
        if (toolBarManager == null) {
            return null;
        }
        return toolBarManager.getToolBar("style");
    }

    protected SpreadManager createSpreadManager() {
        if (this.type == 2) {
            this.rptpro.setManage(this.bgCslForm.getSpreadManager());
        } else if (this.type == 4) {
            this.rptpro.setManage(this.bgCslFormSpecial.getSpreadManager());
        } else if (this.type == 5) {
            this.rptpro.setManage(this.bgCslAdjFormSpecial.getSpreadManager());
        }
        this.initDefaultSpreadSize(this.rptpro.getManage().getSpreadContainer());
        return this.rptpro.getManage();
    }

    protected void initDefaultSpreadSize(SpreadContext spreadContainer) {
        spreadContainer.setPreferredSize(new Dimension(200, 180));
        spreadContainer.setMinimumSize(new Dimension(200, 180));
    }

    protected void initReoprtLayout() throws Exception {
        KDToolBar toolBar2;
        if (this.preToolBar != null) {
            this.remove((Component)this.preToolBar);
        }
        this.preToolBar = toolBar2 = this.getSpreadStyleToolBar();
        this.rptpro.setSpreadToolBar(toolBar2);
        this.add((Component)toolBar2, "North");
        if (this.type == 5) {
            this.tabpane.addTab("", null, this.bgCslAdjFormSpecial.getPageDimensionPanel(), "", true);
            this.rptpro.setPageDimensionPanel(this.bgCslAdjFormSpecial.getPageDimensionPanel());
        } else if (this.type == 4) {
            this.tabpane.addTab("", null, this.bgCslFormSpecial.getPageDimensionPanel(), "", true);
            this.rptpro.setPageDimensionPanel(this.bgCslFormSpecial.getPageDimensionPanel());
        } else {
            this.tabpane.addTab("", null, (Component)this.createSpreadManager().getSpreadContainer(), "", true);
        }
        this.tabpane.setSelectedIndex(this.tabpane.getTabCount() - 1);
    }

    protected void initEventListener() {
        this.tabpane.addCloseActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgSingleRptProperties single = BgCslWorkTableProcessUI.this.manager.getRptProperties(BgCslWorkTableProcessUI.this.tabpane.getSeletedTabCtxId());
                String detail = BgCslWorkTableProcessUI.this.manager.getModifyBgCslDetailBySingleRpt(single);
                boolean isClose = true;
                if (!StringUtils.isEmpty((String)detail)) {
                    isClose = 2 != MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.cslworktable.CslWorkTableResource", (String)"29_CslWkTbReportProcessUI"), (String)detail);
                }
                if (isClose) {
                    BgCslWorkTableProcessUI.this.manager.discardAllEdits();
                    try {
                        BgCslWorkTableProcessUI.this.closeReportTab(single);
                    }
                    catch (Exception e1) {
                        BgCslWorkTableProcessUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
        this.tabpane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!BgCslWorkTableProcessUI.this.isOnLoad) {
                    return;
                }
                if (BgCslWorkTableProcessUI.this.tabpane.getTabCount() > 0 && BgCslWorkTableProcessUI.this.manager.hasRptProperties(BgCslWorkTableProcessUI.this.tabpane.getSeletedTabCtxId())) {
                    try {
                        BgCslWorkTableProcessUI.this.initRptSelfProperties(false);
                    }
                    catch (Exception e1) {
                        BgCslWorkTableProcessUI.this.discardFailedTab();
                        BgCslWorkTableProcessUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
    }

    public void closeTabPane() {
        BgSingleRptProperties single = this.manager.getRptProperties(this.tabpane.getSeletedTabCtxId());
        String detail = this.manager.getModifyBgCslDetailBySingleRpt(single);
        boolean isClose = true;
        if (!StringUtils.isEmpty((String)detail)) {
            int re = MsgBox.showConfirm3((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (2 == re) {
                isClose = false;
            } else {
                if (0 == re) {
                    ArrayList<BgSingleRptProperties> singles = new ArrayList<BgSingleRptProperties>(1);
                    singles.add(single);
                    try {
                        this.saveBgRptBeforeDetroyWindows(singles);
                    }
                    catch (Exception var1) {
                        this.handUIExceptionAndAbort(var1);
                    }
                }
                isClose = true;
            }
        }
        if (isClose) {
            try {
                this.closeReportTab(single);
            }
            catch (Exception e1) {
                this.handUIExceptionAndAbort(e1);
            }
        }
    }

    private void closeReportTab(BgSingleRptProperties single) throws Exception {
        if (this.check()) {
            this.releaseNetControl(single);
            this.releaseMutexLock(single);
            this.manager.removeRptPro(this.tabpane.getSeletedTabCtxId());
            this.tabpane.removeTabAt(this.tabpane.getSelectedIndex());
            KingdeeTabbedPaneExtUI ui = (KingdeeTabbedPaneExtUI)this.tabpane.getUI();
            ui.getColorMap().clear();
            this.initRptSelfProperties(false);
        }
    }

    private void releaseNetControl(BgSingleRptProperties rptprop) {
        IVOChangeListener listener = this.getVOChangeListener();
        if (listener != null) {
            VOChangeEvent e = new VOChangeEvent((Object)this);
            if ((IObjectValue)this.getUIContext().get("CURRENT.VO") != null) {
                e.setCurrentObject((IObjectValue)this.getUIContext().get("CURRENT.VO"));
            }
            e.setState("RELEASEALL");
            if (rptprop.getRptid() != null) {
                e.setCurrentObjectId(rptprop.getRptid());
                try {
                    listener.change(e);
                }
                catch (Throwable e1) {
                    this.handUIException(e1);
                    this.abort();
                }
            }
        }
    }

    private void releaseMutexLock(BgSingleRptProperties single) {
        String requestId = single.getRptid();
        MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(requestId);
    }

    private boolean check() {
        if (this.type == 1) {
            return this.mbgWorkPaper.checkBeforeWindowClosing();
        }
        if (this.type == 2) {
            return this.bgCslForm.checkBeforeWindowClosing();
        }
        if (this.type == 3) {
            return this.bgCslViewListForm.checkBeforeWindowClosing();
        }
        if (this.type == 4) {
            return this.bgCslFormSpecial.checkBeforeWindowClosing();
        }
        if (this.type == 5) {
            return this.bgCslAdjFormSpecial.checkBeforeWindowClosing();
        }
        return true;
    }

    private void discardFailedTab() {
        if (!this.manager.hasRptProperties(this.tabpane.getSeletedTabCtxId()) && this.tabpane.getSelectedIndex() > 0) {
            this.tabpane.removeTabAt(this.tabpane.getSelectedIndex());
        }
    }

    public IMenuManager createMenuManagerImpl() {
        return null;
    }

    public IContextManager createContextManagerImpl() {
        if (this.type == 1) {
            return this.mbgWorkPaper.getContextManager();
        }
        if (this.type == 3) {
            return this.bgCslViewListForm.getContextManager();
        }
        return null;
    }

    public IActionManager createActionsManagerImpl() {
        return null;
    }

    protected void registerAction() {
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.manager.size() > 0) {
            int size = this.tabpane.getTabCount();
            List<BgSingleRptProperties> bgRpts = new ArrayList<BgSingleRptProperties>();
            for (int i = size - 1; i >= 0; --i) {
                BgSingleRptProperties single = this.manager.getRptProperties(this.tabpane.getctxid(i));
                bgRpts.add(single);
            }
            bgRpts = this.saveSequence(bgRpts);
            this.saveBgRptBeforeDetroyWindows(bgRpts);
        }
    }

    public void openReportsFromListUI(final List<String> ids, final List tmplTypes, final List formTypes, final List oprtStatuss, final boolean addOne, final String oprtStatus, final String period) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        ProgressDialog dialog = ProgressDialog.createProgressDialog((Component)((Object)this), (boolean)true);
        dialog.run4New(false, true, new IRunnableWithProgress(){
            boolean isGreatestLimited = false;
            int defaultSelectedIndex;
            boolean isSelectedTab;
            {
                this.defaultSelectedIndex = BgCslWorkTableProcessUI.this.tabpane.getTabCount() - 1;
                this.isSelectedTab = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) {
                monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"36_RptReportProcessNewUI"), -1);
                monitor.setTaskName(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"37_RptReportProcessNewUI"));
                monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"42_RptReportProcessNewUI"));
                String ctxid = null;
                String reportid = null;
                String tmplType = null;
                BgTemFormTypeEnum formType = null;
                String oprt = null;
                try {
                    for (int i = 0; i < ids.size(); ++i) {
                        reportid = (String)ids.get(i);
                        tmplType = (String)tmplTypes.get(i);
                        BgTemFormTypeEnum bgTemFormTypeEnum = formType = formTypes.isEmpty() ? null : (BgTemFormTypeEnum)formTypes.get(i);
                        if (oprtStatuss.size() > 0) {
                            oprt = (String)oprtStatuss.get(i);
                        }
                        if (!"NOTFOUND".equals(ctxid = BgCslWorkTableProcessUI.this.manager.findReportByID(reportid))) {
                            BgCslWorkTableProcessUI.this.tabpane.SetSelectedTab(ctxid);
                            this.isSelectedTab = true;
                            continue;
                        }
                        if (BgCslWorkTableProcessUI.this.isGreatestLimited()) {
                            this.isGreatestLimited = true;
                            break;
                        }
                        BgCslWorkTableProcessUI.this.getUIContext().put("ID", reportid);
                        BgCslWorkTableProcessUI.this.getUIContext().put("tmplType", tmplType);
                        BgCslWorkTableProcessUI.this.getUIContext().put("formType", formType);
                        BgCslWorkTableProcessUI.this.getUIContext().put("period", period);
                        BgCslWorkTableProcessUI.this.setOprt(oprt != null ? oprt : oprtStatus);
                        BgCslWorkTableProcessUI.this.addNewTab();
                        BgCslWorkTableProcessUI.this.onShow();
                        String name = BgCslWorkTableProcessUI.this.getTablTitleName();
                        BgCslWorkTableProcessUI.this.initRptSelfProperties(true);
                        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"110_RptReportProcessNewUI");
                        monitor.subTaskBegin(MessageFormat.format(msg, name));
                    }
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"41_RptReportProcessNewUI"));
                }
                catch (Exception e) {
                    block8: {
                        try {
                            if (e instanceof NullPointerException) break block8;
                            BgCslWorkTableProcessUI.this.handUIExceptionAndAbort(e);
                        }
                        catch (Throwable throwable) {
                            monitor.done();
                            BgCslWorkTableProcessUI.this.requestFocus();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (isGreatestLimited) {
                                        BgCslWorkTableProcessUI.this.handUIExceptionAndAbort((Exception)new ReportProcessException(ReportProcessException.OPENREPORTLIMITED, new Object[]{10}));
                                    } else if (defaultSelectedIndex >= 0 && defaultSelectedIndex < BgCslWorkTableProcessUI.this.tabpane.getTabCount() && !isSelectedTab) {
                                        int reSelectedIndex;
                                        int n = reSelectedIndex = addOne ? defaultSelectedIndex + 1 : defaultSelectedIndex;
                                        if (reSelectedIndex < BgCslWorkTableProcessUI.this.tabpane.getTabCount()) {
                                            BgCslWorkTableProcessUI.this.tabpane.setSelectedIndex(reSelectedIndex);
                                        } else {
                                            BgCslWorkTableProcessUI.this.tabpane.setSelectedIndex(defaultSelectedIndex);
                                        }
                                    }
                                }
                            });
                            throw throwable;
                        }
                    }
                    monitor.done();
                    BgCslWorkTableProcessUI.this.requestFocus();
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                monitor.done();
                BgCslWorkTableProcessUI.this.requestFocus();
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void setOprt(String oprtStatus) {
        this.setOprtState(oprtStatus);
    }

    private String setTitle() {
        StringBuffer tb;
        String title = null;
        String tabTitle = null;
        if (this.type == 1) {
            MbgWorkPaperContextManager mbgWorkPaperContextManager = (MbgWorkPaperContextManager)this.createContextManagerImpl();
            title = mbgWorkPaperContextManager.getTitle();
            tabTitle = mbgWorkPaperContextManager.getTabTitle();
        } else if (this.type == 2) {
            tb = new StringBuffer();
            tb.append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"bgCslForm")).append(" - ").append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)this.getOprtState()));
            String _name = this.bgCslForm.getEditData().getName();
            if (!StringUtils.isEmpty((String)_name)) {
                tb.append(" - ").append(_name);
            }
            title = tb.toString();
            tabTitle = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"bgCslForm") + " - " + _name;
        } else if (this.type == 3) {
            BgCslViewListFormContextManager bgCslViewListFormContextManager = (BgCslViewListFormContextManager)this.createContextManagerImpl();
            title = bgCslViewListFormContextManager.getTitle();
            tabTitle = bgCslViewListFormContextManager.getTabTitle();
        } else if (this.type == 4) {
            tb = new StringBuffer();
            tb.append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"bgCslForm")).append(" - ").append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)this.getOprtState()));
            String _name = this.bgCslFormSpecial.getEditData().getName();
            if (!StringUtils.isEmpty((String)_name)) {
                tb.append(" - ").append(_name);
            }
            title = tb.toString();
            tabTitle = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"bgCslForm") + " - " + _name;
        } else if (this.type == 5) {
            tb = new StringBuffer();
            tb.append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateResource", (String)"bgCslForm")).append(" - ").append(EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)this.getOprtState()));
            String _name = this.bgCslAdjFormSpecial.getEditData().getName();
            if (!StringUtils.isEmpty((String)_name)) {
                tb.append(" - ").append(_name);
            }
            title = tb.toString();
            tabTitle = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateResource", (String)"bgCslForm") + " - " + _name;
        }
        this.setUITitle(title);
        int seleted = this.tabpane.getSelectedIndex();
        if (seleted != -1) {
            this.tabpane.setTitleAt(seleted, tabTitle);
            this.tabpane.setToolTipTextAt(seleted, tabTitle);
            this.setTabColor(seleted);
            this.tabid = seleted;
        }
        return tabTitle;
    }

    private String getTablTitleName() {
        String tabTitle = null;
        if (this.type == 1) {
            MbgWorkPaperContextManager mbgWorkPaperContextManager = (MbgWorkPaperContextManager)this.createContextManagerImpl();
            tabTitle = mbgWorkPaperContextManager.getTabTitle();
        } else if (this.type == 2) {
            String _name = this.bgCslForm.getEditData().getName();
            tabTitle = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"bgCslForm") + " - " + _name;
        } else if (this.type == 3) {
            BgCslViewListFormContextManager bgCslViewListFormContextManager = (BgCslViewListFormContextManager)this.createContextManagerImpl();
            tabTitle = bgCslViewListFormContextManager.getTabTitle();
        } else if (this.type == 4) {
            String _name = this.bgCslFormSpecial.getEditData().getName();
            tabTitle = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslTemplateResource", (String)"bgCslForm") + " - " + _name;
        } else if (this.type == 5) {
            String _name = this.bgCslAdjFormSpecial.getEditData().getName();
            tabTitle = EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateResource", (String)"bgCslForm") + " - " + _name;
        }
        return tabTitle;
    }

    private void setTabColor(int seleted) {
        KingdeeTabbedPaneExtUI ui;
        Color color;
        if (this.tabid != -1) {
            color = new Color(0, 139, 0);
            ui = (KingdeeTabbedPaneExtUI)this.tabpane.getUI();
            ui.getColorMap().put(this.tabid, color);
        }
        color = Color.RED;
        ui = (KingdeeTabbedPaneExtUI)this.tabpane.getUI();
        ui.getColorMap().put(seleted, color);
    }

    private void initCommToolBarManager() {
        if (this.closeBtn != null) {
            this.getUIToolBar().add(this.closeBtn);
        }
        KDWorkButton btnSave = (KDWorkButton)this.getUIToolBar().getComponentAtIndex(1);
        Icon icon = btnSave.getIcon();
        boolean isEnable = btnSave.isEnabled();
        String text = btnSave.getText();
        int memmonic = btnSave.getMnemonic();
        short textIconDisStyle = btnSave.getTextIconDisStyle();
        btnSave.setActionCommand(" com.kingdee.eas.ma.mbg.client.AbstractBgSpreadViewUI$actionSave");
        btnSave.setAction((Action)this.actionSave);
        btnSave.setBounds(0, 4, 27, 21);
        btnSave.setIcon(icon);
        btnSave.setEnabled(isEnable);
        btnSave.setText(text);
        btnSave.setMnemonic(memmonic);
        btnSave.setTextIconDisStyle(textIconDisStyle);
    }

    private boolean isGreatestLimited() {
        return this.manager.size() + 1 > 10;
    }

    public boolean destroyWindow() {
        Map map = this.manager.getAllModifyBgCslDetail();
        String detail = (String)map.get("detail");
        if (!StringUtils.isEmpty((String)detail)) {
            int choose = MsgBox.showConfirm4a((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslWorkTableResource", (String)"saveOrNot"), (String)detail);
            if (2 == choose) {
                return false;
            }
            if (1 == choose) {
                this.manager.discardAllEdits();
            } else {
                try {
                    List bgRpts = (List)map.get("bgRpts");
                    bgRpts = this.saveSequence(bgRpts);
                    this.saveBgRptBeforeDetroyWindows(bgRpts);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.manager.discardAllEdits();
            }
        }
        int size = this.tabpane.getTabCount();
        for (int i = size - 1; i >= 0; --i) {
            BgSingleRptProperties single = this.manager.getRptProperties(this.tabpane.getctxid(i));
            this.releaseNetControl(single);
            this.releaseMutexLock(single);
        }
        this.manager.clearAll();
        ProgressDialogHelper.destroyAllMonitorFromThreadPool();
        return super.destroyWindow();
    }

    private List saveSequence(List<BgSingleRptProperties> bgRpts) {
        ArrayList allInOne = new ArrayList();
        List<BgSingleRptProperties> bgWorkPaper = new ArrayList();
        List<BgSingleRptProperties> bgCslForm = new ArrayList();
        List<BgSingleRptProperties> bgCslAdjForm = new ArrayList();
        for (BgSingleRptProperties rptpro : bgRpts) {
            String tmplType = rptpro.getTmplType();
            if ("worktemplate".equals(tmplType)) {
                bgWorkPaper.add(rptpro);
                continue;
            }
            if ("csltemplate".equals(tmplType)) {
                bgCslForm.add(rptpro);
                continue;
            }
            if (!"csladjtemplate".equals(tmplType)) continue;
            bgCslAdjForm.add(rptpro);
        }
        bgWorkPaper = this.sortList(bgWorkPaper);
        bgCslForm = this.sortList(bgCslForm);
        bgCslAdjForm = this.sortList(bgCslAdjForm);
        allInOne.addAll(bgWorkPaper);
        allInOne.addAll(bgCslForm);
        allInOne.addAll(bgCslAdjForm);
        return allInOne;
    }

    private List sortList(List bgRpts) {
        Collections.sort((List)bgRpts, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                BgSingleRptProperties b1 = (BgSingleRptProperties)o1;
                BgSingleRptProperties b2 = (BgSingleRptProperties)o2;
                return b1.getPeriod().compareTo(b2.getPeriod());
            }
        });
        return bgRpts;
    }

    private void saveBgRptBeforeDetroyWindows(List<BgSingleRptProperties> bgRpts) throws Exception {
        for (BgSingleRptProperties pro : bgRpts) {
            int type = pro.getType();
            Object processui = pro.getProcessUI();
            switch (type) {
                case 1: {
                    ((MbgWorkPaperProcessUI)processui).actionSave_actionPerformed(new ActionEvent(((MbgWorkPaperProcessUI)processui).getUIToolBar().getComponent(1), 1001, "com.kingdee.eas.ma.mbg.client.AbstractBgSpreadViewUI$ActionSave", 16));
                    break;
                }
                case 2: {
                    ((BgCslFormProcessUI)processui).actionSave_actionPerformed(new ActionEvent(((BgCslFormProcessUI)processui).getUIToolBar().getComponent(1), 1001, "com.kingdee.eas.fi.newrpt.client.designer.AbstractReportDesignerUI$actionSave", 16));
                    break;
                }
                case 3: {
                    ((BgCslViewListFormProcessUI)processui).actionSave_actionPerformed(new ActionEvent(((BgCslViewListFormProcessUI)processui).getUIToolBar().getComponent(1), 1001, "com.kingdee.eas.ma.mbg.client.AbstractBgSpreadViewUI$ActionSave", 16));
                    break;
                }
                case 4: {
                    ((BgCslFormSpecialProcessUi)processui).actionSave_actionPerformed(new ActionEvent(((BgCslFormSpecialProcessUi)processui).getUIToolBar().getComponent(1), 1001, "com.kingdee.eas.fi.newrpt.client.designer.AbstractReportDesignerUI$actionSave", 16));
                    break;
                }
                case 5: {
                    ((BgCslAdjFormSpecialProcessUi)processui).actionSave_actionPerformed(new ActionEvent(((BgCslAdjFormSpecialProcessUi)processui).getUIToolBar().getComponent(1), 1001, "com.kingdee.eas.fi.newrpt.client.designer.AbstractReportDesignerUI$actionSave", 16));
                    break;
                }
            }
        }
    }
}

