/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.template;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.bgcsl.client.BgNWorkLayoutDesignerUI;
import com.kingdee.eas.ma.mbg.client.common.ComponentDragSourceForViewList;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.TransferableForLayout;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PanelDropTargetForBgNWork
implements DropTargetListener {
    private CoreUI owner;
    protected int targetType = 0;
    protected JPanel panel;
    protected Point lastP;
    protected Color bg;
    protected boolean isLockOrgUnit = false;
    protected MbgViewListDimensionManager iBgDimensionManager;
    private boolean isRoll = false;

    public CoreUI getOwner() {
        return this.owner;
    }

    public PanelDropTargetForBgNWork(IGetComponent owner, JPanel aPanel, int targetType, MbgViewListDimensionManager iBgDimensionManager, boolean isRoll, boolean isLockOrgUnit) {
        this.owner = (CoreUI)owner;
        this.panel = aPanel;
        new DropTarget(this.panel, this);
        this.bg = this.panel.getBackground();
        this.targetType = targetType;
        this.iBgDimensionManager = iBgDimensionManager;
        this.isRoll = isRoll;
        this.isLockOrgUnit = isLockOrgUnit;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.panel.setBackground(this.brighter(this.bg, 0.9f));
    }

    private Color brighter(Color c, float FACTOR) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(1.0 / (1.0 - (double)FACTOR));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / FACTOR), 255), Math.min((int)((float)g / FACTOR), 255), Math.min((int)((float)b / FACTOR), 255));
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        if (this.lastP != null && (this.lastP.x != p.x || this.lastP.y != p.y)) {
            this.markTarget(this.lastP);
            this.panel.updateUI();
        }
        this.markTarget(p);
        this.lastP = p;
    }

    private void markTarget(Point p) {
        Graphics g = this.panel.getGraphics();
        g.setColor(Color.RED);
        int lenx = 25;
        int leny = 25;
        g.drawLine(p.x - 25, p.y, p.x + 25, p.y);
        g.drawLine(p.x, p.y - 25, p.x, p.y + 25);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private int getDropPositionIndex(Point dropPoint) {
        Point p;
        Component[] cs = this.panel.getComponents();
        ArrayList<Point> list = new ArrayList<Point>();
        for (int j = 0; j < cs.length; ++j) {
            p = cs[j].getLocation();
            p.x += cs[j].getWidth();
            p.y += cs[j].getHeight();
            list.add(p);
        }
        int index = -1;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            p = (Point)list.get(i);
            if (dropPoint.x > p.x || dropPoint.y > p.y) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable tr = dtde.getTransferable();
        try {
            IMbgViewListObject info = null;
            JComponent c = null;
            Integer sourcePnlType = null;
            if (tr.isDataFlavorSupported(TransferableForLayout.DIMENSION_FLAVOR) && tr.isDataFlavorSupported(TransferableForLayout.COMPONENT_FLAVOR) && tr.isDataFlavorSupported(TransferableForLayout.SOURCE_PNL_TYPE_FLAVOR)) {
                info = (IMbgViewListObject)tr.getTransferData(TransferableForLayout.DIMENSION_FLAVOR);
                c = ((IGetComponent)this.owner).getDimensionComponent(info);
                sourcePnlType = (Integer)tr.getTransferData(TransferableForLayout.SOURCE_PNL_TYPE_FLAVOR);
                if (this.targetType == 2 && this.isLockOrgUnit && info instanceof MbgViewListDimensionInfo && MBGLayoutConstants.BG_ORGANIZATION.equals(((MbgViewListDimensionInfo)info).getNumber())) {
                    MsgBox.showInfo((Component)this.owner, (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"cannotMoveToPage"), ((MbgViewListDimensionInfo)info).getAlias()));
                    dtde.rejectDrop();
                    this.panel.setBackground(this.bg);
                    this.panel.updateUI();
                    return;
                }
                JPanel oldP = (JPanel)c.getParent();
                if (oldP != this.panel) {
                    if (info instanceof MbgViewListAtribute) {
                        oldP.remove(c);
                    } else {
                        KDBizPromptBox prmpt;
                        MbgViewListDimensionInfo dimension = (MbgViewListDimensionInfo)info;
                        if (c instanceof KDBizPromptBox && (prmpt = (KDBizPromptBox)c).getUserObject() instanceof MbgViewListDimensionInfo) {
                            dimension = (MbgViewListDimensionInfo)prmpt.getUserObject();
                        }
                        switch (this.targetType) {
                            case 4: {
                                dimension.setLayout("col");
                                break;
                            }
                            case 3: {
                                dimension.setLayout("row");
                                break;
                            }
                            case 1: {
                                dimension.setLayout("view");
                                break;
                            }
                            case 2: {
                                dimension.setLayout("page");
                            }
                        }
                        if (!dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) && c instanceof KDBizPromptBox) {
                            if (this.targetType == 4 || this.targetType == 3) {
                                ((Component)c).setEnabled(false);
                                ((KDBizPromptBox)c).setValue(null);
                                dimension.getMember().clear();
                                dimension.getCanAddMember().clear();
                            } else if (this.targetType == 1) {
                                ((Component)c).setEnabled(false);
                                ((KDBizPromptBox)c).setValue(null);
                                dimension.getMember().clear();
                                dimension.getCanAddMember().clear();
                            } else {
                                ((Component)c).setEnabled(false);
                            }
                        }
                        this.panel.add(c, null, this.getDropPositionIndex(dtde.getLocation()));
                        for (int i = oldP.getComponentCount() - 1; i >= 0; --i) {
                            IKDComponent comp;
                            if (!(oldP.getComponent(i) instanceof IKDComponent) || !((comp = (IKDComponent)oldP.getComponent(i)).getUserObject() instanceof MbgViewListAtribute)) continue;
                            MbgViewListAtribute attrib = (MbgViewListAtribute)comp.getUserObject();
                            if (!dimension.getNumber().equals(attrib.getDimNumber())) continue;
                            attrib.setLayout(dimension.getLayout());
                            oldP.remove(i);
                            if (this.targetType != 3 && this.targetType != 4) continue;
                            this.panel.add((JComponent)comp);
                        }
                    }
                    oldP.updateUI();
                    this.panel.updateUI();
                } else {
                    this.panel.add(c, null, this.getDropPositionIndex(dtde.getLocation()));
                    this.panel.updateUI();
                }
                this.createDragSource(dtde, info, c);
                dtde.dropComplete(true);
                if (this.owner instanceof BgNWorkLayoutDesignerUI) {
                    BgNWorkLayoutDesignerUI layoutUi = (BgNWorkLayoutDesignerUI)this.owner;
                    layoutUi.firePanelDimensions_changed(oldP, this.panel);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
        this.panel.setBackground(this.bg);
    }

    protected void createDragSource(DropTargetDropEvent dtde, IMbgViewListObject info, Component comp) {
        ComponentDragSourceForViewList.createDragSource((Component)comp, (Object)info, (int)dtde.getDropAction());
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.panel.setBackground(this.bg);
    }

    public int getTargetType() {
        return this.targetType;
    }

    public static interface IGetComponent {
        public JComponent getDimensionComponent(Object var1);
    }
}

