/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.utils;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateFactory;
import com.kingdee.eas.ma.biz.BizCalcCollection;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcGroupInfo;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetCollection;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizRelyCollection;
import com.kingdee.eas.ma.biz.BizRelyFactory;
import com.kingdee.eas.ma.biz.BizRelyInfo;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.BizStateEnum;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class BgCslBizCalcExportHelper {
    public static final String ENCODING = "UTF-8";
    private static final String DOCUMENT_BIZCALC = "BizCalc";
    private static final String DOCUMENT_NUMBER = "number";
    private static final String DOCUMENT_NAME = "name";
    private static final String DOCUMENT_DESCRIPTION = "description";
    private static final String DOCUMENT_ISBGEXE = "isBGExe";
    private static final String DOCUMENT_BIZCALCSUBSET = "bizCalcSubset";
    private static final String DOCUMENT_SEQ = "seq";
    private static final String DOCUMENT_FORMULA = "formula";
    private static final String DOCUMENT_SCOPE = "scope";
    private static final String DOCUMENT_BGMEMBERALIAS = "bgMemberAlias";
    private static final String DOCUMENT_BGMEMBERNUM = "bgMemberNum";
    private static final String DOCUMENT_BGMEMBERTYPE = "bgMemberType";
    private static final String DOCUMENT_BIZDATATYPE = "bizDataType";
    private static final String DOCUMENT_FILLTYPE = "fillType";
    private static final String DOCUMENT_REFFIELD = "refField";
    private static final String DOCUMENT_BIZRELY = "bizRely";
    private static final String DOCUMENT_BIZREFBGTEMPLATE = "bizRefBgTemplate";
    private static final String DOCUMENT_BIZREFWORKTEMPLATE = "bizRefWorkTemplate";
    private static final String DOCUMENT_BIZREFBGCSLADJTEMPLATE = "bizRefBgCslAdjTemplate";
    private static final String DOCUMENT_BIZCALCGROUP = "bizCalcGroup";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportBizCalc(List<String> selectIds, File file) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add(DOCUMENT_NUMBER);
        sic.add(DOCUMENT_NAME);
        sic.add(DOCUMENT_DESCRIPTION);
        sic.add(DOCUMENT_ISBGEXE);
        sic.add("bizCalcSubset.id");
        sic.add("bizCalcSubset.seq");
        sic.add("bizCalcSubset.name");
        sic.add("bizCalcSubset.formula");
        sic.add("bizCalcSubset.scope.id");
        sic.add("bizCalcSubset.scope.bgMemberNum");
        sic.add("bizCalcSubset.scope.bgMemberAlias");
        sic.add("bizCalcSubset.scope.bgMemberType");
        sic.add("bizCalcSubset.scope.bizDataType");
        sic.add("bizCalcSubset.scope.refField");
        sic.add("bizCalcSubset.scope.seq");
        sic.add("bizCalcSubset.scope.fillType");
        sic.add("bizCalcGroup.id");
        sic.add("bizCalcGroup.number");
        sic.add("bizCalcGroup.name");
        evi.setSelector(sic);
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo(DOCUMENT_NUMBER));
        evi.getSorter().add(new SorterItemInfo("bizCalcSubset.seq"));
        evi.getSorter().add(new SorterItemInfo("bizCalcSubset.scope.seq"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(selectIds), CompareType.INCLUDE));
        BizCalcCollection calcs = BizCalcFactory.getRemoteInstance().getBizCalcCollection(evi);
        Map refTemplateMap = BizRefCslTemplateFactory.getRemoteInstance().getRefTemplates(new HashSet<String>(selectIds));
        String id = null;
        evi.getSelector().clear();
        evi.getSelector().add("bizCalc.id");
        evi.getSelector().add("relyBiz.id");
        evi.getSelector().add("relyBiz.number");
        evi.getSelector().add("relyBiz.name");
        evi.getSorter().clear();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bizCalc.id", new HashSet<String>(selectIds), CompareType.INCLUDE));
        BizRelyCollection bizRely = BizRelyFactory.getRemoteInstance().getBizRelyCollection(evi);
        HashMap<String, List<BizRelyInfo>> bizRelyMap = new HashMap<String, List<BizRelyInfo>>();
        for (int i = 0; i < bizRely.size(); ++i) {
            id = bizRely.get(i).getBizCalc().getId().toString();
            if (!bizRelyMap.containsKey(id)) {
                bizRelyMap.put(id, new ArrayList());
            }
            ((List)bizRelyMap.get(id)).add(bizRely.get(i));
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElement = doc.addElement(DOCUMENT_BIZCALC);
        rootElement.addComment(BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"bizCalcExportMsg"));
        for (int i = 0; i < calcs.size(); ++i) {
            BgCslBizCalcExportHelper.buildDocument(rootElement, calcs.get(i), refTemplateMap, bizRelyMap);
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(ENCODING);
        try (FileOutputStream out = new FileOutputStream(file);){
            XMLWriter writer = new XMLWriter((OutputStream)out, format);
            writer.write(doc);
            writer.close();
        }
    }

    private static void buildDocument(Element rootElement, BizCalcInfo bizCalcInfo, Map<String, Map<String, IObjectCollection>> refTemplateMap, Map<String, List<BizRelyInfo>> bizRelyMap) {
        Element bizElement = rootElement.addElement(DOCUMENT_BIZCALC);
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_NUMBER, (Object)bizCalcInfo.getNumber());
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_NAME, (Object)bizCalcInfo.getName());
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_ISBGEXE, (Object)bizCalcInfo.isIsBGExe());
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_DESCRIPTION, (Object)bizCalcInfo.getDescription());
        BgCslBizCalcExportHelper.buildDocument(bizElement, bizCalcInfo.getBizCalcSubset());
        BgCslBizCalcExportHelper.buildDocument(bizElement, refTemplateMap.get(bizCalcInfo.getId().toString()));
        BgCslBizCalcExportHelper.buildDocumentRely(bizElement, bizRelyMap.get(bizCalcInfo.getId().toString()));
        BgCslBizCalcExportHelper.buildDocument(bizElement, bizCalcInfo.getBizCalcGroup());
    }

    private static void buildDocument(Element bizElement, BizCalcGroupInfo bizCalcGroupInfo) {
        if (bizElement == null || bizCalcGroupInfo == null) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BIZCALCGROUP);
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NUMBER, (Object)bizCalcGroupInfo.getNumber());
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NAME, (Object)bizCalcGroupInfo.getName());
    }

    private static void buildDocument(Element bizElement, BizCalcSubsetCollection bizCalcSubset) {
        for (int i = 0; i < bizCalcSubset.size(); ++i) {
            BgCslBizCalcExportHelper.buildDocument(bizElement, bizCalcSubset.get(i));
        }
    }

    private static void buildDocument(Element bizElement, BizCalcSubsetInfo bizCalcSubsetInfo) {
        Element subSetElement = bizElement.addElement(DOCUMENT_BIZCALCSUBSET);
        BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_SEQ, (Object)bizCalcSubsetInfo.getSeq());
        BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_FORMULA, (Object)bizCalcSubsetInfo.getBizFormula());
        BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_NAME, (Object)bizCalcSubsetInfo.getName());
        for (int i = 0; i < bizCalcSubsetInfo.getScope().size(); ++i) {
            BgCslBizCalcExportHelper.buildDocument(subSetElement, bizCalcSubsetInfo.getScope().get(i));
        }
    }

    private static void buildDocument(Element subSetElement, BizScopeInfo bizScopeInfo) {
        Element scopeElement = subSetElement.addElement(DOCUMENT_SCOPE);
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BGMEMBERALIAS, (Object)bizScopeInfo.getBgMemberAlias());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BGMEMBERNUM, (Object)bizScopeInfo.getBgMemberNum());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BGMEMBERTYPE, (Object)bizScopeInfo.getBgMemberType());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BIZDATATYPE, (Object)bizScopeInfo.getBizDataType().getName());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_FILLTYPE, (Object)bizScopeInfo.getFillType().getName());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_REFFIELD, (Object)bizScopeInfo.getRefField());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_SEQ, (Object)bizScopeInfo.getSeq());
    }

    private static void buildDocumentRely(Element bizElement, List<BizRelyInfo> bizRelyInfos) {
        if (bizRelyInfos == null) {
            return;
        }
        for (int i = 0; i < bizRelyInfos.size(); ++i) {
            BgCslBizCalcExportHelper.buildDocument(bizElement, bizRelyInfos.get(i));
        }
    }

    private static void buildDocument(Element bizElement, BizRelyInfo bizRelyInfo) {
        if (bizRelyInfo == null) {
            return;
        }
        Element bizRelyElement = bizElement.addElement(DOCUMENT_BIZRELY);
        BgViewHelper.addElementText((Element)bizRelyElement, (String)DOCUMENT_NUMBER, (Object)bizRelyInfo.getRelyBiz().getNumber());
        BgViewHelper.addElementText((Element)bizRelyElement, (String)DOCUMENT_NAME, (Object)bizRelyInfo.getRelyBiz().getName());
    }

    private static void buildDocument(Element bizElement, Map<String, IObjectCollection> refTemps) {
        int i;
        AbstractObjectCollection colls;
        if (bizElement == null || refTemps == null || refTemps.isEmpty()) {
            return;
        }
        if (refTemps.containsKey("WORKTEMPLATE_COLLECTION") && (colls = (BgNWorkTemplateCollection)refTemps.get("WORKTEMPLATE_COLLECTION")) != null && !colls.isEmpty()) {
            for (i = 0; i < colls.size(); ++i) {
                BgCslBizCalcExportHelper.buildDocument(bizElement, colls.get(i));
            }
        }
        if (refTemps.containsKey("bgtemplate") && (colls = (BgCslTemplateCollection)refTemps.get("bgtemplate")) != null && !colls.isEmpty()) {
            for (i = 0; i < colls.size(); ++i) {
                BgCslBizCalcExportHelper.buildDocument(bizElement, colls.get(i));
            }
        }
        if (refTemps.containsKey("bgcsladjtemplate") && (colls = (BgCslAdjTemplateCollection)refTemps.get("bgcsladjtemplate")) != null && !colls.isEmpty()) {
            for (i = 0; i < colls.size(); ++i) {
                BgCslBizCalcExportHelper.buildDocument(bizElement, colls.get(i));
            }
        }
    }

    private static void buildDocument(Element bizElement, BgNWorkTemplateInfo bgNWorkTemplateInfo) {
        if (bizElement == null || bgNWorkTemplateInfo == null) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BIZREFWORKTEMPLATE);
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NUMBER, (Object)bgNWorkTemplateInfo.getNumber());
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NAME, (Object)bgNWorkTemplateInfo.getName());
    }

    private static void buildDocument(Element bizElement, BgCslTemplateInfo bgCslTemplateInfo) {
        if (bizElement == null || bgCslTemplateInfo == null) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BIZREFBGTEMPLATE);
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NUMBER, (Object)bgCslTemplateInfo.getNumber());
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NAME, (Object)bgCslTemplateInfo.getName());
    }

    private static void buildDocument(Element bizElement, BgCslAdjTemplateInfo bgCslTemplateInfo) {
        if (bizElement == null || bgCslTemplateInfo == null) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BIZREFBGCSLADJTEMPLATE);
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NUMBER, (Object)bgCslTemplateInfo.getNumber());
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NAME, (Object)bgCslTemplateInfo.getName());
    }

    public static String importBizCalc(String bgSchemeId, String orgUnitId, String filePath, ErrorHandleModeEnum errorHandle, String orgTreeId, String bizCalcGroupId) throws Exception {
        LinkedHashMap<String, BizCalcInfo> calcMap = new LinkedHashMap<String, BizCalcInfo>();
        HashMap<String, Map<String, IObjectCollection>> refTempMap = new HashMap<String, Map<String, IObjectCollection>>();
        HashMap<String, List<BizCalcInfo>> relyMap = new HashMap<String, List<BizCalcInfo>>();
        BgCslBizCalcExportHelper.unParse(filePath, calcMap, refTempMap, relyMap, bizCalcGroupId);
        return BizRefCslTemplateFactory.getRemoteInstance().importBizCalc(bgSchemeId, orgUnitId, orgTreeId, calcMap, refTempMap, relyMap, errorHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unParse(String filePath, Map<String, BizCalcInfo> calcMap, Map<String, Map<String, IObjectCollection>> refTempMap, Map<String, List<BizCalcInfo>> relyMap, String bizCalcGroupId) throws Exception {
        SAXReader reader = new SAXReader();
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(new File(filePath));
            Document document = reader.read((InputStream)fileInputStream);
            Element rootElement = document.getRootElement();
            Iterator it = rootElement.elementIterator(DOCUMENT_BIZCALC);
            while (it.hasNext()) {
                BgCslBizCalcExportHelper.unParseBizCalc((Element)it.next(), calcMap, refTempMap, relyMap, bizCalcGroupId);
            }
        }
    }

    private static void unParseBizCalc(Element bizElement, Map<String, BizCalcInfo> calcMap, Map<String, Map<String, IObjectCollection>> refTempMap, Map<String, List<BizCalcInfo>> relyMap, String bizCalcGroupId) {
        BizCalcInfo bizCalc = new BizCalcInfo();
        bizCalc.setId(BOSUuid.create((BOSObjectType)bizCalc.getBOSType()));
        bizCalc.setState(BizStateEnum.SAVED);
        calcMap.put(bizCalc.getId().toString(), bizCalc);
        bizCalc.setNumber(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_NUMBER));
        bizCalc.setName(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_NAME));
        bizCalc.setIsBGExe(Boolean.parseBoolean(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_ISBGEXE)));
        bizCalc.setDescription(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_DESCRIPTION));
        Iterator it = bizElement.elementIterator(DOCUMENT_BIZCALCSUBSET);
        while (it.hasNext()) {
            BizCalcSubsetInfo subSet = new BizCalcSubsetInfo();
            subSet.setBizCalc(bizCalc);
            bizCalc.getBizCalcSubset().add(subSet);
            BgCslBizCalcExportHelper.unParseSubSet((Element)it.next(), subSet);
        }
        it = bizElement.elementIterator(DOCUMENT_BIZREFWORKTEMPLATE);
        while (it.hasNext()) {
            BgCslBizCalcExportHelper.unParseRefWorkTemplate((Element)it.next(), bizCalc.getId().toString(), refTempMap);
        }
        it = bizElement.elementIterator(DOCUMENT_BIZREFBGTEMPLATE);
        while (it.hasNext()) {
            BgCslBizCalcExportHelper.unParseRefBgTemplate((Element)it.next(), bizCalc.getId().toString(), refTempMap);
        }
        it = bizElement.elementIterator(DOCUMENT_BIZREFBGCSLADJTEMPLATE);
        while (it.hasNext()) {
            BgCslBizCalcExportHelper.unParseRefBgCslAdjTemplate((Element)it.next(), bizCalc.getId().toString(), refTempMap);
        }
        it = bizElement.elementIterator(DOCUMENT_BIZRELY);
        while (it.hasNext()) {
            BgCslBizCalcExportHelper.unParseRely((Element)it.next(), bizCalc.getId().toString(), relyMap);
        }
        BgCslBizCalcExportHelper.umParseBizCalcGroup(bizCalc, bizElement, bizCalcGroupId);
    }

    private static void umParseBizCalcGroup(BizCalcInfo bizCalc, Element bizElement, String bizCalcGroupId) {
        if (StringUtils.isEmpty((String)bizCalcGroupId)) {
            if (BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_BIZCALCGROUP) != null) {
                Iterator it = bizElement.elementIterator(DOCUMENT_BIZCALCGROUP);
                while (it.hasNext()) {
                    Element bizCalcGroupElement = (Element)it.next();
                    BizCalcGroupInfo bizCalcGroupInfo = new BizCalcGroupInfo();
                    if (bizCalcGroupElement != null) {
                        bizCalcGroupInfo.setNumber(BgViewHelper.getElementValue((Element)bizCalcGroupElement, (String)DOCUMENT_NUMBER));
                        bizCalcGroupInfo.setName(BgViewHelper.getElementValue((Element)bizCalcGroupElement, (String)DOCUMENT_NAME));
                        if (BgViewHelper.getElementValue((Element)bizCalcGroupElement, (String)DOCUMENT_NUMBER).equals("PRE")) {
                            bizCalcGroupInfo.setId(BOSUuid.read((String)"IkpMdUyjQyOGom8OtZ0y2TQyFtQ="));
                        } else {
                            bizCalcGroupInfo.setId(BOSUuid.create((BOSObjectType)bizCalcGroupInfo.getBOSType()));
                        }
                    } else {
                        bizCalcGroupInfo.setId(BOSUuid.read((String)"IkpMdUyjQyOGom8OtZ0y2TQyFtQ="));
                        bizCalcGroupInfo.setNumber("PRE");
                        bizCalcGroupInfo.setName(BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"default_bizCalcGroup"));
                    }
                    bizCalc.setBizCalcGroup(bizCalcGroupInfo);
                }
            } else {
                BizCalcGroupInfo bizCalcGroupInfo = new BizCalcGroupInfo();
                bizCalcGroupInfo.setId(BOSUuid.read((String)"IkpMdUyjQyOGom8OtZ0y2TQyFtQ="));
                bizCalcGroupInfo.setNumber("PRE");
                bizCalcGroupInfo.setName(BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"default_bizCalcGroup"));
                bizCalc.setBizCalcGroup(bizCalcGroupInfo);
            }
        } else {
            BizCalcGroupInfo bizCalcGroupInfo = new BizCalcGroupInfo();
            bizCalcGroupInfo.setId(BOSUuid.read((String)bizCalcGroupId));
            bizCalc.setBizCalcGroup(bizCalcGroupInfo);
        }
    }

    private static void unParseRely(Element relyElement, String bizCalcId, Map<String, List<BizCalcInfo>> relyMap) {
        if (relyElement == null) {
            return;
        }
        BizCalcInfo bizCalcInfo = new BizCalcInfo();
        if (!relyMap.containsKey(bizCalcId)) {
            relyMap.put(bizCalcId, new ArrayList());
        }
        relyMap.get(bizCalcId).add(bizCalcInfo);
        bizCalcInfo.setNumber(BgViewHelper.getElementValue((Element)relyElement, (String)DOCUMENT_NUMBER));
        bizCalcInfo.setName(BgViewHelper.getElementValue((Element)relyElement, (String)DOCUMENT_NAME));
    }

    private static void unParseRefWorkTemplate(Element refBgTemplateElement, String bizCalcId, Map<String, Map<String, IObjectCollection>> refBgTempMap) {
        if (!refBgTempMap.containsKey(bizCalcId)) {
            refBgTempMap.put(bizCalcId, new HashMap());
        }
        if (!refBgTempMap.get(bizCalcId).containsKey("WORKTEMPLATE_COLLECTION")) {
            refBgTempMap.get(bizCalcId).put("WORKTEMPLATE_COLLECTION", (IObjectCollection)new BgNWorkTemplateCollection());
        }
        BgNWorkTemplateInfo bgNWorkTemplateInfo = new BgNWorkTemplateInfo();
        refBgTempMap.get(bizCalcId).get("WORKTEMPLATE_COLLECTION").addObject((IObjectValue)bgNWorkTemplateInfo);
        bgNWorkTemplateInfo.setNumber(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NUMBER));
        bgNWorkTemplateInfo.setName(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NAME));
    }

    private static void unParseRefBgTemplate(Element refBgTemplateElement, String bizCalcId, Map<String, Map<String, IObjectCollection>> refBgTempMap) {
        if (!refBgTempMap.containsKey(bizCalcId)) {
            refBgTempMap.put(bizCalcId, new HashMap());
        }
        if (!refBgTempMap.get(bizCalcId).containsKey("bgtemplate")) {
            refBgTempMap.get(bizCalcId).put("bgtemplate", (IObjectCollection)new BgCslTemplateCollection());
        }
        BgCslTemplateInfo bgCslTemplateInfo = new BgCslTemplateInfo();
        refBgTempMap.get(bizCalcId).get("bgtemplate").addObject((IObjectValue)bgCslTemplateInfo);
        bgCslTemplateInfo.setNumber(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NUMBER));
        bgCslTemplateInfo.setName(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NAME));
    }

    private static void unParseRefBgCslAdjTemplate(Element refBgTemplateElement, String bizCalcId, Map<String, Map<String, IObjectCollection>> refBgTempMap) {
        if (!refBgTempMap.containsKey(bizCalcId)) {
            refBgTempMap.put(bizCalcId, new HashMap());
        }
        if (!refBgTempMap.get(bizCalcId).containsKey("bgcsladjtemplate")) {
            refBgTempMap.get(bizCalcId).put("bgcsladjtemplate", (IObjectCollection)new BgCslAdjTemplateCollection());
        }
        BgCslAdjTemplateInfo bgCslTemplateInfo = new BgCslAdjTemplateInfo();
        refBgTempMap.get(bizCalcId).get("bgcsladjtemplate").addObject((IObjectValue)bgCslTemplateInfo);
        bgCslTemplateInfo.setNumber(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NUMBER));
        bgCslTemplateInfo.setName(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NAME));
    }

    private static void unParseSubSet(Element subSetElement, BizCalcSubsetInfo subSetInfo) {
        subSetInfo.setId(BOSUuid.create((BOSObjectType)subSetInfo.getBOSType()));
        subSetInfo.setSeq(Integer.parseInt(BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_SEQ)));
        subSetInfo.setName(BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_NAME));
        subSetInfo.setBizFormula(BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_FORMULA));
        Iterator it = subSetElement.elementIterator(DOCUMENT_SCOPE);
        while (it.hasNext()) {
            BizScopeInfo scope = new BizScopeInfo();
            scope.setBizCalcSubset(subSetInfo);
            subSetInfo.getScope().add(scope);
            BgCslBizCalcExportHelper.unParseScope((Element)it.next(), scope);
        }
    }

    private static void unParseScope(Element scopeElement, BizScopeInfo scopeInfo) {
        scopeInfo.setId(BOSUuid.create((BOSObjectType)scopeInfo.getBOSType()));
        scopeInfo.setSeq(Integer.parseInt(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_SEQ)));
        scopeInfo.setBgMemberAlias(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BGMEMBERALIAS));
        scopeInfo.setBgMemberNum(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BGMEMBERNUM));
        scopeInfo.setBgMemberType(Integer.parseInt(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BGMEMBERTYPE)));
        scopeInfo.setBizDataType(BgMemberSelectTypeEnum.getEnum((String)BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BIZDATATYPE)));
        scopeInfo.setFillType(DimensionMemberTypeEnum.getEnum((String)BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_FILLTYPE)));
        scopeInfo.setRefField(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_REFFIELD));
    }
}

