/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.utils;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgExamineRefCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.mbg.BgExamineCollection;
import com.kingdee.eas.ma.mbg.BgExamineFactory;
import com.kingdee.eas.ma.mbg.BgExamineGroupInfo;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineNoPassEnum;
import com.kingdee.eas.ma.mbg.BgExamineStateEnum;
import com.kingdee.eas.ma.mbg.BgExamineSubsetInfo;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgScopeInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineExportHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class BgCslExamineExportHelper {
    public static final String ENCODING = "UTF-8";
    private static final String DOCUMENT_BGEXAMINE = "BgExamine";
    private static final String DOCUMENT_NUMBER = "number";
    private static final String DOCUMENT_NAME = "name";
    private static final String DOCUMENT_HINT = "hint";
    private static final String DOCUMENT_ERRORDATA = "errorData";
    private static final String DOCUMENT_NOPASS = "noPass";
    private static final String DOCUMENT_DESCRIPTION = "description";
    private static final String DOCUMENT_SEQ = "seq";
    private static final String DOCUMENT_FORMULA = "formula";
    private static final String DOCUMENT_SCOPE = "bgScope";
    private static final String DOCUMENT_BGMEMBERALIAS = "bgMemberAlias";
    private static final String DOCUMENT_BGMEMBERNUM = "bgMemberNum";
    private static final String DOCUMENT_BGMEMBERTYPE = "bgMemberType";
    private static final String DOCUMENT_BIZDATATYPE = "bizDataType";
    private static final String DOCUMENT_FILLTYPE = "fillType";
    private static final String DOCUMENT_REFFIELD = "refField";
    private static final String DOCUMENT_MBGDIMNUM = "mbgDimNum";
    private static final String DOCUMENT_BGEXAMINESUBSET = "bgExamineSubset";
    private static final String DOCUMENT_BGEXAMINEREFBGTEMPLATE = "bgExamineRefBgTemplate";
    private static final String DOCUMENT_BGEXAMINEREFWORKTEMPLATE = "bgExamineRefWorkTemplate";
    private static final String DOCUMENT_BGEXAMINEREFBGCSLADJTEMPLATE = "bgExamineRefBgCslAdjTemplate";
    private static final String DOCUMENT_SRCS = "SRCS";
    private static final String DOCUMENT_BGEXAMINEGROUP = "bgExamineGroup";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportBgExamine(List<String> selectIds, File file) throws Exception {
        Map fieldDimMap = BgExamineExportHelper.getFieldDimMap();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add(DOCUMENT_NUMBER);
        sic.add(DOCUMENT_NAME);
        sic.add(DOCUMENT_FORMULA);
        sic.add(DOCUMENT_HINT);
        sic.add(DOCUMENT_ERRORDATA);
        sic.add(DOCUMENT_NOPASS);
        sic.add(DOCUMENT_DESCRIPTION);
        sic.add("srcNumbers");
        sic.add("bgExamineSubset.*");
        sic.add("bgExamineSubset.bgScope.*");
        sic.add("bgExamineGroup.id");
        sic.add("bgExamineGroup.number");
        sic.add("bgExamineGroup.name");
        evi.setSelector(sic);
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo(DOCUMENT_NUMBER));
        evi.getSorter().add(new SorterItemInfo("bgExamineSubset.seq"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(selectIds), CompareType.INCLUDE));
        BgExamineCollection bgExamines = BgExamineFactory.getRemoteInstance().getBgExamineCollection(evi);
        Map refTemplateMap = BgExamineRefCslTemplateFactory.getRemoteInstance().getRefTemplates(new HashSet<String>(selectIds));
        Document doc = DocumentHelper.createDocument();
        Element rootElement = doc.addElement(DOCUMENT_BGEXAMINE);
        rootElement.addComment(BgCommCHelper.getMessageStr((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"bgExamineExportMsg"));
        for (int i = 0; i < bgExamines.size(); ++i) {
            BgCslExamineExportHelper.buildDocument(rootElement, bgExamines.get(i), refTemplateMap, fieldDimMap);
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(ENCODING);
        try (FileOutputStream out = new FileOutputStream(file);){
            XMLWriter writer = new XMLWriter((OutputStream)out, format);
            writer.write(doc);
            writer.close();
        }
    }

    private static void buildDocument(Element rootElement, BgExamineInfo bgExamineInfo, Map<String, Map<String, IObjectCollection>> refTemplateMap, Map<String, MbgDimInfo> fieldDimMap) {
        Element bizElement = rootElement.addElement(DOCUMENT_BGEXAMINE);
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_NUMBER, (Object)bgExamineInfo.getNumber());
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_NAME, (Object)bgExamineInfo.getName());
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_NOPASS, (Object)bgExamineInfo.getNoPass().getName());
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_DESCRIPTION, (Object)bgExamineInfo.getDescription());
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_SRCS, (Object)bgExamineInfo.getSrcNumbers());
        BgExamineSubsetInfo bgExamineSubsetInfo = null;
        for (int index = 0; index < bgExamineInfo.getBgExamineSubset().size(); ++index) {
            bgExamineSubsetInfo = bgExamineInfo.getBgExamineSubset().get(index);
            BgCslExamineExportHelper.buildDocument(bizElement, bgExamineSubsetInfo, fieldDimMap);
        }
        BgCslExamineExportHelper.buildDocument(bizElement, refTemplateMap.get(bgExamineInfo.getId().toString()));
        BgCslExamineExportHelper.buildDocument(bizElement, bgExamineInfo.getBgExamineGroup());
    }

    private static void buildDocument(Element bizElement, BgExamineGroupInfo bgExamineGroupInfo) {
        if (bizElement == null || bgExamineGroupInfo == null) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BGEXAMINEGROUP);
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NUMBER, (Object)bgExamineGroupInfo.getNumber());
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NAME, (Object)bgExamineGroupInfo.getName());
    }

    private static void buildDocument(Element bizElement, BgExamineSubsetInfo bgExamineSubsetInfo, Map<String, MbgDimInfo> fieldDimMap) {
        Element subSetElement = bizElement.addElement(DOCUMENT_BGEXAMINESUBSET);
        BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_NAME, (Object)bgExamineSubsetInfo.getName());
        BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_SEQ, (Object)bgExamineSubsetInfo.getSeq());
        BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_ERRORDATA, (Object)bgExamineSubsetInfo.getErrorData());
        BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_HINT, (Object)bgExamineSubsetInfo.getHint());
        BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_FORMULA, (Object)bgExamineSubsetInfo.getBizFormula());
        for (int i = 0; i < bgExamineSubsetInfo.getBgScope().size(); ++i) {
            BgCslExamineExportHelper.buildDocument(subSetElement, bgExamineSubsetInfo.getBgScope().get(i), fieldDimMap);
        }
    }

    private static void buildDocument(Element bizElement, BgScopeInfo bgScopeInfo, Map<String, MbgDimInfo> fieldDimMap) {
        Element scopeElement = bizElement.addElement(DOCUMENT_SCOPE);
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BGMEMBERALIAS, (Object)bgScopeInfo.getBgMemberAlias());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BGMEMBERNUM, (Object)bgScopeInfo.getBgMemberNum());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BGMEMBERTYPE, (Object)bgScopeInfo.getBgMemberType());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BIZDATATYPE, (Object)bgScopeInfo.getBizDataType().getName());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_FILLTYPE, (Object)bgScopeInfo.getFillType().getName());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_MBGDIMNUM, (Object)fieldDimMap.get(bgScopeInfo.getRefField()).getNumber());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_REFFIELD, (Object)bgScopeInfo.getRefField());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_SEQ, (Object)bgScopeInfo.getSeq());
    }

    private static void buildDocument(Element bizElement, Map<String, IObjectCollection> refTemps) {
        int i;
        AbstractObjectCollection colls;
        if (bizElement == null || refTemps == null || refTemps.isEmpty()) {
            return;
        }
        if (refTemps.containsKey("WORKTEMPLATE_COLLECTION") && (colls = (BgNWorkTemplateCollection)refTemps.get("WORKTEMPLATE_COLLECTION")) != null && !colls.isEmpty()) {
            for (i = 0; i < colls.size(); ++i) {
                BgCslExamineExportHelper.buildDocument(bizElement, colls.get(i));
            }
        }
        if (refTemps.containsKey("bgtemplate") && (colls = (BgCslTemplateCollection)refTemps.get("bgtemplate")) != null && !colls.isEmpty()) {
            for (i = 0; i < colls.size(); ++i) {
                BgCslExamineExportHelper.buildDocument(bizElement, colls.get(i));
            }
        }
        if (refTemps.containsKey("bgcsladjtemplate") && (colls = (BgCslAdjTemplateCollection)refTemps.get("bgcsladjtemplate")) != null && !colls.isEmpty()) {
            for (i = 0; i < colls.size(); ++i) {
                BgCslExamineExportHelper.buildDocument(bizElement, colls.get(i));
            }
        }
    }

    private static void buildDocument(Element bizElement, BgNWorkTemplateInfo bgNWorkTemplateInfo) {
        if (bizElement == null || bgNWorkTemplateInfo == null) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BGEXAMINEREFWORKTEMPLATE);
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NUMBER, (Object)bgNWorkTemplateInfo.getNumber());
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NAME, (Object)bgNWorkTemplateInfo.getName());
    }

    private static void buildDocument(Element bizElement, BgCslTemplateInfo bgCslTemplateInfo) {
        if (bizElement == null || bgCslTemplateInfo == null) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BGEXAMINEREFBGTEMPLATE);
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NUMBER, (Object)bgCslTemplateInfo.getNumber());
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NAME, (Object)bgCslTemplateInfo.getName());
    }

    private static void buildDocument(Element bizElement, BgCslAdjTemplateInfo bgCslTemplateInfo) {
        if (bizElement == null || bgCslTemplateInfo == null) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BGEXAMINEREFBGCSLADJTEMPLATE);
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NUMBER, (Object)bgCslTemplateInfo.getNumber());
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NAME, (Object)bgCslTemplateInfo.getName());
    }

    public static String importBgExamine(String bgSchemeId, String orgUnitId, String orgTreeId, String filePath, ErrorHandleModeEnum errorHandle, String bgExamineGroupId) throws Exception {
        Map mbgDimMap = BgExamineExportHelper.getMbgDimMap();
        LinkedHashMap<String, BgExamineInfo> bgExamineMap = new LinkedHashMap<String, BgExamineInfo>();
        HashMap<String, Map<String, IObjectCollection>> refBgTempMap = new HashMap<String, Map<String, IObjectCollection>>();
        BgCslExamineExportHelper.unParse(filePath, bgExamineMap, refBgTempMap, mbgDimMap, bgExamineGroupId);
        return BgExamineRefCslTemplateFactory.getRemoteInstance().importBgExamine(bgSchemeId, orgUnitId, orgTreeId, bgExamineMap, refBgTempMap, errorHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unParse(String filePath, Map<String, BgExamineInfo> bgExamineMap, Map<String, Map<String, IObjectCollection>> refBgTempMap, Map<String, MbgDimInfo> mbgDimMap, String bgExamineGroupId) throws Exception {
        SAXReader reader = new SAXReader();
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(new File(filePath));
            Document document = reader.read((InputStream)fileInputStream);
            Element rootElement = document.getRootElement();
            Iterator it = rootElement.elementIterator(DOCUMENT_BGEXAMINE);
            while (it.hasNext()) {
                BgCslExamineExportHelper.unParseBgExamine((Element)it.next(), bgExamineMap, refBgTempMap, mbgDimMap, bgExamineGroupId);
            }
        }
    }

    private static void unParseBgExamine(Element bizElement, Map<String, BgExamineInfo> bgExamineMap, Map<String, Map<String, IObjectCollection>> refBgTempMap, Map<String, MbgDimInfo> mbgDimMap, String bgExamineGroupId) {
        BgExamineInfo bgExamineInfo = new BgExamineInfo();
        bgExamineInfo.setId(BOSUuid.create((BOSObjectType)bgExamineInfo.getBOSType()));
        bgExamineInfo.setState(BgExamineStateEnum.SAVED);
        bgExamineMap.put(bgExamineInfo.getId().toString(), bgExamineInfo);
        bgExamineInfo.setNumber(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_NUMBER));
        bgExamineInfo.setName(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_NAME));
        bgExamineInfo.setNoPass(BgExamineNoPassEnum.getEnum((String)BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_NOPASS)));
        bgExamineInfo.setDescription(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_DESCRIPTION));
        bgExamineInfo.setSrcNumbers(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_SRCS));
        bgExamineInfo.setEnableTime(new Timestamp(System.currentTimeMillis()));
        bgExamineInfo.setEnableUser(SysContext.getSysContext().getCurrentUserInfo());
        Iterator it = bizElement.elementIterator(DOCUMENT_BGEXAMINESUBSET);
        while (it.hasNext()) {
            BgExamineSubsetInfo subSet = new BgExamineSubsetInfo();
            subSet.setBgExamine(bgExamineInfo);
            bgExamineInfo.getBgExamineSubset().add(subSet);
            BgCslExamineExportHelper.unParseSubSet((Element)it.next(), subSet, mbgDimMap);
        }
        it = bizElement.elementIterator(DOCUMENT_BGEXAMINEREFWORKTEMPLATE);
        while (it.hasNext()) {
            BgCslExamineExportHelper.unParseRefWorkTemplate((Element)it.next(), bgExamineInfo.getId().toString(), refBgTempMap);
        }
        it = bizElement.elementIterator(DOCUMENT_BGEXAMINEREFBGTEMPLATE);
        while (it.hasNext()) {
            BgCslExamineExportHelper.unParseRefBgTemplate((Element)it.next(), bgExamineInfo.getId().toString(), refBgTempMap);
        }
        it = bizElement.elementIterator(DOCUMENT_BGEXAMINEREFBGCSLADJTEMPLATE);
        while (it.hasNext()) {
            BgCslExamineExportHelper.unParseRefBgCslAdjTemplate((Element)it.next(), bgExamineInfo.getId().toString(), refBgTempMap);
        }
        BgCslExamineExportHelper.umParseBizCalcGroup(bgExamineInfo, bizElement, bgExamineGroupId);
    }

    private static void umParseBizCalcGroup(BgExamineInfo bgExamineInfo, Element bizElement, String bgExamineGroupId) {
        if (StringUtils.isEmpty((String)bgExamineGroupId)) {
            if (BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_BGEXAMINEGROUP) != null) {
                Iterator it = bizElement.elementIterator(DOCUMENT_BGEXAMINEGROUP);
                while (it.hasNext()) {
                    Element bgExamineGroupElement = (Element)it.next();
                    BgExamineGroupInfo bgExamineGroupInfo = new BgExamineGroupInfo();
                    if (bgExamineGroupElement != null) {
                        bgExamineGroupInfo.setNumber(BgViewHelper.getElementValue((Element)bgExamineGroupElement, (String)DOCUMENT_NUMBER));
                        bgExamineGroupInfo.setName(BgViewHelper.getElementValue((Element)bgExamineGroupElement, (String)DOCUMENT_NAME));
                        if (BgViewHelper.getElementValue((Element)bgExamineGroupElement, (String)DOCUMENT_NUMBER).equals("PRE")) {
                            bgExamineGroupInfo.setId(BOSUuid.read((String)"PCto8jovS9md/v3tQ45tMIdbVAE="));
                        } else {
                            bgExamineGroupInfo.setId(BOSUuid.create((BOSObjectType)bgExamineGroupInfo.getBOSType()));
                        }
                    } else {
                        bgExamineGroupInfo.setId(BOSUuid.read((String)"PCto8jovS9md/v3tQ45tMIdbVAE="));
                        bgExamineGroupInfo.setNumber("PRE");
                        bgExamineGroupInfo.setName(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"default_group"));
                    }
                    bgExamineInfo.setBgExamineGroup(bgExamineGroupInfo);
                }
            } else {
                BgExamineGroupInfo bgExamineGroupInfo = new BgExamineGroupInfo();
                bgExamineGroupInfo.setId(BOSUuid.read((String)"PCto8jovS9md/v3tQ45tMIdbVAE="));
                bgExamineGroupInfo.setNumber("PRE");
                bgExamineGroupInfo.setName(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"default_group"));
                bgExamineInfo.setBgExamineGroup(bgExamineGroupInfo);
            }
        } else {
            BgExamineGroupInfo bgExamineGroupInfo = new BgExamineGroupInfo();
            bgExamineGroupInfo.setId(BOSUuid.read((String)bgExamineGroupId));
            bgExamineInfo.setBgExamineGroup(bgExamineGroupInfo);
        }
    }

    private static void unParseSubSet(Element subSetElement, BgExamineSubsetInfo subSetInfo, Map<String, MbgDimInfo> mbgDimMap) {
        subSetInfo.setId(BOSUuid.create((BOSObjectType)subSetInfo.getBOSType()));
        subSetInfo.setName(BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_NAME));
        subSetInfo.setErrorData(new BigDecimal(BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_ERRORDATA)));
        subSetInfo.setSeq(Integer.valueOf(BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_SEQ)).intValue());
        subSetInfo.setHint(BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_HINT));
        subSetInfo.setBizFormula(BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_FORMULA));
        Iterator it = subSetElement.elementIterator(DOCUMENT_SCOPE);
        while (it.hasNext()) {
            BgScopeInfo scope = new BgScopeInfo();
            scope.setBgExamineSubset(subSetInfo);
            subSetInfo.getBgScope().add(scope);
            BgCslExamineExportHelper.unParseScope((Element)it.next(), scope, mbgDimMap);
        }
    }

    private static void unParseScope(Element scopeElement, BgScopeInfo scopeInfo, Map<String, MbgDimInfo> mbgDimMap) {
        scopeInfo.setId(BOSUuid.create((BOSObjectType)scopeInfo.getBOSType()));
        scopeInfo.setSeq(Integer.parseInt(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_SEQ)));
        scopeInfo.setBgMemberAlias(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BGMEMBERALIAS));
        scopeInfo.setBgMemberNum(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BGMEMBERNUM));
        scopeInfo.setBgMemberType(Integer.parseInt(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BGMEMBERTYPE)));
        scopeInfo.setBizDataType(BgMemberSelectTypeEnum.getEnum((String)BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BIZDATATYPE)));
        scopeInfo.setFillType(DimensionMemberTypeEnum.getEnum((String)BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_FILLTYPE)));
        String mbgDimNum = BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_MBGDIMNUM);
        if (!StringUtils.isEmpty((String)mbgDimNum)) {
            scopeInfo.setRefField(mbgDimMap.get(mbgDimNum).getRefField());
        } else {
            scopeInfo.setRefField(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_REFFIELD));
        }
    }

    private static void unParseRefWorkTemplate(Element refBgTemplateElement, String bgExamineId, Map<String, Map<String, IObjectCollection>> refBgTempMap) {
        if (!refBgTempMap.containsKey(bgExamineId)) {
            refBgTempMap.put(bgExamineId, new HashMap());
        }
        if (!refBgTempMap.get(bgExamineId).containsKey("WORKTEMPLATE_COLLECTION")) {
            refBgTempMap.get(bgExamineId).put("WORKTEMPLATE_COLLECTION", (IObjectCollection)new BgNWorkTemplateCollection());
        }
        BgNWorkTemplateInfo bgTemplateInfo = new BgNWorkTemplateInfo();
        refBgTempMap.get(bgExamineId).get("WORKTEMPLATE_COLLECTION").addObject((IObjectValue)bgTemplateInfo);
        bgTemplateInfo.setNumber(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NUMBER));
        bgTemplateInfo.setName(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NAME));
    }

    private static void unParseRefBgTemplate(Element refBgTemplateElement, String bgExamineId, Map<String, Map<String, IObjectCollection>> refBgTempMap) {
        if (!refBgTempMap.containsKey(bgExamineId)) {
            refBgTempMap.put(bgExamineId, new HashMap());
        }
        if (!refBgTempMap.get(bgExamineId).containsKey("bgtemplate")) {
            refBgTempMap.get(bgExamineId).put("bgtemplate", (IObjectCollection)new BgCslTemplateCollection());
        }
        BgCslTemplateInfo bgTemplateInfo = new BgCslTemplateInfo();
        refBgTempMap.get(bgExamineId).get("bgtemplate").addObject((IObjectValue)bgTemplateInfo);
        bgTemplateInfo.setNumber(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NUMBER));
        bgTemplateInfo.setName(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NAME));
    }

    private static void unParseRefBgCslAdjTemplate(Element refBgTemplateElement, String bgExamineId, Map<String, Map<String, IObjectCollection>> refBgTempMap) {
        if (!refBgTempMap.containsKey(bgExamineId)) {
            refBgTempMap.put(bgExamineId, new HashMap());
        }
        if (!refBgTempMap.get(bgExamineId).containsKey("bgcsladjtemplate")) {
            refBgTempMap.get(bgExamineId).put("bgcsladjtemplate", (IObjectCollection)new BgCslAdjTemplateCollection());
        }
        BgCslAdjTemplateInfo bgTemplateInfo = new BgCslAdjTemplateInfo();
        refBgTempMap.get(bgExamineId).get("bgcsladjtemplate").addObject((IObjectValue)bgTemplateInfo);
        bgTemplateInfo.setNumber(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NUMBER));
        bgTemplateInfo.setName(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NAME));
    }
}

