/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.client.utils;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.bgcsl.UnionDataFacadeFactory;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class MbgWorkPaperThread {
    private BOSUuid bgSchemeId = null;
    private BOSUuid unionId = null;
    private BOSUuid billId = null;
    private List<BOSUuid> orgUnitIds = null;
    private List<List<IDimension>> mbgDims = null;

    @Deprecated
    private MbgWorkPaperThread(BOSUuid bgSchemeId, BOSUuid unionId, BOSUuid billId, List<BOSUuid> orgUnitIds, List<List<IDimension>> mbgDims) {
        this.bgSchemeId = bgSchemeId;
        this.unionId = unionId;
        this.billId = billId;
        this.orgUnitIds = orgUnitIds;
        this.mbgDims = mbgDims;
    }

    public Map<String, Map<String, IBgNData>> queryWorkPaperDataByMultiThread() throws InterruptedException, ExecutionException {
        int i;
        HashMap<String, Map<String, IBgNData>> resultWorkPaperData = new HashMap<String, Map<String, IBgNData>>();
        int poolSize = 6;
        ExecutorService threadPool = Executors.newFixedThreadPool(poolSize);
        ArrayList<Future<Object>> result = new ArrayList<Future<Object>>();
        Map<Integer, List<BOSUuid>> splitOrgParamPoolMap = this.getSplitOrgParamPoolMap(poolSize, this.orgUnitIds);
        for (i = 0; i < poolSize; ++i) {
            MbgWorkPaperCallable curBgDataMapCall = new MbgWorkPaperCallable(splitOrgParamPoolMap.get(i));
            Future<Object> curBgDataMap = threadPool.submit(curBgDataMapCall);
            result.add(curBgDataMap);
        }
        threadPool.shutdown();
        for (i = 0; i < result.size(); ++i) {
            if (!(((Future)result.get(i)).get() instanceof Map)) continue;
            resultWorkPaperData.putAll((Map)((Future)result.get(i)).get());
        }
        return resultWorkPaperData;
    }

    private Map<Integer, List<BOSUuid>> getSplitOrgParamPoolMap(int poolSize, List<BOSUuid> orgUnitIds) {
        HashMap<Integer, List<BOSUuid>> orgParamPoolMap = new HashMap<Integer, List<BOSUuid>>();
        if (orgUnitIds.isEmpty()) {
            return orgParamPoolMap;
        }
        int orgSize = orgUnitIds.size();
        int averageCount = orgSize / poolSize;
        int modCount = orgSize % poolSize;
        ArrayList<Object> curOrgList = null;
        if (averageCount < 1) {
            for (int i = 0; i < orgUnitIds.size(); ++i) {
                curOrgList = new ArrayList();
                curOrgList.add(orgUnitIds.get(i));
                orgParamPoolMap.put(i, curOrgList);
            }
        } else {
            for (int i = 0; i < poolSize; ++i) {
                curOrgList = new ArrayList<Object>();
                for (int j = i; j < (i + 1) * averageCount; ++j) {
                    curOrgList.add(orgUnitIds.get(j));
                }
                if (modCount > 0) {
                    curOrgList.add(curOrgList.get(--modCount));
                }
                orgParamPoolMap.put(i, curOrgList);
            }
        }
        return orgParamPoolMap;
    }

    class MbgWorkPaperCallable
    implements Callable<Object> {
        private List<BOSUuid> orgGroupList = null;

        public MbgWorkPaperCallable(List<BOSUuid> orgGroupList) {
            this.orgGroupList = orgGroupList;
        }

        @Override
        public Object call() throws Exception {
            Map indvDataMap = UnionDataFacadeFactory.getRemoteInstance().loadIndvData(MbgWorkPaperThread.this.bgSchemeId, MbgWorkPaperThread.this.unionId, MbgWorkPaperThread.this.billId, this.orgGroupList, MbgWorkPaperThread.this.mbgDims, null, null);
            return indvDataMap;
        }
    }
}

