/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.client.cslTemplate.BgSpecialBudgetHelper;
import com.kingdee.eas.ma.bgcsl.common.IBgCslSpecialInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BgCslFormHelper {
    public static final String NEW_BOOK = "newBook";
    public static final String RESOURCE = "com.kingdee.eas.ma.bgcsl.BgCslFormResource";
    public static final String RESOURCE_ADJ = "com.kingdee.eas.ma.bgcsl.BgCslAdjFormResource";
    public static final String ISEXPORTWORKPAPERINFO = "isExportWorkPaperInfo";
    public static final String ISEXPORTADJFORMINFO = "isExportCslAdjFormInfo";
    public static final String ISALLFORMINFO = "isAllFormInfo";

    public static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("state");
        sic.add("data");
        sic.add("dimensionData");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("processType");
        sic.add("startDate");
        sic.add("endDate");
        sic.add("sourceType");
        sic.add("CU.id");
        sic.add("CU.name");
        sic.add("orgType");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("company.isBizUnit");
        sic.add("company.accountPeriodType.id");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.beginDate");
        sic.add("bgPeriod.endDate");
        sic.add("bgPeriod.halfyear");
        sic.add("bgPeriod.week");
        sic.add("bgPeriod.year");
        sic.add("bgPeriod.month");
        sic.add("bgPeriod.quarter");
        sic.add("bgPeriod.longnumber");
        sic.add("bgVersion.id");
        sic.add("bgVersion.number");
        sic.add("bgVersion.name");
        sic.add("bgVersion.versionId");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("bgScheme.name");
        sic.add("bgScheme.dateFrom");
        sic.add("bgScheme.dateTo");
        sic.add("bgScheme.orgUnit.id");
        sic.add("bgScheme.orgUnit.number");
        sic.add("bgScheme.orgUnit.name");
        sic.add("bgCslTemplate.id");
        sic.add("bgCslTemplate.number");
        sic.add("bgCslTemplate.name");
        sic.add("bgCslTemplate.formType");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("cslFormMeasureUnit.id");
        sic.add("cslFormMeasureUnit.bgElement.id");
        sic.add("cslFormMeasureUnit.bgElement.number");
        sic.add("cslFormMeasureUnit.bgElement.name");
        sic.add("cslFormMeasureUnit.measureUnit.id");
        sic.add("cslFormMeasureUnit.measureUnit.number");
        sic.add("cslFormMeasureUnit.measureUnit.coefficient");
        sic.add("measureUnit.id");
        sic.add("measureUnit.number");
        sic.add("measureUnit.name");
        sic.add("measureUnit.coefficient");
        sic.add("currency.id");
        sic.add("currency.number");
        sic.add("currency.precision");
        sic.add("currency.name");
        sic.add("orgTree.id");
        sic.add("orgTree.number");
        sic.add("bgSpecialItems.*");
        sic.add("bgSpecialItems.dimRelaGroupRef.*");
        sic.add("bgCslTemplate.styleSet.id");
        sic.add("bgCslTemplate.styleSet.number");
        sic.add("bgCslTemplate.styleSet.name");
        sic.add("bgCslTemplate.styleSet.data");
        sic.add("bgCslTemplate.styleSet.isSysDefault");
        sic.add("bgCslTemplate.bgScheme.id");
        return sic;
    }

    public static void setNewBook(Book book) {
        if (book != null) {
            book.setUserObject(NEW_BOOK, (Object)NEW_BOOK);
        }
    }

    public static boolean isNewBook(Book book) {
        return book != null && NEW_BOOK.equals(book.getUserObjectValue(NEW_BOOK));
    }

    public static void removeNewBook(Book book) {
        if (book != null) {
            book.removeUserObject(NEW_BOOK);
        }
    }

    public static void putSpecialDimsToPageView(Context ctx, IBgCslSpecialInfo bgFormInfo, IMbgViewManager view, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        List<BgDimensionInfo> specialDims;
        if (bgFormInfo == null || view == null) {
            return;
        }
        if (bgFormInfo.getBgSpecialItems().isEmpty() && BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgFormInfo.getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM))) {
            IBgCslSpecialInfo _bgFormInfo = null;
            ICoreBase cb = null;
            cb = ctx != null ? (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)((CoreBaseInfo)bgFormInfo).getBOSType()) : (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)((CoreBaseInfo)bgFormInfo).getBOSType(), ICoreBase.class);
            _bgFormInfo = (IBgCslSpecialInfo)cb.getValue("select bgSpecialItems.* where id = '" + bgFormInfo.getId() + "'");
            if (_bgFormInfo != null && !_bgFormInfo.getBgSpecialItems().isEmpty()) {
                BgCslSpecialItemsInfo bgSpecialItemsInfo = _bgFormInfo.getBgSpecialItems().get(0);
                bgFormInfo.getBgSpecialItems().add(bgSpecialItemsInfo);
            }
        }
        if ((specialDims = BgCslFormHelper.getSpecialDimsByForm(ctx, bgFormInfo, schemeHelper)) != null && !specialDims.isEmpty()) {
            HashMap<String, BgDimensionInfo> specialDimsMap = new HashMap<String, BgDimensionInfo>();
            for (BgDimensionInfo specialDim : specialDims) {
                specialDimsMap.put(specialDim.getNumber(), specialDim);
            }
            for (int s = 0; s < view.getSheetManagers().size(); ++s) {
                IBgDimensionManager dimManager = ((IMbgSheetManager)view.getSheetManagers().get(s)).getDimensionManager();
                boolean isAddSpecialDimsToPage = false;
                for (int d = dimManager.getDimension().size() - 1; d >= 0; --d) {
                    BgDimensionInfo dim = (BgDimensionInfo)dimManager.getDimension().get(d);
                    if (!specialDimsMap.keySet().contains(dim.getNumber())) continue;
                    if (dim.getMember().isEmpty()) {
                        dimManager.getDimension().remove(d);
                        continue;
                    }
                    isAddSpecialDimsToPage = true;
                }
                if (isAddSpecialDimsToPage) continue;
                for (BgDimensionInfo specialDim : specialDims) {
                    specialDim.setDimensionManager((IBgDimensionManagerBase)dimManager);
                    specialDim.setLayout("page");
                    specialDim.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
                    specialDim.setShow(true);
                    dimManager.addDimensionInfo(specialDim.clone());
                }
            }
        }
    }

    public static List<BgDimensionInfo> getSpecialDimsByForm(Context ctx, IBgCslSpecialInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        ArrayList<BgDimensionInfo> bgDimensions = new ArrayList<BgDimensionInfo>();
        if (bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.getBgSpecialItems().isEmpty()) {
            BgCslSpecialItemsInfo bgSpecialItemsInfo = bgFormInfo.getBgSpecialItems().get(0);
            if (bgSpecialItemsInfo == null || schemeHelper == null || StringUtils.isEmpty((String)bgSpecialItemsInfo.getDimensionNumber())) {
                return bgDimensions;
            }
            String dimensionNumber = bgSpecialItemsInfo.getDimensionNumber();
            String memberName = bgSpecialItemsInfo.getMemberName();
            Map srcNumAndDimensonMap = schemeHelper.getDimensionBySrcNumber();
            String[] numbers = dimensionNumber.split(DimensionConstants.COMMA_SEPARATOR);
            String[] names = DimensionCommonHelper.splitName((String)memberName, (String)DimensionConstants.TICK_SEPARATOR);
            BgDimensionInfo bgDimensionInfo = null;
            BgDimensionMember bgDimensionMember = null;
            String mNumber = null;
            String meName = null;
            String srcNum = null;
            int length = numbers.length;
            for (int index = 0; index < length; ++index) {
                srcNum = numbers[index].split(":")[0];
                mNumber = numbers[index].split(":")[1];
                meName = names[index];
                if (!srcNumAndDimensonMap.containsKey(srcNum)) continue;
                bgDimensionInfo = ((BgDimensionInfo)srcNumAndDimensonMap.get(srcNum)).clone();
                bgDimensionInfo.getMember().clear();
                if ("#".equals(mNumber)) {
                    bgDimensionMember = null;
                } else {
                    bgDimensionMember = new BgDimensionMember(bgDimensionInfo.getNumber(), bgDimensionInfo.getRefField(), meName, mNumber);
                    bgDimensionMember.setSrcNumber(srcNum);
                    bgDimensionInfo.getMember().add(bgDimensionMember);
                }
                bgDimensions.add(bgDimensionInfo);
            }
        }
        return bgDimensions;
    }

    public static IMbgViewManager getFormView(Context ctx, BgCslFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper) throws Exception {
        IMbgViewManager view = new MbgXMLParser(ctx).parse(bgFormInfo.getDimensionData());
        DimensionCommonHelper.fillDefaultMembers((CurrencyInfo)bgFormInfo.getCurrency(), (BgPeriodInfo)bgFormInfo.getBgPeriod(), (BgVersionInfo)bgFormInfo.getBgVersion(), (IMbgViewManager)view);
        DimensionCommonHelper.convertPeriodNParam((BgPeriodInfo)bgFormInfo.getBgPeriod(), (IMbgViewManager)view);
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgFormInfo.getBgCslTemplate().getFormType())) {
            BgCslFormHelper.putSpecialDimsToPageView(ctx, bgFormInfo, view, schemeHelper);
        }
        return view;
    }

    public static IMbgViewManager getFormView(Context ctx, BgCslAdjFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper) throws Exception {
        IMbgViewManager view = new MbgXMLParser(ctx).parse(bgFormInfo.getDimensionData());
        DimensionCommonHelper.fillDefaultMembers((CurrencyInfo)bgFormInfo.getCurrency(), (BgPeriodInfo)bgFormInfo.getBgPeriod(), (BgVersionInfo)bgFormInfo.getBgVersion(), (IMbgViewManager)view);
        DimensionCommonHelper.convertPeriodNParam((BgPeriodInfo)bgFormInfo.getBgPeriod(), (IMbgViewManager)view);
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgFormInfo.getBgCslTemplate().getFormType())) {
            BgCslFormHelper.putSpecialDimsToPageView(ctx, bgFormInfo, view, schemeHelper);
        }
        return view;
    }

    public static void processNewBook(Book book, IDimDataQuery info, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        IBgCslSpecialInfo spInfo;
        if (book == null || info == null) {
            return;
        }
        HashMap<String, String> formulaMap = new HashMap<String, String>();
        Sheet sheet = null;
        Cell cell = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            BgNFSHelper.replaceSheetSign((Sheet)sheet);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    cell = sheet.getCell(r, c, false);
                    if (cell == null) continue;
                    BgCslFormHelper.processNewBook(cell, formulaMap, info);
                }
            }
        }
        if (info instanceof IBgCslSpecialInfo && !(spInfo = (IBgCslSpecialInfo)info).getBgSpecialItems().isEmpty()) {
            BgSpecialBudgetHelper.setNewSpecBook(book);
            BgSpecialBudgetHelper.fillAndbuildFormula(book, spInfo, schemeHelper);
        }
    }

    private static void processNewBook(Cell cell, Map<String, String> formulaMap, IDimDataQuery info) throws EASBizException {
        if (cell == null) {
            return;
        }
        String _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
        if (!StringUtils.isEmpty((String)_formulaStr)) {
            String _tmpformulaStr = BgNFSHelper.checkFormula(formulaMap, (String)_formulaStr, (BgPeriodInfo)info.getBizPeriod(), (CurrencyInfo)info.getBizCurrency());
            if (StringUtils.isEmpty((String)_tmpformulaStr)) {
                throw new BgException(BgException.BGITEMPARSEERROR, (Object[])new String[]{_formulaStr});
            }
            if (!_formulaStr.equals(_tmpformulaStr)) {
                BgNFSHelper.setFormulaOfCell((Cell)cell, (String)_tmpformulaStr);
                _formulaStr = _tmpformulaStr;
            }
            if (!(BgNFSHelper.getValue((Cell)cell) instanceof BigDecimal)) {
                BgNFSHelper.setValue((Cell)cell, null);
            }
        }
    }
}

