/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnionDataClearUtils
implements Serializable {
    private static final long serialVersionUID = 535080500614913496L;
    private static final String CUBE_NAME_VAR = "#cubeName#";
    private static final String CUBE_ENTRY_NAME_VAR = "#cubeEntryName#";
    private Map<String, Map<String, List<Object[]>>> clearParams = new HashMap<String, Map<String, List<Object[]>>>();

    private UnionDataClearUtils() {
    }

    public static UnionDataClearUtils getInstance(List<IBgDimensionManagerBase> dimManagers, Book book, IDimDataQuery info) {
        UnionDataClearUtils instance = new UnionDataClearUtils();
        if (dimManagers == null || dimManagers.isEmpty() || info == null) {
            return instance;
        }
        if (dimManagers.size() == 1) {
            UnionDataClearUtils.singleSheetInstance(instance, info, dimManagers.get(0));
        } else {
            UnionDataClearUtils.multiSheetInstance(instance, info, book);
        }
        return instance;
    }

    private static void multiSheetInstance(UnionDataClearUtils instance, IDimDataQuery info, Book book) {
        if (book == null) {
            return;
        }
        String billVersionNumber = info.getBizVersion().getNumber();
        HashMap formulaMap = new HashMap();
        Sheet sheet = null;
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId2 = null;
        String formulaStr2 = null;
        String cellVersion = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    cell = sheet.getCell(r, c, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || BgNFSHelper.checkIsEmptyValue((Cell)cell) || (formulaStr2 = (formula = BgNFSHelper.getItemFormula((Cell)cell)).getFormula()).indexOf(BgCslDimConstants.csl01) < 0) continue;
                    cellOrgId2 = formula.getExt("ORGUNITID");
                    if (cellOrgId2 == null) {
                        cellOrgId2 = info.getBizOrgUnit().getId().toString();
                    }
                    if ((cellVersion = formula.getExt("Version")) != null && !cellVersion.equals(billVersionNumber)) continue;
                    if (!formulaMap.containsKey(cellOrgId2)) {
                        formulaMap.put(cellOrgId2, new HashSet());
                    }
                    ((Set)formulaMap.get(cellOrgId2)).add(formulaStr2);
                }
            }
        }
        if (formulaMap.isEmpty()) {
            return;
        }
        ArrayList<String> baseParamList = new ArrayList<String>();
        StringBuffer sql = UnionDataClearUtils.getBaseSql(baseParamList, info.getBizVersion().getVersionId());
        int baseSize = baseParamList.size();
        sql.append("and fformula = ? ");
        Set tmpSet = null;
        ArrayList<Object[]> tmpList = null;
        for (String cellOrgId2 : formulaMap.keySet()) {
            tmpSet = (Set)formulaMap.get(cellOrgId2);
            tmpList = new ArrayList<Object[]>();
            instance.clearParams.put(cellOrgId2, new HashMap());
            instance.clearParams.get(cellOrgId2).put(sql.toString(), tmpList);
            for (String formulaStr2 : tmpSet) {
                if (baseParamList.size() == baseSize) {
                    baseParamList.add(formulaStr2);
                } else {
                    baseParamList.set(baseSize, formulaStr2);
                }
                tmpList.add(baseParamList.toArray());
            }
        }
    }

    private static void singleSheetInstance(UnionDataClearUtils instance, IDimDataQuery info, IBgDimensionManagerBase dimManager) {
        ArrayList pageViewDims = new ArrayList();
        pageViewDims.addAll(dimManager.getPageDisplayDimension());
        pageViewDims.addAll(dimManager.getViewDimension());
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer sql = UnionDataClearUtils.getBaseSql(paramList, info.getBizVersion().getVersionId()).append("and exists (select FDataId from ").append(CUBE_ENTRY_NAME_VAR).append(" where FFormId = ? and FDataId = ").append(CUBE_NAME_VAR).append(".FID) ");
        paramList.add(info.getId().toString());
        BgDimensionBaseInfo dimension = null;
        for (int d = 0; d < pageViewDims.size(); ++d) {
            if (!(pageViewDims.get(d) instanceof BgDimensionBaseInfo)) continue;
            dimension = (BgDimensionBaseInfo)pageViewDims.get(d);
            if (dimension.getMember().isEmpty()) {
                return;
            }
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_CSL_NUMBER.equals(dimension.getNumber())) continue;
            if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                sql.append("and fbgperiodid in(Select FID FROM T_MBG_BgPeriod Where FNumber = ?) ");
                paramList.add(BgViewHelper.getNumber(dimension.getMember().get(0)));
                continue;
            }
            if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                sql.append("and fcurrencyid in(Select FID FROM T_BD_Currency Where FNumber = ?) ");
                paramList.add(BgViewHelper.getNumber(dimension.getMember().get(0)));
                continue;
            }
            if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                sql.append("and fbgelementid in(Select FID FROM T_MBG_BgElement Where FNumber = ?) ");
                paramList.add(BgViewHelper.getNumber(dimension.getMember().get(0)));
                continue;
            }
            if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                sql.append("and fscenario in(Select FScenarioID FROM T_MBG_BgScenario Where FNumber = ?) ");
                paramList.add(BgViewHelper.getNumber(dimension.getMember().get(0)));
                continue;
            }
            sql.append("and ").append(dimension.getRefField()).append(" = ? ");
            paramList.add(((BgDimensionMember)dimension.getMember().get(0)).getCombNumber());
        }
        ArrayList<Object[]> tmpList = new ArrayList<Object[]>();
        tmpList.add(paramList.toArray());
        instance.clearParams.put("000000000000000000000000000=", new HashMap());
        instance.clearParams.get("000000000000000000000000000=").put(sql.toString(), tmpList);
    }

    private static StringBuffer getBaseSql(List baseParamList, int versionId) {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(CUBE_NAME_VAR).append(" set FValue = 0, FTmpValue = 0 where FOrgUnitId = ? and FUnionId = ? and F100 = ? and FVersion = ? ");
        baseParamList.add("000000000000000000000000000=");
        baseParamList.add("000000000000000000000000000=");
        baseParamList.add(BgCslDimConstants.csl01);
        baseParamList.add(versionId);
        return sql;
    }

    public void clearUnionData(Connection conn, String cubeName, String cubeEntryName, String unionId, String orgUnitId) throws SQLException {
        if (this.clearParams.isEmpty()) {
            return;
        }
        Map<String, List<Object[]>> sqlMap = null;
        sqlMap = this.clearParams.size() == 1 && this.clearParams.containsKey("000000000000000000000000000=") ? this.clearParams.get("000000000000000000000000000=") : this.clearParams.get(orgUnitId);
        if (sqlMap == null || sqlMap.isEmpty()) {
            return;
        }
        List<Object[]> tmpList = null;
        for (String sql : sqlMap.keySet()) {
            tmpList = sqlMap.get(sql);
            for (Object[] params : tmpList) {
                params[0] = orgUnitId;
                params[1] = unionId;
            }
            sql = sql.replaceAll(CUBE_NAME_VAR, cubeName).replaceAll(CUBE_ENTRY_NAME_VAR, cubeEntryName);
            MbgSqlHelper.executeBatch((Connection)conn, (String)sql, tmpList);
        }
    }

    public void fillClearData(Book book, IDimDataQuery info, Map<String, Map<String, IBgNData>> indvDataMap, Map<String, Map<String, BgNViewDataInfo>> dimDataMap) throws EASBizException, BOSException {
        if (info == null || indvDataMap == null || dimDataMap == null || dimDataMap.isEmpty()) {
            return;
        }
        String billVersionNumber = info.getBizVersion().getNumber();
        Sheet sheet = null;
        Cell cell = null;
        DimensionCacheHelper cacheHelper = new DimensionCacheHelper(null);
        Set actScenario = cacheHelper.getActualScens();
        BgNViewDataInfo data = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        String formulaStr = null;
        String cellVersion = null;
        String scenario = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    cell = sheet.getCell(r, c, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || BgNFSHelper.checkIsEmptyValue((Cell)cell) || (formulaStr = (formula = BgNFSHelper.getItemFormula((Cell)cell)).getFormula()).indexOf(BgCslDimConstants.csl01) < 0) continue;
                    cellOrgId = formula.getExt("ORGUNITID");
                    if (cellOrgId == null) {
                        cellOrgId = info.getBizOrgUnit().getId().toString();
                    }
                    if ((cellVersion = formula.getExt("Version")) != null && !cellVersion.equals(billVersionNumber)) continue;
                    String dimKey = DimUtils.getDimDataKey((String)formulaStr, (String)cellVersion);
                    if (!dimDataMap.containsKey(cellOrgId) || !dimDataMap.get(cellOrgId).containsKey(dimKey)) continue;
                    if (!indvDataMap.containsKey(cellOrgId)) {
                        indvDataMap.put(cellOrgId, new HashMap());
                    }
                    if (indvDataMap.get(cellOrgId).containsKey(dimKey)) continue;
                    data = new BgNViewDataInfo((BgNDataInfo)dimDataMap.get(cellOrgId).get(dimKey));
                    scenario = BgNFSHelper.parseFormulaPara((String)formulaStr)[3];
                    if (actScenario.contains(scenario)) {
                        data.setBizActual(BgNConstants.ZERO);
                    } else {
                        data.setBudgetValue(BgNConstants.ZERO);
                    }
                    indvDataMap.get(cellOrgId).put(dimKey, (IBgNData)data);
                    dimDataMap.get(cellOrgId).get(dimKey).setBudgetValue(BgNConstants.ZERO);
                }
            }
        }
    }
}

