/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgRptReportPropertyAdapter;
import com.kingdee.util.PropertyContainer;
import java.util.Date;

public class BgCslRptReportPropertyAdapter
extends BgRptReportPropertyAdapter {
    private static final long serialVersionUID = -267689187688368681L;
    private String orgTreeNumber = null;

    public void setOrgTreeNumber(String orgTreeNumber) {
        this.orgTreeNumber = orgTreeNumber;
    }

    public BgCslRptReportPropertyAdapter() {
    }

    public BgCslRptReportPropertyAdapter(BgCslFormInfo report) {
        this.setProperties(report);
    }

    private void setProperties(BgCslFormInfo report) {
        if (this.p == null) {
            this.p = new PropertyContainer();
        }
        if (report.getCompany() != null && report.getCompany().getId() != null) {
            this.p.setString("Company.Name", report.getCompany().getName());
            this.p.setString("Company.Number", report.getCompany().getNumber());
            this.p.setString("Company.ID", report.getCompany().getId().toString());
        }
        FullOrgUnitInfo org = report.getOrgUnit();
        this.setOrgUnit(org);
        this.p.setString("BG_FORM_ID", report.getId().toString());
        this.p.setString("BG_TEMPLATE_ID", report.getBgCslTemplate().getId().toString());
        this.p.setString("CSLReport_OrgTree_Number", this.orgTreeNumber);
        this.p.setString("CSLReport_OrgUnit_Group", report.getOrgUnit().getNumber());
        if (report.getOrgTree() != null) {
            this.p.setString("CSLReport_OrgTree_ID", report.getOrgTree().getId().toString());
        }
        if (report.getBgVersion() != null) {
            this.p.setString("BG_VERSION_NUMBER", report.getBgVersion().getNumber());
        }
        if (report.getBgScheme() != null) {
            this.p.setString("BG_SCHEME_NUMBER", report.getBgScheme().getNumber());
        }
        if (BgNFSHelper.getFormulaMap((IObjectValue)report) != null) {
            this.p.put("Report_FormulaMap", (Object)BgNFSHelper.getFormulaMap((IObjectValue)report));
        }
        BgPeriodInfo period = report.getBgPeriod();
        if (report.getBgPeriod() != null) {
            if (report.getBgPeriod().getBeginDate() != null) {
                this.p.setString("bg_begin_date", String.valueOf(report.getBgPeriod().getBeginDate()));
                this.p.setDate("Report_StartDate", report.getBgPeriod().getBeginDate());
            } else {
                this.p.setDate("Report_StartDate", report.getStartDate());
            }
            if (report.getBgPeriod().getEndDate() != null) {
                this.p.setString("bg_end_date", String.valueOf(report.getBgPeriod().getEndDate()));
                this.p.setDate("Report_EndDate", report.getBgPeriod().getEndDate());
            } else {
                this.p.setDate("Report_EndDate", report.getEndDate());
            }
        } else {
            this.p.setDate("Report_StartDate", report.getStartDate());
            this.p.setDate("Report_EndDate", report.getEndDate());
        }
        if (period != null) {
            String id = period.getId().toString();
            BgPeriodEnum periodType = period.getPeriodType();
            int year = period.getYear();
            int halfYear = period.getHalfYear();
            int month = period.getMonth();
            int quart = period.getQuarter();
            this.p.setString("BG_PERIOD_ID", id);
            this.p.setString("BG_PERIOD_NUMBER", period.getNumber());
            if (period.getPeriodType() != null) {
                this.p.setInt("BG_PERIOD_TYPE", period.getPeriodType().getValue());
                this.p.setInt("BG_PERIOD_YEAR", period.getYear());
            }
            if (periodType != null) {
                if (periodType.getValue() == 1) {
                    report.setPeriodType(RptPeriodTypeEnum.YEARLY);
                    report.setYear(year);
                    report.setPeriod((short)1);
                } else if (periodType.getValue() == 2) {
                    report.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
                    report.setYear(year);
                    report.setPeriod((short)halfYear);
                    this.p.setInt("BG_PERIOD_MONTH", period.getHalfYear());
                } else if (periodType.getValue() == 3) {
                    report.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
                    report.setYear(year);
                    report.setPeriod((short)quart);
                    this.p.setInt("BG_PERIOD_MONTH", period.getQuarter());
                } else if (periodType.getValue() == 4) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                    this.p.setInt("BG_PERIOD_MONTH", period.getMonth());
                } else if (periodType.getValue() == 5 || periodType.getValue() == 6) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                    this.p.setInt("BG_PERIOD_MONTH", period.getWeek());
                }
            }
        }
        this.p.setInt("Report.Year", report.getYear());
        this.p.setInt("Report.Period", (int)report.getPeriod());
        if (report.getCurrency() != null) {
            this.p.setString("Currency.Number", report.getCurrency().getNumber());
        }
        if (report.getLastUpdateUser() != null) {
            this.p.setString("LastUpdater.Name", report.getLastUpdateUser().getName());
        }
        this.p.setString("Report.Name", report.getName());
        if (report.getSourceType() != null) {
            this.p.setInt("Report.SourceType", report.getSourceType().getValue());
        }
        if (report.getCU() != null) {
            this.p.setString("CU.Name", report.getCU().getId().toString());
        }
        if (report.getCreator() != null) {
            this.p.setString("Creater.Name", report.getCreator().getName());
        }
        this.p.setDate("bg_create_date", report.getCreateTime() != null ? new Date(report.getCreateTime().getTime()) : new Date());
        FullOrgUnitInfo costCenter = report.getOrgUnit();
        if (costCenter != null) {
            this.p.setString("BgCostCenterNum", costCenter.getNumber());
        }
        if (report.getSheetParam() != null && report.getSheetParam().size() > 0) {
            this.p.setInt("Report_StartYear", report.getSheetParam().get(0).getStartYear());
            this.p.setInt("Report_StartPeriod", report.getSheetParam().get(0).getStartPeriod());
            this.p.setInt("Report_EndYear", report.getSheetParam().get(0).getEndYear());
            this.p.setInt("Report_EndPeriod", report.getSheetParam().get(0).getEndPeriod());
        }
        if (report.getPeriodType() != null) {
            this.p.setInt("PeriodType", report.getPeriodType().getValue());
        }
        if (report.getBgVersion() != null) {
            this.p.setString("BG_VERSION_NUMBER", report.getBgVersion().getNumber());
        }
        this.p.setInt("BG_FORM_STATE", report.getState().getValue());
    }
}

