/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslElimCollection;
import com.kingdee.eas.ma.bgcsl.BgCslElimEntryCollection;
import com.kingdee.eas.ma.bgcsl.BgCslElimEntryInfo;
import com.kingdee.eas.ma.bgcsl.BgCslElimException;
import com.kingdee.eas.ma.bgcsl.BgCslElimInfo;
import com.kingdee.eas.ma.bgcsl.utils.data.UnionBaseDataUtils;
import com.kingdee.eas.ma.mbg.BgDataInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UnionElimDataUtils
extends UnionBaseDataUtils {
    private static final Logger logger = Logger.getLogger(UnionElimDataUtils.class);
    private static final int templetable_threshold = 2;
    private String cfsCube = null;
    private String refFields = null;
    private String tempElim = null;

    public UnionElimDataUtils(TempTablePool pool) {
        super(pool);
    }

    protected Map<String, Set<String>> parseMemberFromBillCol(Context ctx, Connection conn, BgSchemeInfo schemeInfo, IObjectCollection billCol) throws Exception {
        if (ctx == null || conn == null || schemeInfo == null || this.getPool() == null || billCol == null) {
            return null;
        }
        Map<String, Set<String>> mbgMemberMap = this.parseMbgMember(billCol);
        this.updateMemberTable(ctx, conn, schemeInfo, mbgMemberMap);
        this.updateOtherMemberTable(ctx, conn, schemeInfo, mbgMemberMap);
        return mbgMemberMap;
    }

    private Map<String, Set<String>> parseMbgMember(IObjectCollection billCol) {
        HashMap<String, Set<String>> mbgMemberMap = new HashMap<String, Set<String>>();
        if (billCol == null) {
            return mbgMemberMap;
        }
        int count = billCol.size();
        for (int i = 0; i < count; ++i) {
            this.parseMbgMemberFromBill(billCol.getObject(i), mbgMemberMap);
        }
        return mbgMemberMap;
    }

    private void parseMbgMemberFromBill(IObjectValue billInfo, Map<String, Set<String>> mbgMemberMap) {
        if (billInfo instanceof BgCslElimInfo) {
            Set<Object> setBgIndex = null;
            Set<Object> setPeriod = null;
            Set<Object> setElement = null;
            Set<Object> setCurrency = null;
            Set<Object> setScenario = null;
            if (mbgMemberMap.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                setBgIndex = mbgMemberMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD);
            } else {
                setBgIndex = new HashSet();
                mbgMemberMap.put(DimensionBaseConstants.DEF_BGINDEX_FIELD, setBgIndex);
            }
            if (mbgMemberMap.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
                setPeriod = mbgMemberMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
            } else {
                setPeriod = new HashSet();
                mbgMemberMap.put(DimensionBaseConstants.DEF_PERIOD_FIELD, setPeriod);
            }
            if (mbgMemberMap.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD)) {
                setElement = mbgMemberMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD);
            } else {
                setElement = new HashSet();
                mbgMemberMap.put(DimensionBaseConstants.DEF_ELEMENT_FIELD, setElement);
            }
            if (mbgMemberMap.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                setCurrency = mbgMemberMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD);
            } else {
                setCurrency = new HashSet();
                mbgMemberMap.put(DimensionBaseConstants.DEF_CURRENCY_FIELD, setCurrency);
            }
            if (mbgMemberMap.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD)) {
                setScenario = mbgMemberMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD);
            } else {
                setScenario = new HashSet();
                mbgMemberMap.put(DimensionBaseConstants.DEF_SCENARIO_FIELD, setScenario);
            }
            BgCslElimInfo info = (BgCslElimInfo)billInfo;
            setPeriod.add(info.getBgPeriod().getNumber());
            setElement.add(info.getBgElement().getNumber());
            setCurrency.add(info.getCurrency().getNumber());
            setScenario.add(info.getBgScenario().getNumber());
            BgCslElimEntryCollection entries = info.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                BgCslElimEntryInfo entry = entries.get(i);
                setBgIndex.add(entry.getIndexMemberNumber());
            }
        }
    }

    public void audit(Context ctx, Connection conn, BgSchemeInfo schemeInfo, IObjectCollection billCol, Map<String, String> auditParams, Map<String, Map<String, String[]>> result, boolean isDoAudit) throws BOSException, EASBizException {
        if (ctx == null || conn == null || schemeInfo == null || billCol == null || this.pool == null || billCol.size() == 0) {
            return;
        }
        String cfsCube = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
        String adjCube = BgCubeUtils.getCFSAdjustCubeName((String)schemeInfo.getRefCube());
        if (auditParams == null) {
            auditParams = new HashMap<String, String>();
        }
        if (cfsCube == null) {
            return;
        }
        if (!(billCol instanceof BgCslElimCollection)) {
            return;
        }
        BgCslElimCollection elimCol = (BgCslElimCollection)billCol;
        String unionId = elimCol.get(0).getOrgTree().getId().toString();
        String orgUnitid = elimCol.get(0).getOrgUnit().getId().toString();
        int versionId = elimCol.get(0).getBgVersion().getVersionId();
        String audOrgUnitId = auditParams.containsKey("ORGUNIT_AUDIT_ID") ? auditParams.get("ORGUNIT_AUDIT_ID") : orgUnitid;
        String audUserId = auditParams.containsKey("USER_ID") ? auditParams.get("USER_ID") : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Map<String, Set<String>> mbgMemberMap = null;
        List refFields = schemeInfo.getRefFields(conn, 64);
        try {
            mbgMemberMap = this.parseMemberFromBillCol(ctx, conn, schemeInfo, billCol);
            if (mbgMemberMap != null && !mbgMemberMap.isEmpty()) {
                StringBuffer sql = new StringBuffer();
                StringBuffer ids = new StringBuffer();
                for (int i = 0; i < elimCol.size(); ++i) {
                    ids.append(",'").append(elimCol.get(i).getId().toString()).append("'");
                }
                ids = ids.deleteCharAt(0);
                sql.append("update T_MBG_BgCslElim set fstatus=?, fauditorid=?, FAuditTime=? where fid in (").append(ids.toString()).append(")");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{isDoAudit ? 9 : 1, isDoAudit ? audUserId : null, isDoAudit ? now : null});
                if (this.tempElim == null) {
                    this.tempElim = BgDBUtils.createTmpTable((TempTablePool)this.getPool(), (String)this.buildElimCreateSql(refFields));
                } else {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate Table " + this.tempElim));
                }
                BgDBUtils.executeBatch((Connection)conn, (String)this.buildElimInsertSql(this.tempElim, refFields), this.mergeInsertParams(this.buildElimInsertParams(ctx, conn, billCol, refFields, isDoAudit)));
                String updatesql = "update " + this.tempElim + " set FAudUserID = ?";
                BgDBUtils.executeUpdate((Connection)conn, (String)updatesql, (Object[])new Object[]{isDoAudit ? audUserId : null});
                if (!isDoAudit) {
                    sql.setLength(0);
                    sql.append("update " + cfsCube + " set FValue = FValue - (select FValue From " + this.tempElim + " where FUnionId = " + cfsCube + ".FUnionId and FOrgUnitId = " + cfsCube + ".FOrgUnitId and FFormula = " + cfsCube + ".FFormula and FVersion = " + cfsCube + ".FVersion) where FUnionId = ? and FOrgUnitId = ?  and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + cfsCube + ".F2)  and F100 IN ('" + BgCslDimConstants.csl05 + "','" + BgCslDimConstants.csl06 + "')  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + cfsCube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + cfsCube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + cfsCube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + cfsCube + ".FScenario)  and FVersion = ? and FState = ? and exists (select FID from " + this.tempElim + " where FUnionId = " + cfsCube + ".FUnionId  and FOrgUnitId = " + cfsCube + ".FOrgUnitId and FFormula = " + cfsCube + ".FFormula and FVersion = " + cfsCube + ".FVersion)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitid, versionId, 9});
                } else {
                    sql.setLength(0);
                    sql.append("update " + cfsCube + " set FValue = FValue +(select FValue FROM " + this.tempElim + " where FUnionId = " + cfsCube + ".FUnionId and FOrgUnitId = " + cfsCube + ".FOrgUnitId and FFormula = " + cfsCube + ".FFormula and FVersion = " + cfsCube + ".FVersion), FState = ?  where FUnionId = ? and FOrgUnitId = ?  and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + cfsCube + ".F2)  and F100 IN ('" + BgCslDimConstants.csl05 + "','" + BgCslDimConstants.csl06 + "')  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + cfsCube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + cfsCube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + cfsCube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + cfsCube + ".FScenario)  and FVersion = ?  and exists (select FID from " + this.tempElim + " where FUnionId = " + cfsCube + ".FUnionId  and FOrgUnitId = " + cfsCube + ".FOrgUnitId and FFormula = " + cfsCube + ".FFormula and FVersion = " + cfsCube + ".FVersion)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{9, unionId, orgUnitid, versionId});
                }
                sql.setLength(0);
                sql.append("Insert Into " + cfsCube + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FUnionID, FOrgUnitID , FFormula, FValue, FTmpValue");
                for (String field : refFields) {
                    sql.append(", " + field);
                }
                sql.append(", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FAudOrgUnitID, FAudUserID) Select FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FUnionID, FOrgUnitID , FFormula, FValue, FTmpValue");
                for (String field : refFields) {
                    sql.append(", " + field);
                }
                sql.append(", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FAudOrgUnitID, FAudUserID From " + this.tempElim + " where FUnionId = ? and FOrgUnitId = ?  and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + this.tempElim + ".F2)  and F100 IN ('" + BgCslDimConstants.csl05 + "','" + BgCslDimConstants.csl06 + "')  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + this.tempElim + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + this.tempElim + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + this.tempElim + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + this.tempElim + ".FScenario)  and FVersion = ? and FState = ?  and not exists (select FID from " + cfsCube + " where FUnionID = " + this.tempElim + ".FUnionID and FOrgUnitID = " + this.tempElim + ".FOrgUnitID and FFormula = " + this.tempElim + ".FFormula and FVersion = " + this.tempElim + ".FVersion)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitid, versionId, 9});
                sql.setLength(0);
                sql.append("Delete From " + cfsCube + " where FUnionId = ? and FOrgUnitId = ?  and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + cfsCube + ".F2)  and F100 IN ('" + BgCslDimConstants.csl05 + "','" + BgCslDimConstants.csl06 + "')  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + cfsCube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + cfsCube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + cfsCube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + cfsCube + ".FScenario)  and FVersion = ? and FValue = 0 and exists (select FID from " + this.tempElim + " where FUnionId = " + cfsCube + ".FUnionId  and FOrgUnitId = " + cfsCube + ".FOrgUnitId and FFormula = " + cfsCube + ".FFormula and FVersion = " + cfsCube + ".FVersion)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{unionId, orgUnitid, versionId});
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"cslAdjForm audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.clear();
        }
    }

    private List<Object[]> mergeInsertParams(List<Object[]> params) {
        if (null == params || params.isEmpty()) {
            return params;
        }
        HashMap<String, Object> mergeParams = new HashMap<String, Object>();
        for (Object[] param : params) {
            String key = this.getAndConcatParamKey(param);
            if (mergeParams.containsKey(key)) {
                Object[] val = (Object[])mergeParams.get(key);
                BigDecimal sumValue = ((BigDecimal)val[7]).add((BigDecimal)param[7]);
                val[7] = sumValue;
                BigDecimal sumTmpValue = ((BigDecimal)val[8]).add((BigDecimal)param[8]);
                val[8] = sumTmpValue;
                continue;
            }
            mergeParams.put(key, param.clone());
        }
        return new ArrayList<Object[]>(mergeParams.values());
    }

    private String getAndConcatParamKey(Object[] param) {
        return param[4] + "!" + param[5] + "!" + param[6] + "!" + param[14];
    }

    public void clear() {
        super.clear();
        if (this.pool == null) {
            return;
        }
        this.pool.releaseTable(this.tempElim);
    }

    private String buildElimCreateSql(List<String> refFields) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TMP_Table_Name(FID VARCHAR(44) NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FUnionID VARCHAR(44) DEFAULT '' NOT NULL, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(300) DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
        int in = refFields.size();
        for (int i = 0; i < in; ++i) {
            sql.append(refFields.get(i) + " NVARCHAR(80) DEFAULT '' NOT NULL, ");
        }
        sql.append("FBgItemCombination NVARCHAR(300) DEFAULT '' NOT NULL, FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 1 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 0 NOT NULL,FReportOrgUnitID VARCHAR(44) DEFAULT '', FAudUserID VARCHAR(44) DEFAULT '', FAudOrgUnitID VARCHAR(44) DEFAULT '')");
        return sql.toString();
    }

    private String buildElimInsertSql(String tableName, List<String> refFields) {
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tableName + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FUnionID, FOrgUnitID, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate, FReportOrgUnitID, FAudUserID, FAudOrgUnitID");
        int in = refFields.size();
        for (i = 0; i < in; ++i) {
            sql.append(", " + refFields.get(i));
        }
        sql.append(") Values (newbosid('" + new BgDataInfo().getBOSType().toString() + "'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
        in = refFields.size();
        for (i = 0; i < in; ++i) {
            sql.append(",?");
        }
        sql.append(")");
        return sql.toString();
    }

    private List<Object[]> buildElimInsertParams(Context ctx, Connection conn, IObjectCollection billCol, List<String> refFields, boolean isDoAudit) throws BOSException {
        if (!(billCol instanceof BgCslElimCollection)) {
            return null;
        }
        StringBuffer idString = new StringBuffer();
        BgCslElimCollection col = (BgCslElimCollection)billCol;
        BgCslElimInfo info = null;
        BgCslElimEntryInfo entryInfo = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            for (int j = 0; j < info.getEntries().size(); ++j) {
                entryInfo = info.getEntries().get(j);
                idString.append(",'" + entryInfo.getId().toString() + "'");
            }
        }
        idString = idString.deleteCharAt(0);
        StringBuffer sql = new StringBuffer();
        sql.append("Select newbosid('" + new BgDataInfo().getBOSType().toString() + "') bosId, \n");
        sql.append("       elim.forgunitid, elim.FStatus, \n");
        sql.append("       elimEntry.Fitemformula, \n");
        sql.append("       sum(fdebitamount) sumDebit, sum(fcreditamount) sumCredit, \n");
        sql.append("       elimEntry.Fitemformula,  elim.fbgschemeid, elim.forgtreeid, elim.forgunitid, \n");
        sql.append("       elim.fcurrencyid, ver.fversionid, scen.fscenarioid, elim.fbgelementid, elim.fbgperiodid,\n");
        sql.append("       elim.fmembercombinnumber memNumber, elim.fmembercombinname memName, elim.fmembercombinref memRef, \n");
        sql.append("       elimEntry.Fmembercombinnumber, elimEntry.Fmembercombinname, elimEntry.Fmembercombinref, \n");
        sql.append("       elimEntry.Findexmembernumber, elimEntry.Findexmembername, elimEntry.Findexmemberref \n");
        sql.append("  From T_MBG_BgCslElim elim                                         \n");
        sql.append("  Join T_MBG_BgCslElimEntry elimEntry                               \n");
        sql.append("    On elim.fid = elimEntry.Feliminationid                          \n");
        sql.append("  Join T_MBG_BgScenario scen On scen.FId = elim.fbgscenarioid       \n");
        sql.append("  Join T_MBG_BgVersion ver On ver.FId = elim.fbgversionid           \n");
        sql.append(" Where elimEntry.FID in (" + idString + ") \n");
        if (isDoAudit) {
            sql.append(" And elim.FStatus = 9 \n");
        }
        sql.append(" Group By ");
        sql.append("       elim.forgunitid, elim.FStatus, \n");
        sql.append("       elimEntry.Fitemformula, \n");
        sql.append("       elimEntry.Fitemformula, elim.fbgschemeid, elim.forgtreeid, elim.forgunitid, \n");
        sql.append("       elim.fcurrencyid, ver.fversionid, scen.fscenarioid, elim.fbgelementid, elim.fbgperiodid, \n");
        sql.append("       elim.fmembercombinnumber, elim.fmembercombinname, elim.fmembercombinref, \n");
        sql.append("       elimEntry.Fmembercombinnumber, elimEntry.Fmembercombinname, elimEntry.Fmembercombinref, \n");
        sql.append("       elimEntry.Findexmembernumber, elimEntry.Findexmembername, elimEntry.Findexmemberref \n");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        try {
            IRowSet rs = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rs.next()) {
                params.add(this.buildParam(ctx, rs, refFields, true, time).toArray());
                params.add(this.buildParam(ctx, rs, refFields, false, time).toArray());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return params;
    }

    private List<Object> buildParam(Context ctx, IRowSet rs, List<String> refFields, boolean isCredit, Timestamp time) throws SQLException, BgCslElimException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        ArrayList<Object> p = new ArrayList<Object>();
        String itemCombine = null;
        itemCombine = this.getBgItemCombination(rs.getString("Fitemformula"));
        p.add(userId);
        p.add(time);
        p.add(userId);
        p.add(time);
        p.add(rs.getString("forgtreeid"));
        p.add(rs.getString("forgunitid"));
        if (isCredit) {
            p.add(rs.getString("Fitemformula").replaceAll(BgCslDimConstants.csl05, BgCslDimConstants.csl06));
        } else {
            p.add(rs.getString("Fitemformula").replaceAll(BgCslDimConstants.csl06, BgCslDimConstants.csl05));
        }
        if (isCredit) {
            p.add(rs.getBigDecimal("sumCredit") == null ? BigDecimal.ZERO : rs.getBigDecimal("sumCredit"));
        } else {
            p.add(rs.getBigDecimal("sumDebit") == null ? BigDecimal.ZERO : rs.getBigDecimal("sumDebit"));
        }
        if (isCredit) {
            p.add(rs.getBigDecimal("sumCredit") == null ? BigDecimal.ZERO : rs.getBigDecimal("sumCredit"));
        } else {
            p.add(rs.getBigDecimal("sumDebit") == null ? BigDecimal.ZERO : rs.getBigDecimal("sumDebit"));
        }
        if (isCredit) {
            p.add(itemCombine.replaceAll(BgCslDimConstants.csl05, BgCslDimConstants.csl06));
        } else {
            p.add(itemCombine.replaceAll(BgCslDimConstants.csl06, BgCslDimConstants.csl05));
        }
        p.add(rs.getString("fbgperiodid"));
        p.add(rs.getString("fbgelementid"));
        p.add(rs.getString("fcurrencyid"));
        p.add(rs.getString("fscenarioid"));
        p.add(rs.getString("fversionid"));
        if (rs.getInt("FStatus") == 9) {
            p.add(9);
        } else {
            p.add(1);
        }
        p.add(1);
        p.add("");
        p.add("");
        p.add("");
        String[] items = itemCombine.split(",");
        for (int i = 0; i < refFields.size(); ++i) {
            if (i <= items.length - 2) {
                p.add(items[i]);
                continue;
            }
            p.add(isCredit ? BgCslDimConstants.csl06 : BgCslDimConstants.csl05);
        }
        return p;
    }

    private String getBgItemCombination(String itemFormula) {
        return BgNFSHelper.parseFormulaPara((String)itemFormula)[0];
    }

    protected String getKey(IRowSet rs, boolean isCredit) throws SQLException {
        String unionId = rs.getString("forgtreeid");
        String orgUnitId = rs.getString("forgunitid");
        String versionId = rs.getString("fversionid");
        String formulaStr = null;
        String fitemformula = rs.getString("Fitemformula");
        formulaStr = isCredit ? fitemformula.replaceAll(BgCslDimConstants.csl05, BgCslDimConstants.csl06) : fitemformula.replaceAll(BgCslDimConstants.csl06, BgCslDimConstants.csl05);
        return unionId + ";" + orgUnitId + ";" + formulaStr + ";" + versionId;
    }

    protected void getScenrioTmpTable(Connection conn, List<Object> tmpList) throws SQLException {
        BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + this.tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ") "), tmpList);
    }
}

