/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.AbstractBizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgScriptParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.ScriptFormater;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.face.IExprCheck;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.biz.utils.BizMemberQuery;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.MbgFunctionFacadeFactory;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcSubsetInfo
extends AbstractBizCalcSubsetInfo
implements Serializable {
    private static final Logger logger = CoreUIObject.getLogger(BizCalcSubsetInfo.class);
    public boolean hasCalc = true;
    public boolean hasFormula = false;
    private List<IExpress> expres = null;
    private Boolean checkHasOrgScope;
    private Set<String> scopeOrg = null;
    private Map<String, Set<String>> scopeMap = null;

    public BizCalcSubsetInfo() {
    }

    protected BizCalcSubsetInfo(String pkField) {
        super(pkField);
    }

    public String getBizFormula() {
        String _bizFormula = null;
        byte[] _bytes = this.getFormula();
        if (_bytes != null && _bytes.length > 0) {
            _bizFormula = (String)BgAnalyseHelper.getObject((byte[])_bytes);
        }
        return _bizFormula;
    }

    public void setBizFormula(String bizFormula) {
        byte[] _bytes = null;
        if (!StringUtils.isEmpty((String)bizFormula)) {
            _bytes = BgAnalyseHelper.getBytes((Object)bizFormula);
        }
        this.setFormula(_bytes);
    }

    public List<IExpress> getExpres(boolean reParse) throws ParseException {
        if (reParse) {
            this.expres.clear();
            return this.getExpres(null);
        }
        return this.expres;
    }

    public List<IExpress> getExpres() throws ParseException {
        return this.getExpres(null);
    }

    public List<IExpress> getExpres(IExprCheck check) throws ParseException {
        if (this.expres != null && !this.expres.isEmpty()) {
            return this.expres;
        }
        return this.getParseExpres(check);
    }

    protected List<IExpress> getParseExpres(IExprCheck check) throws ParseException {
        if (this.expres == null) {
            this.expres = new ArrayList<IExpress>(50);
        } else {
            this.expres.clear();
        }
        String formulaStr = this.getBizFormula();
        if (StringUtils.isEmpty((String)formulaStr)) {
            return this.expres;
        }
        List<String> scripts = MbgScriptParseHelper.parse(formulaStr, new ScriptFormater());
        if (scripts != null) {
            String script = null;
            IExpress expre = null;
            int jn = scripts.size();
            for (int j = 0; j < jn; ++j) {
                script = scripts.get(j);
                expre = MbgExprParseHelper.parse(script, check);
                if (expre == null) continue;
                this.expres.add(expre);
            }
        }
        return this.expres;
    }

    public boolean checkHasOrgScope(Context ctx, String orgUnitNumber, String bgOrgViewId, String bgSchemeId, BOSUuid unionId) {
        boolean check = false;
        this.checkHasOrgScope = null;
        if (StringUtils.isEmpty((String)orgUnitNumber)) {
            return check;
        }
        if (this.checkHasOrgScope == null) {
            try {
                BizScopeCollection scopeTmpCol = new BizScopeCollection();
                BizScopeCollection scopeCol = this.getScope();
                if (scopeCol != null && !scopeCol.isEmpty()) {
                    for (int i = 0; i < scopeCol.size(); ++i) {
                        BizScopeInfo scopeInfo = scopeCol.get(i);
                        if (!DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(scopeInfo.getRefField())) continue;
                        if (scopeInfo.getFillType() != DimensionMemberTypeEnum.Normal && !scopeInfo.getBgMemberNum().startsWith("@")) {
                            String srcNumber = BizExprUtils.getDimensionNumber(scopeInfo.getRefField()) == null ? "" : BizExprUtils.getDimensionNumber(scopeInfo.getRefField());
                            String functionNum = null;
                            functionNum = !DimUtils.checkBaseDimensionByField((String)scopeInfo.getRefField()) ? BizExprUtils.transMemberToFunctionFormat(scopeInfo.getBgMemberNum(), scopeInfo.getFillType().getValue()) : BizExprUtils.transMemberToFunctionFormat(srcNumber + ":" + scopeInfo.getBgMemberNum(), scopeInfo.getFillType().getValue());
                            scopeInfo.setBgMemberNum(functionNum);
                        }
                        scopeTmpCol.add(scopeInfo);
                    }
                }
                this.scopeOrg = MbgFunctionFacadeFactory.getLocalInstance((Context)ctx).getOrgScopeByBizScope((IObjectCollection)scopeTmpCol, bgOrgViewId, bgSchemeId, unionId);
                if (this.scopeOrg == null || this.scopeOrg.isEmpty() || this.scopeOrg != null && this.scopeOrg.contains(orgUnitNumber)) {
                    check = true;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"get scopeData error", (Throwable)ex);
            }
        }
        this.checkHasOrgScope = check;
        return this.checkHasOrgScope;
    }

    public Set<String> getScopeOrg() {
        return this.scopeOrg;
    }

    public Map<String, Set<String>> getScopeMap() {
        return this.scopeMap;
    }

    public void setScopeMap(Map<String, Set<String>> scopeMap) {
        this.scopeMap = scopeMap;
    }

    public synchronized Map<String, Set<String>> getScopeData(Map<String, String> variateMap, Set<String> bgPeriodNums) {
        return this.getScopeData(variateMap, bgPeriodNums, null);
    }

    public synchronized Map<String, Set<String>> getScopeData(Map<String, String> variateMap, Set<String> bgPeriodNums, Set<String> bgPeriodChecks) {
        try {
            return this.getScopeData(variateMap, bgPeriodNums, null, false, false, null, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Map<String, Set<String>> getScopeData(Map<String, String> variateMap, Set<String> bgPeriodNums, Set<String> bgPeriodChecks, boolean isQueryFunction, boolean isParseMember, Context ctx, BgSchemeInfo bgScheme, MbgDimCollection mbgDims) throws Exception {
        if (this.getScopeMap() == null) {
            this.setScopeMap(new HashMap<String, Set<String>>());
            BizScopeInfo scope = null;
            String field = null;
            String _bgPeriodNumber = null;
            Set<Object> numbers = null;
            BizMemberQuery query = null;
            if (isQueryFunction) {
                query = BizMemberQuery.getInstance(ctx, bgScheme.getId().toString());
                query.setSchemeInfo(bgScheme);
                query.setMbgColls(mbgDims);
            }
            boolean hasProp = false;
            int in = this.getScope().size();
            for (int i = 0; i < in; ++i) {
                scope = this.getScope().get(i);
                if (scope.getBgMemberType() == BizConstants.BIZ_BGORGUNIT_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_ORGUNIT_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGINDEX_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_BGINDEX_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_CURRENCY_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_CURRENCY_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGVERSION_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_VERSION_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGSCENARIO_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_SCENARIO_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGPERIOD_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_PERIOD_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_BGELEMENT_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_ELEMENT_FIELD;
                } else if (scope.getBgMemberType() == BizConstants.BIZ_EXTDIM_TYPE_VALUE) {
                    field = scope.getRefField();
                } else if (scope.getBgMemberType() == BizConstants.BIZ_PROCESS_TYPE_VALUE) {
                    field = DimensionBaseConstants.DEF_PROCESS_FIELD;
                }
                if (this.getScopeMap().containsKey(field)) {
                    numbers = this.getScopeMap().get(field);
                } else {
                    numbers = new HashSet();
                    this.getScopeMap().put(field, numbers);
                }
                int valueType = scope.getBizDataType().getValue();
                if (valueType == 1) {
                    if (0 == scope.getFillType().getValue()) {
                        if (bgPeriodNums != null && !bgPeriodNums.isEmpty()) {
                            for (String bgPeriodNumber : bgPeriodNums) {
                                if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(field) && bgPeriodNumber != null) {
                                    int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNumber);
                                    try {
                                        _bgPeriodNumber = BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNumber, (String)scope.getBgMemberNum(), (int)periodType);
                                        if (bgPeriodChecks != null && !bgPeriodChecks.contains(_bgPeriodNumber)) continue;
                                        scope.setBgMemberNum(_bgPeriodNumber);
                                        if (StringUtils.isEmpty((String)scope.getBgMemberNum())) continue;
                                        numbers.add(scope.getBgMemberNum());
                                    }
                                    catch (BgPeriodException bgPeriodException) {}
                                    continue;
                                }
                                if (StringUtils.isEmpty((String)scope.getBgMemberNum())) continue;
                                numbers.add(scope.getBgMemberNum());
                            }
                            continue;
                        }
                        if (StringUtils.isEmpty((String)scope.getBgMemberNum())) continue;
                        if (isParseMember && query != null) {
                            query.addQueryMember(scope.getRefField(), DimUtils.getNumber((String)scope.getBgMemberNum()), scope.getFillType().getValue(), BizMemberQuery.QUERY_ALL);
                            continue;
                        }
                        numbers.add(scope.getBgMemberNum());
                        continue;
                    }
                    if (isParseMember && query != null) {
                        query.addQueryMember(scope.getRefField(), DimUtils.getNumber((String)scope.getBgMemberNum()), scope.getFillType().getValue(), BizMemberQuery.QUERY_ALL);
                        continue;
                    }
                    String srcNumber = BizExprUtils.getDimensionNumber(scope.getRefField()) == null ? "" : BizExprUtils.getDimensionNumber(scope.getRefField());
                    String functionNum = null;
                    functionNum = !DimUtils.checkBaseDimensionByField((String)scope.getRefField()) ? BizExprUtils.transMemberToFunctionFormat(scope.getBgMemberNum(), scope.getFillType().getValue()) : BizExprUtils.transMemberToFunctionFormat(srcNumber + ":" + scope.getBgMemberNum(), scope.getFillType().getValue());
                    numbers.add(functionNum);
                    continue;
                }
                if (valueType == 2) {
                    if (variateMap == null || !variateMap.containsKey(scope.getBgMemberNum())) continue;
                    numbers.add(variateMap.get(scope.getBgMemberNum()));
                    continue;
                }
                if (valueType == 4) {
                    if (StringUtils.isEmpty((String)scope.getBgMemberNum())) continue;
                    if (isParseMember && query != null) {
                        try {
                            if (!DimUtils.getDimInfoByField((MbgDimCollection)mbgDims).containsKey(scope.getRefField())) continue;
                            query.addQueryFunction(scope.getRefField(), scope.getBgMemberNum(), variateMap);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error((Object)"", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                    numbers.add(scope.getBgMemberNum());
                    continue;
                }
                if (valueType != 3 || bgScheme == null) continue;
                if (query == null) {
                    query = BizMemberQuery.getInstance(ctx, bgScheme.getId().toString());
                    query.setSchemeInfo(bgScheme);
                    query.setMbgColls(mbgDims);
                }
                query.addQueryProp(scope.getRefField(), scope.getBgMemberNum());
                hasProp = true;
            }
            if ((isParseMember || hasProp) && query != null) {
                Map<String, List<IMember>> queryMap;
                try {
                    queryMap = query.queryMember();
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new RuntimeException(e);
                }
                if (queryMap != null) {
                    List<IMember> members = null;
                    int in2 = this.getScope().size();
                    for (int i = 0; i < in2; ++i) {
                        scope = this.getScope().get(i);
                        if (!queryMap.containsKey(scope.getRefField())) continue;
                        members = queryMap.get(scope.getRefField());
                        numbers = this.scopeMap.get(scope.getRefField());
                        if (DimUtils.checkBaseDimensionByField((String)scope.getRefField())) {
                            for (IMember member : members) {
                                numbers.add(member.getNumber());
                            }
                            continue;
                        }
                        for (IMember member : members) {
                            numbers.add(member.getDimNumber());
                        }
                    }
                }
            }
        }
        return this.getScopeMap();
    }

    public BizCalcSubsetInfo clone() {
        BizCalcSubsetInfo clone = new BizCalcSubsetInfo();
        clone.setSeq(this.getSeq());
        clone.setName(this.getName());
        clone.setFormula(this.getFormula());
        clone.setBizCalc(this.getBizCalc());
        clone.setShowDimNums(this.getShowDimNums());
        BizScopeInfo scope = null;
        int in = this.getScope().size();
        for (int i = 0; i < in; ++i) {
            scope = this.getScope().get(i);
            clone.getScope().add(scope.clone());
        }
        return clone;
    }
}

