/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodDispHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.biz.client.AbstractBizCalcDimensionMemberSelectF7UI;
import com.kingdee.eas.ma.biz.client.utils.BizDimMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcDimensionMemberSelectF7UI
extends AbstractBizCalcDimensionMemberSelectF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BizCalcDimensionMemberSelectF7UI.class);
    private Set<String> bgPeriodTypeNumbers = null;
    public static final String KEY_BgPeriodTypeNumbers = "bgPeriodTypeNumbers";
    protected CalendarHelper calendar = new CalendarHelper();
    protected NumberExpendRender render = new NumberExpendRender(1);
    private BgPeriodDispInfo year = null;
    private BgPeriodTypeInfo bgPeriodType = null;
    private BgDimensionBaseInfo dimensionInfo = null;
    private Map<String, Set<String>> filterValueMap = null;
    private Date beginDate = null;
    private Date endDate = null;
    private String orgId = null;
    private boolean isSelfDefined = false;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("dimension") != null) {
            this.cbxDimension.setEnabled(false);
        }
        this.bgPeriodTypeNumbers = (Set)this.getUIContext().get(KEY_BgPeriodTypeNumbers);
        this.beginDate = (Date)this.getUIContext().get("beginDate");
        this.endDate = (Date)this.getUIContext().get("endDate");
        if (this.getUIContext().get("dimension") instanceof BgDimensionBaseInfo) {
            this.dimensionInfo = (BgDimensionBaseInfo)this.getUIContext().get("dimension");
        }
        if (this.getUIContext().get("filterValueMap") instanceof Map) {
            this.filterValueMap = (Map)this.getUIContext().get("filterValueMap");
        }
        this.orgId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        if (this.orgId == null) {
            this.orgId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        this.isSelfDefined = (Boolean)this.getUIContext().get("isSelfDefined");
        this.setBgSchemeID((String)this.getUIContext().get("BGSCHEME_ID"));
        this.cbxYear.removeAllItems();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected DimensionMemberSelectHelper createSelectHelper(BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        return new BizDimMemberSelectHelper(schemeHelper);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (!this.isSelectCombinItem() && e.getClickCount() == 2) {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            rows.add(new Integer(this.tblMain.getSelectManager().getActiveRowIndex()));
            this.selected(rows);
            this.btnOk_actionPerformed(null);
        }
    }

    public Object getData() {
        if (this.data instanceof List) {
            List list = (List)this.data;
            if (list.size() == 1) {
                return list.get(0);
            }
            return super.getData();
        }
        return super.getData();
    }

    protected void cbxDimension_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxDimension_itemStateChanged(e);
        if (e != null && e.getStateChange() != 1) {
            return;
        }
        BgDimensionBaseInfo dimension = DimensionClientHelper.getSelectDimension((KDComboBox)this.cbxDimension);
        if (dimension == null) {
            return;
        }
        if (dimension.getType().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
            this.contYear.setVisible(false);
            this.lblBgType.setVisible(true);
            this.cbxBgPeriodType.setVisible(true);
            this.cbxBgPeriodType.setEnabled(true);
            this.contYear.setVisible(true);
            this.contYear.setEnabled(true);
            this.cbxYear.setVisible(true);
            this.cbxYear.setEnabled(true);
            this.btnExpand.setVisible(true);
            this.btnExpand.setEnabled(true);
            this.btnConstriction.setVisible(true);
            this.btnConstriction.setEnabled(true);
            this.contCombiantion.setVisible(false);
            this.contCombiantion.setEnabled(false);
            this.txtCombination.setVisible(false);
            this.txtCombination.setEnabled(false);
            this.btnClear.setVisible(false);
            this.btnClear.setEnabled(false);
            this.loadBgPeriodType();
        } else {
            this.contYear.setVisible(false);
            this.lblBgType.setVisible(false);
            this.cbxBgPeriodType.setVisible(false);
            this.cbxBgPeriodType.setEnabled(false);
            this.contYear.setVisible(false);
            this.contYear.setEnabled(false);
            this.cbxYear.setVisible(false);
            this.cbxYear.setEnabled(false);
            this.btnExpand.setVisible(false);
            this.btnExpand.setEnabled(false);
            this.btnConstriction.setVisible(false);
            this.btnConstriction.setEnabled(false);
            this.contCombiantion.setVisible(false);
            this.contCombiantion.setEnabled(false);
            this.txtCombination.setVisible(false);
            this.txtCombination.setEnabled(false);
            this.btnClear.setVisible(false);
            this.btnClear.setEnabled(false);
        }
        this.parseTable();
        this.doQuery(false);
    }

    protected void loadBgPeriodType() {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.setSelector(new SelectorItemCollection());
            evi.setSorter(new SorterItemCollection());
            evi.getSelector().add("*");
            SorterItemInfo info0 = new SorterItemInfo("simplename");
            info0.setSortType(SortType.ASCEND);
            evi.getSorter().add(info0);
            SorterItemInfo info1 = new SorterItemInfo("isSysdata");
            info1.setSortType(SortType.DESCEND);
            evi.getSorter().add(info1);
            SorterItemInfo info2 = new SorterItemInfo("number");
            info2.setSortType(SortType.ASCEND);
            evi.getSorter().add(info2);
            if (this.bgPeriodTypeNumbers == null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"Select FTypeId FROM T_Mbg_BgPeriodDisp", CompareType.INNER));
            } else if (this.bgPeriodTypeNumbers.isEmpty()) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)BgBaseConstants.nullID));
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", this.bgPeriodTypeNumbers, CompareType.INCLUDE));
            }
            BgPeriodTypeCollection coll = BgPeriodTypeFactory.getRemoteInstance().getBgPeriodTypeCollection(evi);
            this.cbxBgPeriodType.removeAllItems();
            if (coll != null && !coll.isEmpty()) {
                this.cbxBgPeriodType.addItems(coll.toArray());
                this.selectDefaultBgPeriodType();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    protected void selectDefaultBgPeriodType() {
        int defaultIndex = -1;
        for (int i = 0; i < this.cbxBgPeriodType.getItemCount(); ++i) {
            BgPeriodTypeInfo itemAt = (BgPeriodTypeInfo)this.cbxBgPeriodType.getItemAt(i);
            if (!FiscalYearEnum.STANDARDYEAR.equals((Object)itemAt.getFiscalYear()) || itemAt.getBgPeriodEnum(true) == 8 || 4 != itemAt.getBgPeriodEnum(false)) continue;
            defaultIndex = i;
            break;
        }
        if (defaultIndex >= 0 && defaultIndex != this.cbxBgPeriodType.getSelectedIndex()) {
            this.cbxBgPeriodType.setSelectedIndex(defaultIndex);
        }
    }

    @Override
    protected void cbxBgPeriodType_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxBgPeriodType_itemStateChanged(e);
        if (e != null && e.getStateChange() != 1) {
            return;
        }
        if (this.cbxBgPeriodType.getSelectedItem() != null) {
            BgPeriodTypeInfo newType = this.getSelectBgPeriodType();
            if (this.bgPeriodType == null || !this.bgPeriodType.getId().equals((Object)newType.getId())) {
                this.bgPeriodType = newType;
                this.loadYear();
            }
        }
    }

    protected void loadYear() throws BOSException {
        BgPeriodDispCollection yearPeriod;
        logger.error((Object)"******************************* loadYear **********************************");
        this.year = null;
        this.cbxYear.removeAllItems();
        BgPeriodTypeInfo type = this.getSelectBgPeriodType();
        this.cbxYear.setAccessAuthority(0);
        this.contYear.setEnabled(true);
        BgPeriodDispInfo disp = new BgPeriodDispInfo();
        disp.setId(BOSUuid.read((String)BgBaseConstants.nullID));
        disp.setName(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"ALL"));
        disp.setNumber("all");
        BgPeriodInfo peroidInfo = new BgPeriodInfo();
        peroidInfo.setId(BOSUuid.read((String)BgBaseConstants.nullID));
        peroidInfo.setName(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"ALL"));
        peroidInfo.setNumber("all");
        this.cbxYear.addItem((Object)peroidInfo);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.setSelector(new SelectorItemCollection());
        evi.setSorter(new SorterItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("bgPeriod.year");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("longNumber");
        evi.getSelector().add("periodType");
        SorterItemInfo sic = new SorterItemInfo("bgPeriod.year");
        sic.setSortType(SortType.ASCEND);
        this.isSelfDefined = BgNPeriodHelper.isOnlySelfDefinedPeriod((BgPeriodTypeInfo)type);
        evi.getSorter().add(sic);
        if (!this.isSelfDefined) {
            this.cbxYear.setEnabled(true);
            if (!type.isSelfDefined()) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.periodType", (Object)1));
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.level", (Object)1));
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("type.id", (Object)type.getId().toString()));
            if (this.beginDate != null && this.endDate != null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.beginDate)), CompareType.GREATER_EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.endDate)), CompareType.LESS_EQUALS));
            }
        } else {
            BgPeriodDispHelper.getOnlySelfPeriodFilter((FilterInfo)evi.getFilter(), (Date)this.beginDate, (Date)this.endDate, (BgPeriodTypeInfo)type);
            this.cbxYear.setEnabled(false);
            this.cbxYear.setSelectedIndex(-1);
        }
        if ((yearPeriod = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(evi)) != null && !yearPeriod.isEmpty()) {
            int defaultIndex = -1;
            int currYear = this.calendar.getCurrentlyYear();
            for (int i = 0; i < yearPeriod.size(); ++i) {
                if (yearPeriod.get(i).getBgPeriod().getYear() == currYear) {
                    defaultIndex = i + 1;
                }
                this.cbxYear.addItem((Object)yearPeriod.get(i).toBgPeriodInfo());
            }
            if (defaultIndex >= 0 && !this.isSelfDefined) {
                this.cbxYear.setSelectedIndex(defaultIndex);
            } else {
                this.cbxYear.setSelectedIndex(0);
            }
        }
    }

    protected void cbxYear_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxYear_itemStateChanged(e);
        int selectIndex = this.cbxYear.getSelectedIndex();
        if (selectIndex == -1) {
            return;
        }
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.cbxYear.getItemAt(selectIndex);
        BgPeriodTypeInfo periodType = this.getSelectBgPeriodType();
        if (bgPeriodInfo.getId().toString().equals(BgBaseConstants.nullID)) {
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("type.id", (Object)periodType.getId().toString()));
            filter.setMaskString("#0");
        }
    }

    protected void filterContYear(FilterInfo filter) {
        BgPeriodTypeInfo periodType = this.getSelectBgPeriodType();
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.cbxYear.getSelectedItem();
        if (bgPeriodInfo.getId().toString().equals(BgBaseConstants.nullID)) {
            if (this.beginDate != null && this.endDate != null && periodType.getBgPeriodEnum(false) != 0) {
                FilterItemCollection items = filter.getFilterItems();
                items.add(new FilterItemInfo("type.id", (Object)periodType.getId().toString()));
                items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.beginDate)), CompareType.GREATER_EQUALS));
                items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.endDate)), CompareType.LESS_EQUALS));
                filter.setMaskString("#0 and #1 and #2");
            } else {
                BgPeriodDispHelper.getOnlySelfPeriodFilter((FilterInfo)filter, (Date)this.beginDate, (Date)this.endDate, (BgPeriodTypeInfo)periodType);
            }
            return;
        }
        super.filterContYear(filter);
    }

    private BgPeriodTypeInfo getSelectBgPeriodType() {
        return (BgPeriodTypeInfo)this.cbxBgPeriodType.getSelectedItem();
    }

    @Override
    protected void btnExpand_actionPerformed(ActionEvent e) throws Exception {
        super.btnExpand_actionPerformed(e);
        int rowSize = this.tblMain.getRowCount();
        if (rowSize == 0) {
            return;
        }
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            expandInfo.setExpandStatus(true);
            row.getStyleAttributes().setHided(false);
        }
        this.tblMain.setRowCount(rowSize);
    }

    @Override
    protected void btnConstriction_actionPerformed(ActionEvent e) throws Exception {
        super.btnConstriction_actionPerformed(e);
        int rowSize = this.tblMain.getBody().size();
        if (rowSize == 0) {
            return;
        }
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            expandInfo.setExpandStatus(false);
            if (expandInfo.getLongNumber().equals(expandInfo.getNumber())) continue;
            row.getStyleAttributes().setHided(true);
        }
    }

    protected void txtFilter_focusLost(FocusEvent e) throws Exception {
        super.txtFilter_focusLost(e);
    }
}

