/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizFacadeFactory;
import com.kingdee.eas.ma.biz.client.AbstractBizCalcMembersUI;
import com.kingdee.eas.ma.biz.client.BizCalcDimensionMemberSelectDialog;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgPeriodFunctionDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgProcessHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class BizCalcMembersUI
extends AbstractBizCalcMembersUI
implements IGetSchemeHelper {
    private static final Logger logger = CoreUIObject.getLogger(BizCalcMembersUI.class);
    private String formula;
    private Map<String, KDBizPromptBox> compMap = new HashMap<String, KDBizPromptBox>();
    private List<KDBizPromptBox> compList = new ArrayList<KDBizPromptBox>();
    private BgSchemeDimensionHelper schemeHelper = null;
    KDRadioButton kDRadioNotLeaf = new KDRadioButton();
    KDRadioButton kDRadioLeaf = new KDRadioButton();
    KDRadioButton kDRadioAll = new KDRadioButton();

    public String getFormula() {
        return this.formula;
    }

    protected void setFormula(String formula) {
        this.formula = formula;
    }

    public List<KDBizPromptBox> getCompList() {
        return this.compList;
    }

    public Map<String, KDBizPromptBox> getCompMap() {
        return this.compMap;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.spMain.setHorizontalScrollBarPolicy(31);
        this.initPanel();
    }

    protected void initPanel() throws Exception {
        List allDimension = (List)this.getUIContext().get("allDimensions");
        Map memberMap = (Map)this.getUIContext().get("memberMap");
        if (allDimension != null) {
            int x = 0;
            int y = 10;
            int width = 348;
            int height = 19;
            int yCompGap = 15;
            int xCompGap = 20;
            int yindex = 0;
            int totalHeight = 0;
            boolean isShowOrg = this.getSchemeHelper() == null || !this.getSchemeHelper().isBgCsl();
            int skip = isShowOrg ? 0 : -1;
            int i = 0;
            while (i < allDimension.size()) {
                BgDimensionInfo dim = (BgDimensionInfo)allDimension.get(i);
                KDLabelContainer container = new KDLabelContainer();
                container.setName("cont" + dim.getNumber());
                container.setBoundLabelText(dim.getName());
                container.setBoundLabelLength(100);
                container.setBoundLabelUnderline(true);
                container.setBounds(new Rectangle(x, y + (yindex + skip) * (height + yCompGap), width, height));
                this.pnlMain.add((Component)container, null);
                totalHeight += height + yCompGap;
                Object dialog = null;
                if (dim.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
                    dialog = new BgPeriodFunctionDialog((CoreUIObject)this, false, false);
                    dialog.setBgSchemeID(this.schemeHelper.getBgSchemeId());
                    dialog.setOrgId((String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    dialog.setDimension((Object)this.getSchemeHelper().getDimension(dim.getNumber()));
                    dialog.setCanSelectUserPeriod(true);
                    Set numSet = BizFacadeFactory.getRemoteInstance().queryPeriodType(this.schemeHelper.getBgSchemeId());
                    dialog.setBgPeriodTypeNumbers(numSet);
                } else {
                    dialog = new BizCalcDimensionMemberSelectDialog((Component)((Object)this), this.getSchemeHelper().getBgSchemeId(), this.getSchemeHelper().getDimension(dim.getNumber()), (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    ((BizCalcDimensionMemberSelectDialog)((Object)dialog)).setShowOusealup(false);
                    ((BizCalcDimensionMemberSelectDialog)((Object)dialog)).setMulti(false);
                    if (this.getUIContext().get("isHiddenPartCsldim") instanceof Boolean) {
                        ((BizCalcDimensionMemberSelectDialog)((Object)dialog)).setHiddenCslPartDim((Boolean)this.getUIContext().get("isHiddenPartCsldim"));
                    }
                }
                KDBizPromptBox prmt = new KDBizPromptBox();
                prmt.setUserObject((Object)dim);
                prmt.setName("prmt" + dim.getNumber());
                prmt.setSelector((KDPromptSelector)dialog);
                container.setBoundEditor((JComponent)prmt);
                if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) {
                    prmt.addDataChangeListener(new DataChangeListener(){

                        public void dataChanged(DataChangeEvent eventObj) {
                            BgDimensionMember orgMember = (BgDimensionMember)eventObj.getNewValue();
                            if (orgMember != null) {
                                BizCalcMembersUI.this.resetDimDialog(orgMember.getNumber());
                            }
                        }
                    });
                }
                prmt.setEditFormatter((IFormatter)new CalcMemDispFormatter());
                prmt.setDisplayFormatter((IFormatter)new CalcMemDispFormatter());
                if (memberMap != null && memberMap.containsKey(dim.getNumber())) {
                    prmt.setData(memberMap.get(dim.getNumber()));
                }
                this.compList.add(prmt);
                ++i;
                ++yindex;
            }
            if (this.isNeedProcessType()) {
                KDLabelContainer container = new KDLabelContainer();
                container.setName("cont" + BgProcessHelper.DEF_PROCESS_NUMBER);
                container.setBoundLabelText(BgProcessHelper.DEF_PROCESS_NAME);
                container.setBoundLabelLength(100);
                container.setBoundLabelUnderline(true);
                container.setBounds(new Rectangle(x, y + (yindex + skip) * (height + yCompGap), width, height));
                this.pnlMain.add((Component)container);
                totalHeight += height + yCompGap;
                KDBizPromptBox prmtBgProcess = BgExamineHelper.getBgProcessPrmBox((CoreUI)this, (boolean)false);
                prmtBgProcess.setName("prmt" + BgProcessHelper.DEF_PROCESS_NUMBER);
                container.setBoundEditor((JComponent)prmtBgProcess);
                if (memberMap != null && memberMap.containsKey(BgProcessHelper.DEF_PROCESS_NUMBER)) {
                    if (memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER) instanceof BgDimensionMember) {
                        prmtBgProcess.setData((Object)BgProcessHelper.memberToEnum((BgDimensionMember)((BgDimensionMember)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER))));
                    } else if (memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER) instanceof Set) {
                        prmtBgProcess.setData(BgProcessHelper.membersToEnums((Set)((Set)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER))));
                    }
                }
                this.compList.add(prmtBgProcess);
            }
            if ((double)(totalHeight += yCompGap) > this.spMain.getPreferredSize().getHeight() - (double)yCompGap) {
                int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height - 150;
                if (maxHeight > 700) {
                    maxHeight = 700;
                }
                int initHeight = this.spMain.getHeight();
                this.pnlMain.setPreferredSize(new Dimension(width, totalHeight + yCompGap));
                Dimension bounds = this.getPreferredSize();
                if (totalHeight > maxHeight - yCompGap) {
                    bounds.height = bounds.height + maxHeight - initHeight;
                    this.setPreferredSize(new Dimension(bounds.width, bounds.height));
                    this.spMain.setVerticalScrollBarPolicy(22);
                } else {
                    bounds.height = (int)((double)bounds.height + this.pnlMain.getPreferredSize().getHeight() - (double)initHeight);
                    this.setPreferredSize(new Dimension(bounds.width, bounds.height));
                    this.spMain.setVerticalScrollBarPolicy(21);
                }
            }
        }
    }

    private void initRadio(KDPanel kDPanel) {
        int borederInner = 25;
        int xGapRadio = 15;
        int radioWidth = (kDPanel.getWidth() - borederInner * 2 - xGapRadio * 2) / 3;
        int yRadio = 15;
        int hightRadio = 30;
        this.kDRadioAll.setName("kDRadioAll");
        this.kDRadioAll.setText(BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"selfAndAllChild"));
        this.kDRadioAll.setSelected(true);
        this.kDRadioAll.setBounds(new Rectangle(borederInner, yRadio, radioWidth, hightRadio));
        this.kDRadioLeaf.setName("kDRadioLeaf");
        this.kDRadioLeaf.setText(BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"onlyLeaf"));
        this.kDRadioLeaf.setSelected(false);
        this.kDRadioLeaf.setBounds(new Rectangle(borederInner + radioWidth + xGapRadio, yRadio, radioWidth, hightRadio));
        this.kDRadioNotLeaf.setName("notLeaf");
        this.kDRadioNotLeaf.setText(BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"notLeaf"));
        this.kDRadioNotLeaf.setSelected(false);
        this.kDRadioNotLeaf.setBounds(new Rectangle(borederInner + 2 * (radioWidth + xGapRadio), yRadio, radioWidth, hightRadio));
        KDButtonGroup calculateModeGroup = new KDButtonGroup();
        calculateModeGroup.add((AbstractButton)this.kDRadioAll);
        calculateModeGroup.add((AbstractButton)this.kDRadioLeaf);
        calculateModeGroup.add((AbstractButton)this.kDRadioNotLeaf);
        kDPanel.add((Component)this.kDRadioAll);
        kDPanel.add((Component)this.kDRadioLeaf);
        kDPanel.add((Component)this.kDRadioNotLeaf);
        try {
            if (!MBGFormFacadeFactory.getRemoteInstance().isUseAlgo()) {
                this.kDRadioAll.setEnabled(false);
                this.kDRadioLeaf.setEnabled(false);
                this.kDRadioNotLeaf.setEnabled(false);
            }
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        if (this.getUIContext().get("formulaName") instanceof String) {
            String formulaName = (String)this.getUIContext().get("formulaName");
            if (formulaName.equals("MBR")) {
                this.kDRadioAll.setSelected(true);
            } else if (formulaName.equals("LEAF_MBR")) {
                this.kDRadioLeaf.setSelected(true);
            } else if (formulaName.equals("NLEAF_MBR")) {
                this.kDRadioNotLeaf.setSelected(true);
            }
        }
    }

    private void setUIBounds(KDPanel kDPanel) {
        int yGap = 20;
        this.btnOk.setBounds(this.btnOk.getX(), kDPanel.getY() + kDPanel.getHeight() + yGap * 2, this.btnOk.getWidth(), this.btnOk.getHeight());
        this.btnCancel.setBounds(this.btnCancel.getX(), kDPanel.getY() + kDPanel.getHeight() + yGap * 2, this.btnCancel.getWidth(), this.btnCancel.getHeight());
        this.kDSeparator2.setBounds(new Rectangle(this.kDSeparator2.getX(), kDPanel.getY() + kDPanel.getHeight() + yGap, this.kDSeparator2.getWidth(), this.kDSeparator2.getHeight()));
        this.setBounds(new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight() + kDPanel.getHeight() + yGap));
    }

    private KDPanel getPanel(int x, int y, int width, int height, int yCompGap, int yindex) {
        KDPanel kDPanel = new KDPanel();
        kDPanel.setName("LeafMBRPanel");
        kDPanel.setBorder((Border)new TitledBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(148, 145, 140)), BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"showLeafMBR")));
        kDPanel.setBounds(new Rectangle(x, y + yindex * (height + yCompGap), width, height * 3));
        this.pnlMain.add((Component)kDPanel, (Object)new KDLayout.Constraints(x, y + yindex * (height + yCompGap), width, height * 2, 0));
        kDPanel.setLayout(null);
        return kDPanel;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
        }
        return this.schemeHelper;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.formula = this.generateFormula();
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    protected String generateFormula() {
        int memberSize = 0;
        StringBuffer forStr = new StringBuffer();
        forStr.append("MBR").append(":").append("[");
        for (KDBizPromptBox prmt : this.compList) {
            BgDimensionMember dim = null;
            if (prmt.getData() != null) {
                if (prmt.getData() instanceof BgDimensionMember) {
                    dim = (BgDimensionMember)prmt.getData();
                } else if (prmt.getData() instanceof BgPeriodInfo) {
                    BgPeriodInfo p = (BgPeriodInfo)prmt.getData();
                    dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, p.getName(), p.getNumber());
                    dim.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                } else if (prmt.getData() instanceof List) {
                    List periodVar = (List)prmt.getData();
                    if (!periodVar.isEmpty()) {
                        dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, (String)periodVar.get(0), (String)periodVar.get(0));
                        dim.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                    }
                } else if (prmt.getData() instanceof StringBuffer) {
                    dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, prmt.getData().toString(), prmt.getData().toString());
                } else if (prmt.getData() instanceof BgProcessEnum) {
                    BgProcessEnum bEnum = (BgProcessEnum)prmt.getData();
                    dim = BgProcessHelper.getMember((String)bEnum.getName());
                }
            }
            if (dim == null) continue;
            forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR);
            if (dim.getSrcNumber() != null) {
                forStr.append(dim.getSrcNumber()).append(BgBaseConstants.SEP_FOUR_STR).append(dim.getNumber());
            } else {
                forStr.append(dim.getNumber());
            }
            forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR).append(BgBaseConstants.SEP_THR_STR);
            ++memberSize;
        }
        if (this.compList.size() > 0) {
            forStr.delete(forStr.length() - 1, forStr.length()).append("]");
        }
        if (memberSize == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"bizAtLeastOneDim"));
            SysUtil.abort();
        }
        return forStr.toString();
    }

    protected void resetDimDialog(String number) {
        BizCalcDimensionMemberSelectDialog dialog = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("orgUnitId");
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.setSelector(sic);
        BgOrgUnitCollection orgCol = null;
        String orgUnitId = null;
        try {
            orgCol = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)("getBgOrgUnitCollection error" + e.getMessage()));
        }
        if (orgCol != null && !orgCol.isEmpty()) {
            orgUnitId = orgCol.get(0).getOrgUnitID();
        }
        for (KDBizPromptBox prmt : this.compList) {
            String dimNumber = prmt.getName().substring(4);
            if (DimensionBaseConstants.necessary.contains(dimNumber) || DimensionConstants.DEF_PROCESSTYPE_NUMBER.equals(dimNumber) || "BG_Period1".equals(dimNumber) || "BG_Period2".equals(dimNumber)) continue;
            try {
                dialog = new BizCalcDimensionMemberSelectDialog((Component)((Object)this), this.getSchemeHelper().getBgSchemeId(), this.getSchemeHelper().getDimension(dimNumber), orgUnitId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ((BizCalcDimensionMemberSelectDialog)dialog).setMulti(false);
            prmt.setSelector(dialog);
        }
    }

    protected boolean isNeedProcessType() {
        return this.schemeHelper == null || !this.schemeHelper.getClass().getName().equals(DimensionConstants.CSLSCHEME_HELPER);
    }

    protected class CalcMemDispFormatter
    implements IFormatter {
        protected CalcMemDispFormatter() {
        }

        public String valueToString(Object o) {
            if (o instanceof BgPeriodInfo) {
                BgPeriodInfo p = (BgPeriodInfo)o;
                return "[" + p.getNumber() + "]" + p.getName();
            }
            return o.toString();
        }

        public void applyPattern(String pattern) {
        }
    }
}

