/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.client.AbstractBizDimCellUI;
import com.kingdee.eas.ma.biz.client.BizCalcListUI;
import com.kingdee.eas.ma.biz.client.BizCalcMainUI;
import com.kingdee.eas.ma.biz.utils.BizDimInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BizDimCellUI
extends AbstractBizDimCellUI {
    private static final long serialVersionUID = -2210423406909620193L;
    private static final Logger logger = CoreUIObject.getLogger(BizDimCellUI.class);
    private static final String COL_bizSubSetId = "bizSubSetId";
    private static final String COL_bizCalcNumber = "bizCalcNumber";
    private static final String COL_bizCalcName = "bizCalcName";
    private static final String COL_bgTemplate = "bgTemplate";
    private static final String COL_bizSubSetName = "bizSubSetName";
    private static final String COL_formula = "formula";

    public static void showDimUI(CoreUI ownerUI, final String formula, final String bgSchemeId, final String versionNumber, final String orgUnitId, final String bgPeriodNumber) throws Exception {
        UIContext uiContext = new UIContext((Object)ownerUI);
        uiContext.put((Object)"BGSCHEME_ID", (Object)bgSchemeId);
        uiContext.put((Object)"ORGUNIT_ID", (Object)orgUnitId);
        uiContext.put((Object)"FORMULA", (Object)formula);
        uiContext.put((Object)"VERSION_NUMBER", (Object)versionNumber);
        uiContext.put((Object)"StartBgPeriod", (Object)bgPeriodNumber);
        final ArrayList bizDims = new ArrayList();
        uiContext.put((Object)"InitDataObject", bizDims);
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)ownerUI);
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                List _bizDims = BizCalcFactory.getRemoteInstance().bizDim(bgSchemeId, orgUnitId, formula, versionNumber, bgPeriodNumber);
                if (_bizDims != null && !_bizDims.isEmpty()) {
                    bizDims.addAll(_bizDims);
                }
                return bizDims;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BizDimCellUI.class.getName(), (Map)uiContext);
        BgBaseHelper.setMaxDialog((IUIWindow)uiWindow);
        uiWindow.show();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        List bizDims = (List)this.getUIContext().get("InitDataObject");
        this.loadBizDims(bizDims);
    }

    private void loadBizDims(List<BizDimInfo> bizDims) {
        if (bizDims == null || bizDims.isEmpty()) {
            return;
        }
        IRow row = null;
        for (BizDimInfo info : bizDims) {
            row = this.tblMain.addRow();
            row.setUserObject((Object)info);
            row.getCell(COL_bizSubSetId).setValue((Object)info.getSubSet().getId().toString());
            row.getCell(COL_bizCalcNumber).setValue((Object)info.getSubSet().getBizCalc().getNumber());
            row.getCell(COL_bizCalcName).setValue((Object)info.getSubSet().getBizCalc().getName());
            row.getCell(COL_bizCalcName).setValue((Object)info.getSubSet().getBizCalc().getName());
            row.getCell(COL_bizSubSetName).setValue((Object)info.getSubSet().getName());
            row.getCell(COL_bgTemplate).setValue((Object)info.getRefBgTemplateNumber());
            row.getCell(COL_formula).setValue((Object)info.getExpress());
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() != 2 || e.getButton() != 1) {
            return;
        }
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        BizDimInfo info = (BizDimInfo)row.getUserObject();
        BgSchemeInfo schemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectStringPK((String)this.getUIContext().get("BGSCHEME_ID")));
        BizCalcListUI.showBizEditUI(this, null, info.getSubSet().getBizCalc().getId().toString(), schemeInfo, this.getBizCalcMainUI(), OprtState.VIEW);
    }

    protected String getBizCalcMainUI() {
        return BizCalcMainUI.class.getName();
    }
}

