/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client;

import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.biz.client.AbstractBizFunctionPickerUI;
import com.kingdee.eas.ma.mbg.BizFunctionType;
import com.kingdee.eas.ma.mbg.MbgFunctionProcess;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.function.dataType.MbgFunction;
import com.kingdee.eas.ma.mbg.function.define.MbgFunctionSourceFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ListSelectionEvent;
import org.apache.log4j.Logger;

public class BizFunctionPickerUI
extends AbstractBizFunctionPickerUI {
    private static final Logger logger = CoreUIObject.getLogger(BizFunctionPickerUI.class);
    public static String IS_EXAMINE = "IS_EXAMINE";
    private MbgFunctionSourceFactory fnFactory = null;
    private Map<String, List<String>> fnMap = null;
    protected StringBuffer functionStr = null;
    protected String formula = null;
    public static final String FUNCTION_STR = "functionStr";

    public String getFunctionStr() {
        return this.functionStr.toString();
    }

    public String getFormula() {
        return this.formula;
    }

    public void onLoad() throws Exception {
        this.functionStr = new StringBuffer();
        super.onLoad();
        this.initListPnl();
        this.initCbxFunction();
    }

    protected void initCbxFunction() {
        this.cbxFunction.removeItem((Object)BizFunctionType.MEMBER);
        this.cbxFunction.removeItem((Object)BizFunctionType.AGG);
        this.cbxFunction.removeItem((Object)BizFunctionType.PERIOD);
        if (this.getUIContext() != null && this.getUIContext().get(IS_EXAMINE) != null && this.getUIContext().get(IS_EXAMINE) instanceof Boolean) {
            this.cbxFunction.removeItem((Object)BizFunctionType.BOOLEAN);
        }
    }

    protected void initListPnl() throws Exception {
        BizFunctionType fnType;
        List<String> fnList;
        this.fnFactory = MbgFunctionSourceFactory.getInstance();
        this.fnMap = new HashMap<String, List<String>>();
        Map typeMap = this.fnFactory.getFunctionTypeMap();
        for (String typeName : typeMap.keySet()) {
            List fnList2 = (List)typeMap.get(typeName);
            ArrayList<String> nameList = new ArrayList<String>();
            this.fnMap.put(typeName, nameList);
            for (MbgFunction fn : fnList2) {
                nameList.add(fn.getName() + "  (" + fn.getLocalName() + ")");
            }
        }
        if (this.fnMap != null && (fnList = this.fnMap.get((fnType = (BizFunctionType)this.cbxFunction.getSelectedItem()).getName())) != null) {
            this.lisFunction.setListData(fnList.toArray());
        }
        this.lisFunction.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    try {
                        BizFunctionPickerUI.this.btnOK_actionPerformed(null);
                    }
                    catch (Exception ex) {
                        BizFunctionPickerUI.this.handUIException(ex);
                    }
                }
            }
        });
    }

    @Override
    protected void cbxFunction_actionPerformed(ActionEvent e) throws Exception {
        super.cbxFunction_actionPerformed(e);
        BizFunctionType fnType = (BizFunctionType)this.cbxFunction.getSelectedItem();
        List<String> fnList = this.fnMap.get(fnType.getName());
        if (fnList != null) {
            this.lisFunction.setListData(fnList.toArray());
        } else {
            this.lisFunction.setListData(new Object[0]);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
        uiContext.put((Object)DimensionConstants.DIMENSION, this.getUIContext().get(DimensionConstants.DIMENSION));
        uiContext.put((Object)BgBaseConstants.BGSCHEME_ID, this.getUIContext().get(BgBaseConstants.BGSCHEME_ID));
        uiContext.put((Object)FUNCTION_STR, (Object)this.functionStr);
        if (this.getUIContext() != null && this.getUIContext().get(IS_EXAMINE) != null && this.getUIContext().get(IS_EXAMINE) instanceof Boolean) {
            uiContext.put((Object)"onlyMember", (Object)Boolean.TRUE);
        }
        MbgFunctionProcess process = new MbgFunctionProcess((String)this.lisFunction.getSelectedValue(), (CoreUI)this, uiContext);
        process.process();
        if (StringUtil.isEmpty((String)this.functionStr.toString())) {
            this.formula = null;
        } else {
            this.formula = this.generateFormula();
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void lisFunction_valueChanged(ListSelectionEvent e) throws Exception {
        super.lisFunction_valueChanged(e);
        String selectValue = (String)this.lisFunction.getSelectedValue();
        String selectFnName = null;
        if (selectValue != null) {
            selectFnName = selectValue.substring(0, selectValue.indexOf("(")).trim();
        }
        if (selectFnName != null) {
            MbgFunction function = this.fnFactory.getFunction(selectFnName);
            this.txtDescription.setText(function != null ? function.getLocalDescription() : null);
        } else {
            this.txtDescription.setText("");
        }
    }

    public void checkSelected() {
        if (this.lisFunction.getSelectedIndex() < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected String generateFormula() {
        return "FX:[" + this.functionStr.toString() + "]";
    }
}

