/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client;

import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class ColorControlDocument
extends DefaultStyledDocument {
    private final String STYLE_DEFAULT_ = "styleDefault";
    private final String STYLE_MBR = "styleMBR";
    private final String STYLE_FX = "styleFX";
    private final String STYLE_VAR = "styleVAR";
    private final String STYLE_GVF = "styleGVF";
    private final String STYLE_IFELSE = "styleIFELSE";
    private final String STYLE_ANNOTATION = "styleAnnotation";
    private final String STYLE_PTO = "stylePTO";
    protected UndoManager manager = null;
    protected CompoundEdit compoundEdit = null;
    protected UndoableEditListener undoListener = null;
    protected String initStr = "";
    protected boolean isDoingHighLight = false;
    protected boolean initDone = false;

    public UndoManager getManager() {
        return this.manager;
    }

    public ColorControlDocument(String initStr) {
        try {
            if (initStr != null) {
                this.initStr = initStr;
                this.insertString(0, initStr, null);
                this.doHightLight();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.initStyle();
        this.manager = new UndoManager();
        this.compoundEdit = new CompoundEdit();
        this.undoListener = new BizUndoableEditListener();
        this.addUndoableEditListener(this.undoListener);
        this.addDocumentListener(new DocumentChangeListener());
    }

    protected void initStyle() {
        Style styleDefault = this.addStyle("styleDefault", null);
        StyleConstants.setForeground(styleDefault, new Color(0, 0, 0));
        Style styleMBR = this.addStyle("styleMBR", null);
        StyleConstants.setForeground(styleMBR, Color.red);
        Style stylePTO = this.addStyle("stylePTO", null);
        StyleConstants.setForeground(stylePTO, Color.BLUE);
        Style styleFX = this.addStyle("styleFX", null);
        StyleConstants.setForeground(styleFX, new Color(0, 180, 80));
        Style styleVAR = this.addStyle("styleVAR", null);
        StyleConstants.setForeground(styleVAR, new Color(255, 180, 100));
        Style styleGVF = this.addStyle("styleGVF", null);
        StyleConstants.setForeground(styleGVF, new Color(0, 180, 240));
        Style styleIFELSE = this.addStyle("styleIFELSE", null);
        StyleConstants.setForeground(styleIFELSE, new Color(128, 0, 255));
        Style styleAnnotation = this.addStyle("styleAnnotation", null);
        StyleConstants.setForeground(styleAnnotation, Color.GRAY);
    }

    public void doHightLight() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorControlDocument.this.isDoingHighLight = true;
                SimpleAttributeSet blackset = new SimpleAttributeSet();
                StyleConstants.setForeground(blackset, Color.black);
                ColorControlDocument.this.setCharacterAttributes(0, ColorControlDocument.this.getLength(), blackset, true);
                try {
                    String reg = null;
                    Pattern pattern = null;
                    Matcher match = null;
                    ColorControlDocument.this.findIf();
                    reg = "(MBR:\\[[\\S]*?\\])";
                    pattern = Pattern.compile(reg);
                    match = pattern.matcher(ColorControlDocument.this.getText(0, ColorControlDocument.this.getLength()));
                    while (match.find()) {
                        ColorControlDocument.this.setCharacterAttributes(match.start(), 5, ColorControlDocument.this.getStyle("styleMBR"), true);
                        ColorControlDocument.this.setCharacterAttributes(match.end() - 1, 1, ColorControlDocument.this.getStyle("styleMBR"), true);
                    }
                    reg = "(PTO:\\[[\\S]*?\\])";
                    pattern = Pattern.compile(reg);
                    match = pattern.matcher(ColorControlDocument.this.getText(0, ColorControlDocument.this.getLength()));
                    while (match.find()) {
                        ColorControlDocument.this.setCharacterAttributes(match.start(), 5, ColorControlDocument.this.getStyle("stylePTO"), true);
                        ColorControlDocument.this.setCharacterAttributes(match.end() - 1, 1, ColorControlDocument.this.getStyle("stylePTO"), true);
                    }
                    reg = "(FX:\\[[^\\[\\]]*?\\])";
                    pattern = Pattern.compile(reg);
                    match = pattern.matcher(ColorControlDocument.this.getText(0, ColorControlDocument.this.getLength()));
                    while (match.find()) {
                        ColorControlDocument.this.setCharacterAttributes(match.start(), 4, ColorControlDocument.this.getStyle("styleFX"), true);
                        ColorControlDocument.this.setCharacterAttributes(match.end() - 1, 1, ColorControlDocument.this.getStyle("styleFX"), true);
                    }
                    reg = "(FX:\\[(?:[^\\[\\]]*\\[[^\\[\\]]*\\][^\\[\\]]*)+\\])";
                    pattern = Pattern.compile(reg);
                    match = pattern.matcher(ColorControlDocument.this.getText(0, ColorControlDocument.this.getLength()));
                    while (match.find()) {
                        ColorControlDocument.this.setCharacterAttributes(match.start(), 4, ColorControlDocument.this.getStyle("styleFX"), true);
                        ColorControlDocument.this.setCharacterAttributes(match.end() - 1, 1, ColorControlDocument.this.getStyle("styleFX"), true);
                    }
                    reg = "(GVF:\\[[\\s\\S]*?\\])";
                    pattern = Pattern.compile(reg);
                    match = pattern.matcher(ColorControlDocument.this.getText(0, ColorControlDocument.this.getLength()));
                    while (match.find()) {
                        ColorControlDocument.this.setCharacterAttributes(match.start(), 5, ColorControlDocument.this.getStyle("styleGVF"), true);
                        ColorControlDocument.this.setCharacterAttributes(match.end() - 1, 1, ColorControlDocument.this.getStyle("styleGVF"), true);
                    }
                    reg = "(LEAF_MBR:\\[[\\s\\S]*?\\])";
                    pattern = Pattern.compile(reg);
                    match = pattern.matcher(ColorControlDocument.this.getText(0, ColorControlDocument.this.getLength()));
                    while (match.find()) {
                        ColorControlDocument.this.setCharacterAttributes(match.start(), 10, ColorControlDocument.this.getStyle("styleMBR"), true);
                        ColorControlDocument.this.setCharacterAttributes(match.end() - 1, 1, ColorControlDocument.this.getStyle("styleMBR"), true);
                    }
                    reg = "(NLEAF_MBR:\\[[\\s\\S]*?\\])";
                    pattern = Pattern.compile(reg);
                    match = pattern.matcher(ColorControlDocument.this.getText(0, ColorControlDocument.this.getLength()));
                    while (match.find()) {
                        ColorControlDocument.this.setCharacterAttributes(match.start(), 11, ColorControlDocument.this.getStyle("styleMBR"), true);
                        ColorControlDocument.this.setCharacterAttributes(match.end() - 1, 1, ColorControlDocument.this.getStyle("styleMBR"), true);
                    }
                    reg = "(VAR:\\[[\\s\\S]*?\\])";
                    pattern = Pattern.compile(reg);
                    match = pattern.matcher(ColorControlDocument.this.getText(0, ColorControlDocument.this.getLength()));
                    while (match.find()) {
                        ColorControlDocument.this.setCharacterAttributes(match.start(), 5, ColorControlDocument.this.getStyle("styleVAR"), true);
                        ColorControlDocument.this.setCharacterAttributes(match.end() - 1, 1, ColorControlDocument.this.getStyle("styleVAR"), true);
                    }
                    reg = "(\\/\\*[\\S\\s]*?\\*\\/)";
                    pattern = Pattern.compile(reg);
                    match = pattern.matcher(ColorControlDocument.this.getText(0, ColorControlDocument.this.getLength()));
                    while (match.find()) {
                        ColorControlDocument.this.setCharacterAttributes(match.start(), match.group(1).length(), ColorControlDocument.this.getStyle("styleAnnotation"), true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ExceptionHandler.handle((Throwable)e);
                }
                ColorControlDocument.this.isDoingHighLight = false;
                ColorControlDocument.this.initDone = true;
            }
        });
    }

    protected void findIf() throws BadLocationException {
        String findStr = "IF";
        List<Integer[]> indexes = this.findChar(findStr);
        this.setIfAttributes(findStr, indexes);
        findStr = "ELSE";
        indexes = this.findChar(findStr);
        this.setIfAttributes(findStr, indexes);
    }

    private void setIfAttributes(String findStr, List<Integer[]> allIndexes) {
        for (Integer[] indexes : allIndexes) {
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] == null) continue;
                if (i == 0) {
                    this.setCharacterAttributes(indexes[i], findStr.length(), this.getStyle("styleIFELSE"), true);
                    continue;
                }
                this.setCharacterAttributes(indexes[i], 1, this.getStyle("styleIFELSE"), true);
            }
        }
    }

    private List<Integer[]> findChar(String findStr) throws BadLocationException {
        String text = this.getText(0, this.getLength());
        int point = 0;
        ArrayList<Integer[]> result = new ArrayList<Integer[]>();
        Integer[] subList = null;
        int index = -1;
        int count = 0;
        while (point < text.length() && (index != -1 || point < text.length() - findStr.length())) {
            if (index == -1 && findStr.equals(text.substring(point, point + findStr.length()))) {
                index = 0;
                subList = new Integer[5];
                result.add(subList);
                subList[0] = point;
                count = 0;
                point += findStr.length();
                continue;
            }
            if (index >= 0) {
                if ('{' == text.charAt(point) && subList != null) {
                    subList[3] = point;
                }
                if ('}' == text.charAt(point) && subList != null) {
                    subList[4] = point;
                    index = -1;
                }
                if ('[' == text.charAt(point)) {
                    if (count == 0 && subList != null && subList[3] == null) {
                        subList[1] = point;
                    }
                    ++count;
                }
                if (']' == text.charAt(point) && subList != null && subList[3] == null && --count == 0) {
                    subList[2] = point;
                }
            }
            ++point;
        }
        return result;
    }

    public class DocumentChangeListener
    implements DocumentListener {
        public ColorControlDocument document = null;

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.document = (ColorControlDocument)e.getDocument();
            ColorControlDocument.this.doHightLight();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.document = (ColorControlDocument)e.getDocument();
            ColorControlDocument.this.doHightLight();
        }
    }

    protected class BizUndoableEditListener
    implements UndoableEditListener {
        public ColorControlDocument document = null;

        protected BizUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            this.document = (ColorControlDocument)e.getSource();
            if (ColorControlDocument.this.initDone) {
                if (!ColorControlDocument.this.isDoingHighLight) {
                    if (ColorControlDocument.this.compoundEdit.isInProgress()) {
                        ColorControlDocument.this.compoundEdit.end();
                    }
                    ColorControlDocument.this.compoundEdit = new CompoundEdit();
                    ColorControlDocument.this.manager.addEdit(ColorControlDocument.this.compoundEdit);
                }
                ColorControlDocument.this.compoundEdit.addEdit(e.getEdit());
            }
        }
    }
}

