/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizFacadeFactory;
import com.kingdee.eas.ma.biz.client.BizCalcMainUI;
import com.kingdee.eas.ma.biz.utils.BizCalcCommonHelper;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.client.BgExamineMainUI;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgProcessHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcClientHelper {
    private static final Logger logger = CoreUIObject.getLogger(BizCalcClientHelper.class);
    private static final String PTO_UI = "com.kingdee.eas.ma.biz.client.BizPtoMembersUI";
    private static final String MBR_UI = "com.kingdee.eas.ma.biz.client.BizCalcMembersUI";
    private static final String FX_UI = "com.kingdee.eas.ma.biz.client.BizFunctionPickerUI";
    private static final String VAR_UI = "com.kingdee.eas.ma.mbg.client.FunctionSelectF7UI";
    private static final String GVF_UI = null;
    private static final String DESP_UI = null;

    public static String parseFormula(String txt, int caretMark, String formulaName, KDTextPane txtPane) {
        if (StringUtils.isEmpty((String)formulaName)) {
            return null;
        }
        String formula = null;
        StringBuffer tmpStack = new StringBuffer();
        int newCaretDot = txt.indexOf("[", caretMark);
        if (newCaretDot != -1) {
            tmpStack.append("[");
        } else {
            return null;
        }
        while (++newCaretDot < txt.length()) {
            if (txt.charAt(newCaretDot) == ']') {
                tmpStack.deleteCharAt(tmpStack.length() - 1);
            } else if (txt.charAt(newCaretDot) == '[') {
                tmpStack.append('[');
            }
            if (tmpStack.length() != 0) continue;
        }
        if (newCaretDot > 0 && tmpStack.length() == 0 && BizCalcCommonHelper.verifyFormula(formulaName, formula = txt.substring(caretMark, newCaretDot + 1))) {
            txtPane.setSelectionStart(caretMark);
            txtPane.setSelectionEnd(newCaretDot + 1);
            return formula;
        }
        return null;
    }

    public static String parseFormulName(String txt, int caretMark, int caretDot) {
        String tx;
        String formulaName = txt.substring(caretMark, caretDot);
        if (caretMark > 4 && !StringUtils.isEmpty((String)(tx = txt.substring(caretMark - 4, caretMark - 1))) && (tx.equalsIgnoreCase("MAX") || tx.equalsIgnoreCase("MIN") || tx.equalsIgnoreCase("ABS") || tx.equalsIgnoreCase("AVG"))) {
            return null;
        }
        if (BizConstants.ALL_FORMULA.contains(formulaName)) {
            return formulaName;
        }
        return null;
    }

    public static String getFormulaUIName(String formulaName, String formula) {
        if (StringUtils.isEmpty((String)formulaName)) {
            return null;
        }
        if (formulaName.equals("MBR") || formulaName.equals("LEAF_MBR") || formulaName.equals("NLEAF_MBR")) {
            return MBR_UI;
        }
        if (formulaName.equals("PTO")) {
            return PTO_UI;
        }
        if (formulaName.equals("FX")) {
            return FX_UI;
        }
        if (formulaName.equals("VAR")) {
            return VAR_UI;
        }
        if (formulaName.equals("GVF")) {
            return GVF_UI;
        }
        if (formulaName.equals("DESC")) {
            return null;
        }
        return null;
    }

    public static Map<String, Object> parseMBRMember(BgSchemeDimensionHelper hepler, String formulaName, String formula, BgSchemeInfo bgSchemeInfo) {
        if (hepler == null || StringUtils.isEmpty((String)formulaName) || StringUtils.isEmpty((String)formula)) {
            return null;
        }
        HashMap<String, Object> memberMap = new HashMap<String, Object>();
        String[] members = null;
        if (formulaName.equals("MBR") || formulaName.equals("LEAF_MBR") || formulaName.equals("NLEAF_MBR")) {
            if (formula.indexOf("FX:[") > 0) {
                int fxStart = formula.indexOf("FX:[") - 1;
                int fxEnd = formula.indexOf("]", fxStart) + 2;
                String fx = formula.substring(fxStart, fxEnd);
                formula = formula.replace(fx, "");
                if ((fx = fx.substring(1, fx.length() - 1)).indexOf("@Lead") > 0) {
                    memberMap.put(DimensionConstants.DEF_PERIOD_NUMBER, new StringBuffer(fx));
                } else if (fx.indexOf("@Parent") > 0) {
                    memberMap.put(DimensionConstants.DEF_ORGUNIT_NUMBER, new StringBuffer(fx));
                }
            }
            members = formula.substring(formula.indexOf("[") + 1, formula.indexOf("]")).split(",");
        }
        if (bgSchemeInfo != null) {
            try {
                hepler = new BgSchemeDimensionHelper(bgSchemeInfo.getId().toString());
            }
            catch (Exception ex) {
                logger.error((Object)("getSchemeHelper error:" + ex.getMessage()));
            }
        }
        Map srcMap = hepler.getDimensionBySrcNumber();
        HashMap<String, String> dimMap = new HashMap<String, String>();
        String[] memNum = null;
        String srcNum = null;
        String number = null;
        String bgSchemeId = null;
        if (members != null && members.length > 0) {
            if (bgSchemeInfo != null) {
                String bgSchemeNumber = members[0].split(":")[1];
                if (bgSchemeInfo == null) {
                    return memberMap;
                }
                bgSchemeId = bgSchemeInfo.getId().toString();
                try {
                    if (!hepler.getBgSchemeId().equals(bgSchemeId)) {
                        hepler = new BgSchemeDimensionHelper(bgSchemeId);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
                srcMap = hepler.getDimensionBySrcNumber();
                int firstSep = members[0].indexOf(":");
                int secondSep = members[0].indexOf(":", firstSep + 1);
                String memNumTmp = members[0].substring(secondSep + 1);
                memNum = memNumTmp.substring(1, memNumTmp.length() - 1).split(":");
                srcNum = memNum[0];
                number = memNum[1];
                if (srcMap.get(srcNum) != null) {
                    dimMap.put(srcNum, number);
                }
                for (int i = 1; i < members.length; ++i) {
                    BgDimensionMember member;
                    if (StringUtils.isEmpty((String)members[i])) continue;
                    memNum = members[i].substring(1, members[i].length() - 1).split(":");
                    srcNum = memNum[0];
                    number = memNum[1];
                    if (srcMap.get(srcNum) != null) {
                        dimMap.put(srcNum, number);
                    }
                    if (!BgProcessHelper.DEF_PROCESS_SRC.equals(srcNum) || (member = BgProcessHelper.getMember((String)number)) == null) continue;
                    if (!memberMap.containsKey(BgProcessHelper.DEF_PROCESS_NUMBER)) {
                        memberMap.put(BgProcessHelper.DEF_PROCESS_NUMBER, new HashSet());
                    }
                    ((Set)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER)).add(member);
                }
            } else {
                bgSchemeId = hepler.getBgSchemeId();
                for (int i = 0; i < members.length; ++i) {
                    BgDimensionMember member;
                    if (members[i].length() <= 0 || StringUtils.isEmpty((String)members[i])) continue;
                    memNum = members[i].substring(1, members[i].length() - 1).split(":");
                    srcNum = memNum[0];
                    number = memNum[1];
                    if (srcMap.get(srcNum) != null) {
                        dimMap.put(srcNum, number);
                    }
                    if (BgProcessHelper.DEF_PROCESS_SRC.equals(srcNum) && (member = BgProcessHelper.getMember((String)number)) != null) {
                        if (!memberMap.containsKey(BgProcessHelper.DEF_PROCESS_NUMBER)) {
                            memberMap.put(BgProcessHelper.DEF_PROCESS_NUMBER, new HashSet());
                        }
                        ((Set)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER)).add(member);
                    }
                    if (!DimensionBaseConstants.DEF_PERIOD_SRCNUMBER.equals(srcNum) || !BgPeriodNVariableHelper.checkCanConvert((String)number)) continue;
                    member = new BgDimensionMember(DimensionBaseConstants.DEF_PERIOD_NUMBER, DimensionBaseConstants.DEF_PERIOD_FIELD, null, number);
                    member.setSrcNumber(DimensionBaseConstants.DEF_PERIOD_SRCNUMBER);
                    memberMap.put(DimensionBaseConstants.DEF_PERIOD_NUMBER, member);
                }
            }
            try {
                memberMap.putAll(BizFacadeFactory.getRemoteInstance().queryDimMember(bgSchemeId, dimMap, srcMap, false, false, BizCalcClientHelper.getOrgTreeIdBySchemeHelper(hepler)));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
        }
        return memberMap;
    }

    public static Map<String, Object> parsePTOMember(BgSchemeDimensionHelper hepler, String formulaName, String formula, BgSchemeInfo bgSchemeInfo) {
        if (hepler == null || StringUtils.isEmpty((String)formulaName) || StringUtils.isEmpty((String)formula)) {
            return null;
        }
        HashMap<String, Object> memberMap = new HashMap<String, Object>();
        String[] members = null;
        if (formulaName.equals("PTO")) {
            if (formula.indexOf("FX:[") > 0) {
                int fxStart = formula.indexOf("FX:[") - 1;
                int fxEnd = formula.indexOf("]", fxStart) + 2;
                String fx = formula.substring(fxStart, fxEnd);
                formula = formula.replace(fx, "");
                if ((fx = fx.substring(1, fx.length() - 1)).indexOf("@Lead") > 0) {
                    memberMap.put(DimensionConstants.DEF_PERIOD_NUMBER, new StringBuffer(fx));
                } else if (fx.indexOf("@Parent") > 0) {
                    memberMap.put(DimensionConstants.DEF_ORGUNIT_NUMBER, new StringBuffer(fx));
                }
            }
            members = formula.substring(formula.indexOf("[") + 1, formula.indexOf("]")).split(",");
        }
        if (bgSchemeInfo != null) {
            try {
                hepler = new BgSchemeDimensionHelper(bgSchemeInfo.getId().toString());
            }
            catch (Exception ex) {
                logger.error((Object)("getSchemeHelper error:" + ex.getMessage()));
            }
        }
        Map srcMap = hepler.getDimensionBySrcNumber();
        HashMap<String, String> dimMap = new HashMap<String, String>();
        String[] memNum = null;
        String srcNum = null;
        String number = null;
        String bgSchemeId = null;
        if (members != null && members.length > 0) {
            if (bgSchemeInfo != null) {
                String bgSchemeNumber = members[0].split(":")[1];
                if (bgSchemeInfo == null) {
                    return memberMap;
                }
                bgSchemeId = bgSchemeInfo.getId().toString();
                try {
                    if (!hepler.getBgSchemeId().equals(bgSchemeId)) {
                        hepler = new BgSchemeDimensionHelper(bgSchemeId);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
                srcMap = hepler.getDimensionBySrcNumber();
                BgDimensionInfo bgPeriod1 = ((BgDimensionInfo)srcMap.get(DimensionConstants.DEF_PERIOD_SRCNUMBER)).clone();
                bgPeriod1.setNumber("BG_Period1");
                srcMap.put("BgP1", bgPeriod1);
                BgDimensionInfo bgPeriod2 = ((BgDimensionInfo)srcMap.get(DimensionConstants.DEF_PERIOD_SRCNUMBER)).clone();
                bgPeriod2.setNumber("BG_Period2");
                srcMap.put("BgP2", bgPeriod2);
                int firstSep = members[0].indexOf(":");
                int secondSep = members[0].indexOf(":", firstSep + 1);
                String memNumTmp = members[0].substring(secondSep + 1);
                memNum = memNumTmp.substring(1, memNumTmp.length() - 1).split(":");
                srcNum = memNum[0];
                number = memNum[1];
                if (srcMap.get(srcNum) != null) {
                    dimMap.put(srcNum, number);
                }
                for (int i = 1; i < members.length; ++i) {
                    BgDimensionMember member;
                    if (StringUtils.isEmpty((String)members[i])) continue;
                    memNum = members[i].substring(1, members[i].length() - 1).split(":");
                    srcNum = memNum[0];
                    number = memNum[1];
                    if (srcMap.get(srcNum) != null) {
                        dimMap.put(srcNum, number);
                    }
                    if (!BgProcessHelper.DEF_PROCESS_SRC.equals(srcNum) || (member = BgProcessHelper.getMember((String)number)) == null) continue;
                    if (!memberMap.containsKey(BgProcessHelper.DEF_PROCESS_NUMBER)) {
                        memberMap.put(BgProcessHelper.DEF_PROCESS_NUMBER, new HashSet());
                    }
                    ((Set)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER)).add(member);
                }
            } else {
                BgDimensionInfo bgPeriod1 = ((BgDimensionInfo)srcMap.get(DimensionConstants.DEF_PERIOD_SRCNUMBER)).clone();
                bgPeriod1.setNumber("BG_Period1");
                srcMap.put("BgP1", bgPeriod1);
                BgDimensionInfo bgPeriod2 = ((BgDimensionInfo)srcMap.get(DimensionConstants.DEF_PERIOD_SRCNUMBER)).clone();
                bgPeriod2.setNumber("BG_Period2");
                srcMap.put("BgP2", bgPeriod2);
                bgSchemeId = hepler.getBgSchemeId();
                for (int i = 0; i < members.length; ++i) {
                    BgDimensionMember member;
                    if (members[i].length() <= 0 || StringUtils.isEmpty((String)members[i])) continue;
                    memNum = members[i].substring(1, members[i].length() - 1).split(":");
                    srcNum = memNum[0];
                    number = memNum[1];
                    if (srcMap.get(srcNum) != null) {
                        dimMap.put(srcNum, number);
                    }
                    if (BgProcessHelper.DEF_PROCESS_SRC.equals(srcNum) && (member = BgProcessHelper.getMember((String)number)) != null) {
                        if (!memberMap.containsKey(BgProcessHelper.DEF_PROCESS_NUMBER)) {
                            memberMap.put(BgProcessHelper.DEF_PROCESS_NUMBER, new HashSet());
                        }
                        ((Set)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER)).add(member);
                    }
                    if (DimensionBaseConstants.DEF_PERIOD_SRCNUMBER.equals(srcNum) && BgPeriodNVariableHelper.checkCanConvert((String)number)) {
                        member = new BgDimensionMember(DimensionBaseConstants.DEF_PERIOD_NUMBER, DimensionBaseConstants.DEF_PERIOD_FIELD, null, number);
                        member.setSrcNumber(DimensionBaseConstants.DEF_PERIOD_SRCNUMBER);
                        memberMap.put(DimensionBaseConstants.DEF_PERIOD_NUMBER, member);
                        continue;
                    }
                    if ("BgP1".equals(srcNum) && BgPeriodNVariableHelper.checkCanConvert((String)number)) {
                        member = new BgDimensionMember("BG_Period1", DimensionBaseConstants.DEF_PERIOD_FIELD, null, number);
                        member.setSrcNumber("BgP1");
                        memberMap.put("BG_Period1", member);
                        continue;
                    }
                    if (!"BgP2".equals(srcNum) || !BgPeriodNVariableHelper.checkCanConvert((String)number)) continue;
                    member = new BgDimensionMember("BG_Period2", DimensionBaseConstants.DEF_PERIOD_FIELD, null, number);
                    member.setSrcNumber("BgP2");
                    memberMap.put("BG_Period2", member);
                }
            }
            try {
                memberMap.putAll(BizFacadeFactory.getRemoteInstance().queryDimMember(bgSchemeId, dimMap, srcMap, false, false, BizCalcClientHelper.getOrgTreeIdBySchemeHelper(hepler)));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
        }
        return memberMap;
    }

    public static BgSchemeInfo getBgSchemeIdByNumber(String bgSchemeNumber) {
        if (StringUtils.isEmpty((String)bgSchemeNumber)) {
            return null;
        }
        BgSchemeInfo bgSchemeInfo = null;
        BgSchemeCollection col = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgSchemeNumber, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            col = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection(view);
            if (col != null && !col.isEmpty()) {
                bgSchemeInfo = col.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("getBgSchemeIdByNumber err " + e.getMessage()));
        }
        return bgSchemeInfo;
    }

    public static BgSchemeInfo parseSchMBRFomula(String formulaName, String formula) {
        String[] members = null;
        if (formulaName.equals("MBR")) {
            members = formula.substring(formula.indexOf("[") + 1, formula.indexOf("]")).split(",");
        }
        BgSchemeInfo bgSchemeInfo = null;
        Object bgSchemeId = null;
        Object memNum = null;
        Object srcNum = null;
        Object number = null;
        if (members != null && members[0].indexOf("Sch:") != -1) {
            String bgSchemeNumber = members[0].substring(1, members[0].length() - 1).split(":")[1];
            bgSchemeInfo = BizCalcClientHelper.getBgSchemeIdByNumber(bgSchemeNumber);
            return bgSchemeInfo;
        }
        return bgSchemeInfo;
    }

    public static BgSchemeInfo parseSchPTOFomula(String formulaName, String formula) {
        String[] members = null;
        if (formulaName.equals("PTO")) {
            members = formula.substring(formula.indexOf("[") + 1, formula.indexOf("]")).split(",");
        }
        BgSchemeInfo bgSchemeInfo = null;
        Object bgSchemeId = null;
        Object memNum = null;
        Object srcNum = null;
        Object number = null;
        if (members != null && members[0].indexOf("Sch:") != -1) {
            String bgSchemeNumber = members[0].substring(1, members[0].length() - 1).split(":")[1];
            bgSchemeInfo = BizCalcClientHelper.getBgSchemeIdByNumber(bgSchemeNumber);
            return bgSchemeInfo;
        }
        return bgSchemeInfo;
    }

    public static BgDimensionMember parseFXMember(BgSchemeDimensionHelper hepler, String formulaName, String formula) {
        Map memberMap = new HashMap();
        Map srcMap = hepler.getDimensionBySrcNumber();
        HashMap<String, String> dimMap = new HashMap<String, String>();
        String member = formula.substring(formula.indexOf("(") + 1, formula.indexOf(")")).split(",")[0];
        if (member != null) {
            String[] memNum = member.substring(1, member.length() - 1).split(":");
            String srcNum = memNum[0];
            String number = memNum[1];
            if (srcMap.get(srcNum) != null) {
                dimMap.put(srcNum, number);
            }
            try {
                memberMap = BizFacadeFactory.getRemoteInstance().queryDimMember(hepler.getBgSchemeId(), dimMap, srcMap, false, false, BizCalcClientHelper.getOrgTreeIdBySchemeHelper(hepler));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
            if (srcMap.get(srcNum) != null) {
                return (BgDimensionMember)memberMap.get(((BgDimensionInfo)srcMap.get(srcNum)).getNumber());
            }
        }
        return null;
    }

    public static MbgViewListResultData parseAllFXMember(BgSchemeDimensionHelper helper, String formulaName, String formula) {
        HashMap memberMap = new HashMap();
        Map srcMap = helper.getDimensionBySrcNumber();
        HashMap dimMap = new HashMap();
        String subFormulaName = formula.split("\\(")[1].split(":")[0];
        boolean isVariate = subFormulaName.equals("VAR");
        if (isVariate) {
            return BizCalcClientHelper.getMulFxVariate(helper, formula);
        }
        return BizCalcClientHelper.getMulFxMember(helper, formula);
    }

    private static MbgViewListResultData getMulFxMember(BgSchemeDimensionHelper helper, String formula) {
        Map memberMap = new HashMap();
        Map srcMap = helper.getDimensionBySrcNumber();
        HashMap<String, HashSet<String>> dimMap = new HashMap<String, HashSet<String>>();
        String memberStr = formula.split("\"")[1].split("\"")[0];
        String srcNum = memberStr.split(":")[0];
        String[] allMember = memberStr.split(":")[1].split(",");
        if (allMember != null && allMember.length > 0) {
            for (int i = 0; i < allMember.length; ++i) {
                String member = allMember[i];
                if (srcMap.get(srcNum) == null) continue;
                HashSet<String> numberSet = (HashSet<String>)dimMap.get(srcNum);
                if (numberSet == null) {
                    numberSet = new HashSet<String>();
                    dimMap.put(srcNum, numberSet);
                }
                numberSet.add(member);
            }
            try {
                memberMap = BizFacadeFactory.getRemoteInstance().queryDimMember(helper.getBgSchemeId(), dimMap, srcMap, false, true, BizCalcClientHelper.getOrgTreeIdBySchemeHelper(helper));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
            ArrayList<BgDimensionMember> memberList = new ArrayList<BgDimensionMember>();
            MbgViewListResultData result = new MbgViewListResultData();
            for (String dimNum : memberMap.keySet()) {
                Set memberSet = (Set)memberMap.get(dimNum);
                for (BgDimensionMember member : memberSet) {
                    member.setSrcNumber((String)helper.getSrcNumberMap().get(member.getType()));
                    memberList.add(member);
                }
            }
            Collections.sort(memberList);
            result.setMembers(memberList);
            result.setMemberType(BgMemberSelectTypeEnum.Member);
            return result;
        }
        return null;
    }

    private static MbgViewListResultData getMulFxVariate(BgSchemeDimensionHelper helper, String formula) {
        Set memberSet = new HashSet();
        String memberStr = formula.split("\"")[1].split("\"")[0];
        String[] allMember = memberStr.split(",");
        HashSet<String> varNumSet = new HashSet<String>();
        varNumSet.addAll(Arrays.asList(allMember));
        if (allMember != null && allMember.length > 0) {
            try {
                memberSet = BizFacadeFactory.getRemoteInstance().queryVariate(helper.getBgSchemeId(), varNumSet, false);
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
            ArrayList<BgDimensionMember> memberList = new ArrayList<BgDimensionMember>();
            for (BgDimensionMember member : memberSet) {
                member.setSrcNumber((String)helper.getSrcNumberMap().get(member.getType()));
                memberList.add(member);
            }
            Collections.sort(memberList);
            MbgViewListResultData result = new MbgViewListResultData();
            result.setMembers(memberList);
            result.setMemberType(BgMemberSelectTypeEnum.Variate);
            return result;
        }
        return null;
    }

    public static MbgViewListResultData parseAllFXMultiMember(BgSchemeDimensionHelper hepler, String formulaName, String formula) {
        Map memberMap = new HashMap();
        Map srcMap = hepler.getDimensionBySrcNumber();
        HashMap dimMap = new HashMap();
        ArrayList<BgDimensionMember> memberList = new ArrayList<BgDimensionMember>();
        MbgViewListResultData result = new MbgViewListResultData();
        String member = null;
        String srcNum = null;
        String[] members = null;
        if (formula.indexOf("@") != -1) {
            String[] functions = formula.split(" ,");
            BgDimensionMember dimMember = null;
            for (int i = 0; i < functions.length; ++i) {
                member = functions[i];
                srcNum = BizCalcClientHelper.getRefNumByFunction(member);
                dimMember = new BgDimensionMember(null, hepler.getRefFieldBySrcNumber(srcNum), member, member);
                memberList.add(dimMember);
            }
            result.setMembers(memberList);
            result.setMemberType(BgMemberSelectTypeEnum.Function);
        } else {
            srcNum = formula.substring(0, formula.indexOf(":"));
            members = formula.substring(formula.indexOf(":") + 1, formula.length()).split(",");
            int fillType = 0;
            for (int j = 0; j < members.length; ++j) {
                member = members[j];
                if (srcMap.get(srcNum) == null) continue;
                HashSet<String> numberSet = (HashSet<String>)dimMap.get(((BgDimensionInfo)hepler.getDimensionBySrcNumber().get(srcNum)).getNumber());
                if (numberSet == null) {
                    numberSet = new HashSet<String>();
                    dimMap.put(((BgDimensionInfo)hepler.getDimensionBySrcNumber().get(srcNum)).getNumber(), numberSet);
                }
                member = MbgFunctionHelper.getMemberNumber((String)member);
                numberSet.add(member);
            }
            try {
                memberMap = BizFacadeFactory.getRemoteInstance().queryDimMember(dimMap, hepler.getBgSchemeId(), false, null);
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
            for (int j = 0; j < members.length; ++j) {
                member = members[j];
                fillType = MbgFunctionHelper.getFillType((String)member);
                member = MbgFunctionHelper.getMemberNumber((String)member);
                Set memberSet = (Set)memberMap.get(((BgDimensionInfo)hepler.getDimensionBySrcNumber().get(srcNum)).getNumber());
                if (memberSet == null) continue;
                for (BgDimensionMember m : memberSet) {
                    if (!m.getNumber().equals(member)) continue;
                    try {
                        m = m.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                    m.setSrcNumber(srcNum);
                    if (0 != fillType) {
                        m.setFillType(fillType);
                    }
                    memberList.add(m);
                }
            }
            result.setMembers(memberList);
            result.setMemberType(BgMemberSelectTypeEnum.Member);
        }
        return result;
    }

    public static MbgViewListResultData parseMemFXInMathFX(BgSchemeDimensionHelper hepler, String formulaName, String formula) {
        MbgViewListResultData result = new MbgViewListResultData();
        Map srcMap = hepler.getDimensionBySrcNumber();
        HashMap<String, Object> dimMap = new HashMap<String, Object>();
        ArrayList<String> fxStrs = new ArrayList<String>();
        String allFxStr = formula.substring(formula.indexOf("(") + 1, formula.lastIndexOf(")"));
        StringBuffer tmpFxStr = new StringBuffer();
        for (int i = 0; i < allFxStr.length(); ++i) {
            if (allFxStr.charAt(i) == ',' && allFxStr.charAt(i + 1) == '@') {
                fxStrs.add(tmpFxStr.toString());
                tmpFxStr.delete(0, tmpFxStr.length());
                continue;
            }
            tmpFxStr.append(allFxStr.charAt(i));
        }
        fxStrs.add(tmpFxStr.toString());
        if (fxStrs.size() > 0) {
            int i;
            ArrayList<String> memberStrs = new ArrayList<String>();
            LinkedHashMap existMap = new LinkedHashMap();
            for (i = 0; i < fxStrs.size(); ++i) {
                String fxStr = (String)fxStrs.get(i);
                String member = org.apache.commons.lang.StringUtils.strip((String)fxStr.substring(fxStr.indexOf("(") + 1, fxStr.lastIndexOf(")")).split(",")[0], (String)"\"");
                memberStrs.add(member);
                existMap.put(memberStrs.get(i), fxStr);
            }
            for (i = 0; i < memberStrs.size(); ++i) {
                String memberStr = (String)memberStrs.get(i);
                String[] memNum = memberStr.split(":");
                String srcNum = memNum[0];
                String number = memNum[1];
                if (srcMap.get(srcNum) == null) continue;
                HashSet<String> memSet = (HashSet<String>)dimMap.get(srcNum);
                if (memSet == null) {
                    memSet = new HashSet<String>();
                    dimMap.put(srcNum, memSet);
                }
                memSet.add(number);
            }
            Map memberMap = new HashMap();
            try {
                memberMap = BizFacadeFactory.getRemoteInstance().queryDimMember(hepler.getBgSchemeId(), dimMap, srcMap, false, true, BizCalcClientHelper.getOrgTreeIdBySchemeHelper(hepler));
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
            HashSet<String> existMemberSet = new HashSet<String>();
            for (Object dinNum : memberMap.keySet()) {
                Set memberSet = (Set)memberMap.get(dinNum);
                for (BgDimensionMember member : memberSet) {
                    String number = member.getSrcNumber() + ":" + member.getNumber();
                    existMemberSet.add(number);
                }
            }
            StringBuffer innerFXStr = new StringBuffer();
            for (String member : existMap.keySet()) {
                if (!existMemberSet.contains(member)) continue;
                innerFXStr.append((String)existMap.get(member)).append(",");
            }
            if (innerFXStr.length() > 0) {
                innerFXStr.delete(innerFXStr.length() - 1, innerFXStr.length());
            }
            if (innerFXStr.length() > 0) {
                String[] functionMembers = innerFXStr.toString().split(",@");
                BgDimensionMember fxMem = null;
                ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
                int len = functionMembers.length;
                for (int i2 = 0; i2 < len; ++i2) {
                    String member = org.apache.commons.lang.StringUtils.strip((String)functionMembers[i2].substring(functionMembers[i2].indexOf("(") + 1, functionMembers[i2].lastIndexOf(")")).split(",")[0], (String)"\"");
                    String srcNumber = member.split(":")[0];
                    if (functionMembers[i2].indexOf("@") == -1) {
                        functionMembers[i2] = "@" + functionMembers[i2];
                    }
                    fxMem = new BgDimensionMember(null, null, functionMembers[i2], functionMembers[i2]);
                    fxMem.setSrcNumber(srcNumber);
                    members.add(fxMem);
                    result.setMembers(members);
                    result.setMemberType(BgMemberSelectTypeEnum.Function);
                }
                return result;
            }
        }
        return null;
    }

    private static String getRefNumByFunction(String functionStr) {
        String refNum = null;
        if (StringUtils.isEmpty((String)functionStr)) {
            return refNum;
        }
        String param = functionStr.substring(functionStr.indexOf("(") + 1, functionStr.indexOf(")"));
        String srcNum = param.split(":")[0].replace("\"", "");
        return srcNum;
    }

    public static BgDimensionMember parseVARMember(BgSchemeDimensionHelper hepler, String formulaName, String formula) {
        Set memberSet = new HashSet();
        String member = formula.substring(formula.indexOf("[") + 1, formula.indexOf("]")).split(",")[0];
        if (member != null) {
            Iterator iterator;
            String varNum = member.substring(1, member.length() - 1);
            HashSet<String> varNumSet = new HashSet<String>();
            varNumSet.add(varNum);
            try {
                memberSet = BizFacadeFactory.getRemoteInstance().queryVariate(hepler.getBgSchemeId(), varNumSet, false);
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
            if (memberSet != null && memberSet.size() > 0 && (iterator = memberSet.iterator()).hasNext()) {
                Object obj = iterator.next();
                return (BgDimensionMember)obj;
            }
        }
        return null;
    }

    public static void dealWithErrorMsg(Component comp, Map result, boolean isCancel, boolean isMainUI) {
        if (result == null || result.isEmpty()) {
            return;
        }
        Set inCorrectStateSet = (Set)result.get("incorrectNumSet");
        Object verifyErrorMsg = result.get("verifyErrorMsg");
        int totalSize = Integer.parseInt(result.get("totalSize").toString());
        int failSet = Integer.parseInt(result.get("cancelFailCount").toString());
        String verifyErrMsg = isCancel || verifyErrorMsg == null ? "" : verifyErrorMsg.toString();
        StringBuffer numberStr = new StringBuffer();
        if (inCorrectStateSet != null && !inCorrectStateSet.isEmpty() && result != null && result.size() > 0) {
            for (String incorrectNum : inCorrectStateSet) {
                numberStr.append(incorrectNum).append(",");
            }
            numberStr.delete(numberStr.length() - 1, numberStr.length());
        }
        if (isCancel) {
            if (isMainUI) {
                if (!StringUtils.isEmpty((String)numberStr.toString())) {
                    MsgBox.showDetailAndOK((Component)comp, (String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelFailDetail"), (String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelFail", (Object[])new Object[]{numberStr}), (int)2);
                    SysUtil.abort();
                } else if (comp instanceof BizCalcMainUI) {
                    ((BizCalcMainUI)((Object)comp)).getMainStatusBar().setMessage(EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelSuccess"));
                } else if (comp instanceof BgExamineMainUI) {
                    ((BgExamineMainUI)comp).getMainStatusBar().setMessage(EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelSuccess"));
                }
            } else if (StringUtils.isEmpty((String)numberStr.toString()) && StringUtils.isEmpty((String)verifyErrMsg.toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelSuccess"));
            } else {
                MsgBox.showDetailAndOK((Component)comp, (String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelResMsg", (Object[])new Object[]{totalSize, totalSize - failSet, failSet}), (String)(StringUtils.isEmpty((String)numberStr.toString()) ? "" + verifyErrMsg : EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelFail", (Object[])new Object[]{numberStr}) + "\n" + verifyErrMsg), (int)2);
                SysUtil.abort();
            }
        } else if (isMainUI) {
            if (!StringUtils.isEmpty((String)numberStr.toString()) || !StringUtils.isEmpty((String)verifyErrMsg)) {
                MsgBox.showDetailAndOK((Component)comp, (String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelCancelFailDetail"), (String)(StringUtils.isEmpty((String)numberStr.toString()) ? "" + verifyErrMsg : EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"incorrectState", (Object[])new Object[]{numberStr}) + "\n" + verifyErrMsg), (int)2);
                SysUtil.abort();
            } else if (comp instanceof BizCalcMainUI) {
                ((BizCalcMainUI)((Object)comp)).getMainStatusBar().setMessage(EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelCancelSuccess"));
            } else if (comp instanceof BgExamineMainUI) {
                ((BgExamineMainUI)comp).getMainStatusBar().setMessage(EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelCancelSuccess"));
            }
        } else if (StringUtils.isEmpty((String)numberStr.toString()) && StringUtils.isEmpty((String)verifyErrMsg.toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelCancelSuccess"));
        } else {
            MsgBox.showDetailAndOK((Component)comp, (String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"cancelCancelResMsg", (Object[])new Object[]{totalSize, totalSize - failSet, failSet}), (String)(StringUtils.isEmpty((String)numberStr.toString()) ? "" + verifyErrMsg : EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"incorrectState", (Object[])new Object[]{numberStr}) + "\n" + verifyErrMsg), (int)2);
            SysUtil.abort();
        }
    }

    private static String getOrgTreeIdBySchemeHelper(BgSchemeDimensionHelper hepler) {
        String orgTreeId = null;
        if (DimensionConstants.CSLSCHEME_HELPER.equals(hepler.getClass().getName()) && hepler.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId() != null && BOSUuid.getBOSObjectType((String)hepler.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId(), (boolean)true).equals((Object)new OrgTreeInfo().getBOSType())) {
            orgTreeId = hepler.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
        }
        return orgTreeId;
    }

    public static void checkScope(KDTable scopeTable) {
        if (scopeTable == null) {
            return;
        }
        BgDimensionMember member = null;
        List members = null;
        Object objs = null;
        String dimName = null;
        int in = scopeTable.getRowCount();
        for (int i = 0; i < in; ++i) {
            objs = scopeTable.getCell(i, "dimValue").getValue();
            dimName = (String)scopeTable.getCell(i, "dimType").getValue();
            if (!(objs instanceof MbgViewListResultData) || ((MbgViewListResultData)objs).getMembers() == null) continue;
            members = ((MbgViewListResultData)objs).getMembers();
            int jn = members.size();
            for (int j = 0; j < jn; ++j) {
                member = (BgDimensionMember)members.get(j);
                if (member == null || member.getNumber().length() < 4000) continue;
                MsgBox.showWarning((String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"scropeOverLength", (Object[])new String[]{dimName}));
                SysUtil.abort();
            }
        }
    }
}

