/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client.utils;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizExecuteReportFactory;
import com.kingdee.eas.ma.biz.BizExecuteResultEnum;
import com.kingdee.eas.ma.biz.BizFacadeFactory;
import com.kingdee.eas.ma.biz.client.BizExecuteProgressDialogUI;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.ProgressDialogUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BizCalcExecuteHelper {
    public static final String BIZCALC_ID = "BizCalcInfo";
    protected Object owner = null;
    protected BizCalcInfo bizCalcInfo = null;
    protected BgSchemeInfo bgSchemeInfo = null;
    private BOSUuid unionId = null;

    protected BgSchemeInfo getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public BizCalcExecuteHelper() {
    }

    public BizCalcExecuteHelper(Object owner, BizCalcInfo bizCalcInfo, BgSchemeInfo bgSchemeInfo, BOSUuid unionId) {
        this.bizCalcInfo = bizCalcInfo;
        this.bgSchemeInfo = bgSchemeInfo;
        this.unionId = unionId;
        this.owner = owner;
    }

    public void calcExecute() throws Exception {
        Map costCenterMap = BizFacadeFactory.getRemoteInstance().getCostCenterIDByCalcID(Arrays.asList(this.bizCalcInfo.getId().toString()), this.bgSchemeInfo.getId(), this.unionId);
        Set costCenterSet = (Set)costCenterMap.get(this.bizCalcInfo.getId().toString());
        Map<String, String> costCenters = this.getCostCenterName(costCenterSet);
        UIContext map = new UIContext(this.owner);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BizExecuteProgressDialogUI.class.getName(), (Map)map);
        if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
            ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
            this.initParameterValue(ui, costCenters, this.bizCalcInfo.getId().toString());
            this.writeReport(this.bizCalcInfo.getId().toString());
            ui.init();
            window.show();
        }
        this.updateReport(this.bizCalcInfo.getId().toString(), ((BizExecuteProgressDialogUI)window.getUIObject()).isCancel());
        this.showExecuteReport();
    }

    protected void initParameterValue(ProgressDialogUI ui, Map<String, String> costCenters, String bizCalcID) throws Exception {
        ui.setUITitle(EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"bizCalcExecuteTitle"));
        ui.setInvokeClass(BizCalcExecuteHelper.class.getName());
        ui.setShowTableMessage(true);
        ui.setCountSum(costCenters.size() - 1);
        ui.setInvokeMethod("doExecute");
        Class[] paramCla = new Class[]{BOSUuid.class, String.class, String.class, String.class, String.class};
        ui.setInvokeMethodParmeterType(paramCla);
        Object[][] paramValue = new Object[costCenters.size()][4];
        int i = 0;
        for (String costCenterID : costCenters.keySet()) {
            Object[] param = new Object[]{this.getBgSchemeInfo().getId(), bizCalcID, costCenterID, costCenters.get(costCenterID), null};
            paramValue[i] = param;
            ++i;
        }
        ui.setInvokeMethodParmeterValue(paramValue);
    }

    public Object[] doExecute(BOSUuid bgSchemeID, String calcId, String costCenterID, String costCenterName, String bgPeriodNum) {
        try {
            BizCalcFactory.getRemoteInstance().execute(bgSchemeID, BOSUuid.read((String)costCenterID), Arrays.asList(BOSUuid.read((String)calcId)), 1, bgPeriodNum);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return new Object[]{costCenterName};
    }

    protected Map<String, String> getCostCenterName(Set<String> costCenterSet) throws Exception {
        HashMap<String, String> costCenterMap = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", costCenterSet, CompareType.INCLUDE));
        FullOrgUnitCollection coll = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            costCenterMap.put(coll.get(i).getId().toString(), coll.get(i).getName());
        }
        return costCenterMap;
    }

    protected void writeReport(String bizCalcID) throws Exception {
        BizExecuteReportFactory.getRemoteInstance().writeReport(Arrays.asList(bizCalcID), this.getBgSchemeInfo().getId().toString());
    }

    protected void updateReport(String bizCalcID, boolean isCancel) throws Exception {
        BizExecuteResultEnum result = isCancel ? BizExecuteResultEnum.CANCEL : BizExecuteResultEnum.SECCESS;
        BizExecuteReportFactory.getRemoteInstance().updateReport(Arrays.asList(bizCalcID), result);
    }

    public void checkBizStatus(String bizCalcId) throws Exception {
        Map result = BizCalcFactory.getRemoteInstance().checkBizExecuteStatus(Arrays.asList(bizCalcId));
        StringBuffer executErrorMsg = new StringBuffer();
        if (((List)result.get("bizTempsaveStr")).size() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"tempSaveAndExecute"));
            SysUtil.abort();
        }
        if (((List)result.get("bizExecutingStr")).size() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"executing"));
            SysUtil.abort();
        }
    }

    public void showExecuteReport() throws Exception {
        UIContext context = new UIContext(this.owner);
        context.put((Object)"BGSCHEME_INFO", (Object)this.getBgSchemeInfo());
        context.put((Object)BIZCALC_ID, (Object)this.bizCalcInfo.getId().toString());
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.biz.client.BizExecuteReportListUI", (Map)context, null, OprtState.VIEW);
        win.show();
    }
}

