/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl.expr;

import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.BizExprConstants;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParse;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MemberProxy;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.CalcExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.OperandExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse.Parse2RPN;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;

public class FunctionProxy {
    public static FunctionExpr parse(String functionStr) throws ParseException {
        if (StringUtils.isEmpty((String)functionStr)) {
            return null;
        }
        FunctionExpr functionExpr = FunctionProxy.getFunction(functionStr);
        if (FunctionProxy.checkFunction(functionExpr)) {
            return functionExpr;
        }
        return null;
    }

    public static boolean isFunction(String functionStr) {
        return FunctionProxy.verify(functionStr);
    }

    public static boolean verify(String functionStr) {
        if (StringUtils.isEmpty((String)functionStr)) {
            return false;
        }
        return MbgFunctionHelper.verifyFormula((String)"FX", (String)functionStr);
    }

    protected static FunctionExpr getFunction(String functionStr) throws ParseException {
        String _functionStr = functionStr.trim();
        FunctionProxy.checkFunctionFormat(_functionStr);
        FunctionExpr functionExpr = FunctionProxy.getFunctionExpr(_functionStr);
        return functionExpr;
    }

    private static FunctionExpr getFunctionExpr(String _functionStr) throws ParseException {
        FunctionExpr result = (FunctionExpr)FunctionProxy.getFunctionExpress(_functionStr, null);
        return result;
    }

    private static Object getFunctionExpress(String _functionStr, String functionname) throws ParseException {
        if (_functionStr.indexOf("@") != -1 && !"ABS".equals(functionname)) {
            int startIndex = _functionStr.indexOf("@");
            int endIndex = _functionStr.indexOf("(");
            int lastIndex = _functionStr.lastIndexOf(")");
            String functionName = _functionStr.substring(startIndex + 1, endIndex);
            String functionParamStr = _functionStr.substring(endIndex + 1, lastIndex);
            FunctionExpr funcExpr = new FunctionExpr();
            funcExpr.functionName = functionName;
            funcExpr.params = new ArrayList<Object>();
            String[] params = FunctionProxy.split(functionParamStr, BizExprConstants.SEP_COMMA);
            String[] tmpStrsOne = null;
            CalcExpr param = null;
            if (params != null) {
                int in = params.length;
                for (int i = 0; i < in; ++i) {
                    if (params[i].charAt(0) == '\"' && params[i].charAt(params[i].length() - 1) == '\"' && !"Lead".equals(functionName)) {
                        funcExpr.params.add(params[i].substring(1, params[i].length() - 1));
                        continue;
                    }
                    if ("Lead".equals(functionName)) {
                        params[i] = params[i].replaceAll("\"", "");
                        if (i == 0) {
                            param = new OperandExpr(params[i]);
                            funcExpr.params.add(param);
                            continue;
                        }
                        if (i != 1 || StringUtils.isEmpty((String)params[i])) continue;
                        tmpStrsOne = params[i].split(":");
                        if (tmpStrsOne.length == 2) {
                            param = new MemberExpr();
                            ((MemberExpr)param).srcNumber = tmpStrsOne[0];
                            ((MemberExpr)param).number = tmpStrsOne[1];
                        }
                        funcExpr.params.add(param);
                        continue;
                    }
                    if ("AVG".equals(functionName)) {
                        if (params[i] == null || !params[i].startsWith("MBR")) continue;
                        String memberStr = params[i].split("\"")[1].split("\"")[0];
                        String srcNum = memberStr.split(":")[0];
                        String[] allMember = memberStr.split(":")[1].split(",");
                        for (int m = 0; m < allMember.length; ++m) {
                            funcExpr.params.add(MemberProxy.parseDimNum(DimensionFormulaHelper.getCombination((String)srcNum, (String)allMember[m])));
                        }
                        continue;
                    }
                    funcExpr.params.add(MbgExprParseHelper.parse(params[i]));
                }
            }
            return funcExpr;
        }
        if ("ABS".equals(functionname)) {
            Parse2RPN parse = null;
            IExpress expr = null;
            try {
                parse = new Parse2RPN(_functionStr);
                parse.parse();
                MbgExprParse p2 = new MbgExprParse(parse.getTokens());
                expr = p2.parse();
            }
            catch (Exception p2) {
                // empty catch block
            }
            return expr;
        }
        if (MbgFunctionHelper.IsNativeFunction((String)functionname)) {
            ArrayList<Object> paramCols = new ArrayList<Object>();
            String[] srcNum = _functionStr.split(",");
            MemberExpr memExpr = new MemberExpr();
            memExpr.srcNumber = srcNum[0].split(":")[0].replace("\"", "");
            memExpr.number = srcNum[0].split(":")[1].replace("\"", "");
            paramCols.add(memExpr);
            if (srcNum.length > 1) {
                paramCols.add(srcNum[1].replace("\"", ""));
            }
            return paramCols;
        }
        ArrayList<String> paramCols = new ArrayList<String>();
        if (_functionStr.indexOf("VAR") == -1) {
            String[] params = _functionStr.split(",");
            String curParam = null;
            for (int i = 0; i < params.length; ++i) {
                curParam = params[i].replace("\"", "");
                paramCols.add(curParam);
            }
        } else {
            String curParam = _functionStr.substring(_functionStr.indexOf("[") + 1, _functionStr.indexOf("]")).replace("\"", "");
            String[] curParams = curParam.split(",");
            for (int i = 0; i < curParams.length; ++i) {
                curParam = "VAR:" + curParams[i];
                paramCols.add(curParam);
            }
        }
        return paramCols;
    }

    private static void checkFunctionFormat(String functionStr) throws ParseException {
    }

    private static void Expected(String c) throws ParseException {
        throw new ParseException(" cannot Parse, as special number : " + c);
    }

    protected static boolean checkFunction(FunctionExpr functionExpr) {
        boolean check;
        block5: {
            if (functionExpr == null) {
                return false;
            }
            check = false;
            Class<?> _class = null;
            Object _method = null;
            Method[] _methods = null;
            Class[] _param = null;
            try {
                int i;
                _class = Class.forName("com.kingdee.eas.ma.biz.execute.calc.impl.expr.FunctionProxy");
                if (_class == null) break block5;
                _param = new Class[functionExpr.params.size()];
                int in = functionExpr.params.size();
                for (i = 0; i < in; ++i) {
                    _param[i] = functionExpr.params.get(i).getClass();
                }
                _methods = _class.getDeclaredMethods();
                for (i = 0; i < _methods.length; ++i) {
                    if (!functionExpr.functionName.toLowerCase(Locale.ENGLISH).equals(_methods[i].getName().toLowerCase(Locale.ENGLISH))) continue;
                    check = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return check;
    }

    public static String[] split(String functionParamsStr, char sep) {
        int i;
        if (StringUtils.isEmpty((String)functionParamsStr)) {
            return null;
        }
        int count = 0;
        String tmpStr = "";
        String[] tmpStrs = null;
        ArrayList<String> params = new ArrayList<String>();
        int in = functionParamsStr.length();
        for (i = 0; i < in; ++i) {
            char _char = functionParamsStr.charAt(i);
            if (_char == BizExprConstants.LEFT_BRACE || _char == BizExprConstants.LEFT_BRACKET || _char == BizExprConstants.LEFT_PARENTHESIS) {
                ++count;
            }
            if (_char == BizExprConstants.RIGHT_BRACE || _char == BizExprConstants.RIGHT_BRACKET || _char == BizExprConstants.RIGHT_PARENTHESIS) {
                --count;
            }
            if (count == 0 && _char == sep) {
                params.add(tmpStr);
                tmpStr = "";
                continue;
            }
            tmpStr = tmpStr + _char;
        }
        if (!StringUtils.isEmpty((String)tmpStr)) {
            params.add(tmpStr);
        }
        tmpStrs = new String[params.size()];
        in = params.size();
        for (i = 0; i < in; ++i) {
            tmpStrs[i] = (String)params.get(i);
            if (tmpStrs[i].startsWith("L1:")) {
                tmpStrs[i] = tmpStrs[i].substring(3);
                tmpStrs[i] = FunctionProxy.formatRemoveFunMemStr(tmpStrs[i]);
            }
            if (!tmpStrs[i].startsWith("L2:")) continue;
            tmpStrs[i] = tmpStrs[i].substring(3);
            tmpStrs[i] = FunctionProxy.formatRemoveFunMemStr(tmpStrs[i]);
        }
        return tmpStrs;
    }

    private static String formatRemoveFunMemStr(String memParamStr) {
        StringBuffer memBuffer = new StringBuffer();
        if (StringUtils.isEmpty((String)memParamStr)) {
            return memBuffer.toString();
        }
        String memPrefix = memParamStr.substring(0, memParamStr.indexOf("[") + 1);
        String memStr = memParamStr.substring(memParamStr.indexOf("[") + 1, memParamStr.indexOf("]"));
        if (memStr.startsWith("@")) {
            return memParamStr;
        }
        String[] paramArray = null;
        String[] memberArray = null;
        String memNumsStr = null;
        String srcNumber = null;
        paramArray = memStr.split(":");
        srcNumber = paramArray[0];
        memNumsStr = paramArray[1];
        memBuffer.append(memPrefix);
        if (!StringUtils.isEmpty((String)memNumsStr)) {
            memberArray = memNumsStr.split(",");
            for (int i = 0; i < memberArray.length; ++i) {
                memBuffer.append("\"").append(srcNumber).append(":").append(memberArray[i]).append("\"").append(",");
            }
            memBuffer.delete(memBuffer.length() - 1, memBuffer.length());
        }
        memBuffer.append("]");
        return memBuffer.toString();
    }

    private void ancestors(String member) {
    }

    private void children(String member, boolean isDetail) {
    }

    private void descendants(String member, boolean isDetail) {
    }

    private void siblings(String member, boolean isDetail) {
    }

    private void iAllancestors(String member, boolean isDetail) {
    }

    private void iAncestors(String member, boolean isDetail) {
    }

    private void iChildrens(String member, boolean isDetail) {
    }

    private void iSiblings(String member, boolean isDetail) {
    }

    private void iDescendants(String member, boolean isDetail) {
    }

    private void attribute(String member, boolean isDetail) {
    }

    private void remove(String member, boolean isDetail) {
    }

    private void isAncest(String member) {
    }

    private void isChild(String member) {
    }

    private void isDescendants(String member) {
    }

    private void isParent(String member) {
    }

    private void isSibling(String member) {
    }

    private void isIAncest(String member) {
    }

    private void isIChild(String member) {
    }

    private void isIDesc(String member) {
    }

    private void isIParent(String member) {
    }

    private void isMember(String member) {
    }

    private void isISibling(String member) {
    }

    private void avg() {
    }

    private void max() {
    }

    private void min() {
    }

    private void abs() {
    }

    private void pow() {
    }
}

