/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl.expr;

import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParse;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgScriptParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.ScriptFormater;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.face.IExprCheck;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse.IParseExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse.Parse2Cond;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse.Parse2RPN;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.util.StringUtils;
import java.util.List;

public class MbgExprParseHelper {
    private static String CONDITION_BEGIN_TAG = "IF";
    private static String CONDITION_ELSE_TAG = "ELSE";

    public static IExpress parse(String line) throws ParseException {
        return MbgExprParseHelper.parse(line, null, true);
    }

    public static IExpress parse(String line, IExprCheck exprCheck) throws ParseException {
        return MbgExprParseHelper.parse(line, exprCheck, true);
    }

    public static IExpress parse(String line, IExprCheck exprCheck, boolean isCheckNameExpr) throws ParseException {
        IParseExpr parse = null;
        IExpress expr = null;
        if (exprCheck != null) {
            exprCheck.check(line);
        }
        if (MbgExprParseHelper.isCondition(line, exprCheck)) {
            parse = new Parse2Cond(line);
            parse.parse();
            expr = parse.getExpr();
            expr.setOriginalExpr(line);
        } else {
            parse = new Parse2RPN(line);
            ((Parse2RPN)parse).isCheckNameExpr = isCheckNameExpr;
            parse.parse();
            MbgExprParse p2 = new MbgExprParse(parse.getTokens());
            expr = p2.parse();
            expr.setOriginalExpr(line);
        }
        if (exprCheck != null) {
            exprCheck.check(expr);
        }
        return expr;
    }

    public static boolean isCondition(String formulaStr, IExprCheck exprCheck) throws ParseException {
        if (StringUtils.isEmpty((String)formulaStr)) {
            return false;
        }
        boolean result = false;
        String _formulaStr = formulaStr.trim();
        if (_formulaStr.startsWith(CONDITION_BEGIN_TAG)) {
            int countCond = 0;
            int countResult = 0;
            int begin = -1;
            int end = -1;
            int exprs = 0;
            boolean condition = false;
            String _tmpStr = null;
            IExpress expr = null;
            int in = _formulaStr.length();
            for (int index = 0; index < in; ++index) {
                char c = _formulaStr.charAt(index);
                if (!condition && countResult == 0) {
                    if (c == '[') {
                        if (countCond == 0) {
                            begin = index;
                        }
                        ++countCond;
                    } else if (c == ']' && --countCond == 0) {
                        end = index;
                    }
                    if (begin == -1 || end == -1) continue;
                    _tmpStr = _formulaStr.substring(begin + 1, end).trim();
                    expr = MbgExprParseHelper.parse(_tmpStr, exprCheck, true);
                    if (expr != null) {
                        condition = true;
                        begin = -1;
                        end = -1;
                        countCond = 0;
                        continue;
                    }
                    throw new ParseException(" cannot Parse, sorry : " + _tmpStr);
                }
                if (c == '{') {
                    if (countResult == 0) {
                        begin = index;
                    }
                    ++countResult;
                } else if (c == '}' && --countResult == 0) {
                    end = index;
                }
                if (begin == -1 || end == -1) continue;
                _tmpStr = _formulaStr.substring(begin + 1, end).trim();
                List<String> scripts = MbgScriptParseHelper.parse(_tmpStr, new ScriptFormater());
                if (scripts != null && !scripts.isEmpty()) {
                    ++exprs;
                    String script = null;
                    int jn = scripts.size();
                    for (int j = 0; j < jn; ++j) {
                        script = scripts.get(j);
                        expr = MbgExprParseHelper.parse(script, exprCheck, true);
                        if (expr == null) {
                            throw new ParseException(" cannot Parse, sorry : " + script);
                        }
                        begin = -1;
                        end = -1;
                        countResult = 0;
                    }
                    continue;
                }
                throw new ParseException(" cannot Parse, sorry : " + _formulaStr);
            }
            if (condition && exprs >= 1) {
                result = true;
            }
            if (exprs >= 2 && _formulaStr.indexOf(CONDITION_ELSE_TAG) < 0) {
                throw new ParseException(" cannot Parse, sorry : " + _formulaStr);
            }
        }
        return result;
    }
}

