/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr;

import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.CalcExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizPtoUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MdxMemberExpr
extends CalcExpr {
    public List<IExpress> params = new ArrayList<IExpress>();
    public int leafFeature = 0;
    public BizCalcMember calcMember = null;
    private boolean isLeft = false;
    private boolean isMaxMin = false;

    @Override
    public void setRemoveProcessType(boolean isRemove) {
        MdxMemberExpr.setRemoveProcessType(this.params, isRemove);
    }

    @Override
    public void setLeft() {
        this.isLeft = true;
        if (this.params != null) {
            for (IExpress e : this.params) {
                e.setLeft();
            }
        }
    }

    public void setMaxMin(boolean isMaxMin) {
        this.isMaxMin = isMaxMin;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.leafFeature == 1) {
            str.append("LEAF_MBR").append(":[");
        } else if (this.leafFeature == 2) {
            str.append("NLEAF_MBR").append(":[");
        } else if (this.leafFeature == 3) {
            str.append("PTO").append(":[");
        } else {
            str.append("MBR").append(":[");
        }
        if (this.params != null) {
            IExpress param = null;
            int in = this.params.size();
            for (int i = 0; i < in; ++i) {
                param = this.params.get(i);
                if (param instanceof FunctionExpr) {
                    str.append("\"FX:[" + param.toString() + "]\",");
                    continue;
                }
                if (param == null) continue;
                str.append(param.toString());
                str.append(",");
            }
            if (str.length() > 1) {
                str.delete(str.length() - 1, str.length());
            }
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public String toMdx() {
        IExpress param = null;
        StringBuffer mdx = new StringBuffer();
        String subMdx = null;
        HashSet<String> hasRefField = new HashSet<String>();
        int in = this.params.size();
        for (int i = 0; i < in; ++i) {
            param = this.params.get(i);
            if (param == null) continue;
            if (param instanceof MemberExpr) {
                ((MemberExpr)param).calcMember = this.calcMember;
                hasRefField.add(((MemberExpr)param).field);
            } else if (param instanceof FunctionExpr) {
                ((FunctionExpr)param).calcMember = this.calcMember;
            }
            subMdx = param.toMdx();
            if (StringUtils.isEmpty((String)subMdx)) continue;
            mdx.append(subMdx + ",");
        }
        boolean hasMemberMap = false;
        if (!this.isLeft && this.calcMember.getMemberMap() != null && !this.calcMember.getMemberMap().isEmpty()) {
            for (String right : this.calcMember.getMemberMap().keySet()) {
                if (hasRefField.contains(right)) continue;
                hasMemberMap = true;
                mdx.append(DimUtils.getDimensionNumber((String)right)).append(".MemberMap(").append(DimUtils.getDimensionNumber((String)this.calcMember.getMemberMap().get(right))).append("),");
            }
        }
        if (mdx.length() > 1) {
            mdx.delete(mdx.length() - 1, mdx.length());
        }
        if (!this.isMaxMin && this.params.size() > 1 || hasMemberMap && this.params.size() == 1) {
            mdx.insert(0, "(");
            mdx.append(")");
        }
        return mdx.toString();
    }

    @Override
    public String toPlanString() {
        StringBuffer str = new StringBuffer();
        if (this.params != null) {
            IExpress param = null;
            int in = this.params.size();
            for (int i = 0; i < in; ++i) {
                param = this.params.get(i);
                if (param == null) continue;
                str.append(param.toPlanString());
                str.append(",");
            }
            if (str.length() > 1) {
                str.delete(str.length() - 1, str.length());
            }
        }
        return str.toString();
    }

    @Override
    public IExpress clone() throws CloneNotSupportedException {
        MdxMemberExpr clone = (MdxMemberExpr)super.clone();
        if (this.params != null) {
            clone.params = new ArrayList<IExpress>(this.params.size());
            for (IExpress expr : this.params) {
                clone.params.add(expr.clone());
            }
        }
        return clone;
    }

    @Override
    public String build() {
        IExpress param = null;
        StringBuffer mdx = new StringBuffer();
        String subMdx = null;
        if (this.params.size() > 1) {
            mdx.append("(");
        }
        int in = this.params.size();
        for (int i = 0; i < in; ++i) {
            param = this.params.get(i);
            if (param == null) continue;
            if (param instanceof MemberExpr) {
                ((MemberExpr)param).calcMember = this.calcMember;
            } else if (param instanceof FunctionExpr) {
                ((FunctionExpr)param).calcMember = this.calcMember;
            }
            subMdx = param.build();
            if (StringUtils.isEmpty((String)subMdx)) continue;
            mdx.append(subMdx + ",");
        }
        if (mdx.length() > 1) {
            mdx.delete(mdx.length() - 1, mdx.length());
        }
        if (this.params.size() > 1) {
            mdx.append(")");
        }
        return mdx.toString();
    }

    @Override
    public String toPTOString(Map<String, List<String>> allPeriodMap, String bgPeriodNumber) {
        if (this.leafFeature != 3) {
            boolean hasPeriod = false;
            StringBuffer str1 = new StringBuffer();
            str1.append("MBR").append(":[");
            if (this.params != null) {
                IExpress param = null;
                int in = this.params.size();
                for (int i = 0; i < in; ++i) {
                    param = this.params.get(i);
                    if (param instanceof FunctionExpr) {
                        str1.append("\"FX:[" + param.toString() + "]\",");
                        continue;
                    }
                    if (param == null) continue;
                    if (param instanceof MemberExpr) {
                        str1.append("\"").append(param.toPlanString()).append("\"");
                        str1.append(",");
                        if (!((MemberExpr)param).srcNumber.equals(DimensionConstants.DEF_PERIOD_SRCNUMBER)) continue;
                        hasPeriod = true;
                        continue;
                    }
                    str1.append(param.toString());
                    str1.append(",");
                }
                if (str1.length() > 1) {
                    str1.delete(str1.length() - 1, str1.length());
                }
            }
            if (!hasPeriod && !StringUtils.isEmpty((String)bgPeriodNumber)) {
                str1.append(",");
                str1.append("\"").append("BgP:").append(bgPeriodNumber).append("\"");
            }
            str1.append("]");
            return str1.toString();
        }
        StringBuffer str = new StringBuffer();
        String beginPeriod = "";
        String endPeriod = "";
        ArrayList<IExpress> otherParams = new ArrayList<IExpress>();
        if (this.params != null) {
            IExpress param = null;
            int in = this.params.size();
            for (int i = 0; i < in; ++i) {
                param = this.params.get(i);
                if (!(param instanceof MemberExpr) || StringUtils.isEmpty((String)((MemberExpr)param).srcNumber)) continue;
                if ("BgP1".equals(((MemberExpr)param).srcNumber)) {
                    beginPeriod = ((MemberExpr)param).number;
                    continue;
                }
                if ("BgP2".equals(((MemberExpr)param).srcNumber)) {
                    endPeriod = ((MemberExpr)param).number;
                    continue;
                }
                otherParams.add(param);
            }
        }
        if (StringUtils.isEmpty((String)beginPeriod) && !StringUtils.isEmpty((String)bgPeriodNumber)) {
            beginPeriod = bgPeriodNumber;
        }
        if (StringUtils.isEmpty((String)endPeriod) && !StringUtils.isEmpty((String)bgPeriodNumber)) {
            endPeriod = bgPeriodNumber;
        }
        List<String> tmpList = null;
        if (!StringUtils.isEmpty((String)beginPeriod) && !StringUtils.isEmpty((String)endPeriod)) {
            int endType;
            int beginType = BgNPeriodHelper.parserBgPeriodType((String)beginPeriod);
            if (beginType != (endType = BgNPeriodHelper.parserBgPeriodType((String)endPeriod))) {
                return str.toString();
            }
            tmpList = BizPtoUtils.getBegin2EndPeriod(beginPeriod, endPeriod, allPeriodMap);
        }
        if (tmpList != null && !tmpList.isEmpty()) {
            str.append(" (");
            for (int l = 0; l < tmpList.size(); ++l) {
                String number = tmpList.get(l);
                StringBuffer tmpStr = new StringBuffer();
                tmpStr.append("MBR").append(":[");
                boolean hasPeriod = false;
                if (this.params != null) {
                    IExpress param = null;
                    boolean isAppend = false;
                    int in = this.params.size();
                    for (int i = 0; i < in; ++i) {
                        param = this.params.get(i);
                        if (param instanceof MemberExpr && !StringUtils.isEmpty((String)((MemberExpr)param).srcNumber)) {
                            if ("BgP1".equals(((MemberExpr)param).srcNumber) || "BgP2".equals(((MemberExpr)param).srcNumber)) {
                                if (!isAppend) {
                                    tmpStr.append("\"").append("BgP:").append(number).append("\"");
                                    tmpStr.append(",");
                                    isAppend = true;
                                }
                            } else {
                                tmpStr.append("\"").append(param.toPlanString()).append("\"");
                                tmpStr.append(",");
                            }
                        }
                        if (!((MemberExpr)param).srcNumber.equals(DimensionConstants.DEF_PERIOD_SRCNUMBER) && !"BgP1".equals(((MemberExpr)param).srcNumber) && !"BgP2".equals(((MemberExpr)param).srcNumber)) continue;
                        hasPeriod = true;
                    }
                    if (!hasPeriod && !StringUtils.isEmpty((String)bgPeriodNumber)) {
                        tmpStr.append("\"").append("BgP:").append(bgPeriodNumber).append("\"");
                        tmpStr.append(",");
                    }
                }
                if (tmpStr.length() > 1) {
                    tmpStr.delete(tmpStr.length() - 1, tmpStr.length());
                }
                tmpStr.append("]");
                if (l < tmpList.size() - 1) {
                    tmpStr.append(" + ");
                }
                str.append(tmpStr);
            }
            str.append(" ) ");
        }
        return str.toString();
    }
}

