/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.expr.parse;

import com.kingdee.eas.ma.biz.expr.ParseException;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.expr.oper.AddOper;
import com.kingdee.eas.ma.biz.expr.oper.AssignmentOper;
import com.kingdee.eas.ma.biz.expr.oper.DivOper;
import com.kingdee.eas.ma.biz.expr.oper.EqualOper;
import com.kingdee.eas.ma.biz.expr.oper.GreaterEqualOper;
import com.kingdee.eas.ma.biz.expr.oper.GreaterThanOper;
import com.kingdee.eas.ma.biz.expr.oper.LeftParentheses;
import com.kingdee.eas.ma.biz.expr.oper.LessEqualOper;
import com.kingdee.eas.ma.biz.expr.oper.LessthanOper;
import com.kingdee.eas.ma.biz.expr.oper.ModOper;
import com.kingdee.eas.ma.biz.expr.oper.MultiplyOper;
import com.kingdee.eas.ma.biz.expr.oper.NotEqualOper;
import com.kingdee.eas.ma.biz.expr.oper.OperationType;
import com.kingdee.eas.ma.biz.expr.oper.SubOper;
import com.kingdee.eas.ma.biz.expr.parse.IParseExpr;
import java.util.List;
import java.util.Stack;

public class Prase2RPN
implements IParseExpr {
    private String formulaStr = null;
    private int length = 0;
    private int point = 0;
    private char look;
    private ParseUtils utils = new ParseUtils();
    private static final char STACK_OPERATOR = '\u0000';
    private static final char TAB = '\t';
    private static final char ENTER = '\r';
    private static final char LINE_FEED = '\n';
    private static final char WHITE = ' ';
    private static final char[] OPERATIONS = new char[]{'+', '-', '*', '/', '%', '=', '<', '>'};
    private Stack<Object> operand = new Stack();
    private Stack<AbstractOper> operator = new Stack();

    @Override
    public List getTokens() {
        return this.operand;
    }

    public Prase2RPN(String formulaStr) throws ParseException {
        if (formulaStr == null || formulaStr.trim().length() == 0) {
            this.Expected(" formulaStr is null!");
        } else {
            this.formulaStr = formulaStr.trim();
            this.point = 0;
            this.length = this.formulaStr.length();
        }
    }

    @Override
    public void parse() throws ParseException {
        this.init();
        while (this.look != '\u0000') {
            this.utils.team();
            if (this.utils.isOperation(this.look)) {
                this.utils.readOperation(this.look);
                continue;
            }
            this.utils.readOperand();
        }
        this.push2S1();
    }

    public void Expected(String c) throws ParseException {
        throw new ParseException(" cannot Parse, sorry : " + c);
    }

    private void init() {
        this.utils.getChar();
    }

    private void push2S1() {
        while (!this.operator.isEmpty()) {
            this.operand.push(this.operator.pop());
        }
    }

    private void push2S2(AbstractOper oper) {
        this.operator.push(oper);
    }

    private void pushCheck2S2(AbstractOper oper) {
        if (oper == null) {
            return;
        }
        AbstractOper _oper = null;
        while (!this.operator.isEmpty()) {
            _oper = this.operator.pop();
            if (OperationType.comparePRI(oper.getSID(), _oper.getSID()) > 0) {
                this.operator.push(_oper);
                continue;
            }
            this.operand.push(_oper);
        }
        this.operator.push(oper);
    }

    private void pushS22S1ByRightP() {
        AbstractOper _oper = null;
        while (!this.operator.isEmpty() && 1 != (_oper = this.operator.pop()).getSID()) {
            this.operand.push(_oper);
        }
    }

    @Override
    public IExpress getExpr() throws ParseException {
        return null;
    }

    public class ParseUtils {
        public void getChar() {
            if (Prase2RPN.this.point == Prase2RPN.this.length) {
                Prase2RPN.this.look = '\u0000';
                return;
            }
            Prase2RPN.this.look = Prase2RPN.this.formulaStr.charAt(Prase2RPN.this.point++);
            Prase2RPN.this.look = Prase2RPN.this.utils.toDBC(Prase2RPN.this.look);
        }

        public void back() {
            if (Prase2RPN.this.point == 0) {
                return;
            }
            if (Prase2RPN.this.point > 1) {
                Prase2RPN.this.point--;
                Prase2RPN.this.look = Prase2RPN.this.formulaStr.charAt(Prase2RPN.this.point - 1);
            } else {
                Prase2RPN.this.point = 0;
                this.getChar();
            }
        }

        public void team() throws ParseException {
            this.skipWhite();
        }

        public void skipWhite() {
            while (this.isWhite(Prase2RPN.this.look)) {
                this.getChar();
            }
        }

        public char toDBC(char c) {
            int _char = c;
            if (_char == 12288) {
                _char = 32;
            } else if (_char > 65280 && _char < 65375) {
                _char = (char)(_char - 65248);
            } else {
                switch (_char) {
                    case 65285: {
                        _char = 37;
                        break;
                    }
                    case 65286: {
                        _char = 38;
                        break;
                    }
                    case 65288: {
                        _char = 40;
                        break;
                    }
                    case 65289: {
                        _char = 41;
                        break;
                    }
                    case 65290: {
                        _char = 42;
                        break;
                    }
                    case 65291: {
                        _char = 43;
                        break;
                    }
                    case 65292: {
                        _char = 44;
                        break;
                    }
                    case 65293: {
                        _char = 45;
                        break;
                    }
                    case 65294: {
                        _char = 46;
                        break;
                    }
                    case 65295: {
                        _char = 47;
                        break;
                    }
                    case 65306: {
                        _char = 58;
                        break;
                    }
                    case 65307: {
                        _char = 59;
                        break;
                    }
                    case 65308: {
                        _char = 60;
                        break;
                    }
                    case 65309: {
                        _char = 61;
                        break;
                    }
                    case 65310: {
                        _char = 62;
                        break;
                    }
                    case 65312: {
                        _char = 64;
                        break;
                    }
                    case 65339: {
                        _char = 91;
                        break;
                    }
                    case 65341: {
                        _char = 93;
                        break;
                    }
                    case 65343: {
                        _char = 95;
                        break;
                    }
                    case 65371: {
                        _char = 123;
                        break;
                    }
                    case 65372: {
                        _char = 124;
                        break;
                    }
                    case 65373: {
                        _char = 125;
                    }
                }
            }
            return (char)_char;
        }

        public void match(char x) throws ParseException {
            if (Prase2RPN.this.look != x) {
                Prase2RPN.this.Expected("" + x + "");
            } else {
                this.getChar();
                this.skipWhite();
            }
        }

        public boolean isWhite(char c) {
            return c == ' ' || c == '\t' || c == '\r' || c == '\n';
        }

        public boolean isOperation(char c) {
            for (char tmpChar : OPERATIONS) {
                if (tmpChar != c) continue;
                return true;
            }
            return false;
        }

        public void readOperation(char c) throws ParseException {
            if ('+' == c) {
                this.add(c);
            } else if ('-' == c) {
                this.sub();
            } else if ('*' == c) {
                this.multiply();
            } else if ('/' == c) {
                this.div();
            } else if ('%' == c) {
                this.mod();
            } else if ('=' == c) {
                this.assignment();
            } else if ('>' == c) {
                this.greaterThan();
            } else if ('<' == c) {
                this.lessThan();
            } else if ('(' == c) {
                this.leftParentheses();
            } else if (')' == c) {
                this.rightParentheses();
            }
        }

        private void readOperation(String operation) {
        }

        public void readOperand() throws ParseException {
        }

        private void add(char c) throws ParseException {
            this.match('+');
            Prase2RPN.this.pushCheck2S2(new AddOper());
        }

        private void sub() throws ParseException {
            this.match('-');
            Prase2RPN.this.pushCheck2S2(new SubOper());
        }

        private void div() throws ParseException {
            this.match('/');
            Prase2RPN.this.pushCheck2S2(new DivOper());
        }

        private void mod() throws ParseException {
            this.match('%');
            Prase2RPN.this.pushCheck2S2(new ModOper());
        }

        private void multiply() throws ParseException {
            this.match('*');
            Prase2RPN.this.pushCheck2S2(new MultiplyOper());
        }

        private void assignment() throws ParseException {
            this.match('=');
            if (Prase2RPN.this.look == '=') {
                this.equal();
            } else {
                Prase2RPN.this.pushCheck2S2(new AssignmentOper());
            }
        }

        private void equal() throws ParseException {
            this.match('=');
            Prase2RPN.this.pushCheck2S2(new EqualOper());
        }

        private void leftParentheses() throws ParseException {
            this.match('(');
            Prase2RPN.this.push2S2(new LeftParentheses());
        }

        private void rightParentheses() throws ParseException {
            this.match(')');
            Prase2RPN.this.pushS22S1ByRightP();
        }

        private void greaterThan() throws ParseException {
            this.match('>');
            if (Prase2RPN.this.look == '=') {
                this.greaterEqual();
            } else {
                Prase2RPN.this.pushCheck2S2(new GreaterThanOper());
            }
        }

        private void greaterEqual() throws ParseException {
            this.match('=');
            Prase2RPN.this.pushCheck2S2(new GreaterEqualOper());
        }

        private void lessThan() throws ParseException {
            this.match('<');
            if (Prase2RPN.this.look == '=') {
                this.lessEqual();
            } else if (Prase2RPN.this.look == '>') {
                this.notEqual();
            } else {
                Prase2RPN.this.pushCheck2S2(new LessthanOper());
            }
        }

        private void lessEqual() throws ParseException {
            this.match('=');
            Prase2RPN.this.pushCheck2S2(new LessEqualOper());
        }

        private void notEqual() throws ParseException {
            this.match('>');
            Prase2RPN.this.pushCheck2S2(new NotEqualOper());
        }
    }
}

