/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.parse;

import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.parse.AbstractBizChecker;
import com.kingdee.eas.ma.biz.parse.BizParseExceptionHandler;
import com.kingdee.eas.ma.biz.parse.BizParseParam;
import com.kingdee.eas.ma.biz.parse.Parse2RPN;
import com.kingdee.eas.ma.biz.parse.operand.impl.Operand;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class BizAssignExprChecker
extends AbstractBizChecker {
    private BizParseParam param = null;
    private Integer currLine = null;
    private String text = null;
    private String bizName = null;
    private String subsetName = null;
    private static Set<String> ILLEGAL_OPER = new HashSet<String>();

    public BizAssignExprChecker(BizParseParam param) {
        Collections.addAll(ILLEGAL_OPER, ">", ">=", "<", "<=", "==", "<>", "NOT", "AND", "OR");
        this.param = param;
        this.text = param.getText();
        this.currLine = param.getCurrLine();
        this.subsetName = param.getSubsetName();
    }

    @Override
    public boolean check(Stack expr) {
        if (!this.checkToken(expr)) {
            this.recordException(BizCalcParseException.ERROR_EXPR, this.text.trim());
            return false;
        }
        Parse2RPN rpnParser = new Parse2RPN("", this.currLine, (Stack)expr.clone());
        try {
            rpnParser.parse();
            String type = rpnParser.getExprReturnType();
            if (!type.equals("other")) {
                this.recordException(BizCalcParseException.ERROR_EXPR, this.text.trim());
                return false;
            }
        }
        catch (BizCalcParseException e) {
            e.printStackTrace();
            this.recordException(BizCalcParseException.ERROR_EXPR, this.text.trim());
            return false;
        }
        return true;
    }

    @Override
    protected boolean checkToken(Stack expr) {
        if (!super.checkToken(expr)) {
            return false;
        }
        boolean left = true;
        boolean leftOperand = false;
        for (int i = 0; i < expr.size(); ++i) {
            Object obj = expr.get(i);
            if (obj instanceof AbstractOper) {
                if (((AbstractOper)obj).getOper().equals("=")) {
                    if (left) {
                        left = false;
                    } else {
                        return false;
                    }
                }
                if (!ILLEGAL_OPER.contains(((AbstractOper)obj).getOper())) continue;
                return false;
            }
            if (left) {
                if (!leftOperand) {
                    this.verifyExprLeft((Operand)obj);
                    leftOperand = true;
                    continue;
                }
                return false;
            }
            this.verifyExprRight((Operand)obj);
        }
        return true;
    }

    private void verifyExprLeft(Operand operand) {
        if (this.isFX(operand.getOperand())) {
            if (this.isBoolFX(operand.getOperand())) {
                this.recordException(BizCalcParseException.ERROR_EXPR_BOOL, operand.getOperand());
            }
            if (this.isMathFX(operand.getOperand())) {
                this.recordException(BizCalcParseException.ERROR_EXPR_MATH, operand.getOperand());
            }
        }
        if (this.isGVF(operand.getOperand())) {
            this.recordException(BizCalcParseException.EXPR_LEFT_GVF, operand.getOperand());
        }
        if (this.isNum(operand.getOperand())) {
            this.recordException(BizCalcParseException.ERROR_EXPR_CONSTANTS, operand.getOperand());
        }
        if (this.isLead(operand)) {
            this.recordException(BizCalcParseException.EROR_LEAD_LEFT, operand.getOperand());
        }
    }

    private boolean isLead(Operand operand) {
        return operand.getOperand().indexOf("FX:[") >= 0 && operand.getOperand().indexOf("Lead") >= 0;
    }

    private void verifyExprRight(Operand operand) {
        if (this.isBoolFX(operand.getOperand())) {
            this.recordException(BizCalcParseException.ERROR_EXPR_BOOL, null);
        }
        if (this.isAggFX(operand.getOperand())) {
            this.recordException(BizCalcParseException.ERROR_EXPR_AGG, null);
        }
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq) {
        BizParseExceptionHandler.recordException(excSubItem, charSeq, this.param);
    }
}

