/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.parse;

import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.parse.AbstractBizChecker;
import com.kingdee.eas.ma.biz.parse.BizParseExceptionHandler;
import com.kingdee.eas.ma.biz.parse.BizParseParam;
import com.kingdee.eas.ma.biz.parse.Parse2RPN;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Stack;

public class BizConditionChecker
extends AbstractBizChecker {
    private BizParseParam param = null;
    private Integer currLine = null;
    private String text = null;
    private String bizName = null;
    private String subsetName = null;

    public BizConditionChecker(BizParseParam param) {
        this.param = param;
        this.text = param.getText();
        this.currLine = param.getCurrLine();
        this.bizName = param.getBizName();
        this.subsetName = param.getSubsetName();
    }

    @Override
    public boolean check(Stack expr) {
        if (!this.checkToken(expr)) {
            this.recordException(BizCalcParseException.ERROR_CONDITION, this.text.trim());
            return false;
        }
        Parse2RPN rpnParser = new Parse2RPN("", this.currLine, (Stack)expr.clone());
        try {
            rpnParser.parse();
            String type = rpnParser.getExprReturnType();
            if (!type.equals("boolean")) {
                this.recordException(BizCalcParseException.ERROR_CONDITION, this.text.trim());
                return false;
            }
        }
        catch (BizCalcParseException e) {
            e.printStackTrace();
            this.recordException(BizCalcParseException.ERROR_CONDITION, this.text.trim());
            return false;
        }
        return true;
    }

    @Override
    protected boolean checkToken(Stack expr) {
        if (!super.checkToken(expr)) {
            return false;
        }
        for (int i = 0; i < expr.size(); ++i) {
            Object obj = expr.get(i);
            if (!(obj instanceof AbstractOper) || !((AbstractOper)obj).getOper().equals("=")) continue;
            return false;
        }
        return true;
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq) {
        BizParseExceptionHandler.recordException(excSubItem, charSeq, this.param);
    }
}

