/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.parse;

import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.expr.oper.AddOper;
import com.kingdee.eas.ma.biz.expr.oper.AssignmentOper;
import com.kingdee.eas.ma.biz.expr.oper.DivOper;
import com.kingdee.eas.ma.biz.expr.oper.EqualOper;
import com.kingdee.eas.ma.biz.expr.oper.GreaterEqualOper;
import com.kingdee.eas.ma.biz.expr.oper.GreaterThanOper;
import com.kingdee.eas.ma.biz.expr.oper.LeftParentheses;
import com.kingdee.eas.ma.biz.expr.oper.LessEqualOper;
import com.kingdee.eas.ma.biz.expr.oper.LessthanOper;
import com.kingdee.eas.ma.biz.expr.oper.LogicAndOper;
import com.kingdee.eas.ma.biz.expr.oper.LogicNotOper;
import com.kingdee.eas.ma.biz.expr.oper.LogicOrOper;
import com.kingdee.eas.ma.biz.expr.oper.ModOper;
import com.kingdee.eas.ma.biz.expr.oper.MultiplyOper;
import com.kingdee.eas.ma.biz.expr.oper.NotEqualOper;
import com.kingdee.eas.ma.biz.expr.oper.RightParentheses;
import com.kingdee.eas.ma.biz.expr.oper.SubOper;
import com.kingdee.eas.ma.biz.parse.BizCalcExprChecker;
import com.kingdee.eas.ma.biz.parse.BizParseExceptionHandler;
import com.kingdee.eas.ma.biz.parse.BizParseHelper;
import com.kingdee.eas.ma.biz.parse.BizParseParam;
import com.kingdee.eas.ma.biz.parse.IBizParser;
import com.kingdee.eas.ma.biz.parse.Parse2RPN;
import com.kingdee.eas.ma.biz.parse.expr.IBizExpr;
import com.kingdee.eas.ma.biz.parse.operand.impl.Operand;
import com.kingdee.eas.ma.biz.utils.BizCalcCommonHelper;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class BizExprParser
implements IBizParser {
    private static final String RIGHT_CANNOT_DISPLAY = "rightCannotDisplay";
    private BizParseParam param = null;
    private Integer currLine = null;
    private String text = null;
    private String bizName = null;
    private String subsetName = null;
    private Map<String, Map<String, Map<Integer, List<IBizExpr>>>> exprMap = null;
    private Map<String, Map<String, Map<Integer, List<Exception>>>> allExceptions = new LinkedHashMap<String, Map<String, Map<Integer, List<Exception>>>>();
    private int currPos = 0;
    private char currChar = '\u0000';
    private Stack exprStack = new Stack();
    private static Set<String> OPER_CHAR = new HashSet<String>();
    private static Set<String> LOGIC_CHAR = new HashSet<String>();
    private static Set<String> OPERATOR = new HashSet<String>();
    private static Set<String> LOGIC_OPER = new HashSet<String>();
    private static Set<String> FORMULA_TAG = new HashSet<String>();
    private final char SEMICOLON = ';';
    private final char STACK_OPERATOR = '\u0000';
    private boolean isRecordExc;

    public BizExprParser(BizParseParam param) {
        Collections.addAll(OPER_CHAR, "+", "-", "*", "/", "<", ">", "=");
        Collections.addAll(LOGIC_CHAR, "A", "N", "D", "O", "T", "R");
        Collections.addAll(OPERATOR, "+", "-", "*", "/", "=", "<", ">", ">=", "<=", "==", "<>");
        Collections.addAll(LOGIC_OPER, "NOT", "AND", "OR");
        Collections.addAll(FORMULA_TAG, "MBR", "VAR", "FX", "GVF", "LEAF_MBR", "NLEAF_MBR", "PTO");
        this.SEMICOLON = (char)59;
        this.STACK_OPERATOR = '\u0000';
        this.isRecordExc = true;
        this.param = param;
        this.currLine = param.getCurrLine();
        this.text = param.getText();
        this.bizName = param.getBizName();
        this.subsetName = param.getSubsetName();
        this.exprMap = param.getExprMap();
        this.allExceptions = param.getAllExceptions();
    }

    public Stack getExprStack() {
        return this.exprStack;
    }

    @Override
    public boolean parse() {
        this.readChar();
        boolean equlseFlag = false;
        while (this.currChar != '\u0000') {
            String oper;
            String formula;
            if (this.currChar == '=') {
                equlseFlag = true;
            }
            if (this.currChar == '/' && this.preViewNextChar() == '*') {
                String annoStr = this.readAnnotation(true);
                if (!this.isAnnotation(annoStr)) {
                    this.recordException(BizCalcParseException.ERROR_ANNO_NO_END, annoStr);
                    return false;
                }
            } else if (this.isLikeFormula(this.currChar)) {
                formula = this.readFormula();
                if (formula == null) {
                    this.recordException(BizCalcParseException.ERROR_EXPR, this.text);
                    return false;
                }
                String returnFlag = this.processFormual(formula, equlseFlag);
                if (returnFlag == null) {
                    this.recordException(BizCalcParseException.ERROR_CHAR, formula);
                    return false;
                }
                if (RIGHT_CANNOT_DISPLAY.equals(returnFlag)) {
                    this.recordException(BizCalcParseException.ERROR_LEAF_RIGHT, formula);
                    return false;
                }
            } else if (this.isLikeOperator(this.currChar)) {
                oper = "";
                if (this.isLikeNegative(this.currChar)) {
                    oper = this.readNumeric();
                    if (oper == null) {
                        this.recordException(BizCalcParseException.ERROR_CHAR, oper);
                        return false;
                    }
                    if (!this.operand(oper)) {
                        this.recordException(BizCalcParseException.ERROR_CHAR, oper);
                        return false;
                    }
                } else {
                    oper = this.readOperator();
                    if (!OPERATOR.contains(oper)) {
                        this.recordException(BizCalcParseException.ERROR_CHAR, oper);
                        return false;
                    }
                    if (!this.processOperator(oper)) {
                        this.recordException(BizCalcParseException.ERROR_CHAR, oper);
                        return false;
                    }
                }
            } else if (this.isLikeLogicOper(this.currChar)) {
                oper = this.readLogicOper();
                if (!LOGIC_OPER.contains(oper)) {
                    this.recordException(BizCalcParseException.ERROR_CHAR, oper);
                    return false;
                }
                if (!this.processOperator(oper)) {
                    this.recordException(BizCalcParseException.ERROR_CHAR, oper);
                    return false;
                }
            } else {
                if (this.isLikeIf(this.currChar)) {
                    formula = this.readIf();
                    if (formula == null) {
                        this.recordException(BizCalcParseException.ERROR_CHAR, this.text);
                        return false;
                    }
                    if (formula.length() == 0) {
                        return false;
                    }
                    try {
                        IExpress express = MbgExprParseHelper.parse(formula);
                        if (express == null) {
                            this.recordException(BizCalcParseException.ERROR_CHAR, formula);
                            return false;
                        }
                        if (express instanceof ConditionExpr) {
                            for (IExpress cond : ((ConditionExpr)express).conditions) {
                                block44: {
                                    BizExprParser parser = new BizExprParser(this.createParam(cond.getOriginalExpr()));
                                    if (parser.parse()) {
                                        Stack exprStack = parser.getExprStack();
                                        Parse2RPN rpnParser = new Parse2RPN("", this.currLine, exprStack);
                                        try {
                                            rpnParser.parse();
                                            String type = rpnParser.getExprReturnType();
                                            if (!type.equals("boolean")) {
                                                this.recordException(BizCalcParseException.ERROR_IF_NOLOGIC, this.text.trim());
                                                return false;
                                            }
                                            break block44;
                                        }
                                        catch (BizCalcParseException e) {
                                            e.printStackTrace();
                                            this.recordException(BizCalcParseException.ERROR_EXPR, this.text.trim());
                                            return false;
                                        }
                                    }
                                    this.currLine = parser.getCurrLine();
                                }
                                this.checkNull(cond);
                            }
                        }
                        if (this.operand(formula)) continue;
                        this.recordException(BizCalcParseException.ERROR_CHAR, formula);
                        return false;
                    }
                    catch (ParseException e) {
                        if (e.getMessage().startsWith("error if true")) {
                            this.recordException(BizCalcParseException.ERROR_IF_TRUE, formula);
                        } else {
                            this.recordException(BizCalcParseException.ERROR_CHAR, formula);
                        }
                        return false;
                    }
                }
                if (this.isLikeNumeric(this.currChar)) {
                    String num = this.readNumeric();
                    if (!this.isNum(num)) {
                        this.recordException(BizCalcParseException.ERROR_CHAR, num);
                        return false;
                    }
                    if (!this.operand(num)) {
                        this.recordException(BizCalcParseException.ERROR_CHAR, num);
                        return false;
                    }
                } else if (this.currChar == '(' || this.currChar == ')') {
                    if (!this.processOperator(String.valueOf(this.currChar))) {
                        this.recordException(BizCalcParseException.ERROR_CHAR, this.currChar + "");
                        return false;
                    }
                } else if (this.currChar != ';' && !BizParseHelper.isBlank(this.currChar)) {
                    this.recordException(BizCalcParseException.ERROR_CHAR, this.currChar + "");
                    return false;
                }
            }
            this.readChar();
        }
        return this.exprStack.size() > 0;
    }

    private void checkNull(IExpress cond) {
        if (cond instanceof BinaryExpr) {
            BinaryExpr expr = (BinaryExpr)cond;
            if (this.checkIsEmptyVar(expr.left) && this.checkIsEmptyVar(expr.right)) {
                this.recordException(BizCalcParseException.ERROR_IF_DOUBLENULL, this.text);
            } else if ((this.checkIsEmptyVar(expr.left) || this.checkIsEmptyVar(expr.right)) && expr.operType.getSID() != 13 && expr.operType.getSID() != 18) {
                this.recordException(BizCalcParseException.ERROR_IF_NULL, this.text);
            }
            this.checkNull(expr.left);
            this.checkNull(expr.right);
        } else if (cond instanceof ConditionExpr) {
            for (IExpress e : ((ConditionExpr)cond).conditions) {
                this.checkNull(e);
            }
        }
    }

    private boolean checkIsEmptyVar(IExpress expr) {
        return expr instanceof VariateExpr && "NULL".equals(((VariateExpr)expr).name);
    }

    private boolean checkExprToken() {
        AbstractOper oper;
        if (this.exprStack.size() == 1) {
            AbstractOper oper2;
            Object token = this.exprStack.get(0);
            return !(token instanceof AbstractOper) || (oper2 = (AbstractOper)token).getOper().equals("NOT") || oper2.getOper().equals("(");
        }
        Object token1 = this.exprStack.get(this.exprStack.size() - 1);
        Object token2 = this.exprStack.get(this.exprStack.size() - 2);
        return !(token1 instanceof Operand ? token2 instanceof Operand : ((oper = (AbstractOper)token1).getOper().equals("NOT") ? token2 instanceof Operand : (oper.getOper().equals("(") ? token2 instanceof Operand || token2 instanceof AbstractOper && ((AbstractOper)token2).getOper().equals(")") : (oper.getOper().equals(")") ? token2 instanceof AbstractOper && !((AbstractOper)token2).getOper().equals(")") : token2 instanceof AbstractOper && !((AbstractOper)token2).getOper().equals(")")))));
    }

    private boolean isLikeFormula(char currChar) {
        if (currChar == 'M' || currChar == 'F' || currChar == 'V' || currChar == 'G' || currChar == 'N' || currChar == 'L' || currChar == 'P') {
            String formulaToken = String.valueOf(currChar);
            int charNum = 0;
            charNum = currChar == 'M' || currChar == 'V' || currChar == 'G' || currChar == 'P' ? 4 : (currChar == 'N' ? 10 : (currChar == 'L' ? 9 : 3));
            for (int i = 0; i < charNum; ++i) {
                if (this.currPos + i >= this.text.length()) continue;
                formulaToken = formulaToken + this.text.charAt(this.currPos + i);
            }
            for (String tag : FORMULA_TAG) {
                if (!formulaToken.equals(tag + ":[")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLikeOperator(char currChar) {
        return OPER_CHAR.contains(String.valueOf(currChar));
    }

    private boolean isLikeIf(char currChar) {
        return currChar == 'I';
    }

    private boolean isLikeLogicOper(char currChar) {
        return currChar == 'A' || currChar == 'O' || currChar == 'N';
    }

    private boolean isLikeNegative(char currChar) {
        return currChar == '-' && this.isLikeNumeric(this.preViewNextChar()) && this.exprStack.peek() instanceof AbstractOper && OPERATOR.contains(((AbstractOper)this.exprStack.peek()).getOper());
    }

    private boolean isLikeNumeric(char cuurChar) {
        return Character.isDigit(cuurChar) || this.currChar == '-';
    }

    private boolean isNumericChar(char currChar) {
        return String.valueOf(currChar).matches("[\\d\\.\\%]");
    }

    private boolean isAnnotation(String script) {
        return script.trim().matches("\\/\\*[\\s\\S]*\\*\\/");
    }

    private String readNumeric() {
        String numStr = "";
        numStr = numStr + this.currChar;
        while (this.isNumericChar(this.preViewNextChar())) {
            this.readChar();
            numStr = numStr + this.currChar;
        }
        return numStr.toString();
    }

    private String readOperator() {
        String operatorStr = "";
        operatorStr = operatorStr + this.currChar;
        while (this.isLikeOperator(this.preViewNextChar()) && OPERATOR.contains(operatorStr + this.preViewNextChar())) {
            this.readChar();
            operatorStr = operatorStr + this.currChar;
        }
        return operatorStr.toString();
    }

    private String readLogicOper() {
        String operatorStr = "";
        operatorStr = operatorStr + this.currChar;
        while (LOGIC_CHAR.contains(String.valueOf(this.preViewNextChar()))) {
            this.readChar();
            operatorStr = operatorStr + this.currChar;
        }
        return operatorStr.toString();
    }

    private String readIf() {
        int countLeft = 0;
        int counRight = 0;
        StringBuffer formulaStr = new StringBuffer();
        while (this.currChar != '\u0000') {
            if (this.currChar == '[') {
                ++countLeft;
            }
            if (this.currChar == ']') {
                ++counRight;
            }
            if (this.currChar == '{' && countLeft == 0) {
                this.recordException(BizCalcParseException.ERROR_IF_NOCONDITION, this.text);
                return "";
            }
            formulaStr.append(this.currChar);
            this.readChar();
            if (countLeft != counRight || countLeft == 0) continue;
        }
        this.readResult(formulaStr);
        this.readBlank(formulaStr);
        while (this.readElse(formulaStr)) {
            this.readBlank(formulaStr);
            this.readResult(formulaStr);
            this.readBlank(formulaStr);
        }
        return formulaStr.toString();
    }

    protected void readBlank(StringBuffer formulaStr) {
        while (this.currChar != '\u0000' && BizParseHelper.isBlank(this.currChar)) {
            formulaStr.append(this.currChar);
            this.readChar();
        }
    }

    private boolean readElse(StringBuffer formulaStr) {
        if (this.currChar == 'E' && this.text.charAt(this.currPos) == 'L' && this.text.charAt(this.currPos + 1) == 'S' && this.text.charAt(this.currPos + 2) == 'E') {
            for (int i = 0; i < 4; ++i) {
                formulaStr.append(this.currChar);
                this.readChar();
            }
            int countLeft = 0;
            int counRight = 0;
            while (this.currChar != '\u0000' && this.currChar != '{') {
                if (this.currChar == '[') {
                    ++countLeft;
                }
                if (this.currChar == ']') {
                    ++counRight;
                }
                formulaStr.append(this.currChar);
                this.readChar();
                if (countLeft != counRight || countLeft == 0) continue;
            }
            return true;
        }
        return false;
    }

    private void readResult(StringBuffer formulaStr) {
        int countLeft = 0;
        int counRight = 0;
        while (this.currChar != '\u0000') {
            if (this.currChar == '{') {
                ++countLeft;
            }
            if (this.currChar == '}') {
                ++counRight;
            }
            formulaStr.append(this.currChar);
            this.readChar();
            if (countLeft != counRight || countLeft == 0) continue;
            return;
        }
    }

    private String readFormula() {
        int countLeft = 0;
        int counRight = 0;
        StringBuffer formulaStr = new StringBuffer();
        while (this.currChar != '\u0000') {
            if (this.currChar == '[') {
                ++countLeft;
            }
            if (this.currChar == ']') {
                ++counRight;
            }
            formulaStr.append(this.currChar);
            if (countLeft == counRight && countLeft != 0) {
                return formulaStr.toString();
            }
            this.readChar();
        }
        return null;
    }

    private String processFormual(String formula, boolean equlseFlag) {
        if (equlseFlag && (this.isLEAFMBR(formula) || this.isNLEAFMBR(formula))) {
            return RIGHT_CANNOT_DISPLAY;
        }
        if (this.isFX(formula) || this.isMBR(formula) || this.isVAR(formula) || this.isGVF(formula) || this.isLEAFMBR(formula) || this.isNLEAFMBR(formula) || this.isPTO(formula)) {
            if (this.isFX(formula) && this.isMathFX(formula) && BizCalcCommonHelper.getFunctionName(formula).equals("@ABS")) {
                String subFormula = formula.substring(formula.indexOf("(") + 1, formula.lastIndexOf(")"));
                BizExprParser parser = new BizExprParser(this.createParam(subFormula));
                parser.setRecordExc(false);
                if (!parser.parse()) {
                    return null;
                }
                Stack exprStack = parser.getExprStack();
                BizCalcExprChecker exprCheck = new BizCalcExprChecker(this.createParam(subFormula));
                if (!exprCheck.check(exprStack)) {
                    return null;
                }
                return this.operand(formula) ? formula : null;
            }
            return this.operand(formula) ? formula : null;
        }
        return null;
    }

    private boolean processOperator(String operator) {
        if (operator.equals("+")) {
            return this.add();
        }
        if (operator.equals("-")) {
            return this.sub();
        }
        if (operator.equals("*")) {
            return this.multiply();
        }
        if (operator.equals("/")) {
            return this.div();
        }
        if (operator.equals("=")) {
            return this.assignment();
        }
        if (operator.equals(">")) {
            return this.greaterThan();
        }
        if (operator.equals(">=")) {
            return this.greaterEqual();
        }
        if (operator.equals("<")) {
            return this.lessThan();
        }
        if (operator.equals("<=")) {
            return this.lessEqual();
        }
        if (operator.equals("<>")) {
            return this.notEqual();
        }
        if (operator.equals("==")) {
            return this.equal();
        }
        if (operator.equals("NOT")) {
            return this.logicNot();
        }
        if (operator.equals("AND")) {
            return this.logicAnd();
        }
        if (operator.equals("OR")) {
            return this.logicOr();
        }
        if (operator.equals("(")) {
            return this.leftParentheses();
        }
        if (operator.equals(")")) {
            return this.rightParentheses();
        }
        return false;
    }

    private boolean isPTO(String currExpr) {
        return BizParseHelper.isPTO(currExpr);
    }

    private boolean isMBR(String currExpr) {
        return BizParseHelper.isMBR(currExpr);
    }

    private boolean isLEAFMBR(String currExpr) {
        return BizParseHelper.isLEAFMBR(currExpr);
    }

    private boolean isNLEAFMBR(String currExpr) {
        return BizParseHelper.isNLEAFMBR(currExpr);
    }

    private boolean isVAR(String currExpr) {
        return BizParseHelper.isVAR(currExpr);
    }

    private boolean isGVF(String currExpr) {
        return BizParseHelper.isGVF(currExpr);
    }

    private boolean isFX(String currExpr) {
        return BizParseHelper.isFX(currExpr);
    }

    private boolean isMathFX(String currExpr) {
        return BizParseHelper.isMathFX(currExpr);
    }

    protected boolean isNum(String currExpr) {
        return BizParseHelper.isNum(currExpr);
    }

    private boolean push2ExprStack(Object oper) {
        this.exprStack.push(oper);
        return this.checkExprToken();
    }

    private boolean operand(String exprand) {
        return this.push2ExprStack(new Operand(exprand));
    }

    private boolean add() {
        return this.push2ExprStack(new AddOper());
    }

    private boolean sub() {
        return this.push2ExprStack(new SubOper());
    }

    private boolean div() {
        return this.push2ExprStack(new DivOper());
    }

    private boolean mod() {
        return this.push2ExprStack(new ModOper());
    }

    private boolean multiply() {
        return this.push2ExprStack(new MultiplyOper());
    }

    private boolean assignment() {
        return this.push2ExprStack(new AssignmentOper());
    }

    private boolean leftParentheses() {
        return this.push2ExprStack(new LeftParentheses());
    }

    private boolean rightParentheses() {
        return this.push2ExprStack(new RightParentheses());
    }

    private boolean equal() {
        return this.push2ExprStack(new EqualOper());
    }

    private boolean notEqual() {
        return this.push2ExprStack(new NotEqualOper());
    }

    private boolean lessThan() {
        return this.push2ExprStack(new LessthanOper());
    }

    private boolean lessEqual() {
        return this.push2ExprStack(new LessEqualOper());
    }

    private boolean greaterThan() {
        return this.push2ExprStack(new GreaterThanOper());
    }

    private boolean greaterEqual() {
        return this.push2ExprStack(new GreaterEqualOper());
    }

    private boolean logicNot() {
        return this.push2ExprStack(new LogicNotOper());
    }

    private boolean logicAnd() {
        return this.push2ExprStack(new LogicAndOper());
    }

    private boolean logicOr() {
        return this.push2ExprStack(new LogicOrOper());
    }

    private String readAnnotation(boolean changeLine) {
        StringBuffer annoStr = new StringBuffer();
        while (this.currChar != '\u0000') {
            if (this.currChar == '/' && annoStr.length() > 1 && annoStr.charAt(annoStr.length() - 1) == '*') {
                annoStr.append(this.currChar);
                break;
            }
            annoStr.append(this.currChar);
            if (changeLine) {
                this.readChar();
                continue;
            }
            this.readCharIgnoreLine();
        }
        return annoStr.toString();
    }

    private void readNotBlankChar() {
        do {
            this.readChar();
        } while (this.currChar != '\u0000' && BizParseHelper.isBlank(this.currChar));
    }

    private char preViewNextChar() {
        if (this.currPos == this.text.length()) {
            return '\u0000';
        }
        return this.text.charAt(this.currPos);
    }

    private void readChar() {
        if (this.currPos == this.text.length()) {
            this.currChar = '\u0000';
            return;
        }
        this.currChar = this.text.charAt(this.currPos++);
        if (this.currChar == '\n') {
            Integer n = this.currLine;
            Integer n2 = this.currLine = Integer.valueOf(this.currLine + 1);
        }
        if (this.currChar == '%' || this.currChar == '$') {
            return;
        }
    }

    private void readCharIgnoreLine() {
        if (this.currPos == this.text.length()) {
            this.currChar = '\u0000';
            return;
        }
        this.currChar = this.text.charAt(this.currPos++);
    }

    public void setRecordExc(boolean isRecordExc) {
        this.isRecordExc = isRecordExc;
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq) {
        if (this.isRecordExc) {
            BizParseExceptionHandler.recordException(excSubItem, charSeq, this.createParam(""));
        }
    }

    private BizParseParam createParam(String text) {
        BizParseParam param = new BizParseParam();
        param.setCurrLine(this.currLine);
        param.setBizName(this.bizName);
        param.setSubsetName(this.subsetName);
        param.setText(text);
        param.setExprMap(this.exprMap);
        param.setAllExceptions(this.allExceptions);
        return param;
    }

    @Override
    public Integer getCurrLine() {
        return this.currLine;
    }
}

