/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcRef;
import com.kingdee.eas.ma.biz.BizCalcRefEntry;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcRefUtils {
    private static Logger logger = Logger.getLogger(BizCalcRefUtils.class);
    private Context ctx = null;
    private Map<String, MbgDimInfo> mbgDimMap = null;
    private Map<String, Map<String, Map<String, Set<String>>>> memberRefMap = new HashMap<String, Map<String, Map<String, Set<String>>>>();

    protected void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    protected void setMbgDimMap(Map<String, MbgDimInfo> mbgDimMap) {
        this.mbgDimMap = mbgDimMap;
    }

    protected Map<String, MbgDimInfo> getMbgDimMap() {
        return this.mbgDimMap;
    }

    protected Map<String, Map<String, Map<String, Set<String>>>> getMemberRefMap() {
        return this.memberRefMap;
    }

    public BizCalcRefUtils(Context ctx) throws BOSException {
        this.setCtx(ctx);
        this.setMbgDimMap(DimUtils.getDimInfoMap((Context)this.getCtx()));
    }

    public static BizCalcRefUtils getInterface(Context ctx) throws BOSException {
        return new BizCalcRefUtils(ctx);
    }

    public BizCalcRefUtils checkRef(List<BizCalcInfo> calcs) {
        if (calcs == null || calcs.isEmpty()) {
            return this;
        }
        for (BizCalcInfo calc : calcs) {
            this.checkRef(calc);
        }
        return this;
    }

    public BizCalcRefUtils checkRef(IObjectCollection calcs) {
        if (calcs == null || calcs.isEmpty()) {
            return this;
        }
        BizCalcInfo calc = null;
        int in = calcs.size();
        for (int i = 0; i < in; ++i) {
            calc = (BizCalcInfo)calcs.getObject(i);
            this.checkRef(calc);
        }
        return this;
    }

    public void checkRef(BizCalcInfo calc) {
        if (calc == null || calc.getBizCalcSubset() == null || calc.getBizCalcSubset().isEmpty()) {
            return;
        }
        BizCalcSubsetInfo subsetInfo = null;
        int in = calc.getBizCalcSubset().size();
        for (int i = 0; i < in; ++i) {
            subsetInfo = calc.getBizCalcSubset().get(i);
            try {
                this.checkRef(calc.getId(), subsetInfo.getExpres(), subsetInfo.getScopeData(null, null));
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public void checkRef(BOSUuid calcId, List<IExpress> expres, Map<String, Set<String>> scopeMap) {
        if (calcId == null || expres == null || expres.isEmpty()) {
            return;
        }
        IExpress expr = null;
        int jn = expres.size();
        for (int j = 0; j < jn; ++j) {
            expr = expres.get(j);
            if (!(expr instanceof BinaryExpr)) continue;
            this.checkRef(calcId, (BinaryExpr)expr, scopeMap);
        }
    }

    private void checkRef(BOSUuid calcId, BinaryExpr expr, Map<String, Set<String>> scopeMap) {
        if (calcId == null || expr == null || scopeMap == null) {
            return;
        }
        String _calcId = calcId.toString();
        HashMap<String, Set<String>> leftMemberMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> rightMemberMap = new HashMap<String, Set<String>>();
        this.checkExpr(expr.left, leftMemberMap);
        this.checkExpr(expr.right, rightMemberMap);
        Map.Entry entry2 = null;
        Set<String> leftMemberSet = null;
        Set rightMemberSet = null;
        Map<Object, Object> dimMemberMap = null;
        Map refMap = null;
        Set refSet = null;
        for (Map.Entry entry2 : rightMemberMap.entrySet()) {
            if (!leftMemberMap.containsKey(entry2.getKey()) && !scopeMap.containsKey(entry2.getKey())) continue;
            leftMemberSet = leftMemberMap.containsKey(entry2.getKey()) ? (Set<String>)leftMemberMap.get(entry2.getKey()) : scopeMap.get(entry2.getKey());
            rightMemberSet = (Set)entry2.getValue();
            if (leftMemberSet.size() <= 0) continue;
            if (this.getMemberRefMap().containsKey(_calcId)) {
                dimMemberMap = this.getMemberRefMap().get(_calcId);
            } else {
                dimMemberMap = new HashMap();
                this.getMemberRefMap().put(_calcId, dimMemberMap);
            }
            if (dimMemberMap.containsKey(entry2.getKey())) {
                refMap = (Map)dimMemberMap.get(entry2.getKey());
            } else {
                refMap = new HashMap();
                dimMemberMap.put(entry2.getKey(), refMap);
            }
            String bgMemberNum = leftMemberSet.iterator().next();
            if (refMap.containsKey(bgMemberNum)) {
                refSet = (Set)refMap.get(bgMemberNum);
            } else {
                refSet = new HashSet();
                refMap.put(bgMemberNum, refSet);
            }
            refSet.addAll(rightMemberSet);
        }
    }

    private void checkExpr(IExpress expr, Map<String, Set<String>> memberMap) {
        if (expr == null || memberMap == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            this.checkExpr((BinaryExpr)expr, memberMap);
        } else if (expr instanceof MdxMemberExpr) {
            this.checkExpr((MdxMemberExpr)expr, memberMap);
        } else if (expr instanceof ConditionExpr) {
            this.checkExpr((ConditionExpr)expr, memberMap);
        }
    }

    private void checkExpr(ConditionExpr expr, Map<String, Set<String>> memberMap) {
        if (expr == null) {
            return;
        }
        for (IExpress _expr : expr.getAllExpresss()) {
            this.checkExpr(_expr, memberMap);
        }
    }

    private void checkExpr(BinaryExpr expr, Map<String, Set<String>> memberMap) {
        if (expr == null || memberMap == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            this.checkExpr((BinaryExpr)expr.left, memberMap);
        } else if (expr.left instanceof MdxMemberExpr) {
            this.checkExpr((MdxMemberExpr)expr.left, memberMap);
        }
        if (expr.right instanceof BinaryExpr) {
            this.checkExpr((BinaryExpr)expr.right, memberMap);
        } else if (expr.right instanceof MdxMemberExpr) {
            this.checkExpr((MdxMemberExpr)expr.right, memberMap);
        }
    }

    private void checkExpr(MdxMemberExpr expr, Map<String, Set<String>> memberMap) {
        if (expr == null || expr.params == null || expr.params.size() == 0 || memberMap == null) {
            return;
        }
        IExpress _expr = null;
        MemberExpr memberExpr = null;
        Set<Object> memberSet = null;
        String field = null;
        int in = expr.params.size();
        for (int i = 0; i < in; ++i) {
            _expr = expr.params.get(i);
            if (!(_expr instanceof MemberExpr)) continue;
            memberExpr = (MemberExpr)_expr;
            if (memberExpr.srcNumber.equals(DimensionConstants.DEF_PROCESS_SRCNUMBER)) continue;
            field = memberExpr.srcNumber.equals("BgP1") || memberExpr.srcNumber.equals("BgP2") ? this.getMbgDimMap().get(DimensionConstants.DEF_PERIOD_SRCNUMBER).getRefField() : this.getMbgDimMap().get(memberExpr.srcNumber).getRefField();
            if (memberMap.containsKey(field)) {
                memberSet = memberMap.get(field);
            } else {
                memberSet = new HashSet();
                memberMap.put(field, memberSet);
            }
            memberSet.add(memberExpr.getDimNumber());
        }
    }

    public void saveRef() throws BOSException, EASBizException {
        if (this.getCtx() == null || this.getMemberRefMap() == null || this.getMemberRefMap().isEmpty()) {
            return;
        }
        String calcId = null;
        String field = null;
        String refId = null;
        String entryId = null;
        String memberNum = null;
        BOSObjectType bosType = new BizCalcRef().getType();
        BOSObjectType entryType = new BizCalcRefEntry().getType();
        Map.Entry<String, Map<String, Map<String, Set<String>>>> entry2 = null;
        Map.Entry<String, Map<String, Set<String>>> mEntry2 = null;
        Map.Entry<String, Set<String>> iEntry2 = null;
        Map<String, Map<String, Set<String>>> calcRefMap = null;
        Map<String, Set<String>> memberRefMap = null;
        Set<String> memberRefSet = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.ctx);
            for (Map.Entry<String, Map<String, Map<String, Set<String>>>> entry2 : this.getMemberRefMap().entrySet()) {
                calcId = entry2.getKey();
                calcRefMap = entry2.getValue();
                try {
                    this.deleteRef(calcId);
                    for (Map.Entry<String, Map<String, Set<String>>> mEntry2 : calcRefMap.entrySet()) {
                        field = mEntry2.getKey();
                        memberRefMap = mEntry2.getValue();
                        if (memberRefMap.isEmpty() || !DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) continue;
                        for (Map.Entry<String, Set<String>> iEntry2 : memberRefMap.entrySet()) {
                            memberNum = iEntry2.getKey();
                            memberRefSet = iEntry2.getValue();
                            try {
                                refId = BOSUuid.create((BOSObjectType)bosType).toString();
                                BgDBUtils.executeUpdate((Connection)conn, (String)"Insert Into T_MBG_BizCalcRefBgIndex(FID, FBizCalcID, FBgIndexNum) values (?,?,?)", (Object[])new Object[]{refId, calcId, memberNum});
                                for (String refMemberNum : memberRefSet) {
                                    entryId = BOSUuid.create((BOSObjectType)entryType).toString();
                                    BgDBUtils.executeUpdate((Connection)conn, (String)"Insert Into T_MBG_BizCalcRefBgIndexEntry(FID, FRefID, FBgIndexNum) values (?,?,?)", (Object[])new Object[]{entryId, refId, refMemberNum});
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)"sql errror:", (Throwable)ex);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public void deleteRef(IObjectPK calcPk) throws BOSException, EASBizException {
        if (calcPk == null) {
            return;
        }
        this.deleteRef(calcPk.toString());
    }

    public void deleteRef(BOSUuid calcId) throws BOSException, EASBizException {
        if (calcId == null) {
            return;
        }
        this.deleteRef(calcId.toString());
    }

    public void deleteRef(IObjectCollection calcs) throws BOSException, EASBizException {
        if (calcs == null || calcs.isEmpty()) {
            return;
        }
        BizCalcInfo calc = null;
        int in = calcs.size();
        for (int i = 0; i < in; ++i) {
            calc = (BizCalcInfo)calcs.getObject(i);
            this.deleteRef(calc);
        }
    }

    public void deleteRef(BizCalcInfo calc) throws BOSException, EASBizException {
        if (calc == null || calc.getId() == null) {
            return;
        }
        this.deleteRef(calc.getId());
    }

    private void deleteRef(String calcId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)calcId)) {
            return;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.ctx);
            BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BizCalcRefBgIndexEntry where exists (select FID from T_MBG_BizCalcRefBgIndex where T_MBG_BizCalcRefBgIndexEntry.FRefID = FID and FBizCalcID = ?)", (Object[])new Object[]{calcId.toString()});
            BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BizCalcRefBgIndex where FBizCalcID = ?", (Object[])new Object[]{calcId.toString()});
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql errror:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

