/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.utils;

import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BizCalcRunUtils {
    private static Logger logger = Logger.getLogger(BizCalcRunUtils.class);
    private static final String VariableStr = "(\\w+.)(N\\+?\\-?\\d*!|\\d{4})Y(.(N\\+?\\-?\\d*!|\\d{2})(HY|Q|M|W|)|)(.(N\\+?\\-?\\d*!|\\d{2})(D|MW|TD|)|)";
    public static final String YEAR_HALFYEAR_MONTH_Q_WEEK_REG_STR = "(\\w+.)(\\d{4}|(N(\\+?\\-?\\d+)?!))Y((.(\\d{2}|(N(\\+?\\-?\\d+)?!))(HY|M|Q|W))?)";
    public static final String YEAR_MONTH_WEEK_REG_STR = "(\\w+.)(\\d{4}|(N(\\+?\\-?\\d+)?!))Y.(\\d{2}|(N(\\+?\\-?\\d+)?!))M.(\\d{2}|(N(\\+?\\-?\\d+)?)?!)MW";
    public static final int PERIOD_TYPE = -1;
    private static final String FindStr = "(?:\\-\\d+|\\+\\d+)!(?:Y|HY|Q|M|W|MW|D|TD)";

    private Expression checkExpression(Expression expression, BizCalcInfo calc) {
        if (expression instanceof BinaryOperationExpr) {
            expression = this.checkBinaryOperationExpr((BinaryOperationExpr)expression, calc);
        } else if (expression instanceof StringExpr) {
            expression = this.checkStringExpr((StringExpr)expression, calc);
        }
        return expression;
    }

    private BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, BizCalcInfo calc) {
        boExpr.left = this.checkExpression(boExpr.left, calc);
        boExpr.right = this.checkExpression(boExpr.right, calc);
        return boExpr;
    }

    private StringExpr checkStringExpr(StringExpr sExpr, BizCalcInfo calc) {
        return sExpr;
    }

    public static boolean hasBgPeriodVariable(String bgPeriodNumber) {
        if (StringUtils.isEmpty((String)bgPeriodNumber)) {
            return false;
        }
        if ((bgPeriodNumber = bgPeriodNumber.trim().toUpperCase()).matches(VariableStr)) {
            return BizCalcRunUtils.verifyBgPeriodVariable(bgPeriodNumber);
        }
        return false;
    }

    public static boolean verifyBgPeriodVariable(String periodNumber) {
        if (StringUtils.isEmpty((String)periodNumber)) {
            return false;
        }
        return (periodNumber = periodNumber.trim().toUpperCase()).matches(YEAR_HALFYEAR_MONTH_Q_WEEK_REG_STR) || periodNumber.matches(YEAR_MONTH_WEEK_REG_STR);
    }

    public static boolean hasBgPeriodVariable(BizCalcInfo calc) {
        if (calc == null) {
            return false;
        }
        return false;
    }

    public static boolean hasVariable(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return false;
        }
        return number.matches("N!(?:Y|HY|Q|M|W|MW|D|TD)");
    }

    public static Map<Integer, Integer> getOffset(String bgPeriodVariable) {
        HashMap<Integer, Integer> offset = new HashMap<Integer, Integer>();
        offset.put(-1, BizCalcRunUtils.getPeriodType(bgPeriodVariable));
        if (StringUtils.isEmpty((String)bgPeriodVariable)) {
            return offset;
        }
        if (BizCalcRunUtils.hasBgPeriodVariable(bgPeriodVariable)) {
            String tmpStr = null;
            String[] tmpStrs = null;
            Pattern pattern = Pattern.compile(FindStr);
            Matcher matcher = pattern.matcher(bgPeriodVariable);
            while (matcher.find()) {
                tmpStr = matcher.group();
                if (tmpStr == null) continue;
                tmpStrs = tmpStr.split("!");
                offset.put(BgPeriodHelper.getPeriodEnumType((String)tmpStrs[1]).getValue(), new Integer(tmpStrs[0]));
            }
        }
        return offset;
    }

    public static boolean checkOffset(Map<Integer, Integer> offsetMap) {
        if (offsetMap == null || offsetMap.isEmpty()) {
            return false;
        }
        return offsetMap.size() != 1 || !offsetMap.containsKey(-1);
    }

    public static int getPeriodType(String bgPeriodNumber) {
        if (StringUtils.isEmpty((String)bgPeriodNumber)) {
            return -1;
        }
        int periodType = -1;
        String[] tmpStrs = bgPeriodNumber.split("\\.");
        if (tmpStrs != null) {
            if (tmpStrs.length >= 2 && tmpStrs[1].endsWith("Y")) {
                periodType = 1;
            }
            if (tmpStrs.length >= 3 && tmpStrs[2] != null && periodType != -1) {
                periodType = tmpStrs[2].endsWith("HY") ? 2 : (tmpStrs[2].endsWith("Q") ? 3 : (tmpStrs[2].endsWith("M") ? 4 : (tmpStrs[2].endsWith("W") ? 5 : -1)));
            }
            if (tmpStrs.length >= 4 && tmpStrs[3] != null && periodType != -1) {
                periodType = tmpStrs[3].endsWith("D") ? 7 : (tmpStrs[3].endsWith("TD") ? 9 : (tmpStrs[3].endsWith("MW") ? 6 : -1));
            }
        }
        return periodType;
    }

    public static String getNegationOffsetBgPeriodNumber(String ccbgPeriodNumber, Map<Integer, Integer> offset) {
        if (offset == null || offset.isEmpty()) {
            return ccbgPeriodNumber;
        }
        if (!offset.isEmpty()) {
            HashMap<Integer, Integer> tmpMap = new HashMap<Integer, Integer>();
            tmpMap.putAll(offset);
            Object var3_3 = null;
            for (Map.Entry entry : tmpMap.entrySet()) {
                if ((Integer)entry.getKey() == -1) continue;
                entry.setValue((Integer)entry.getValue() * -1);
            }
            return BizCalcRunUtils.getOffsetBgPeriodNumber(ccbgPeriodNumber, tmpMap);
        }
        return ccbgPeriodNumber;
    }

    public static String getOffsetBgPeriodNumber(String ccbgPeriodNumber, String offsetNumber) {
        if (StringUtils.isEmpty((String)ccbgPeriodNumber) || StringUtils.isEmpty((String)offsetNumber)) {
            return ccbgPeriodNumber;
        }
        StringBuffer str = new StringBuffer();
        String ccNumber = null;
        String offNumber = null;
        String[] ccStrs = ccbgPeriodNumber.split("\\.");
        String[] offStrs = offsetNumber.split("\\.");
        if (offStrs != null && ccStrs != null) {
            int i;
            int in;
            int n = in = ccStrs.length > offStrs.length ? offStrs.length : ccStrs.length;
            for (i = 0; i < in; ++i) {
                ccNumber = ccStrs[i];
                offNumber = offStrs[i];
                if (offNumber.indexOf("N!") < 0) continue;
                if (ccNumber.matches(offNumber.replaceAll("N!", "\\\\d+"))) {
                    offStrs[i] = ccNumber;
                    continue;
                }
                return null;
            }
            for (i = 0; i < offStrs.length; ++i) {
                if (BizCalcRunUtils.hasVariable(offStrs[i])) {
                    return null;
                }
                str.append(offStrs[i] + ".");
            }
            if (str.length() > 0) {
                str = str.delete(str.length() - 1, str.length());
            }
        }
        return str.toString();
    }

    public static String getOffsetBgPeriodNumber(String ccbgPeriodNumber, Map<Integer, Integer> offset) {
        if (StringUtils.isEmpty((String)ccbgPeriodNumber)) {
            return null;
        }
        if (offset == null || offset.isEmpty()) {
            return ccbgPeriodNumber;
        }
        int periodType = offset.get(-1);
        if (periodType == -1) {
            return ccbgPeriodNumber;
        }
        String _offsetNumber = BizCalcRunUtils.offsetBgPeriodNumber(ccbgPeriodNumber, offset);
        return _offsetNumber;
    }

    private static String offsetBgPeriodNumber(String bgPeriodNumber, Map<Integer, Integer> offsetMap) {
        int offset;
        if (StringUtils.isEmpty((String)bgPeriodNumber)) {
            return null;
        }
        String[] tmpStrs = bgPeriodNumber.split("\\.");
        if (tmpStrs == null || tmpStrs.length == 0) {
            return null;
        }
        String _offsetNumber = null;
        String _oneNumber = null;
        String _twoNumber = null;
        String _threeNumber = null;
        String _periodCode = null;
        int oneCode = 0;
        int twoCode = 0;
        int threeCode = 0;
        String prdfix = tmpStrs[0];
        if (tmpStrs.length > 1 && tmpStrs[1] != null) {
            _oneNumber = tmpStrs[1];
            oneCode = new Integer(_oneNumber.substring(0, 4));
        }
        if (tmpStrs.length > 2 && tmpStrs[2] != null) {
            _twoNumber = tmpStrs[2];
            twoCode = new Integer(_twoNumber.substring(0, 2));
        }
        if (tmpStrs.length > 3 && tmpStrs[3] != null) {
            _threeNumber = tmpStrs[3];
            threeCode = new Integer(_threeNumber.substring(0, 2));
        }
        Calendar calendar = null;
        if (tmpStrs.length > 3) {
            if (_threeNumber != null) {
                _periodCode = _threeNumber.substring(2);
            }
            if (offsetMap.containsKey(7) && "D".equals(_periodCode)) {
                if (Pattern.matches("[\\d]{2}D", _threeNumber)) {
                    offset = offsetMap.get(7);
                    calendar = BizCalcRunUtils.getDay(oneCode, twoCode, threeCode, offset);
                }
            } else if (offsetMap.containsKey(9) && "TD".equals(_periodCode)) {
                if (Pattern.matches("[\\d]{2}TD", _threeNumber)) {
                    offset = offsetMap.get(9);
                    calendar = BizCalcRunUtils.getTenDays(oneCode, twoCode, threeCode, offset);
                }
            } else if (offsetMap.containsKey(6) && "MW".equals(_periodCode) && Pattern.matches("[\\d]{2}MW", _threeNumber)) {
                offset = offsetMap.get(6);
                calendar = BizCalcRunUtils.getMonthWeek(oneCode, twoCode, threeCode, offset);
            }
        }
        if (tmpStrs.length > 2) {
            if (_twoNumber != null) {
                _periodCode = _twoNumber.substring(2);
            }
            if (offsetMap.containsKey(2) && "HY".equals(_periodCode)) {
                if (Pattern.matches("[\\d]{2}HY", _twoNumber)) {
                    offset = offsetMap.get(2);
                    calendar = BizCalcRunUtils.getHalfYear(oneCode, twoCode, offset, calendar);
                }
            } else if (offsetMap.containsKey(3) && "Q".equals(_periodCode)) {
                if (Pattern.matches("[\\d]{2}Q", _twoNumber)) {
                    offset = offsetMap.get(3);
                    calendar = BizCalcRunUtils.getQuarter(oneCode, twoCode, offset, calendar);
                }
            } else if (offsetMap.containsKey(4) && "M".equals(_periodCode)) {
                if (Pattern.matches("[\\d]{2}M", _twoNumber)) {
                    offset = offsetMap.get(4);
                    calendar = BizCalcRunUtils.getMonth(oneCode, twoCode, offset, calendar);
                }
            } else if (offsetMap.containsKey(5) && "W".equals(_periodCode) && Pattern.matches("[\\d]{2}W", _twoNumber)) {
                offset = offsetMap.get(5);
                calendar = BizCalcRunUtils.getYearWeek(oneCode, twoCode, offset);
            }
        }
        if (tmpStrs.length > 1) {
            if (_oneNumber != null) {
                _periodCode = _oneNumber.substring(4);
            }
            if (offsetMap.containsKey(1) && "Y".equals(_periodCode) && Pattern.matches("[\\d]{4}Y", _oneNumber)) {
                offset = offsetMap.get(1);
                calendar = BizCalcRunUtils.getYear(oneCode, offset, calendar);
            }
        }
        if (calendar == null) {
            return bgPeriodNumber;
        }
        int periodType = offsetMap.get(-1);
        if (periodType == 1) {
            _offsetNumber = String.valueOf(calendar.get(1)) + "Y";
        } else if (periodType == 2) {
            _offsetNumber = BizCalcRunUtils.getHalfYearNumber(calendar);
        } else if (periodType == 3) {
            _offsetNumber = BizCalcRunUtils.getQuarterNumber(calendar);
        } else if (periodType == 4) {
            _offsetNumber = BizCalcRunUtils.getMonthNumber(calendar);
        } else if (periodType == 5) {
            _offsetNumber = BizCalcRunUtils.getYearWeekNumber(calendar);
        } else if (periodType == 7) {
            _offsetNumber = BizCalcRunUtils.getDayNumber(calendar);
        } else if (periodType == 9) {
            _offsetNumber = BizCalcRunUtils.getTenDayNumber(calendar);
        } else if (periodType == 6) {
            _offsetNumber = BizCalcRunUtils.getMonthWeekNumber(calendar);
        }
        return prdfix + "." + _offsetNumber;
    }

    private static Calendar getYear(int year, int offset, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
            calendar.set(year, 0, 1);
        }
        calendar.add(1, offset);
        return calendar;
    }

    private static Calendar getHalfYear(int year, int halfYear, int offset, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
            calendar.set(year, (halfYear - 1) * 6, 1);
        }
        if (offset != 0) {
            calendar.add(2, offset * 6);
        }
        return calendar;
    }

    private static Calendar getQuarter(int year, int quarter, int offset, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
            calendar.set(year, (quarter - 1) * 3, 1);
        }
        calendar.add(2, offset * 3);
        return calendar;
    }

    private static Calendar getMonth(int year, int month, int offset, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
            calendar.set(year, month - 1, 1);
        }
        if (offset != 0) {
            calendar.add(2, offset);
        }
        return calendar;
    }

    private static Calendar getYearWeek(int year, int week, int offset) {
        Calendar calendar = Calendar.getInstance();
        CalendarHelper helper = new CalendarHelper();
        int maxWeek = helper.getWeeksOfYear(year, true);
        int tmpWeek = week + offset;
        if (tmpWeek > 0) {
            while (tmpWeek > maxWeek) {
                tmpWeek -= maxWeek;
                maxWeek = helper.getWeeksOfYear(++year, true);
            }
        } else if (tmpWeek <= 0) {
            while (tmpWeek <= 0) {
                tmpWeek += maxWeek;
                maxWeek = helper.getWeeksOfYear(--year, true);
            }
        }
        calendar.setTime(helper.getFirstDayOfWeek(year, week));
        return calendar;
    }

    private static Calendar getDay(int year, int month, int day, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day);
        calendar.add(6, offset);
        return calendar;
    }

    private static Calendar getTenDays(int year, int month, int tendays, int offset) {
        Calendar calendar = Calendar.getInstance();
        int _tendays = tendays + offset;
        if (_tendays <= 0) {
            while (_tendays <= 0) {
                offset += 3;
                if (--month < 1) {
                    month = 12;
                    --year;
                }
                _tendays = tendays + offset;
            }
        } else if (_tendays > 3) {
            while (_tendays > 3) {
                offset -= 3;
                if (++month > 12) {
                    month = 1;
                    ++year;
                }
                _tendays = tendays + offset;
            }
        }
        if ((tendays += offset) == 1) {
            calendar.set(year, month - 1, 1);
        } else if (tendays == 2) {
            calendar.set(year, month - 1, 11);
        } else {
            calendar.set(year, month - 1, 21);
        }
        return calendar;
    }

    private static Calendar getMonthWeek(int year, int month, int week, int offset) {
        Calendar calendar = Calendar.getInstance();
        CalendarHelper calendarHelper = new CalendarHelper();
        int _year = year;
        int _month = month;
        int _week = week;
        int _offset = offset;
        int _amount = calendarHelper.getWeeksOfMonth(_year, _month);
        if (_offset > 0) {
            while (_week + _offset > _amount) {
                _offset -= _amount;
                if (++_month > 12) {
                    ++_year;
                    _month = 1;
                }
                _amount = calendarHelper.getWeeksOfMonth(_year, _month);
            }
            _week += _offset;
        } else {
            while (_week + _offset <= 0) {
                _offset += _amount;
                if (--_month <= 0) {
                    --_year;
                    _month = 12;
                }
                _amount = calendarHelper.getWeeksOfMonth(_year, _month);
            }
            _week += _offset;
        }
        calendar.setTime(calendarHelper.getFirstDayOfWeek(_year, _month, _week));
        return calendar;
    }

    private static String getHalfYearNumber(Calendar calendar) {
        StringBuffer _bgPeriodNumber = new StringBuffer();
        _bgPeriodNumber.append(new SimpleDateFormat("yyyy'Y.'").format(calendar.getTime()));
        int _month = calendar.get(2) + 1;
        _bgPeriodNumber.append(_month > 6 ? "02" : "01");
        _bgPeriodNumber.append("HY");
        return _bgPeriodNumber.toString();
    }

    private static String getQuarterNumber(Calendar calendar) {
        StringBuffer _bgPeriodNumber = new StringBuffer();
        _bgPeriodNumber.append(new SimpleDateFormat("yyyy'Y.'").format(calendar.getTime()));
        int _month = calendar.get(2) + 1;
        if (_month > 6) {
            if (_month > 9) {
                _bgPeriodNumber.append("04");
            } else {
                _bgPeriodNumber.append("03");
            }
        } else if (_month > 3) {
            _bgPeriodNumber.append("02");
        } else {
            _bgPeriodNumber.append("01");
        }
        _bgPeriodNumber.append("Q");
        return _bgPeriodNumber.toString();
    }

    private static String getMonthNumber(Calendar calendar) {
        return new SimpleDateFormat("yyyy'Y.'MM'M'").format(calendar.getTime());
    }

    private static String getYearWeekNumber(Calendar calendar) {
        int year = calendar.get(1);
        int week = calendar.get(3);
        return String.format("%04dY.%02dW", year, week);
    }

    private static String getDayNumber(Calendar calendar) {
        return new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(calendar.getTime());
    }

    private static String getTenDayNumber(Calendar calendar) {
        int day = calendar.get(5);
        String _tenDaysNumber = null;
        _tenDaysNumber = day >= 1 && day <= 10 ? "01TD" : (day >= 11 && day <= 20 ? "02TD" : "03TD");
        _tenDaysNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'").format(calendar.getTime()) + _tenDaysNumber;
        return _tenDaysNumber;
    }

    private static String getMonthWeekNumber(Calendar calendar) {
        int week = calendar.get(4);
        String _weekNumber = new SimpleDateFormat("yyyy'Y.'MM'M.'").format(calendar.getTime());
        _weekNumber = _weekNumber + new DecimalFormat("00").format(week) + "MW";
        return _weekNumber;
    }

    public static List<String> adapterVariable(String bgPeriodVariable, Set<String> offsetPeriodNums) {
        ArrayList<String> bgPeriodNums = new ArrayList<String>();
        if (StringUtils.isEmpty((String)bgPeriodVariable)) {
            return bgPeriodNums;
        }
        String bgPeriodNumber2 = null;
        String variable = bgPeriodVariable.replaceAll("N\\-?\\+?\\d*\\!", "\\\\d+");
        for (String bgPeriodNumber2 : offsetPeriodNums) {
            if (!bgPeriodNumber2.matches(variable)) continue;
            bgPeriodNums.add(bgPeriodNumber2);
        }
        return bgPeriodNums;
    }

    public static boolean adapterVariable(String bgPeriodVariable, String bgPeriodNumber) {
        if (StringUtils.isEmpty((String)bgPeriodVariable) || StringUtils.isEmpty((String)bgPeriodNumber)) {
            return false;
        }
        String variable = bgPeriodVariable.replaceAll("N\\+?\\-?\\d*\\!", "\\\\d+");
        return bgPeriodNumber.matches(variable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BgSchemeInfo> queryScheme(Connection conn, Timestamp timestamp) throws SQLException, SQLDataException {
        if (conn == null || timestamp == null) {
            return null;
        }
        ArrayList<BgSchemeInfo> rootSchemes = new ArrayList<BgSchemeInfo>();
        BgSchemeInfo bgSchemeInfo = null;
        StringBuffer rootSchemeSql = new StringBuffer();
        rootSchemeSql.append("select FID, FNumber, FRefCube from T_MBG_BgScheme where FIsFormal = 1 and FDateFrom <= ? and FDateTo >= ?");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)rootSchemeSql.toString(), (Object[])new Object[]{timestamp, timestamp});
            while (rst.next()) {
                bgSchemeInfo = new BgSchemeInfo();
                bgSchemeInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgSchemeInfo.setNumber(rst.getString("FNumber"));
                bgSchemeInfo.setName(bgSchemeInfo.getNumber());
                bgSchemeInfo.setRefCube(rst.getString("FRefCube"));
                rootSchemes.add(bgSchemeInfo);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return rootSchemes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<BOSUuid> queryExecuteOrgUnit(Connection conn, BgSchemeInfo scheme) throws SQLException, SQLDataException {
        HashSet<BOSUuid> exeOrgUnits = new HashSet<BOSUuid>();
        if (conn == null || scheme == null || scheme.getEditOrgViewId() == null) {
            return exeOrgUnits;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FOrgUnitID from T_MBG_BgOrgUnit where FViewId = ? and FIsLeaf = 1");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{scheme.getEditOrgViewId().toString()});
            while (rst.next()) {
                exeOrgUnits.add(BOSUuid.read((String)rst.getString("FOrgUnitID")));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return exeOrgUnits;
    }

    public static Set<String> mergeDimMember(String bgIndexNumber, String extDimNumber, Set<String> bgIndexMember, Map<String, Set<String>> extDimMember, Map<String, MbgDimInfo> bgDimsMap, List<String[]> relationData, Map<String, Set<String>> dimScopeMap) {
        int i;
        int in;
        HashSet<String> bgDimNumSet = new HashSet<String>();
        if (bgIndexMember == null || extDimMember == null || relationData == null || relationData.isEmpty()) {
            return bgDimNumSet;
        }
        if (bgIndexMember.isEmpty() || extDimMember.isEmpty()) {
            return bgDimNumSet;
        }
        HashMap<String, String> filerDataMap = new HashMap<String, String>();
        HashMap<String, Integer> filterIndexMap = new HashMap<String, Integer>();
        if (!StringUtils.isEmpty((String)extDimNumber)) {
            String[] tmpDims = null;
            String[] tmpStrs = null;
            MbgDimInfo dimension = null;
            tmpDims = extDimNumber.split("\\|");
            if (tmpDims != null) {
                int in2 = tmpDims.length;
                for (int i2 = 0; i2 < in2; ++i2) {
                    tmpStrs = tmpDims[i2].split(":");
                    dimension = bgDimsMap.get(tmpStrs[0]);
                    filerDataMap.put(dimension.getRefField(), tmpDims[i2]);
                }
            }
        }
        int bgIndex = -1;
        int exIndex = -1;
        boolean hasBgIndex = false;
        StringBuffer str = null;
        String number = null;
        String field = null;
        String filterDimNum = null;
        ArrayList<Object> tmpRelData = new ArrayList<Object>();
        tmpRelData.addAll(relationData);
        String[] dimFields = (String[])tmpRelData.get(0);
        String[] relData = null;
        HashSet<String> refFieldSet = new HashSet<String>();
        HashSet<String> tmpSet = null;
        Set<String> tmpScope = null;
        HashSet<String> extMember = null;
        HashSet<Integer> baseDimSet = new HashSet<Integer>();
        for (int i3 = 0; i3 < dimFields.length; ++i3) {
            field = dimFields[i3];
            refFieldSet.add(field);
            if (DimUtils.checkBaseDimensionByField((String)field)) {
                baseDimSet.add(i3);
            }
            if (field.equals(DimensionConstants.DEF_BGINDEX_FIELD)) {
                bgIndex = i3;
                hasBgIndex = true;
                break;
            }
            if (!filerDataMap.containsKey(field)) continue;
            filterIndexMap.put(field, i3);
        }
        if (!filterIndexMap.isEmpty()) {
            ArrayList<String[]> filterData = new ArrayList<String[]>();
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : filterIndexMap.entrySet()) {
                field = (String)entry2.getKey();
                exIndex = (Integer)entry2.getValue();
                filterDimNum = (String)filerDataMap.get(field);
                filterData.add(dimFields);
                in = tmpRelData.size();
                for (i = 1; i < in; ++i) {
                    relData = (String[])tmpRelData.get(i);
                    number = BizCalcRunUtils.getDimNumber(relData[exIndex]);
                    if (!filterDimNum.equals(number)) continue;
                    filterData.add(relData);
                }
                tmpRelData.clear();
                tmpRelData.addAll(filterData);
                filterData.clear();
            }
        }
        ArrayList<String> memList = new ArrayList<String>();
        ArrayList<String> tmpList = new ArrayList<String>();
        if (hasBgIndex) {
            HashSet<String> _bgIndexSet = new HashSet<String>();
            if (!StringUtils.isEmpty((String)bgIndexNumber)) {
                _bgIndexSet.add(bgIndexNumber);
            } else if (dimScopeMap != null && dimScopeMap.containsKey(DimensionConstants.DEF_BGINDEX_FIELD)) {
                tmpScope = dimScopeMap.get(DimensionConstants.DEF_BGINDEX_FIELD);
                tmpSet = new HashSet<String>(bgIndexMember);
                tmpSet.retainAll(tmpScope);
                _bgIndexSet.addAll(tmpSet);
            } else {
                _bgIndexSet.addAll(bgIndexMember);
            }
            in = tmpRelData.size();
            for (i = 1; i < in; ++i) {
                relData = (String[])tmpRelData.get(i);
                if (!_bgIndexSet.contains(relData[bgIndex])) continue;
                str = new StringBuffer();
                int jn = relData.length;
                for (int j = 0; j < jn; ++j) {
                    number = BizCalcRunUtils.getDimNumber(relData[j]);
                    str.append(number + ",");
                }
                if (str.length() > 0) {
                    str = str.delete(str.length() - 1, str.length());
                }
                memList.add(str.toString());
            }
        } else {
            if (!StringUtils.isEmpty((String)bgIndexNumber)) {
                memList.add(bgIndexNumber);
            } else if (dimScopeMap != null && dimScopeMap.containsKey(DimensionConstants.DEF_BGINDEX_FIELD)) {
                tmpScope = dimScopeMap.get(DimensionConstants.DEF_BGINDEX_FIELD);
                tmpSet = new HashSet<String>(bgIndexMember);
                tmpSet.retainAll(tmpScope);
                memList.addAll(tmpSet);
            } else {
                memList.addAll(bgIndexMember);
            }
            for (String bgIndexNum : memList) {
                int in3 = tmpRelData.size();
                for (int i4 = 1; i4 < in3; ++i4) {
                    relData = (String[])tmpRelData.get(i4);
                    str = new StringBuffer(bgIndexNum + ",");
                    int jn = relData.length;
                    for (int j = 0; j < jn; ++j) {
                        if (baseDimSet.contains(j)) continue;
                        number = BizCalcRunUtils.getDimNumber(relData[j]);
                        str.append(number + ",");
                    }
                    if (str.length() > 0) {
                        str = str.delete(str.length() - 1, str.length());
                    }
                    tmpList.add(str.toString());
                }
            }
            memList.clear();
            memList.addAll(tmpList);
            tmpList.clear();
        }
        TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        treeMap.putAll(extDimMember);
        Map.Entry entry3 = null;
        String dimField = null;
        for (Map.Entry entry3 : treeMap.entrySet()) {
            dimField = (String)entry3.getKey();
            extMember = (HashSet<String>)entry3.getValue();
            if (refFieldSet.contains(dimField)) continue;
            if (filerDataMap.containsKey(field)) {
                filterDimNum = (String)filerDataMap.get(field);
                for (String srcMem : memList) {
                    tmpList.add(srcMem + "," + filterDimNum);
                }
            } else {
                if (dimScopeMap != null && dimScopeMap.containsKey(dimField)) {
                    tmpScope = dimScopeMap.get(dimField);
                    tmpSet = new HashSet<String>(tmpScope);
                    tmpSet.retainAll(extMember);
                    extMember = tmpSet;
                }
                for (String dstStr : extMember) {
                    for (String srcMem : memList) {
                        tmpList.add(srcMem + "," + dstStr);
                    }
                }
            }
            memList.clear();
            memList.addAll(tmpList);
            tmpList.clear();
        }
        if (!memList.isEmpty()) {
            String tmpStr = null;
            TreeMap dimDataMap = new TreeMap(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    String str1 = o1.substring(1);
                    String str2 = o2.substring(1);
                    return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
                }
            });
            tmpList.clear();
            for (String dimNumber : memList) {
                tmpStr = DimUtils.getDimNumber((String)dimNumber, bgDimsMap, dimDataMap);
                if (tmpStr == null) continue;
                tmpList.add(tmpStr);
            }
            memList.clear();
            memList.addAll(tmpList);
        }
        bgDimNumSet.addAll(memList);
        return bgDimNumSet;
    }

    private static String getDimNumber(String mdxNumber) {
        if (mdxNumber == null) {
            return null;
        }
        String number = null;
        if (mdxNumber.startsWith("[") && mdxNumber.endsWith("]")) {
            String[] tmpStrs = mdxNumber.split("\\]\\.\\[");
            number = tmpStrs[tmpStrs.length - 1];
            number = number.substring(0, number.length() - 1);
        } else {
            number = mdxNumber;
        }
        return number;
    }

    public static Set<String> mergeDimMember(String bgIndexNumber, String extDimNumber, Set<String> bgIndexMember, Map<String, Set<String>> extDimMember, Map<String, MbgDimInfo> bgDimsMap, Map<String, Set<String>> dimScopeMap) {
        HashSet<String> bgDimNumSet = new HashSet<String>();
        if (bgIndexMember == null || bgIndexMember.isEmpty() || extDimMember == null) {
            return bgDimNumSet;
        }
        HashSet<String> tmpSet = null;
        Set<String> tmpScope = null;
        HashSet<String> extMember = null;
        ArrayList<String> memList = new ArrayList<String>();
        ArrayList<String> tmpList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)bgIndexNumber)) {
            memList.add(bgIndexNumber);
        } else if (dimScopeMap != null && dimScopeMap.containsKey(DimensionConstants.DEF_BGINDEX_FIELD)) {
            tmpScope = dimScopeMap.get(DimensionConstants.DEF_BGINDEX_FIELD);
            tmpSet = new HashSet<String>(tmpScope);
            tmpSet.retainAll(bgIndexMember);
            memList.addAll(tmpSet);
        } else {
            memList.addAll(bgIndexMember);
        }
        HashMap<String, String> filerDataMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)extDimNumber)) {
            String[] tmpDims = null;
            String[] tmpStrs = null;
            MbgDimInfo dimension = null;
            tmpDims = extDimNumber.split("\\|");
            if (tmpDims != null) {
                int in = tmpDims.length;
                for (int i = 0; i < in; ++i) {
                    tmpStrs = tmpDims[i].split(":");
                    dimension = bgDimsMap.get(tmpStrs[0]);
                    filerDataMap.put(dimension.getRefField(), tmpDims[i]);
                }
            }
        }
        TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        treeMap.putAll(extDimMember);
        Map.Entry entry2 = null;
        String field = null;
        String filterDimNum = null;
        for (Map.Entry entry2 : treeMap.entrySet()) {
            field = (String)entry2.getKey();
            extMember = (HashSet<String>)entry2.getValue();
            if (filerDataMap.containsKey(field)) {
                filterDimNum = (String)filerDataMap.get(field);
                for (String srcMem : memList) {
                    tmpList.add(srcMem + "," + filterDimNum);
                }
            } else {
                if (dimScopeMap != null && dimScopeMap.containsKey(field)) {
                    tmpScope = dimScopeMap.get(field);
                    tmpSet = new HashSet<String>(tmpScope);
                    tmpSet.retainAll(extMember);
                    extMember = tmpSet;
                }
                for (String dstStr : extMember) {
                    for (String srcMem : memList) {
                        tmpList.add(srcMem + "," + dstStr);
                    }
                }
            }
            memList.clear();
            memList.addAll(tmpList);
            tmpList.clear();
        }
        bgDimNumSet.addAll(memList);
        return bgDimNumSet;
    }
}

