/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.utils;

import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.ICalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParse;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FormulaExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.NameExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.OperandExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse.Parse2RPN;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizPtoUtils;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BizExprUtils {
    private static final String DEF_CALC_NAME = "MbgBizCalc";
    public static final String SUPPORT_ACCT = "ACCT";
    public static final String SUPPORT_ACCTITEM = "ACCTITEM";
    public static final String SUPPORT_MBGREFBGTEM = "MBGREFBGTEM";
    public static final String SUPPORT_ELIMDATA = "ELIMDATA";
    public static final String SUPPORT_MBGADJUST = "MBGADJUST";
    public static final String SUPPORT_MBGADJUSTDATE = "MBGADJUSTDATE";
    public final String SEPARATOR_LEFT_STR = "\\[";
    public final String SEPARATOR_RIGTH_STR = "\\]";
    public final String SEPARATOR_STR = "\\`";

    public static final String replaceAll(String str) {
        return str.replaceAll("\\[", "\\`").replaceAll("\\]", "\\`");
    }

    public static final String replaceAllNull(String str) {
        return str.replaceAll("\\[", "").replaceAll("\\]", "");
    }

    public static final String replace(String str, String oldChars, String newChars) {
        block1: {
            if (str == null || oldChars == null || newChars == null) {
                return str;
            }
            int pos = str.indexOf(oldChars);
            if (pos <= -1) break block1;
            String firstPart = str.substring(0, pos);
            String lastPart = str.substring(pos + oldChars.length(), str.length());
            str = firstPart + newChars + lastPart;
        }
        return str;
    }

    public static String getCalcNumber(String calcNumber, int calcSeq, int calcSubSeq, int exprSeq, int subSeq) {
        String calcName = DEF_CALC_NAME;
        if (!StringUtils.isEmpty((String)calcNumber)) {
            calcName = calcNumber;
        }
        if (Character.isDigit(calcName.charAt(0))) {
            calcName = DEF_CALC_NAME + calcName;
        }
        calcName = calcName + "A" + String.valueOf(calcSeq);
        calcName = calcName + String.valueOf(calcSubSeq);
        calcName = calcName + String.valueOf(exprSeq);
        calcName = calcName + String.valueOf(subSeq);
        return calcName.replaceAll("-", "");
    }

    public static int getSloveOrder(int calcSeq, int calcSubSeq, int exprSeq, int subSeq) {
        int sloveOrder = 999999;
        return sloveOrder -= Integer.valueOf(String.valueOf(calcSeq) + String.valueOf(exprSeq) + String.valueOf(subSeq)).intValue();
    }

    public static String getMdxField(String field) {
        return DimUtils.getDimensionNumber((String)field);
    }

    public static String getMdxNumber(String number) {
        return BizExprUtils.getMdxNumber(number, null);
    }

    public static String getMdxNumber(String number, Map<String, String> inneIdMap) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        StringBuffer mdx = new StringBuffer();
        String[] tmpNums = number.split("!");
        int in = tmpNums.length;
        for (int i = 0; i < in; ++i) {
            if (inneIdMap != null && inneIdMap.containsKey(tmpNums[i])) {
                mdx.append(".[" + inneIdMap.get(tmpNums[i]) + "]");
                continue;
            }
            mdx.append(".[" + tmpNums[i] + "]");
        }
        return mdx.toString();
    }

    public static String getMdxNumber(String field, String srcNumber, String dimNumber, Map<String, Map<String, String>> mdxNumMap, Map<String, Map<String, String>> numInnMap, boolean isOrgLongNumber) {
        if (field == null || dimNumber == null || mdxNumMap == null) {
            return null;
        }
        String number = null;
        String mdxNumber = null;
        mdxNumber = DimensionConstants.DEF_ORGUNIT_FIELD.equals(field) && !isOrgLongNumber ? dimNumber : BizExprUtils.queryMdxNumber(field, dimNumber, mdxNumMap);
        StringBuffer mdx = new StringBuffer();
        String[] tmpNums = mdxNumber.split("!");
        String[] tmpStrs = null;
        int in = tmpNums.length;
        for (int i = 0; i < in; ++i) {
            tmpStrs = tmpNums[i].split(":");
            if (tmpStrs != null) {
                number = tmpStrs.length > 1 ? tmpStrs[1] : tmpStrs[0];
            }
            if (DimensionConstants.DEF_PROCESS_FIELD.equals(field)) {
                mdx.append(".[" + number + "]");
                continue;
            }
            if (numInnMap != null && numInnMap.containsKey(field)) {
                Map<String, String> tmpMap = numInnMap.get(field);
                if (tmpMap != null && tmpMap.containsKey(tmpNums[i])) {
                    mdx.append(".[" + tmpMap.get(tmpNums[i]) + "]");
                    continue;
                }
                if (DimUtils.checkBaseDimensionByField((String)field)) {
                    mdx.append(".[" + tmpNums[i] + "]");
                    continue;
                }
                mdx.append(".[" + srcNumber + ":" + number + "]");
                continue;
            }
            if (DimUtils.checkBaseDimensionByField((String)field)) {
                mdx.append(".[" + tmpNums[i] + "]");
                continue;
            }
            mdx.append(".[" + srcNumber + ":" + number + "]");
        }
        return mdx.toString();
    }

    public static String queryMdxNumber(String field, String dimNumber, Map<String, Map<String, String>> mdxNumMap) {
        Map<String, String> tmpMap;
        if (field == null || dimNumber == null || mdxNumMap == null) {
            return null;
        }
        String _dimNumber = dimNumber;
        if (DimUtils.checkBaseDimensionByField((String)field)) {
            _dimNumber = DimUtils.getNumber((String)_dimNumber);
        }
        String mdxNumber = _dimNumber;
        if (mdxNumMap.containsKey(field) && (tmpMap = mdxNumMap.get(field)) != null && tmpMap.containsKey(_dimNumber)) {
            mdxNumber = tmpMap.get(_dimNumber);
        }
        return mdxNumber;
    }

    public static void putDimNumber(String field, String dimNumber, Map<String, Set<String>> refDimMap) {
        if (field == null || dimNumber == null || refDimMap == null) {
            return;
        }
        String _dimNumber = dimNumber;
        if ((DimUtils.checkBaseDimensionByField((String)field) || DimensionConstants.DEF_CSL_FIELD.equals(field)) && _dimNumber.indexOf("@") == -1) {
            _dimNumber = DimUtils.getNumber((String)_dimNumber);
        }
        Set<Object> dimNumSet = null;
        if (refDimMap.containsKey(field)) {
            dimNumSet = refDimMap.get(field);
        } else {
            dimNumSet = new HashSet();
            refDimMap.put(field, dimNumSet);
        }
        if (dimNumSet != null) {
            dimNumSet.add(_dimNumber);
        }
    }

    public static boolean hasExp(List<ICalcMember> members) throws ParseException {
        if (members == null || members.isEmpty()) {
            return false;
        }
        boolean check = false;
        for (ICalcMember member : members) {
            boolean _check;
            if (!(member instanceof BizCalcMember) || !(_check = BizExprUtils.hasExp((BizCalcMember)member))) continue;
            check = _check;
        }
        return check;
    }

    public static boolean hasExp(BizCalcMember member) throws ParseException {
        if (member == null) {
            return false;
        }
        boolean check = false;
        List<IExpress> express = null;
        IExpress expr = null;
        BizCalcSubsetInfo subCalc = null;
        int in = member.getCalc().getBizCalcSubset().size();
        for (int i = 0; i < in; ++i) {
            subCalc = member.getCalc().getBizCalcSubset().get(i);
            boolean _check = false;
            express = subCalc.getExpres();
            int jn = express.size();
            for (int j = 0; j < jn; ++j) {
                expr = express.get(j);
                if (expr == null) continue;
                if (expr instanceof BinaryExpr) {
                    _check = BizExprUtils.hasExp((BinaryExpr)expr);
                } else if (expr instanceof ConditionExpr) {
                    _check = BizExprUtils.hasExp((ConditionExpr)expr);
                }
                if (!_check) continue;
                check = _check;
                break;
            }
            if (!_check) continue;
            subCalc.hasFormula = true;
        }
        return check;
    }

    public static boolean hasExp(IExpress expr) {
        if (expr == null) {
            return false;
        }
        boolean check = false;
        if (expr instanceof BinaryExpr) {
            check = BizExprUtils.hasExp((BinaryExpr)expr);
        } else if (expr instanceof ConditionExpr) {
            check = BizExprUtils.hasExp((ConditionExpr)expr);
        } else if (expr instanceof FormulaExpr) {
            check = BizExprUtils.hasExp((FormulaExpr)expr);
        }
        return check;
    }

    public static boolean hasExp(BinaryExpr expr) {
        if (expr == null) {
            return false;
        }
        boolean check = false;
        if (expr.left instanceof BinaryExpr) {
            check = BizExprUtils.hasExp((BinaryExpr)expr.left);
        } else if (expr.left instanceof FormulaExpr) {
            check = BizExprUtils.hasExp((FormulaExpr)expr.left);
        } else if (expr.left instanceof ConditionExpr) {
            check = BizExprUtils.hasExp((ConditionExpr)expr.left);
        }
        if (!check) {
            if (expr.right instanceof BinaryExpr) {
                check = BizExprUtils.hasExp((BinaryExpr)expr.right);
            } else if (expr.right instanceof FormulaExpr) {
                check = BizExprUtils.hasExp((FormulaExpr)expr.right);
            } else if (expr.right instanceof ConditionExpr) {
                check = BizExprUtils.hasExp((ConditionExpr)expr.right);
            }
        }
        return check;
    }

    public static boolean hasExp(ConditionExpr expr) {
        IExpress _expr;
        if (expr == null) {
            return false;
        }
        boolean check = false;
        Iterator<IExpress> iterator = expr.getAllExpresss().iterator();
        while (iterator.hasNext() && !(check = BizExprUtils.hasExp(_expr = iterator.next()))) {
        }
        return check;
    }

    public static boolean hasExp(FormulaExpr expr) {
        return expr != null && (SUPPORT_ACCT.equalsIgnoreCase(expr.formulaName) || SUPPORT_ACCTITEM.equalsIgnoreCase(expr.formulaName) || SUPPORT_MBGREFBGTEM.equalsIgnoreCase(expr.formulaName) || SUPPORT_MBGADJUST.equalsIgnoreCase(expr.formulaName) || SUPPORT_MBGADJUSTDATE.equalsIgnoreCase(expr.formulaName));
    }

    public static boolean hasAcctExp(FormulaExpr expr) {
        return expr != null && SUPPORT_ACCT.equalsIgnoreCase(expr.formulaName);
    }

    public static boolean hasMbgRefBgTemExp(FormulaExpr expr) {
        return expr != null && SUPPORT_MBGREFBGTEM.equalsIgnoreCase(expr.formulaName);
    }

    public static boolean hasMbgAdjustExp(FormulaExpr expr) {
        return expr != null && SUPPORT_MBGADJUST.equalsIgnoreCase(expr.formulaName);
    }

    public static boolean hasMbgAdjustDateExp(FormulaExpr expr) {
        return expr != null && SUPPORT_MBGADJUSTDATE.equalsIgnoreCase(expr.formulaName);
    }

    public static boolean hasMbgFormulaExp(FormulaExpr expr) {
        return BizExprUtils.hasMbgRefBgTemExp(expr) || BizExprUtils.hasMbgAdjustExp(expr) || BizExprUtils.hasMbgAdjustDateExp(expr);
    }

    public static boolean hasAcctItemExp(FormulaExpr expr) {
        return expr != null && SUPPORT_ACCTITEM.equalsIgnoreCase(expr.formulaName);
    }

    public static void getFormulaExpr(IExpress expr, Map<String, FormulaExpr> formulaMaps) {
        if (expr == null || formulaMaps == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            BizExprUtils.getFormulaExpr((BinaryExpr)expr, formulaMaps);
        } else if (expr instanceof FormulaExpr) {
            BizExprUtils.getFormulaExpr((FormulaExpr)expr, formulaMaps);
        }
    }

    public static void getFormulaExpr(BinaryExpr expr, Map<String, FormulaExpr> formulaMaps) {
        if (expr == null || formulaMaps == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            BizExprUtils.getFormulaExpr((BinaryExpr)expr.left, formulaMaps);
        } else if (expr.left instanceof FormulaExpr) {
            BizExprUtils.getFormulaExpr((FormulaExpr)expr.left, formulaMaps);
        }
        if (expr.right instanceof BinaryExpr) {
            BizExprUtils.getFormulaExpr((BinaryExpr)expr.right, formulaMaps);
        } else if (expr.right instanceof FormulaExpr) {
            BizExprUtils.getFormulaExpr((FormulaExpr)expr.right, formulaMaps);
        }
    }

    public static void getFormulaExpr(FormulaExpr expr, Map<String, FormulaExpr> formulaMaps) {
        if (expr == null || formulaMaps == null) {
            return;
        }
        String formulaStr = expr.toString();
        if (!formulaMaps.containsKey(formulaStr)) {
            formulaMaps.put(formulaStr, expr);
        }
    }

    public static boolean hasOrgMember(IExpress expr) {
        boolean check = false;
        if (expr == null) {
            return check;
        }
        if (expr instanceof BinaryExpr) {
            check = BizExprUtils.hasOrgMember((BinaryExpr)expr);
        }
        return check;
    }

    public static boolean hasOrgMember(BinaryExpr expr) {
        boolean check = false;
        if (expr == null) {
            return check;
        }
        if (expr.operType.getSID() == 20) {
            if (expr.left instanceof MdxMemberExpr) {
                check = BizExprUtils.hasOrgMember((MdxMemberExpr)expr.left);
            } else if (expr.left instanceof VariateExpr) {
                check = BizExprUtils.hasOrgMember((VariateExpr)expr.left);
            }
        }
        return check;
    }

    public static boolean hasOrgMember(VariateExpr expr) {
        boolean check = false;
        if (expr == null) {
            return check;
        }
        if (expr.expr != null) {
            check = BizExprUtils.hasOrgMember(expr.expr);
        }
        return check;
    }

    public static boolean hasOrgMember(MdxMemberExpr expr) {
        boolean check = false;
        if (expr == null) {
            return check;
        }
        IExpress memberExpr = null;
        int in = expr.params.size();
        for (int i = 0; i < in; ++i) {
            memberExpr = expr.params.get(i);
            if (!(memberExpr instanceof MemberExpr) || !DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(((MemberExpr)memberExpr).field)) continue;
            check = true;
            break;
        }
        return check;
    }

    public static StringBuffer getMdxFunctionStr(String functionName, String scopeMdxStr, String refield, String isDetail) {
        StringBuffer result = new StringBuffer();
        if (functionName.equals("Ancestors")) {
            result.append("Ascendants").append("(").append(scopeMdxStr).append(")").append(" - ").append(scopeMdxStr);
        } else if (functionName.equals("IAncestors")) {
            result.append("Ascendants").append("(").append(scopeMdxStr).append(")");
        } else if (functionName.equals("Descendants")) {
            if (isDetail != null && !StringUtils.isEmpty((String)isDetail)) {
                boolean isDetailQuery = Boolean.parseBoolean(isDetail);
                String dim = scopeMdxStr.substring(0, scopeMdxStr.indexOf("]") + 1);
                if (isDetailQuery) {
                    result.append(" filter (").append(functionName).append("(").append(scopeMdxStr).append(")").append(",").append(" isLeaf(").append(dim).append(".currentmember)").append(" ) ").append(" - ").append(scopeMdxStr);
                } else {
                    result.append(functionName).append("(").append(scopeMdxStr).append(")").append(" - ").append(" filter (").append(functionName).append("(").append(scopeMdxStr).append(")").append(",").append(" isLeaf(").append(dim).append(".currentmember)").append(" ) ").append(" - ").append(scopeMdxStr);
                }
            } else {
                result.append(functionName).append("(").append(scopeMdxStr).append(")").append(" - ").append(scopeMdxStr);
            }
        } else if (functionName.equals("IDescendants")) {
            if (isDetail != null && !StringUtils.isEmpty((String)isDetail)) {
                boolean isDetailQuery = Boolean.parseBoolean(isDetail);
                String dim = scopeMdxStr.substring(0, scopeMdxStr.indexOf("]") + 1);
                if (isDetailQuery) {
                    result.append(" filter (").append("Descendants").append("(").append(scopeMdxStr).append(")").append(",").append(" isLeaf(").append(dim).append(".currentmember)").append(" ) ");
                } else {
                    result.append("Descendants").append("(").append(scopeMdxStr).append(")").append(" - ").append(" filter (").append("Descendants").append("(").append(scopeMdxStr).append(")").append(",").append(" isLeaf(").append(dim).append(".currentmember)").append(" ) ");
                }
            } else {
                result.append("Descendants").append("(").append(scopeMdxStr).append(")").append(" , ").append(scopeMdxStr);
            }
        } else if (functionName.equals("Children")) {
            if (isDetail != null && !StringUtils.isEmpty((String)isDetail)) {
                boolean isDetailQuery = Boolean.parseBoolean(isDetail);
                String dim = scopeMdxStr.substring(0, scopeMdxStr.indexOf("]") + 1);
                if (isDetailQuery) {
                    result.append(" filter (").append(scopeMdxStr).append(".").append(functionName).append(",").append(" isLeaf(").append(dim).append(".currentmember)").append(" ) ").append(" - ").append(scopeMdxStr);
                } else {
                    result.append(scopeMdxStr).append(".").append(functionName).append(" - ").append(" filter (").append(scopeMdxStr).append(".").append(functionName).append(",").append(" isLeaf(").append(dim).append(".currentmember)").append(" ) ").append(" - ").append(scopeMdxStr);
                }
            } else {
                result.append(scopeMdxStr).append(".").append(functionName);
            }
        } else if (functionName.equals("IChildrens")) {
            if (isDetail != null && !StringUtils.isEmpty((String)isDetail)) {
                boolean isDetailQuery = Boolean.parseBoolean(isDetail);
                String dim = scopeMdxStr.substring(0, scopeMdxStr.indexOf("]") + 1);
                if (isDetailQuery) {
                    result.append(" filter ({").append(scopeMdxStr).append(",").append(scopeMdxStr).append(".").append("Children}").append(",").append(" isLeaf(").append(dim).append(".currentmember)").append(" ) ");
                } else {
                    result.append(scopeMdxStr).append(".").append("Children").append(" - ").append(" filter (").append(scopeMdxStr).append(".").append("Children").append(",").append(" isLeaf(").append(dim).append(".currentmember)").append(" ) ").append(",").append(scopeMdxStr);
                }
            } else {
                result.append(scopeMdxStr).append(".").append("Children").append(" , ").append(scopeMdxStr);
            }
        } else if (functionName.equals("Siblings")) {
            result.append(scopeMdxStr).append(".").append(functionName).append(" - ").append(scopeMdxStr);
        } else if (functionName.equals("ISiblings")) {
            result.append(scopeMdxStr).append(".").append("Siblings");
        } else if (functionName.equals("Parent")) {
            result.append(scopeMdxStr).append(".").append("Parent");
        } else if (functionName.equals("IParent")) {
            result.append(scopeMdxStr).append(".").append("Parent").append(" , ").append(scopeMdxStr);
        }
        return result;
    }

    public static String getDimMemByScopeFunction(String scopeFunction) {
        String param = scopeFunction.substring(scopeFunction.indexOf("(") + 1, scopeFunction.indexOf(")"));
        String srcNum = param.split(",")[0].replace("\"", "");
        return srcNum;
    }

    public static String getScopeNumByScopeMemNum(String scopeNum) {
        if (scopeNum == null) {
            return null;
        }
        String funParam = scopeNum.substring(scopeNum.indexOf("(") + 1, scopeNum.indexOf(")"));
        String funParamStr = funParam.split(",")[0].replace("\"", "");
        if (funParamStr.startsWith("Cos:")) {
            funParamStr = funParamStr.substring(4, funParamStr.length());
        }
        return funParamStr;
    }

    public static String getIsDetailByScopeMemNum(String scopeNum) {
        if (scopeNum == null) {
            return null;
        }
        String funParam = scopeNum.substring(scopeNum.indexOf("(") + 1, scopeNum.indexOf(")"));
        String[] param = funParam.split(",");
        String funParamStr = null;
        if (param.length > 1) {
            funParamStr = funParam.split(",")[1].replace("\"", "");
        }
        return funParamStr;
    }

    public static String getFunctionNameByScopeMemNum(String scopeNum) {
        if (scopeNum == null) {
            return null;
        }
        String functionName = null;
        if (StringUtils.isEmpty((String)scopeNum)) {
            return functionName;
        }
        functionName = scopeNum.substring(scopeNum.indexOf("@") + 1, scopeNum.indexOf("("));
        return functionName;
    }

    public static String transMemberToFunctionFormat(String memberNum, int functionTypeValue) {
        String functionName = null;
        if (StringUtils.isEmpty((String)memberNum)) {
            return functionName;
        }
        if (1 == functionTypeValue) {
            functionName = "@Children(\"" + memberNum + "\",\"\"" + ")";
        } else if (4 == functionTypeValue) {
            functionName = "@IChildrens(\"" + memberNum + "\",\"\"" + ")";
        } else if (2 == functionTypeValue) {
            functionName = "@Descendants(\"" + memberNum + "\",\"\"" + ")";
        } else if (5 == functionTypeValue) {
            functionName = "@IDescendants(\"" + memberNum + "\",\"\"" + ")";
        } else if (3 == functionTypeValue) {
            functionName = "@Siblings(\"" + memberNum + "\"" + ")";
        } else if (6 == functionTypeValue) {
            functionName = "@ISiblings(\"" + memberNum + "\"" + ")";
        }
        return functionName;
    }

    public static String getDimensionNumber(String dimField) {
        String dimensionStr = null;
        dimensionStr = DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(dimField) ? DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER : (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(dimField) ? DimensionBaseConstants.DEF_PERIOD_SRCNUMBER : (DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(dimField) ? DimensionBaseConstants.DEF_ELEMENT_SRCNUMBER : (DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(dimField) ? DimensionBaseConstants.DEF_CURRENCY_SRCNUMBER : (DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(dimField) ? DimensionBaseConstants.DEF_SCENARIO_SRCNUMBER : (DimensionBaseConstants.DEF_VERSION_FIELD.equals(dimField) ? DimensionBaseConstants.DEF_VERSION_SRCNUMBER : (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(dimField) ? DimensionBaseConstants.DEF_INDEX_SRCNUMBER : null))))));
        return dimensionStr;
    }

    public static Set<String> transFunFormatToMember(Set<String> memberSet) {
        String dimensionStr2 = null;
        HashSet<String> result = new HashSet<String>();
        for (String dimensionStr2 : memberSet) {
            if (dimensionStr2.indexOf("@") != -1) {
                dimensionStr2 = BizExprUtils.getDimMemByScopeFunction(dimensionStr2);
            }
            result.add(dimensionStr2);
        }
        return result;
    }

    public static boolean checkFunFormatToMember(Set<String> memberSet) {
        return DimUtils.checkFunFormatToMember(memberSet);
    }

    public static String transOperationType(String operationStr) {
        if (StringUtils.isEmpty((String)operationStr)) {
            return null;
        }
        String result = null;
        if (">=".equals(operationStr)) {
            result = "<";
        } else if ("<".equals(operationStr)) {
            result = ">=";
        } else if ("<=".equals(operationStr)) {
            result = ">";
        } else if (">".equals(operationStr)) {
            result = "<=";
        } else if ("=".equals(operationStr)) {
            result = "<>";
        } else if ("<>".equals(operationStr)) {
            result = "=";
        }
        return result;
    }

    public static String getRemoveFunByScopeMemNum(String scopeNum, String field, BizCalcMember calcMember) {
        if (StringUtils.isEmpty((String)field) || StringUtils.isEmpty((String)scopeNum) || calcMember == null) {
            return null;
        }
        StringBuffer list1 = new StringBuffer();
        StringBuffer list2 = new StringBuffer();
        String param = scopeNum.substring(scopeNum.indexOf("("), scopeNum.lastIndexOf(")"));
        String listOne = param.substring(param.indexOf("[") + 1, param.indexOf("L2") - 2);
        String listTwoTmp = param.substring(param.indexOf("L2"), param.lastIndexOf("]"));
        String listTwo = listTwoTmp.substring(listTwoTmp.indexOf("[") + 1);
        list2 = BizExprUtils.getScriptByListStr(scopeNum, field, calcMember, listTwo);
        list1 = BizExprUtils.getScriptByListStr(scopeNum, field, calcMember, listOne);
        return list2.append("-").append(list1).toString();
    }

    private static StringBuffer getScriptByListStr(String scopeNum, String field, BizCalcMember calcMember, String listStr) {
        StringBuffer result = new StringBuffer();
        if (StringUtils.isEmpty((String)listStr)) {
            return null;
        }
        String curNumber = null;
        Object srcNumber = null;
        String functionName = null;
        String isDetail = scopeNum;
        String[] tmpStrs = null;
        String curRefield = null;
        String member = null;
        String srcNum = null;
        String tmpStr = null;
        String[] members = null;
        if (listStr.indexOf("@") != -1) {
            String[] listParams = listStr.split(",@");
            result.append("{");
            for (int i = 0; i < listParams.length; ++i) {
                curNumber = listParams[i];
                functionName = BizExprUtils.getFunctionNameByScopeMemNum(curNumber);
                scopeNum = BizExprUtils.getScopeNumByScopeMemNum(curNumber);
                isDetail = BizExprUtils.getIsDetailByScopeMemNum(curNumber);
                if (scopeNum != null) {
                    tmpStrs = scopeNum.split(":");
                }
                String tmpfun = new String();
                if (tmpStrs != null) {
                    tmpfun = BizExprUtils.getMdxField(field) + BizExprUtils.getMdxNumber(field, tmpStrs[0], scopeNum, calcMember.getMdxNumMap(), calcMember.getNumInnMap(), calcMember.isOrgLongNumber);
                }
                result.append(BizExprUtils.getMdxFunctionStr(functionName, tmpfun, BizExprUtils.getMdxField(field), isDetail)).append(",");
            }
            if (result.length() > 0) {
                result.delete(result.length() - 1, result.length());
            }
            result.append("} ");
        } else {
            srcNum = listStr.substring(0, listStr.indexOf(":"));
            curRefield = calcMember.getSrcFieldMap().get(srcNum);
            members = listStr.substring(listStr.indexOf(":") + 1, listStr.length()).split(",");
            result.append("{");
            int fillType = -1;
            for (int j = 0; j < members.length; ++j) {
                member = members[j];
                fillType = MbgFunctionHelper.getFillType((String)member);
                member = MbgFunctionHelper.getMemberNumber((String)member);
                tmpStr = srcNum.equals(DimensionConstants.DEF_ORGUNIT_SRCNUMBER) ? member : srcNum + ":" + member;
                if (0 == fillType) {
                    result.append(BizExprUtils.getMdxField(curRefield));
                    result.append(BizExprUtils.getMdxNumber(curRefield, srcNum, tmpStr, calcMember.getMdxNumMap(), calcMember.getNumInnMap(), calcMember.isOrgLongNumber)).append(",");
                    continue;
                }
                String function = BizExprUtils.transMemberToFunctionFormat(member, fillType);
                functionName = BizExprUtils.getFunctionNameByScopeMemNum(function);
                String tmpfun = BizExprUtils.getMdxField(field) + BizExprUtils.getMdxNumber(field, srcNum, srcNum + ":" + member, calcMember.getMdxNumMap(), calcMember.getNumInnMap(), calcMember.isOrgLongNumber);
                isDetail = BizExprUtils.getIsDetailByScopeMemNum(function);
                result.append(BizExprUtils.getMdxFunctionStr(functionName, tmpfun, BizExprUtils.getMdxField(field), isDetail)).append(",");
            }
            if (result.length() > 0) {
                result.delete(result.length() - 1, result.length());
            }
            result.append("}");
        }
        return result;
    }

    public static void putMbgMember(IExpress expr, Map<String, Set<String>> refDimMap, Map<String, String> srcFieldMap, Map<String, Set<String>> executeDimData) {
        BizExprUtils.putMbgMember(null, expr, refDimMap, srcFieldMap, executeDimData);
    }

    public static void putMbgMember(IDimensionParameter paramter, IExpress expr, Map<String, Set<String>> refDimMap, Map<String, String> srcFieldMap, Map<String, Set<String>> executeDimData) {
        if (expr == null || refDimMap == null || srcFieldMap == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            BizExprUtils.putMbgMember(paramter, (BinaryExpr)expr, refDimMap, srcFieldMap, false, executeDimData);
        } else if (expr instanceof ConditionExpr) {
            BizExprUtils.putMbgMember(paramter, (ConditionExpr)expr, refDimMap, srcFieldMap, false, executeDimData);
        } else if (expr instanceof MdxMemberExpr) {
            BizExprUtils.putMbgMember(paramter, (MdxMemberExpr)expr, refDimMap, srcFieldMap, false, executeDimData);
        } else if (expr instanceof FunctionExpr) {
            BizExprUtils.putMbgMember(paramter, (FunctionExpr)expr, refDimMap, srcFieldMap, false, executeDimData);
        } else if (expr instanceof MemberExpr) {
            BizExprUtils.putMbgMember(paramter, (MemberExpr)expr, refDimMap, srcFieldMap);
        }
    }

    public static void putMbgMember(IDimensionParameter paramter, BinaryExpr expr, Map<String, Set<String>> refDimMap, Map<String, String> srcFieldMap, boolean isLeaf, Map<String, Set<String>> executeDimData) {
        if (expr == null || refDimMap == null || srcFieldMap == null) {
            return;
        }
        if (expr.left instanceof BinaryExpr) {
            BizExprUtils.putMbgMember(paramter, (BinaryExpr)expr.left, refDimMap, srcFieldMap, isLeaf, executeDimData);
        } else if (expr.left instanceof MdxMemberExpr) {
            if ("=".equals(expr.operType != null ? expr.operType.toString() : null)) {
                BizExprUtils.putMbgMember(paramter, (MdxMemberExpr)expr.left, refDimMap, srcFieldMap, true, executeDimData);
            } else {
                BizExprUtils.putMbgMember(paramter, (MdxMemberExpr)expr.left, refDimMap, srcFieldMap, false, executeDimData);
            }
        } else if (expr.left instanceof VariateExpr) {
            BizExprUtils.putMbgMember(paramter, (VariateExpr)expr.left, refDimMap, srcFieldMap, isLeaf, executeDimData);
        } else if (expr.left instanceof FunctionExpr) {
            BizExprUtils.putMbgMember(paramter, (FunctionExpr)expr.left, refDimMap, srcFieldMap, isLeaf, executeDimData);
        }
        if (expr.right instanceof BinaryExpr) {
            BizExprUtils.putMbgMember(paramter, (BinaryExpr)expr.right, refDimMap, srcFieldMap, isLeaf, executeDimData);
        } else if (expr.right instanceof MdxMemberExpr) {
            BizExprUtils.putMbgMember(paramter, (MdxMemberExpr)expr.right, refDimMap, srcFieldMap, isLeaf, executeDimData);
        } else if (expr.right instanceof VariateExpr) {
            BizExprUtils.putMbgMember(paramter, (VariateExpr)expr.right, refDimMap, srcFieldMap, isLeaf, executeDimData);
        } else if (expr.right instanceof FunctionExpr) {
            BizExprUtils.putMbgMember(paramter, (FunctionExpr)expr.right, refDimMap, srcFieldMap, isLeaf, executeDimData);
        } else if (expr.right instanceof ConditionExpr) {
            BizExprUtils.putMbgMember(paramter, (ConditionExpr)expr.right, refDimMap, srcFieldMap, isLeaf, executeDimData);
        }
    }

    public static void putMbgMember(IDimensionParameter paramter, ConditionExpr expr, Map<String, Set<String>> dimMemberMap, Map<String, String> srcFieldMap, boolean isLeaf, Map<String, Set<String>> executeDimData) {
        if (expr == null || dimMemberMap == null || srcFieldMap == null) {
            return;
        }
        for (IExpress _expr : expr.getAllExpresss()) {
            if (_expr instanceof BinaryExpr) {
                BizExprUtils.putMbgMember(paramter, (BinaryExpr)_expr, dimMemberMap, srcFieldMap, isLeaf, executeDimData);
                continue;
            }
            if (_expr instanceof ConditionExpr) {
                BizExprUtils.putMbgMember(paramter, (ConditionExpr)_expr, dimMemberMap, srcFieldMap, isLeaf, executeDimData);
                continue;
            }
            if (_expr instanceof MdxMemberExpr) {
                BizExprUtils.putMbgMember(paramter, (MdxMemberExpr)_expr, dimMemberMap, srcFieldMap, isLeaf, executeDimData);
                continue;
            }
            if (!(_expr instanceof FunctionExpr)) continue;
            BizExprUtils.putMbgMember(paramter, (FunctionExpr)_expr, dimMemberMap, srcFieldMap, isLeaf, executeDimData);
        }
    }

    public static void putMbgMember(IDimensionParameter paramter, FunctionExpr expr, Map<String, Set<String>> dimMemberMap, Map<String, String> srcFieldMap, boolean isLeaf, Map<String, Set<String>> executeDimData) {
        if (expr == null || dimMemberMap == null || srcFieldMap == null) {
            return;
        }
        Object param = null;
        String[] params = null;
        int in = expr.params.size();
        for (int i = 0; i < in; ++i) {
            param = expr.params.get(i);
            if (param instanceof FunctionExpr) {
                BizExprUtils.putMbgMember(paramter, (FunctionExpr)param, dimMemberMap, srcFieldMap, isLeaf, executeDimData);
                continue;
            }
            if (param instanceof MdxMemberExpr) {
                BizExprUtils.putMbgMember(paramter, (MdxMemberExpr)param, dimMemberMap, srcFieldMap, isLeaf, executeDimData);
                continue;
            }
            if (param instanceof MemberExpr) {
                BizExprUtils.putMbgMember(paramter, (MemberExpr)param, dimMemberMap, srcFieldMap);
                continue;
            }
            if (param instanceof VariateExpr) {
                BizExprUtils.putMbgMember(paramter, (VariateExpr)param, dimMemberMap, srcFieldMap);
                continue;
            }
            if (param instanceof BinaryExpr) {
                BizExprUtils.putMbgMember(paramter, (BinaryExpr)param, dimMemberMap, srcFieldMap, isLeaf, executeDimData);
                continue;
            }
            if ("ABS".equals(expr.functionName) && param.toString().indexOf("MBR") != -1) {
                try {
                    Parse2RPN parse = null;
                    IExpress expr1 = null;
                    parse = new Parse2RPN(param.toString());
                    parse.parse();
                    MbgExprParse p2 = new MbgExprParse(parse.getTokens());
                    expr1 = p2.parse();
                    BizExprUtils.putMbgMember(expr1, dimMemberMap, srcFieldMap, executeDimData);
                }
                catch (Exception parse) {}
                continue;
            }
            if ("MAX".equals(expr.functionName) || "MIN".equals(expr.functionName) || "AVG".equals(expr.functionName) || "IsMember".equals(expr.functionName)) {
                String memNum = param.toString();
                if (memNum.indexOf(":") == -1) continue;
                String srcNumber = memNum.substring(memNum.indexOf("[") + 1, memNum.indexOf("]"));
                String[] numbers = srcNumber.split(":");
                BizExprUtils.putDimNumber(srcFieldMap.get(numbers[0]), srcNumber, dimMemberMap);
                continue;
            }
            params = param.toString().replace("\"", "").split(":");
            BizExprUtils.putDimNumber(srcFieldMap.get(params[0]), param.toString().replace("\"", ""), dimMemberMap);
        }
    }

    public static void putMbgMember(IDimensionParameter paramter, VariateExpr expr, Map<String, Set<String>> dimMemberMap, Map<String, String> srcFieldMap, boolean isLeaf, Map<String, Set<String>> executeDimData) {
        if (expr == null || dimMemberMap == null || srcFieldMap == null) {
            return;
        }
        if (expr.expr != null) {
            BizExprUtils.putMbgMember(paramter, expr.expr, dimMemberMap, srcFieldMap, isLeaf, executeDimData);
        }
    }

    public static void putMbgMember(IDimensionParameter paramter, MdxMemberExpr expr, Map<String, Set<String>> dimMemberMap, Map<String, String> srcFieldMap, boolean isLeft, Map<String, Set<String>> executeDimData) {
        List<String> bePeriods;
        if (expr == null || dimMemberMap == null || srcFieldMap == null) {
            return;
        }
        IExpress param = null;
        String dimNumber = null;
        String beginPeriod = "";
        String endPeriod = "";
        int in = expr.params.size();
        for (int i = 0; i < in; ++i) {
            param = expr.params.get(i);
            if (param instanceof MemberExpr) {
                if (((MemberExpr)param).field == null) {
                    if (srcFieldMap.containsKey(((MemberExpr)param).srcNumber)) {
                        ((MemberExpr)param).field = srcFieldMap.get(((MemberExpr)param).srcNumber);
                    } else if ("BgP1".equals(((MemberExpr)param).srcNumber) || "BgP2".equals(((MemberExpr)param).srcNumber)) {
                        ((MemberExpr)param).field = DimensionConstants.DEF_PERIOD_FIELD;
                    }
                }
                if ("BgP1".equals(((MemberExpr)param).srcNumber)) {
                    beginPeriod = ((MemberExpr)param).number;
                } else if ("BgP2".equals(((MemberExpr)param).srcNumber)) {
                    endPeriod = ((MemberExpr)param).number;
                }
                dimNumber = ((MemberExpr)param).getDimNumber();
                if ((DimUtils.checkBaseDimensionByField((String)((MemberExpr)param).field) || DimensionConstants.DEF_CSL_FIELD.equals(((MemberExpr)param).field)) && dimNumber.indexOf("@") == -1) {
                    dimNumber = DimUtils.getNumber((String)dimNumber);
                }
                if (isLeft && executeDimData != null && executeDimData.get(((MemberExpr)param).field) != null && !executeDimData.get(((MemberExpr)param).field).contains(dimNumber)) continue;
                BizExprUtils.putDimNumber(((MemberExpr)param).field, ((MemberExpr)param).getDimNumber(), dimMemberMap);
                continue;
            }
            if (!(expr.params.get(i) instanceof FunctionExpr)) continue;
            BizExprUtils.putMbgMember(paramter, (FunctionExpr)param, dimMemberMap, srcFieldMap, isLeft, executeDimData);
        }
        if (!(StringUtils.isEmpty((String)beginPeriod) || StringUtils.isEmpty((String)endPeriod) || paramter == null || paramter.getAllPeriodMap() == null || (bePeriods = BizPtoUtils.getBegin2EndPeriod(beginPeriod, endPeriod, paramter.getAllPeriodMap())) == null || bePeriods.isEmpty())) {
            for (int i = 0; i < bePeriods.size(); ++i) {
                BizExprUtils.putDimNumber(DimensionConstants.DEF_PERIOD_FIELD, bePeriods.get(i), dimMemberMap);
            }
        }
    }

    public static void putMbgMember(IDimensionParameter paramter, MemberExpr expr, Map<String, Set<String>> dimMemberMap, Map<String, String> srcFieldMap) {
        if (expr == null || dimMemberMap == null || srcFieldMap == null) {
            return;
        }
        MemberExpr param = expr;
        if (expr.field == null) {
            param.field = srcFieldMap.get(param.srcNumber);
        }
        BizExprUtils.putDimNumber(param.field, param.getDimNumber(), dimMemberMap);
    }

    public static void putMbgMember(IDimensionParameter paramter, NameExpr expr, Map<String, Set<String>> dimMemberMap, Map<String, String> srcFieldMap) {
        if (expr == null || dimMemberMap == null || srcFieldMap == null) {
            return;
        }
        String dimNumber = BizExprUtils.getDimMemByScopeFunction(expr.toString());
        String srcNumber = DimUtils.getSrcNumber((String)dimNumber);
        String refField = srcFieldMap.get(srcNumber);
        BizExprUtils.putDimNumber(refField, dimNumber, dimMemberMap);
    }

    public static IExpress replaceExp(IExpress expr, Map formulaMap) {
        if (expr == null) {
            return expr;
        }
        if (expr instanceof BinaryExpr) {
            BizExprUtils.replaceExp((BinaryExpr)expr, formulaMap);
        } else if (expr instanceof ConditionExpr) {
            BizExprUtils.replaceExp((ConditionExpr)expr, formulaMap);
        } else if (expr instanceof FormulaExpr) {
            return BizExprUtils.replaceExp((FormulaExpr)expr, formulaMap);
        }
        return expr;
    }

    public static void replaceExp(BinaryExpr expr, Map formulaMap) {
        if (expr == null) {
            return;
        }
        expr.left = BizExprUtils.replaceExp(expr.left, formulaMap);
        expr.right = BizExprUtils.replaceExp(expr.right, formulaMap);
    }

    public static void replaceExp(ConditionExpr expr, Map formulaMap) {
        if (expr == null) {
            return;
        }
        BizExprUtils.replaceExp(expr.conditions, formulaMap);
        BizExprUtils.replaceExp(expr.results, formulaMap);
    }

    public static void replaceExp(List<IExpress> exprs, Map formulaMap) {
        if (exprs != null) {
            for (int i = 0; i < exprs.size(); ++i) {
                exprs.set(i, BizExprUtils.replaceExp(exprs.get(i), formulaMap));
            }
        }
    }

    public static IExpress replaceExp(FormulaExpr expr, Map formulaMap) {
        Object[] obj;
        OperandExpr oExpr = null;
        if (expr != null && (SUPPORT_MBGREFBGTEM.equalsIgnoreCase(expr.formulaName) || SUPPORT_MBGADJUST.equalsIgnoreCase(expr.formulaName) || SUPPORT_MBGADJUST.equalsIgnoreCase(expr.formulaName)) && !formulaMap.isEmpty() && formulaMap.containsKey(expr.toString()) && (obj = (Object[])formulaMap.get(expr.toString())) != null && obj[1] != null) {
            oExpr = new OperandExpr(String.valueOf(obj[1]));
        }
        if (oExpr != null) {
            return oExpr;
        }
        return expr;
    }

    public static boolean hasElimExp(FormulaExpr expr) {
        return expr != null && SUPPORT_ELIMDATA.equalsIgnoreCase(expr.formulaName);
    }

    public static boolean checkIsZeroUpdate(IExpress expr, Map formulaMap) {
        if (expr == null) {
            return false;
        }
        boolean check = false;
        if (expr instanceof BinaryExpr) {
            check = BizExprUtils.checkIsZeroUpdate((BinaryExpr)expr, formulaMap);
        } else if (expr instanceof ConditionExpr) {
            check = BizExprUtils.checkIsZeroUpdate((ConditionExpr)expr, formulaMap);
        } else if (expr instanceof FormulaExpr) {
            check = BizExprUtils.checkIsZeroUpdate((FormulaExpr)expr, formulaMap);
        }
        return check;
    }

    public static boolean checkIsZeroUpdate(BinaryExpr expr, Map formulaMap) {
        if (expr == null) {
            return false;
        }
        boolean check = false;
        if (expr.left instanceof BinaryExpr) {
            check = BizExprUtils.checkIsZeroUpdate((BinaryExpr)expr.left, formulaMap);
        } else if (expr.left instanceof FormulaExpr) {
            check = BizExprUtils.checkIsZeroUpdate((FormulaExpr)expr.left, formulaMap);
        } else if (expr.left instanceof ConditionExpr) {
            check = BizExprUtils.checkIsZeroUpdate((ConditionExpr)expr.left, formulaMap);
        }
        if (!check) {
            if (expr.right instanceof BinaryExpr) {
                check = BizExprUtils.checkIsZeroUpdate((BinaryExpr)expr.right, formulaMap);
            } else if (expr.right instanceof FormulaExpr) {
                check = BizExprUtils.checkIsZeroUpdate((FormulaExpr)expr.right, formulaMap);
            } else if (expr.right instanceof ConditionExpr) {
                check = BizExprUtils.checkIsZeroUpdate((ConditionExpr)expr.right, formulaMap);
            }
        }
        return check;
    }

    public static boolean checkIsZeroUpdate(ConditionExpr expr, Map formulaMap) {
        IExpress _expr;
        if (expr == null) {
            return false;
        }
        boolean check = false;
        Iterator<IExpress> iterator = expr.getAllExpresss().iterator();
        while (iterator.hasNext() && !(check = BizExprUtils.checkIsZeroUpdate(_expr = iterator.next(), formulaMap))) {
        }
        return check;
    }

    public static boolean checkIsZeroUpdate(FormulaExpr expr, Map formulaMap) {
        Object[] obj;
        return expr == null || !SUPPORT_ACCTITEM.equalsIgnoreCase(expr.formulaName) || formulaMap.isEmpty() || !formulaMap.containsKey(expr.toString()) || (obj = (Object[])formulaMap.get(expr.toString())) == null || obj[1] == null || !(obj[1] instanceof BigDecimal) || BgNConstants.ZERO.compareTo((BigDecimal)obj[1]) != 0;
    }
}

