/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgExpressionsParseOrgHelper {
    private static final Logger logger = Logger.getLogger(BgExpressionsParseOrgHelper.class);
    public static final String BGFORMULA_STR = "BGFORMULA";
    public static final String ACCT_STR = "ACCT";
    public static final String ACCTITEM_STR = "ACCTITEM";
    public static final String GETORGATTR_STR = "GetOrgTypVal";
    public static final String IF_STR = "IF";
    private static final String IS_BIZ_FOUMULA = "IS_BIZ_FOUMULA";
    private static final String IS_SIMPLE_FORMULA = "IS_SIMPLE_FORMULA";

    public static boolean checkHasTargetExpressions(Cell cell, boolean isExcelFunction) {
        if (BgNFSHelper.checkHasExpression((Cell)cell)) {
            String _expressions = BgNFSHelper.getExpression((Cell)cell);
            if (StringUtils.isEmpty((String)_expressions)) {
                return false;
            }
            HashMap isTheTargetExpr = new HashMap();
            BgExpressionsParseOrgHelper.processExpressionsOrgParam(_expressions, null, null, isTheTargetExpr);
            if (isExcelFunction) {
                return isTheTargetExpr.get(IS_SIMPLE_FORMULA) instanceof Boolean;
            }
            return isTheTargetExpr.get(IS_BIZ_FOUMULA) instanceof Boolean;
        }
        return false;
    }

    public static String processExpressionsOrgParam(String expressions, final String orgNumber, final Map mappingMap, final Map isTheTargetExpr) {
        if (StringUtils.isEmpty((String)expressions)) {
            return null;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressions);
            if (expression instanceof Ref3DExpr) {
                return null;
            }
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgExpressionsParseOrgHelper.checkExpression(expr, orgNumber, mappingMap, isTheTargetExpr);
                }
            });
            _expressions = '=' + expression.toString();
        }
        catch (Exception ex) {
            logger.error((Object)expressions);
            logger.error((Object)ex);
        }
        return _expressions;
    }

    protected static Expression checkExpression(Expression expression, String orgNumber, Map mappingMap, Map isTheTargetExpr) {
        if (expression instanceof FunctionExpr) {
            expression = BgExpressionsParseOrgHelper.checkFunctionExpr((FunctionExpr)expression, orgNumber, mappingMap, isTheTargetExpr);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgExpressionsParseOrgHelper.checkBinaryOperationExpr((BinaryOperationExpr)expression, orgNumber, mappingMap, isTheTargetExpr);
        }
        return expression;
    }

    private static Expression checkFunctionExpr(FunctionExpr funExpr, String orgNumber, Map mappingMap, Map isTheTargetExpr) {
        String funcionName = funExpr.funcionName;
        try {
            if (BgExpressionsParseOrgHelper.isTheTargetExpression(funcionName)) {
                FunctionExpr _expression = funExpr;
                Expression p0 = (Expression)funExpr.parameters.get(0);
                if (p0 instanceof StringExpr) {
                    StringExpr sp = (StringExpr)p0;
                    String valueStr = sp.value;
                    String[] pp = valueStr.split(";");
                    if (pp != null && pp.length > 1) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < pp.length; ++i) {
                            funExpr.parameters.set(0, new StringExpr(pp[i]));
                            if (sb.length() > 1) {
                                sb.append('+');
                            }
                            funExpr.output(sb);
                        }
                        _expression = ExcelFormulaPaserHelper.parse((String)sb.toString());
                        _expression = BgExpressionsParseOrgHelper.checkExpression((Expression)_expression, orgNumber, mappingMap, isTheTargetExpr);
                    }
                }
                if (_expression instanceof FunctionExpr) {
                    BgExpressionsParseOrgHelper.checkExpressionParam(_expression, orgNumber, mappingMap, isTheTargetExpr);
                }
                return _expression;
            }
            if (IF_STR.equalsIgnoreCase(funcionName) && isTheTargetExpr != null) {
                isTheTargetExpr.put(IS_SIMPLE_FORMULA, Boolean.TRUE);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return funExpr;
    }

    private static BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, String orgNumber, Map mappingMap, Map isTheTargetExpr) {
        boExpr.left = BgExpressionsParseOrgHelper.checkExpression(boExpr.left, orgNumber, mappingMap, isTheTargetExpr);
        boExpr.right = BgExpressionsParseOrgHelper.checkExpression(boExpr.right, orgNumber, mappingMap, isTheTargetExpr);
        return boExpr;
    }

    private static void checkExpressionParam(FunctionExpr funExpr, String orgNumber, Map mappingMap, Map isTheTargetExpr) {
        String funcionName = funExpr.funcionName;
        List parameter = funExpr.parameters;
        if (BgExpressionsParseOrgHelper.isTheTargetExpression(funcionName)) {
            if (isTheTargetExpr != null) {
                isTheTargetExpr.put(IS_BIZ_FOUMULA, Boolean.TRUE);
            }
            if (StringUtils.isEmpty((String)orgNumber)) {
                return;
            }
            StringExpr param = null;
            if (ACCTITEM_STR.equals(funcionName)) {
                String key;
                String tempNumber;
                StringExpr param0 = (StringExpr)parameter.get(0);
                param = (StringExpr)parameter.get(1);
                if (!StringUtils.isEmpty((String)param0.value) && mappingMap != null && !StringUtils.isEmpty((String)(tempNumber = (String)mappingMap.get(key = param0.value + "@" + orgNumber)))) {
                    orgNumber = tempNumber;
                }
            } else {
                param = (StringExpr)parameter.get(0);
            }
            param.value = orgNumber;
        }
    }

    public static boolean isTheTargetExpression(String funcionName) {
        return BGFORMULA_STR.equalsIgnoreCase(funcionName) || ACCT_STR.equalsIgnoreCase(funcionName) || ACCTITEM_STR.equalsIgnoreCase(funcionName) || GETORGATTR_STR.equalsIgnoreCase(funcionName);
    }
}

