/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgCtrSettingFacadeFactory;
import com.kingdee.eas.ma.budget.BgCtrlSetHelper;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgFormulaObject;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgPermissionFactory;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemModifyEnum;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgFSHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.BgFSHelper");
    public static final String SIGN_DATA_ID = "SIGN_DATA_ID";
    public static final String SIGN_DATA_SOURCE = "SIGN_DATA_SOURCE";
    public static final String SIGN_DATA_SOURCE_OTHER = "SIGN_DATA_SOURCE_OTHER";
    public static final String DATA_SOURCE_SUPERIOR = "DATA_SOURCE_SUPERIOR";
    public static final String DATA_SOURCE_TEMPLATE = "DATA_SOURCE_TEMPLATE";
    public static final String DATA_SOURCE_EDIT = "DATA_SOURCE_EDIT";
    public static final String DATA_SOURCE_COLLECT = "DATA_SOURCE_COLLECT";
    public static final String DATA_SOURCE_TEMP = "DATA_SOURCE_TEMP";
    public static final String DATA_SOURCE_TEMP_FUDIAN = "DATA_SOURCE_TEMP_FUDIAN";
    public static final String SIGN_TABLE = "AAABBCCCC";
    public static final String SIGN_ROW = "BBBCCAAA";
    public static final String SIGN_COL = "CCCAABBB";
    public static final String IS_COLLECT = "IS_COLLECT";
    public static final String COLLECT_BGFORM = "COLLECT_BGFORM";
    public static final String IS_COLLECT_ADJUST = "IS_COLLECT_ADJUST";
    public static final String COLLECT_ORGUNIT = "COLLECT_ORGUNIT";
    public static final String COLLECT_SCHEME = "COLLECT_SCHEME";
    public static final String COLLECT_FORM_ID = "COLLECT_FORM_ID";
    public static final String COLLECT_FORMULA = "COLLECT_FORMULA";
    public static final String SIGN_SUBMIT_FORM_ADJUST = "SIGN_SUBMIT_FORM_ADJUST";
    public static final String DATA_FORMULA = "DATA_FORMULA";
    public static final String DATA_FORMULA_NEW = "DATA_FORMULA_NEW";
    public static final String DATA_FORMULA_OLD = "DATA_FORMULA_OLD";
    public static final String DATA_BUDGET_VALUE = "DATA_BUDGET_VALUE";
    public static final String DATA_ACTUAL_VALUE = "DATA_ACTUAL_VALUE";
    public static final String DATA_ROW_INDEX = "DATA_ROW_INDEX";
    public static final String DATA_COL_INDEX = "DATA_COL_INDEX";
    public static final String DATA_CTRL_ISCONTROL = "DATA_CTRL_ISCONTROL";
    public static final String DATA_CTRL_ISFLEXIBLE = "DATA_CTRL_ISFLEXIBLE";
    public static final String DATA_CTRL_FLEXPARAM = "DATA_CTRL_FLEXPARAM";
    public static final String DATA_CTRL_CTRLTYPE = "DATA_CTRL_CTRLTYPE";
    public static final String DATA_CTRL_ISGROUPCTRL = "DATA_CTRL_ISGROUPCTRL";
    public static final String DATA_CTRL_GROUPNO = "DATA_CTRL_GROUPNO";
    private static final String routineStr = EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"89_BgFCHelper");
    private static final String findStr = "0";

    public static void initAliasTemplate(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        IColumn column = null;
        Map useMap = null;
        int rowCount = table.getExpandedRowCount();
        int colCount = table.getExpandedColumnCount();
        int in = rowCount;
        for (int i = 0; i < in; ++i) {
            row = table.getRow(i);
            if (row.getUserObject() == null || !(row.getUserObject() instanceof HashMap) || (useMap = (Map)row.getUserObject()).containsKey(SIGN_DATA_SOURCE)) continue;
            useMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_TEMPLATE);
        }
        int jn = colCount;
        for (int j = 0; j < jn; ++j) {
            column = table.getColumn(j);
            if (column.getUserObject() == null || !(column.getUserObject() instanceof HashMap) || (useMap = (Map)column.getUserObject()).containsKey(SIGN_DATA_SOURCE)) continue;
            useMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_TEMPLATE);
        }
    }

    public static void initAliasObject(KDTable table) {
    }

    public static void initAliasObjectTem(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        IColumn column = null;
        ICell cell = null;
        RptCell rptCell = null;
        Map useMap = null;
        HashMap aliMap = new HashMap();
        int rowCount = table.getExpandedRowCount();
        int colCount = table.getExpandedColumnCount();
        boolean isClear = true;
        if (table.getUserObject() != null && table.getUserObject() instanceof HashMap && !(useMap = (Map)table.getUserObject()).containsKey(SIGN_DATA_ID)) {
            useMap.put(SIGN_DATA_ID, BOSUuid.create((String)SIGN_TABLE));
        }
        int in = rowCount;
        for (int i = 0; i < in; ++i) {
            row = table.getRow(i);
            isClear = true;
            if (row == null) continue;
            useMap = row.getUserObject() != null && row.getUserObject() instanceof Map ? (Map)row.getUserObject() : null;
            int jn = colCount;
            for (int j = 0; j < jn; ++j) {
                cell = row.getCell(j);
                if (cell == null) continue;
                if (cell.getValue() != null && cell.getValue().toString().trim().length() > 0 || BgFSHelper.cellIsHavaExpression(cell)) {
                    if (useMap == null) {
                        useMap = (Map)row.getUserObject();
                    } else {
                        if (!useMap.containsKey(SIGN_DATA_ID)) {
                            useMap.put(SIGN_DATA_ID, BOSUuid.create((String)SIGN_ROW));
                        }
                        if (!useMap.containsKey(SIGN_DATA_SOURCE)) {
                            useMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
                        }
                    }
                    aliMap.put(String.valueOf(j), null);
                    isClear = false;
                }
                if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell) {
                    rptCell = (RptCell)cell.getUserObject();
                    if (BgFSHelper.checkHasFormulaOfCell(rptCell) || BgFSHelper.checkHasExpressionsOfCell(rptCell) || BgFSHelper.checkHasFormulaOfBgItem(rptCell) || BgFSHelper.checkHasFormulaOfBgElement(rptCell) || BgFSHelper.checkHasFormulaOfBgPeriod(rptCell) || BgFSHelper.checkHasFormulaOfCurrency(rptCell) || BgFSHelper.checkCellIsLockedFromSuper(rptCell) || BgFSHelper.checkIsLinkCell(rptCell) || BgFSHelper.checkHasComment(rptCell) || BgFSHelper.checkHasOther(rptCell)) {
                        if (useMap == null) {
                            useMap = (Map)row.getUserObject();
                        } else {
                            if (!useMap.containsKey(SIGN_DATA_ID)) {
                                useMap.put(SIGN_DATA_ID, BOSUuid.create((String)SIGN_ROW));
                            }
                            if (!useMap.containsKey(SIGN_DATA_SOURCE)) {
                                useMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
                            }
                        }
                        aliMap.put(String.valueOf(j), null);
                        isClear = false;
                        continue;
                    }
                    cell.setUserObject(null);
                    continue;
                }
                cell.setUserObject(null);
            }
            if (!isClear || row.getUserObject() == null) continue;
            row.setUserObject(null);
        }
        int jn = colCount;
        for (int j = 0; j < jn; ++j) {
            column = table.getColumn(j);
            isClear = true;
            if (column == null) continue;
            useMap = column.getUserObject() != null && column.getUserObject() instanceof Map ? (Map)column.getUserObject() : null;
            if (aliMap.containsKey(String.valueOf(column.getColumnIndex()))) {
                if (useMap == null) {
                    BgSHelper.setColObject(column, SIGN_DATA_ID, BOSUuid.create((String)SIGN_COL));
                    BgSHelper.setColObject(column, SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
                    useMap = (Map)column.getUserObject();
                } else {
                    if (!useMap.containsKey(SIGN_DATA_ID)) {
                        useMap.put(SIGN_DATA_ID, BOSUuid.create((String)SIGN_COL));
                    }
                    if (!useMap.containsKey(SIGN_DATA_SOURCE)) {
                        useMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
                    }
                }
                isClear = false;
            } else {
                int in2 = rowCount;
                for (int i = 0; i < in2; ++i) {
                    cell = table.getCell(i, j);
                    if (cell == null) continue;
                    if (cell.getValue() != null && cell.getValue().toString().trim().length() > 0 || BgFSHelper.cellIsHavaExpression(cell)) {
                        if (useMap == null) {
                            BgSHelper.setColObject(column, SIGN_DATA_ID, BOSUuid.create((String)SIGN_COL));
                            BgSHelper.setColObject(column, SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
                            useMap = (Map)column.getUserObject();
                        } else {
                            if (!useMap.containsKey(SIGN_DATA_ID)) {
                                useMap.put(SIGN_DATA_ID, BOSUuid.create((String)SIGN_ROW));
                            }
                            if (!useMap.containsKey(SIGN_DATA_SOURCE)) {
                                useMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
                            }
                        }
                        isClear = false;
                    }
                    if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell) {
                        rptCell = (RptCell)cell.getUserObject();
                        if (BgFSHelper.checkHasFormulaOfCell(rptCell) || BgFSHelper.checkHasExpressionsOfCell(rptCell) || BgFSHelper.checkHasFormulaOfBgItem(rptCell) || BgFSHelper.checkHasFormulaOfBgElement(rptCell) || BgFSHelper.checkHasFormulaOfBgPeriod(rptCell) || BgFSHelper.checkHasFormulaOfCurrency(rptCell) || BgFSHelper.checkIsLinkCell(rptCell) || BgFSHelper.checkHasComment(rptCell) || BgFSHelper.checkHasOther(rptCell)) {
                            if (useMap == null) {
                                BgSHelper.setColObject(column, SIGN_DATA_ID, BOSUuid.create((String)SIGN_COL));
                                BgSHelper.setColObject(column, SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
                                useMap = (Map)column.getUserObject();
                            } else {
                                if (!useMap.containsKey(SIGN_DATA_ID)) {
                                    useMap.put(SIGN_DATA_ID, BOSUuid.create((String)SIGN_ROW));
                                }
                                if (!useMap.containsKey(SIGN_DATA_SOURCE)) {
                                    useMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
                                }
                            }
                            isClear = false;
                            continue;
                        }
                        cell.setUserObject(null);
                        continue;
                    }
                    cell.setUserObject(null);
                }
            }
            if (!isClear || column.getUserObject() == null) continue;
            column.setUserObject(null);
        }
    }

    public static boolean cellIsHavaExpression(ICell cell) {
        RptCell rptCell;
        if (cell.getExpressions() != null && cell.getExpressions().trim().length() > 0) {
            return true;
        }
        if (cell.getValue() != null && cell.getValue() instanceof BgFormulaObject) {
            BgFormulaObject obj = (BgFormulaObject)cell.getValue();
            if (obj.getBgActualFormula() != null && obj.getBgActualFormula().trim().length() > 0) {
                return true;
            }
            if (obj.getBgDataFormula() != null && obj.getBgDataFormula().trim().length() > 0) {
                return true;
            }
        }
        if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell && (rptCell = (RptCell)cell.getUserObject()).getItemFormula() != null) {
            return BgFSHelper.checkHasExpressionsOfCell(rptCell);
        }
        return false;
    }

    public static void cellFormIsHaveUserObject(ICell cell) {
        if (cell == null) {
            return;
        }
        if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) {
            return;
        }
        RptCell rptCell = (RptCell)cell.getUserObject();
        if (rptCell.getItemFormula() == null) {
            cell.setUserObject(null);
            return;
        }
        if (rptCell.getItemFormulaLine() != null && rptCell.getItemFormulaLine().trim().length() > 0) {
            return;
        }
        if (BgFSHelper.checkHasFormulaOfCell(rptCell) || BgFSHelper.checkHasExpressionsOfCell(rptCell) || BgFSHelper.checkHasFormulaOfBgItem(rptCell) || BgFSHelper.checkHasFormulaOfBgElement(rptCell) || BgFSHelper.checkHasFormulaOfBgPeriod(rptCell) || BgFSHelper.checkHasFormulaOfCurrency(rptCell) || BgFSHelper.checkIsLinkCell(rptCell) || BgFSHelper.checkHasComment(rptCell) || BgFSHelper.checkHasOther(rptCell)) {
            return;
        }
        cell.setUserObject(null);
    }

    public static void updateAliasSuperior(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        IColumn column = null;
        Map aliMap = null;
        int iRowCount = table.getExpandedRowCount();
        int iColCount = table.getExpandedColumnCount();
        for (int rowIndex = 0; rowIndex < iRowCount; ++rowIndex) {
            row = table.getRow(rowIndex);
            if (row == null || row.getUserObject() == null || !(row.getUserObject() instanceof HashMap) || !(aliMap = (Map)row.getUserObject()).containsKey(SIGN_DATA_SOURCE)) continue;
            aliMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_SUPERIOR);
        }
        for (int colIndex = 0; colIndex < iColCount; ++colIndex) {
            column = table.getColumn(colIndex);
            if (column == null || column.getUserObject() == null || !(column.getUserObject() instanceof HashMap) || !(aliMap = (Map)column.getUserObject()).containsKey(SIGN_DATA_SOURCE)) continue;
            aliMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_SUPERIOR);
        }
    }

    public static void updateAliasCantUpdate(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        IColumn column = null;
        ICell cell = null;
        RptCell rptCell = null;
        Map tmpMap = null;
        String source = null;
        int rowCount = table.getExpandedRowCount();
        int colCount = table.getExpandedColumnCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = table.getRow(rowIndex);
            if (row.getUserObject() != null && row.getUserObject() instanceof HashMap && (tmpMap = (Map)row.getUserObject()).containsKey(SIGN_DATA_SOURCE) && (source = (String)tmpMap.get(SIGN_DATA_SOURCE)) != null && source.equals(DATA_SOURCE_COLLECT)) {
                tmpMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
                tmpMap.put(SIGN_DATA_SOURCE_OTHER, DATA_SOURCE_COLLECT);
            }
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                if (rowIndex == 0 && (column = table.getColumn(colIndex)).getUserObject() != null && column.getUserObject() instanceof HashMap && (tmpMap = (Map)column.getUserObject()).containsKey(SIGN_DATA_SOURCE) && (source = (String)tmpMap.get(SIGN_DATA_SOURCE)) != null && source.equals(DATA_SOURCE_COLLECT)) {
                    tmpMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
                    tmpMap.put(SIGN_DATA_SOURCE_OTHER, DATA_SOURCE_COLLECT);
                }
                if (!BgFSHelper.checkHasFormulaOfCell(cell = table.getCell(rowIndex, colIndex))) continue;
                rptCell = (RptCell)cell.getUserObject();
                rptCell.getItemFormula().putExt("BGITEM_CANUPDATE", "false");
            }
        }
    }

    public static void updateAliasObject(KDTable table) {
        if (table == null) {
            return;
        }
        IRow row = null;
        IColumn column = null;
        Map aliMap = null;
        BOSUuid uuid = null;
        String sourceString = null;
        int in = table.getBody().size();
        for (int i = 0; i < in; ++i) {
            row = table.getRow(i);
            if (row == null || row.getUserObject() == null || !(row.getUserObject() instanceof HashMap)) continue;
            aliMap = (Map)row.getUserObject();
            if (aliMap.containsKey("COLLECT_DATA_ID")) {
                uuid = (BOSUuid)aliMap.get("COLLECT_DATA_ID");
                aliMap.remove("COLLECT_DATA_ID");
                aliMap.put(SIGN_DATA_ID, uuid);
            }
            if (!aliMap.containsKey("COLLECT_DATA_SOURCE")) continue;
            sourceString = (String)aliMap.get("COLLECT_DATA_SOURCE");
            aliMap.remove("COLLECT_DATA_SOURCE");
            if (sourceString.equals("COLLECT_SOURCE_COLLECT")) {
                aliMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_COLLECT);
                continue;
            }
            if (!sourceString.equals("COLLECT_SOURCE_EDIT")) continue;
            aliMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
        }
        int jn = table.getColumnCount();
        for (int j = 0; j < jn; ++j) {
            column = table.getColumn(j);
            if (column == null || column.getUserObject() == null || !(column.getUserObject() instanceof HashMap)) continue;
            aliMap = (Map)column.getUserObject();
            if (aliMap.containsKey("COLLECT_DATA_ID")) {
                uuid = (BOSUuid)aliMap.get("COLLECT_DATA_ID");
                aliMap.remove("COLLECT_DATA_ID");
                aliMap.put(SIGN_DATA_ID, uuid);
            }
            if (!aliMap.containsKey("COLLECT_DATA_SOURCE")) continue;
            sourceString = (String)aliMap.get("COLLECT_DATA_SOURCE");
            aliMap.remove("COLLECT_DATA_SOURCE");
            if (sourceString.equals("COLLECT_SOURCE_COLLECT")) {
                aliMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_COLLECT);
                continue;
            }
            if (!sourceString.equals("COLLECT_SOURCE_EDIT")) continue;
            aliMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_EDIT);
        }
    }

    public static void removeNullRows(KDTable table) {
    }

    public static void removeNullAliasRows(KDTable table) {
    }

    public static void removeAllNullRows(KDTable table) {
    }

    public static void removeNullCols(KDTable table) {
        if (table == null) {
            return;
        }
        boolean isClear = false;
        IColumn column = null;
        BOSUuid aliasId = null;
        int colIndex = 0;
        int colCount = table.getColumnCount();
        int minIndex = -1;
        int maxIndex = -1;
        for (colIndex = 0; colIndex < colCount; ++colIndex) {
            column = table.getColumn(colIndex);
            if (column.getUserObject() == null || !(column.getUserObject() instanceof HashMap) || (aliasId = (BOSUuid)BgSHelper.getColObject(column, SIGN_DATA_ID)) == null) continue;
            minIndex = minIndex == -1 ? colIndex : minIndex;
            maxIndex = colIndex;
        }
        if (maxIndex > minIndex) {
            for (colIndex = minIndex; colIndex <= maxIndex; ++colIndex) {
                column = table.getColumn(colIndex);
                if (column.getUserObject() != null && column.getUserObject() instanceof HashMap) {
                    aliasId = (BOSUuid)BgSHelper.getColObject(column, SIGN_DATA_ID);
                    if (aliasId != null && !isClear) {
                        isClear = true;
                    }
                } else {
                    aliasId = null;
                }
                if (aliasId != null || !isClear) continue;
                table.removeColumn(column.getColumnIndex());
                --colIndex;
                --maxIndex;
            }
        }
    }

    public static void removeAllNullCols(KDTable table) {
        if (table == null) {
            return;
        }
        IColumn column = null;
        BOSUuid aliasId = null;
        int colIndex = 0;
        int colCount = table.getColumnCount();
        for (colIndex = colCount - 1; colIndex >= 0; --colIndex) {
            column = table.getColumn(colIndex);
            if (column.getUserObject() != null && column.getUserObject() instanceof HashMap) {
                aliasId = (BOSUuid)BgSHelper.getColObject(column, SIGN_DATA_ID);
                if (aliasId != null) continue;
                table.removeColumn(colIndex);
                continue;
            }
            table.removeColumn(colIndex);
        }
    }

    public static void removeTempRowsAndCols(KDTable table) {
        if (table == null) {
            return;
        }
        String sourceString = null;
        Map useMap = null;
        IRow row = null;
        IColumn column = null;
        for (int rowIndex = table.getBody().size() - 1; rowIndex >= 0; --rowIndex) {
            row = table.getRow(rowIndex);
            if (row == null || row.getUserObject() == null || !(row.getUserObject() instanceof HashMap) || !(useMap = (Map)row.getUserObject()).containsKey(SIGN_DATA_SOURCE) || !(sourceString = (String)useMap.get(SIGN_DATA_SOURCE)).equals(DATA_SOURCE_TEMP)) continue;
            BgFSHelper.removeCellsOfRow(table, row.getRowIndex(), table.getColumnCount());
            table.removeRow(row.getRowIndex());
        }
        for (int colIndex = table.getColumnCount() - 1; colIndex >= 0; --colIndex) {
            column = table.getColumn(colIndex);
            if (column == null || column.getUserObject() == null || !(column.getUserObject() instanceof HashMap) || !(useMap = (Map)column.getUserObject()).containsKey(SIGN_DATA_SOURCE) || !(sourceString = (String)useMap.get(SIGN_DATA_SOURCE)).equals(DATA_SOURCE_TEMP)) continue;
            BgFSHelper.removeCellsOfCol(table, column.getColumnIndex(), table.getBody().size());
            table.removeColumn(column.getColumnIndex());
        }
    }

    public static void removeCollRowsAndCols(KDTable table) {
        if (table == null) {
            return;
        }
        String sourceString = null;
        Map useMap = null;
        IRow row = null;
        IColumn column = null;
        ICell cell = null;
        int colCount = table.getExpandedColumnCount();
        for (int rowIndex = table.getBody().size() - 1; rowIndex >= 0; --rowIndex) {
            row = table.getRow(rowIndex);
            if (row == null || row.getUserObject() == null || !(row.getUserObject() instanceof HashMap) || !(useMap = (Map)row.getUserObject()).containsKey(SIGN_DATA_SOURCE)) continue;
            sourceString = (String)useMap.get(SIGN_DATA_SOURCE);
            if (sourceString.equals(DATA_SOURCE_COLLECT)) {
                BgFSHelper.removeCellsOfRow(table, row.getRowIndex(), table.getColumnCount());
                table.removeRow(row.getRowIndex());
                continue;
            }
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                cell = row.getCell(colIndex);
                BgFSHelper.clearGatherCell(cell);
            }
        }
        for (int colIndex = table.getColumnCount() - 1; colIndex >= 0; --colIndex) {
            column = table.getColumn(colIndex);
            if (column == null || column.getUserObject() == null || !(column.getUserObject() instanceof HashMap) || !(useMap = (Map)column.getUserObject()).containsKey(SIGN_DATA_SOURCE) || !(sourceString = (String)useMap.get(SIGN_DATA_SOURCE)).equals(DATA_SOURCE_COLLECT)) continue;
            BgFSHelper.removeCellsOfCol(table, column.getColumnIndex(), table.getBody().size());
            table.removeColumn(column.getColumnIndex());
        }
    }

    private static void removeCellsOfRow(KDTable table, int rowIndex, int colSize) {
        if (table == null) {
            return;
        }
        ICell cell = null;
        for (int i = 0; i < colSize; ++i) {
            cell = table.getCell(rowIndex, i);
            if (cell == null) continue;
            cell.setValue(null);
            cell.setUserObject(null);
        }
    }

    private static void removeCellsOfCol(KDTable table, int colIndex, int rowSize) {
        if (table == null) {
            return;
        }
        ICell cell = null;
        for (int i = 0; i < rowSize; ++i) {
            cell = table.getCell(i, colIndex);
            if (cell == null) continue;
            cell.setValue(null);
            cell.setUserObject(null);
        }
    }

    public static void updateAliasOfTemp(KDTable table) {
        if (table == null) {
            return;
        }
        String sourceString = null;
        Map tmpMap = null;
        IRow row = null;
        IColumn column = null;
        ICell cell = null;
        int rowCount = table.getExpandedRowCount();
        int colCount = table.getExpandedColumnCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = table.getRow(rowIndex);
            if (row == null || row.getUserObject() == null || !(row.getUserObject() instanceof HashMap) || !(tmpMap = (Map)row.getUserObject()).containsKey(SIGN_DATA_SOURCE)) continue;
            sourceString = (String)tmpMap.get(SIGN_DATA_SOURCE);
            if (sourceString.equals(DATA_SOURCE_COLLECT)) {
                tmpMap.put(SIGN_DATA_ID, BOSUuid.create((String)SIGN_ROW));
                tmpMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_TEMP);
                continue;
            }
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                cell = row.getCell(colIndex);
                BgFSHelper.clearGatherCell(cell);
            }
        }
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            column = table.getColumn(colIndex);
            if (column == null || column.getUserObject() == null || !(column.getUserObject() instanceof HashMap) || !(tmpMap = (Map)column.getUserObject()).containsKey(SIGN_DATA_SOURCE) || !(sourceString = (String)tmpMap.get(SIGN_DATA_SOURCE)).equals(DATA_SOURCE_COLLECT)) continue;
            tmpMap.put(SIGN_DATA_ID, BOSUuid.create((String)SIGN_COL));
            tmpMap.put(SIGN_DATA_SOURCE, DATA_SOURCE_TEMP);
        }
    }

    private static void clearGatherCell(ICell cell) {
        RptCell rptCell;
        String sourceString;
        if (cell == null) {
            return;
        }
        if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell && (sourceString = (rptCell = (RptCell)cell.getUserObject()).getItemFormula().getExt(SIGN_DATA_SOURCE)) != null && DATA_SOURCE_COLLECT.equals(sourceString)) {
            cell.setValue(null);
            cell.setUserObject(null);
        }
    }

    public static String[] getFormulaInfo(Map map, String formulaString) {
        if (formulaString == null || formulaString.trim().length() == 0) {
            return null;
        }
        String[] parameter = null;
        List formulaHint = null;
        FormulaHint formulas = null;
        if (map != null && map.containsKey(formulaString)) {
            parameter = (String[])map.get(formulaString);
        } else {
            try {
                formulaHint = TableToolkit.parseFormula((String)formulaString, (boolean)false);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
            if (formulaHint != null) {
                formulas = (FormulaHint)formulaHint.get(0);
                parameter = formulas.getParams();
                if (map != null) {
                    map.put(formulaString, parameter);
                }
            }
        }
        return parameter;
    }

    public static String[] getFormulaInfo(String formulaString) {
        if (formulaString == null || formulaString.trim().length() == 0) {
            return null;
        }
        String[] parameter = null;
        List formulaHint = null;
        FormulaHint formulas = null;
        try {
            formulaHint = TableToolkit.parseFormula((String)formulaString, (boolean)false);
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        if (formulaHint != null) {
            formulas = (FormulaHint)formulaHint.get(0);
            parameter = formulas.getParams();
        }
        return parameter;
    }

    public static String getFormulaOfCell(ICell curCell) {
        RptCell rptCell;
        String formulaString;
        if (curCell != null && curCell.getUserObject() != null && curCell.getUserObject() instanceof RptCell && (formulaString = (rptCell = (RptCell)curCell.getUserObject()).getItemFormulaLine()) != null && formulaString.trim().length() > 0) {
            return formulaString;
        }
        return null;
    }

    public static String getFormulaOfCell(RptCell rptCell) {
        String formulaString;
        if (rptCell != null && (formulaString = rptCell.getItemFormulaLine()) != null && formulaString.trim().length() > 0) {
            return formulaString;
        }
        return null;
    }

    public static String getExpressionsOfCell(ICell curCell) {
        if (curCell != null && curCell.getExpressions() != null && curCell.getExpressions().trim().length() > 0) {
            return curCell.getExpressions();
        }
        return null;
    }

    public static boolean checkCanUpdateOfCell(ICell curCell) {
        if (curCell == null) {
            return false;
        }
        if (curCell.getUserObject() != null && curCell.getUserObject() instanceof RptCell) {
            RptCell rptCell = (RptCell)curCell.getUserObject();
            if (rptCell.getItemFormula() == null) {
                return true;
            }
            if (rptCell.getItemFormula().getExt("BGITEM_CANUPDATE") == null) {
                rptCell.getItemFormula().putExt("BGITEM_CANUPDATE", "true");
                return true;
            }
            if (rptCell.getItemFormula().getExt("BGITEM_CANUPDATE").equals("false")) {
                return false;
            }
            if (rptCell.getItemFormula().getExt("BGITEM_CANUPDATE").equals("true")) {
                return true;
            }
        }
        return true;
    }

    public static boolean checkHasFormulaOfCell(ICell curCell) {
        String formulaString = BgFSHelper.getFormulaOfCell(curCell);
        return !StringUtils.isEmpty((String)formulaString);
    }

    public static boolean checkHasFormulaOfCell(RptCell curCell) {
        String formulaString = BgFSHelper.getFormulaOfCell(curCell);
        return !StringUtils.isEmpty((String)formulaString);
    }

    public static boolean checkHasFormulaCanCollectOfCell(ICell curCell, Map bgElenmentMapCanCollect) {
        String itemFormula = BgFSHelper.getFormulaOfCell(curCell);
        if (itemFormula != null) {
            List list = new ArrayList();
            try {
                list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
            }
            catch (ParserException e1) {
                return false;
            }
            if (list == null || list.isEmpty()) {
                return false;
            }
            FormulaHint hint = (FormulaHint)list.get(0);
            String[] params = hint.getParams();
            return params.length == 6 && hint.name.equalsIgnoreCase("BgItem") && bgElenmentMapCanCollect.containsKey(params[2].trim());
        }
        return false;
    }

    public static boolean checkHasExpressionsOfCell(ICell curCell) {
        String expressions = BgFSHelper.getExpressionsOfCell(curCell);
        return !StringUtils.isEmpty((String)expressions);
    }

    public static boolean checkHasExpressionsOfCell(RptCell curCell) {
        if (curCell == null || curCell.getItemFormula() == null) {
            return false;
        }
        String expressions = null;
        expressions = curCell.getItemFormula().getExt("BG_BUDGET_EXPRESSIONS");
        if (!StringUtils.isEmpty((String)expressions)) {
            return true;
        }
        expressions = curCell.getItemFormula().getExt("BG_ACTUAL_EXPRESSIONS");
        if (!StringUtils.isEmpty((String)expressions)) {
            return true;
        }
        expressions = curCell.getItemFormula().getExt("BGFORMULA_ACTUAL_ADD_EXPRESSIONS");
        if (!StringUtils.isEmpty((String)expressions)) {
            return true;
        }
        expressions = curCell.getItemFormula().getExt("BGFORMULA_DATA");
        if (!StringUtils.isEmpty((String)expressions)) {
            return true;
        }
        expressions = curCell.getItemFormula().getExt("BGFORMULA_ACTUAL");
        return !StringUtils.isEmpty((String)expressions);
    }

    public static boolean checkHasFormulaOfBgItem(RptCell rptCell) {
        String fillType;
        if (rptCell == null) {
            return false;
        }
        return rptCell.getItemFormula() != null && (fillType = rptCell.getItemFormula().getExt("bgFillType")) != null && fillType.equals("bgFillValueType_item");
    }

    public static boolean checkHasFormulaOfBgItem(ICell cell) {
        if (cell == null || cell.getUserObject() == null) {
            return false;
        }
        if (cell.getUserObject() instanceof RptCell) {
            return BgFSHelper.checkHasFormulaOfBgItem((RptCell)cell.getUserObject());
        }
        return false;
    }

    public static boolean checkHasFormulaOfBgPeriod(RptCell rptCell) {
        String fillType;
        if (rptCell == null) {
            return false;
        }
        return rptCell.getItemFormula() != null && (fillType = rptCell.getItemFormula().getExt("bgFillType")) != null && fillType.equals("bgFillValueType_period");
    }

    public static boolean checkHasFormulaOfBgPeriod(ICell cell) {
        if (cell == null || cell.getUserObject() == null) {
            return false;
        }
        if (cell.getUserObject() instanceof RptCell) {
            return BgFSHelper.checkHasFormulaOfBgPeriod((RptCell)cell.getUserObject());
        }
        return false;
    }

    public static boolean checkHasFormulaOfCurrency(RptCell rptCell) {
        String fillType;
        if (rptCell == null) {
            return false;
        }
        return rptCell.getItemFormula() != null && (fillType = rptCell.getItemFormula().getExt("bgFillType")) != null && fillType.equals("bgFillValueType_currency");
    }

    public static boolean checkHasFormulaOfCurrency(ICell cell) {
        if (cell == null || cell.getUserObject() == null) {
            return false;
        }
        if (cell.getUserObject() instanceof RptCell) {
            return BgFSHelper.checkHasFormulaOfCurrency((RptCell)cell.getUserObject());
        }
        return false;
    }

    public static boolean checkHasFormulaOfBgElement(RptCell rptCell) {
        String fillType;
        if (rptCell == null) {
            return false;
        }
        return rptCell.getItemFormula() != null && (fillType = rptCell.getItemFormula().getExt("bgFillType")) != null && fillType.equals("bgFillValueType_element");
    }

    public static boolean checkCellIsLockedFromSuper(RptCell rptCell) {
        String cellLocked;
        if (rptCell == null) {
            return false;
        }
        return rptCell.getItemFormula() != null && (cellLocked = rptCell.getItemFormula().getExt("CELL_LOCK_SUPER")) != null && cellLocked.equals("true");
    }

    public static boolean checkHasFormulaOfBgElement(ICell cell) {
        if (cell == null || cell.getUserObject() == null) {
            return false;
        }
        if (cell.getUserObject() instanceof RptCell) {
            return BgFSHelper.checkHasFormulaOfBgElement((RptCell)cell.getUserObject());
        }
        return false;
    }

    public static boolean checkIsLinkCell(ICell cell) {
        if (cell == null || cell.getUserObject() == null) {
            return false;
        }
        if (cell.getUserObject() instanceof RptCell) {
            return BgFSHelper.checkIsLinkCell((RptCell)cell.getUserObject());
        }
        return false;
    }

    public static boolean checkIsLinkCell(RptCell rptCell) {
        if (rptCell == null) {
            return false;
        }
        if (rptCell.getItemFormula() != null) {
            String linkForm = rptCell.getItemFormula().getExt("BG_BUDGET_Form");
            String linkTemplate = rptCell.getItemFormula().getExt("BG_LINK_Template_Number");
            if (!StringUtils.isEmpty((String)linkForm) || !StringUtils.isEmpty((String)linkTemplate)) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkHasComment(RptCell rptCell) {
        return rptCell != null && rptCell.getComment() != null;
    }

    public static boolean checkHasOther(RptCell rptCell) {
        if (rptCell == null || rptCell.getItemFormula() == null) {
            return false;
        }
        String otherStr = rptCell.getItemFormula().getExt(COLLECT_FORM_ID);
        if (!StringUtils.isEmpty((String)otherStr)) {
            return true;
        }
        otherStr = rptCell.getItemFormula().getExt(COLLECT_FORMULA);
        return !StringUtils.isEmpty((String)otherStr);
    }

    public static boolean checkHasFormulaOfRow(IRow row, int colSize) {
        if (row == null) {
            return false;
        }
        ICell cell = null;
        for (int i = 0; i < colSize; ++i) {
            cell = row.getCell(i);
            if (!BgFSHelper.checkHasFormulaOfCell(cell)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHasFormulaOfCol(KDTable table, int colIndex, int rowSize) {
        if (table == null) {
            return false;
        }
        ICell cell = null;
        for (int i = 0; i < rowSize; ++i) {
            cell = table.getCell(i, colIndex);
            if (!BgFSHelper.checkHasFormulaOfCell(cell)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHasFormulaOfCol(KDTable table, int colIndex, int rowBegin, int rowEnd) {
        if (table == null) {
            return false;
        }
        ICell cell = null;
        for (int i = rowBegin; i < rowEnd; ++i) {
            cell = table.getCell(i, colIndex);
            if (!BgFSHelper.checkHasFormulaOfCell(cell)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHasDataOfCol(KDTable table, int colAlias) {
        if (table == null) {
            return true;
        }
        int rowCount = table.getExpandedRowCount();
        ICell cell = null;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            cell = table.getCell(rowIndex, colAlias);
            if (cell == null || (cell.getValue() == null || cell.getValue().toString().length() <= 0) && !BgFSHelper.checkHasExpressionsOfCell(cell) && !BgFSHelper.checkHasFormulaOfCell(cell) && !BgFSHelper.checkIsLinkCell(cell)) continue;
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgFormInfo getBgFormInfo(Connection conn, BOSUuid bgFormId, boolean loadData) throws EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        BgFormInfo bgFormInfo;
        block15: {
            if (conn == null) return null;
            if (bgFormId == null) {
                return null;
            }
            bgFormInfo = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select bgf.FID, bgf.FNumber, bgf.FName, bgf.FControlUnitID, bgf.FOrgUnitID, bgf.FBgSchemeID, bgf.FBgTemplateId , bgt.FFormType ," + (loadData ? " bgf.FData, bgf.FAdjustMapData, " : "") + " bgf.FBgPeriodID, bgf.FCurrencyID, bgf.FMeasureUnitID, bgf.FDataSource, bgf.FVersionNo, bgf.FAdjustID, bgf.FState  From T_BG_BgForm bgf left join T_BG_BgTemplate bgt on bgf.FBgTemplateId = bgt.fid where bgf.FID = ?");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgFormId.toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) break block15;
                bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgFormInfo.setNumber(rst.getString("FNumber"));
                bgFormInfo.setName(rst.getString("FName"));
                bgFormInfo.setVersionNo(rst.getBigDecimal("FVersionNo"));
                bgFormInfo.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                bgFormInfo.setDataSource(BgFormDataSourceEnum.getEnum(rst.getInt("FDataSource")));
                if (loadData) {
                    bgFormInfo.setZipData(BgInfoHelper.getBytes((ResultSet)rst, (String)"FData"));
                    bgFormInfo.setAdjustMapData(BgInfoHelper.getBytes((ResultSet)rst, (String)"FAdjustMapData"));
                }
                if (rst.getString("FControlUnitID") != null) {
                    bgFormInfo.setCU(new CtrlUnitInfo());
                    bgFormInfo.getCU().setId(BOSUuid.read((String)rst.getString("FControlUnitID")));
                }
                if (rst.getString("FOrgUnitID") != null) {
                    bgFormInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgFormInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                }
                if (rst.getString("FBgSchemeID") != null) {
                    bgFormInfo.setBgScheme(new BgSchemeInfo());
                    bgFormInfo.getBgScheme().setId(BOSUuid.read((String)rst.getString("FBgSchemeID")));
                }
                if (rst.getString("FBgTemplateId") != null) {
                    BgTemplateInfo template = new BgTemplateInfo();
                    template.setId(BOSUuid.read((String)rst.getString("FBgTemplateId")));
                    template.setFormType(rst.getInt("FFormType") > 0 ? BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")) : null);
                    bgFormInfo.setBgTemplate(template);
                }
                if (rst.getString("FBgPeriodID") != null) {
                    bgFormInfo.setBgPeriod(new BgPeriodInfo());
                    bgFormInfo.getBgPeriod().setId(BOSUuid.read((String)rst.getString("FBgPeriodID")));
                }
                if (rst.getString("FCurrencyID") != null) {
                    bgFormInfo.setCurrency(new CurrencyInfo());
                    bgFormInfo.getCurrency().setId(BOSUuid.read((String)rst.getString("FCurrencyID")));
                }
                if (rst.getString("FMeasureUnitID") != null) {
                    bgFormInfo.setMeasureUnit(new MeasureUnitInfo());
                    bgFormInfo.getMeasureUnit().setId(BOSUuid.read((String)rst.getString("FMeasureUnitID")));
                }
                if (rst.getString("FAdjustID") != null) {
                    bgFormInfo.setAdjust(new BgFormInfo());
                    bgFormInfo.getAdjust().setId(BOSUuid.read((String)rst.getString("FAdjustID")));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (IOException ex2) {
                        throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgFormInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgTemplateInfo getBgTemplateInfo(Connection conn, BOSUuid bgTemplateId, boolean loadData) throws EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        BgTemplateInfo bgTemplateInfo;
        block11: {
            if (conn == null) return null;
            if (bgTemplateId == null) {
                return null;
            }
            bgTemplateInfo = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FNumber, FName, FOrgUnitID, " + (loadData ? " FData, FMapData, " : "") + " FDefaultMeasureUnitID, FCanModify, FIsAllowChange, FParentID, FRootId From T_BG_BgTemplate where FID = ?");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgTemplateId.toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) break block11;
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgTemplateInfo.setNumber(rst.getString("FNumber"));
                bgTemplateInfo.setName(rst.getString("FName"));
                bgTemplateInfo.setCanModify(BgTemModifyEnum.getEnum(rst.getInt("FCanModify")));
                bgTemplateInfo.setIsAllowChange(BgTemModifyEnum.getEnum(rst.getInt("FIsAllowChange")));
                if (rst.getString("FRootId") != null) {
                    bgTemplateInfo.setRootId(BOSUuid.read((String)rst.getString("FRootId")));
                }
                if (loadData) {
                    bgTemplateInfo.setZipData(BgInfoHelper.getBytes((ResultSet)rst, (String)"FData"));
                    bgTemplateInfo.setMapData(BgInfoHelper.getBytes((ResultSet)rst, (String)"FMapData"));
                }
                if (rst.getString("FOrgUnitID") != null) {
                    bgTemplateInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgTemplateInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                }
                if (rst.getString("FDefaultMeasureUnitID") != null) {
                    bgTemplateInfo.setDefaultMeasureUnit(new MeasureUnitInfo());
                    bgTemplateInfo.getDefaultMeasureUnit().setId(BOSUuid.read((String)rst.getString("FDefaultMeasureUnitID")));
                }
                if (rst.getString("FParentID") != null) {
                    bgTemplateInfo.setParent(new BgTemplateInfo());
                    bgTemplateInfo.getParent().setId(BOSUuid.read((String)rst.getString("FParentID")));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (IOException ex2) {
                        throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgTemplateInfo;
    }

    public static BgSchemeInfo getBgSchemeInfo(Context ctx, Connection conn, BOSUuid bgSchemeId) throws EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        BgSchemeInfo bgSchemeInfo;
        block8: {
            if (conn == null || bgSchemeId == null) {
                return null;
            }
            bgSchemeInfo = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FNumber, FName_" + ctx.getLocale() + ", FOrgUnitID, FPeriod, FformallyYearScheme, FIsFormal, FDateFrom, FDateTo, FParentSchemeID, FRootID From T_BG_BgScheme where FID = ?");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgSchemeId.toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) break block8;
                bgSchemeInfo = new BgSchemeInfo();
                bgSchemeInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgSchemeInfo.setNumber(rst.getString("FNumber"));
                bgSchemeInfo.setName(rst.getString("FName_" + ctx.getLocale()));
                bgSchemeInfo.setFormallyYearScheme(rst.getBoolean("FformallyYearScheme"));
                bgSchemeInfo.setIsFormal(rst.getBoolean("FIsFormal"));
                bgSchemeInfo.setDateFrom(rst.getDate("FDateFrom"));
                bgSchemeInfo.setDateTo(rst.getDate("FDateTo"));
                if (rst.getString("FParentSchemeID") != null) {
                    bgSchemeInfo.setParentScheme(new BgSchemeInfo());
                    bgSchemeInfo.getParentScheme().setId(BOSUuid.read((String)rst.getString("FParentSchemeID")));
                }
                if (rst.getString("FRootId") != null) {
                    bgSchemeInfo.setRootId(BOSUuid.read((String)rst.getString("FRootId")));
                }
                if (rst.getString("FOrgUnitID") != null) {
                    bgSchemeInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgSchemeInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgSchemeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void createTmpDataOfFormula(Context ctx, Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgTemplateId, BOSUuid bgFormId, Map adjustMap) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (conn == null) return;
        if (orgUnitId == null) return;
        if (bgSchemeId == null) return;
        if (bgFormId == null) {
            return;
        }
        if (adjustMap == null) return;
        if (adjustMap.isEmpty()) {
            return;
        }
        ArrayList<String> formulaList = new ArrayList<String>();
        HashMap updateMap = new HashMap();
        HashMap formulaMap = new HashMap();
        Map ctrlModeMap = null;
        Map formulaCtrl = null;
        boolean isControl = false;
        boolean isFlexible = false;
        BigDecimal flexParam = null;
        int ctrlType = -1;
        boolean isGroupCtrl = false;
        String groupNo = null;
        boolean isCtrlAllowChange = false;
        boolean isFromSuper = false;
        boolean isAllowAccess = false;
        String itemAndElement = null;
        HashSet<String> bgElementSet = new HashSet<String>();
        HashSet<String> bgPeriodSet = new HashSet<String>();
        HashSet<String> currencySet = new HashSet<String>();
        String formulaString2222222 = null;
        String[] parameter = null;
        BgFormDiversityData divData = null;
        BgDataInfo bgData = new BgDataInfo();
        PreparedStatement pstmt = null;
        StringBuffer create = new StringBuffer();
        create.append("Insert Into T_BG_BgTmpData (FID, FBgValue, FBizActual, FBgBalance, FOrgUnitId, FBgSchemeId, FBgTemplateId, FBgFormId, FFormula, FBgItemCombinId, FBgElementId, FBgPeriodId, FCurrencyId, FIsControl, FIsFlexible, FFlexParam, FCtrlType, FIsGroupCtrl, FGroupNo, FIsCtrlAllowChange, FIsFromSuper, FIsAllowAccess) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?, ?,?,?,?,?,?,?,?,?)");
        for (String formulaString2222222 : adjustMap.keySet()) {
            formulaList.add(formulaString2222222);
            parameter = BgSHelper.getFormulaInfo(formulaMap, formulaString2222222);
            if (parameter == null) continue;
            if (parameter[BgSHelper.paraElement] != null) {
                bgElementSet.add(parameter[BgSHelper.paraElement]);
            }
            if (parameter[BgSHelper.paraPeriod] != null) {
                bgPeriodSet.add(parameter[BgSHelper.paraPeriod]);
            }
            if (parameter[BgSHelper.paraCurrency] == null) continue;
            currencySet.add(parameter[BgSHelper.paraCurrency]);
        }
        Map bgElementMap = BgFSHelper.getBgElementMap(ctx, conn, bgElementSet);
        Map bgPeriodMap = BgFSHelper.getBgPeriodMap(ctx, conn, bgPeriodSet);
        Map currencyMap = BgFSHelper.getCurrencyMap(ctx, conn, currencySet);
        try {
            ctrlModeMap = BgCtrlSetHelper.getCtrlModeMap4InsertTmpData(ctx, bgTemplateId, bgFormId, adjustMap);
            Map itemAndElementCtrl = (Map)BgCtrSettingFacadeFactory.getLocalInstance(ctx).getTemplateCtrlSetting(bgTemplateId, null).get("ctrlModeMap");
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgTmpData where FBgFormId = ?", (Object[])new Object[]{bgFormId.toString()});
            pstmt = conn.prepareStatement(create.toString());
            for (String formulaString2222222 : adjustMap.keySet()) {
                block37: {
                    block38: {
                        divData = (BgFormDiversityData)adjustMap.get(formulaString2222222);
                        formulaCtrl = (Map)ctrlModeMap.get(formulaString2222222);
                        parameter = (String[])formulaMap.get(formulaString2222222);
                        itemAndElement = parameter[0] + "_" + parameter[2];
                        pstmt.setString(1, BOSUuid.create((BOSObjectType)bgData.getBOSType()).toString());
                        if (divData.getNewValue() != null) {
                            pstmt.setBigDecimal(2, divData.getNewValue().setScale(8, 4));
                        } else {
                            pstmt.setBigDecimal(2, BgConstants.BIGZERO);
                            divData.setNewValue(BgConstants.BIGZERO);
                        }
                        if (divData.getOldValue() != null) {
                            pstmt.setBigDecimal(3, divData.getOldValue().setScale(8, 4));
                        } else {
                            pstmt.setBigDecimal(3, BgConstants.BIGZERO);
                            divData.setOldValue(BgConstants.BIGZERO);
                        }
                        pstmt.setBigDecimal(4, divData.getNewValue().subtract(divData.getOldValue()));
                        pstmt.setString(5, orgUnitId.toString());
                        pstmt.setString(6, bgSchemeId.toString());
                        pstmt.setString(7, bgTemplateId.toString());
                        pstmt.setString(8, bgFormId.toString());
                        pstmt.setString(9, formulaString2222222);
                        pstmt.setString(10, null);
                        if (!formulaMap.containsKey(formulaString2222222)) break block38;
                        parameter = (String[])formulaMap.get(formulaString2222222);
                        if (parameter[BgSHelper.paraElement] != null) {
                            if (bgElementMap.containsKey(parameter[BgSHelper.paraElement])) {
                                pstmt.setString(11, ((BgElementInfo)bgElementMap.get(parameter[BgSHelper.paraElement])).getId().toString());
                            } else {
                                pstmt.setString(11, null);
                            }
                        } else {
                            pstmt.setString(11, null);
                        }
                        if (parameter[BgSHelper.paraPeriod] != null) {
                            if (bgPeriodMap.containsKey(parameter[BgSHelper.paraPeriod])) {
                                pstmt.setString(12, ((BgPeriodInfo)bgPeriodMap.get(parameter[BgSHelper.paraPeriod])).getId().toString());
                            } else {
                                pstmt.setString(12, null);
                            }
                        } else {
                            pstmt.setString(12, null);
                        }
                        if (parameter[BgSHelper.paraCurrency] != null) {
                            if (currencyMap.containsKey(parameter[BgSHelper.paraCurrency])) {
                                pstmt.setString(13, ((CurrencyInfo)currencyMap.get(parameter[BgSHelper.paraCurrency])).getId().toString());
                                break block37;
                            } else {
                                pstmt.setString(13, null);
                            }
                            break block37;
                        } else {
                            pstmt.setString(13, null);
                        }
                        break block37;
                    }
                    pstmt.setString(11, null);
                    pstmt.setString(12, null);
                    pstmt.setString(13, null);
                }
                if (formulaCtrl != null && !formulaCtrl.isEmpty()) {
                    isControl = (Boolean)formulaCtrl.get("isCtrl");
                    isFlexible = (Boolean)formulaCtrl.get("isFlexCtrl");
                    flexParam = (BigDecimal)formulaCtrl.get("flexCtrlParam");
                    ctrlType = (Integer)formulaCtrl.get("periodCtrlPolicy");
                    isGroupCtrl = (Boolean)formulaCtrl.get("isGroupCtrl");
                    groupNo = BgCtrlSetHelper.getStrGroupNo(formulaCtrl.get("groupCtrlNo"), bgTemplateId.toString());
                    isCtrlAllowChange = (Boolean)formulaCtrl.get("isCtrlAllowChange");
                    isFromSuper = (Boolean)formulaCtrl.get("isFromSuper");
                    isAllowAccess = (Boolean)formulaCtrl.get("isAllowAccess");
                    pstmt.setBoolean(14, isControl);
                    pstmt.setBoolean(15, isFlexible);
                    pstmt.setBigDecimal(16, flexParam);
                    pstmt.setInt(17, ctrlType);
                    pstmt.setBoolean(18, isGroupCtrl);
                    pstmt.setString(19, groupNo);
                    pstmt.setBoolean(20, isCtrlAllowChange);
                    pstmt.setBoolean(21, isFromSuper);
                    pstmt.setBoolean(22, isAllowAccess);
                } else {
                    pstmt.setBoolean(14, false);
                    pstmt.setBoolean(15, false);
                    pstmt.setBigDecimal(16, new BigDecimal("1.000000"));
                    pstmt.setInt(17, -1);
                    pstmt.setBoolean(18, false);
                    pstmt.setString(19, null);
                    if (itemAndElementCtrl.containsKey(itemAndElement)) {
                        pstmt.setBoolean(20, false);
                        pstmt.setBoolean(21, true);
                    } else {
                        pstmt.setBoolean(20, true);
                        pstmt.setBoolean(21, false);
                    }
                    pstmt.setBoolean(22, false);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            if (!updateMap.isEmpty()) {
                BgFSHelper.updateTmpDataOfFormula(conn, orgUnitId, bgSchemeId, bgFormId, updateMap);
            }
            SQLUtils.cleanup((Statement)pstmt);
            return;
        }
        catch (BOSException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw ex;
            catch (SQLException ex2) {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
            }
            catch (EASBizException ex3) {
                logger.error((Object)"", (Throwable)ex3);
                throw ex3;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return;
            }
        }
        finally {
            SQLUtils.cleanup(pstmt);
        }
    }

    public static Map getTmpDataOfFormula(BgFormInfo bgFormInfo, Map adjustMap) throws BOSException {
        if (bgFormInfo == null || bgFormInfo.getZipData() == null) {
            return adjustMap;
        }
        KDF kdf = null;
        KDTable table = null;
        ICell cell = null;
        RptCell rptCell = null;
        BgFormDiversityData divData = null;
        String formulaString = null;
        String valueString = null;
        BigDecimal value = null;
        int rowCount = 0;
        int rowIndex = 0;
        int colCount = 0;
        int colIndex = 0;
        try {
            kdf = bgFormInfo.getKDF();
            int n = kdf.getAllTable().size();
            for (int i = 0; i < n; ++i) {
                table = (KDTable)kdf.getTableByIndex(i);
                rowCount = table.getBody().size();
                colCount = table.getColumnCount();
                for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex < colCount; ++colIndex) {
                        cell = table.getCell(rowIndex, colIndex);
                        if (!BgFSHelper.checkHasFormulaOfCell(cell)) continue;
                        formulaString = BgFSHelper.getFormulaOfCell(cell);
                        if (!BgFSHelper.checkCanUpdateOfCell(cell) || adjustMap.containsKey(formulaString)) continue;
                        rptCell = (RptCell)cell.getUserObject();
                        valueString = rptCell.getItemFormula().getExt("BG_BUDGET_VALUE");
                        try {
                            value = new BigDecimal(valueString);
                        }
                        catch (Exception ex) {
                            value = BgConstants.BIGZERO;
                        }
                        divData = new BgFormDiversityData();
                        divData.setFormula(formulaString);
                        divData.setNewValue(value);
                        divData.setOldValue(BgConstants.BIGZERO);
                        adjustMap.put(formulaString, divData);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (KDFException ex) {
            throw new BOSException((Throwable)ex);
        }
        return adjustMap;
    }

    public static void updateTmpDataOfFormula(Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgFormId, Map updateMap) throws EASBizException {
        if (conn == null || orgUnitId == null || bgSchemeId == null || bgFormId == null) {
            return;
        }
        if (updateMap == null || updateMap.isEmpty()) {
            return;
        }
        String formulaString2 = null;
        BgFormDiversityData divData = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgTmpData set FBgValue = ?, FBizActual = ?, FBgBalance = ? where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (String formulaString2 : updateMap.keySet()) {
                divData = (BgFormDiversityData)updateMap.get(formulaString2);
                if (divData.getNewValue() != null) {
                    pstmt.setBigDecimal(1, divData.getNewValue().setScale(8, 4));
                } else {
                    pstmt.setBigDecimal(1, BgConstants.BIGZERO);
                }
                if (divData.getOldValue() != null) {
                    pstmt.setBigDecimal(2, divData.getOldValue().setScale(8, 4));
                } else {
                    pstmt.setBigDecimal(2, BgConstants.BIGZERO);
                    divData.setOldValue(BgConstants.BIGZERO);
                }
                pstmt.setBigDecimal(3, divData.getNewValue().subtract(divData.getOldValue()).setScale(8, 4));
                pstmt.setString(4, orgUnitId.toString());
                pstmt.setString(5, bgSchemeId.toString());
                pstmt.setString(6, formulaString2);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static Map getBgItemCombinMap(Context ctx, Set bgItemCombinSet) {
        return null;
    }

    public static Map getBgElementMap(Context ctx, Connection conn, Set bgElementSet) throws EASBizException {
        if (ctx == null || conn == null || bgElementSet == null || bgElementSet.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, BgElementInfo> dataMap = new HashMap<String, BgElementInfo>();
        ArrayList<String> bgElementList = new ArrayList<String>();
        BgElementInfo bgElementInfo = null;
        int index = 0;
        int batchNum = 50;
        int size = bgElementSet.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String noFindStr = "#";
        String bgElementNumer2 = null;
        for (String bgElementNumer2 : bgElementSet) {
            bgElementList.add(bgElementNumer2);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_" + ctx.getLocale() + ", FNumber from T_BG_BgElement where FNumber in(");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)bgElementList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgElementInfo = new BgElementInfo();
                    bgElementInfo.setId(BOSUuid.read((String)rst.getString(1)));
                    bgElementInfo.setName(rst.getString(2));
                    bgElementInfo.setNumber(rst.getString(3));
                    dataMap.put(bgElementInfo.getNumber(), bgElementInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return dataMap;
    }

    public static Map getBgPeriodMap(Context ctx, Connection conn, Set bgPeriodSet) throws EASBizException {
        if (ctx == null || conn == null || bgPeriodSet == null || bgPeriodSet.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, BgPeriodInfo> dataMap = new HashMap<String, BgPeriodInfo>();
        ArrayList<String> bgPeriodList = new ArrayList<String>();
        BgPeriodInfo bgPeriodInfo = null;
        int index = 0;
        int batchNum = 50;
        int size = bgPeriodSet.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String noFindStr = "#";
        String bgPeriodNumer2 = null;
        for (String bgPeriodNumer2 : bgPeriodSet) {
            bgPeriodList.add(bgPeriodNumer2);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_" + ctx.getLocale() + ", FNumber from T_BG_BgPeriod where FNumber in(");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)bgPeriodList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgPeriodInfo = new BgPeriodInfo();
                    bgPeriodInfo.setId(BOSUuid.read((String)rst.getString(1)));
                    bgPeriodInfo.setName(rst.getString(2));
                    bgPeriodInfo.setNumber(rst.getString(3));
                    dataMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return dataMap;
    }

    public static Map getCurrencyMap(Context ctx, Connection conn, Set currencySet) throws EASBizException {
        if (ctx == null || conn == null || currencySet == null || currencySet.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, CurrencyInfo> dataMap = new HashMap<String, CurrencyInfo>();
        ArrayList<String> currencyList = new ArrayList<String>();
        CurrencyInfo currencyInfo = null;
        int index = 0;
        int batchNum = 50;
        int size = currencySet.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String noFindStr = "#";
        String currencyNumer2 = null;
        for (String currencyNumer2 : currencySet) {
            currencyList.add(currencyNumer2);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_" + ctx.getLocale() + ", FNumber from T_BD_Currency where FNumber in(");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)currencyList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    currencyInfo = new CurrencyInfo();
                    currencyInfo.setId(BOSUuid.read((String)rst.getString(1)));
                    currencyInfo.setName(rst.getString(2));
                    currencyInfo.setNumber(rst.getString(3));
                    dataMap.put(currencyInfo.getNumber(), currencyInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return dataMap;
    }

    public static boolean checkHasOverstepMax(BigDecimal value) {
        return value != null && value.compareTo(GlUtils.maxBigDecimal) > 0;
    }

    public static boolean checkHasOverstepMax(String value) {
        try {
            if (value != null && new BigDecimal(value).compareTo(GlUtils.maxBigDecimal) > 0) {
                return true;
            }
        }
        catch (Exception ex) {
            return true;
        }
        return false;
    }

    public static boolean checkHasOverstepMin(BigDecimal value) {
        return value != null && value.compareTo(GlUtils.minBigDecimal) < 0;
    }

    public static boolean checkHasOverstepMin(String value) {
        try {
            if (value != null && new BigDecimal(value).compareTo(GlUtils.minBigDecimal) < 0) {
                return true;
            }
        }
        catch (Exception ex) {
            return true;
        }
        return false;
    }

    public static boolean checkHasAdjust(BgFormInfo bgFormInfo) {
        if (bgFormInfo == null) {
            return false;
        }
        return bgFormInfo.getState().getValue() == 4 || bgFormInfo.getAdjust() != null && !bgFormInfo.getAdjust().getId().equals((Object)bgFormInfo.getId());
    }

    public static boolean isNumericalOfCell(ICell cell) {
        String numberFormat;
        if (cell == null) {
            return false;
        }
        return cell.getStyleAttributes() != null && cell.getStyleAttributes().getNumberFormat() != null && ((numberFormat = cell.getStyleAttributes().getNumberFormat()).equals("") || numberFormat.equals(routineStr) || numberFormat.indexOf(findStr) >= 0);
    }

    public static boolean hideSheet(Context ctx, Sheet _sheet, Map sheetPer, String user, String sheetCreaterID) {
        String sheetCreater = null;
        boolean isShowSheet = false;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign((Sheet)_sheet))) {
            _sheet.setHide(false);
            isShowSheet = true;
        } else {
            sheetCreater = StringUtils.isEmpty((String)sheetCreaterID) ? (String)_sheet.getUserObjectValue("SHEET_CREATER_ID") : sheetCreaterID;
            boolean isContinue = false;
            if (sheetCreater != null) {
                try {
                    isContinue = BgPermissionFactory.getLocalInstance(ctx).isLimitedPermissionUse(user);
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                if (BgSHelper.isBgTemplatePerimissionForUse(ctx)) {
                    if (isContinue) {
                        if (!sheetCreater.equals(user)) {
                            _sheet.setHide(true);
                        } else {
                            _sheet.setHide(false);
                            isShowSheet = true;
                        }
                    } else {
                        _sheet.setHide(false);
                        isShowSheet = true;
                    }
                } else if (!sheetCreater.equals(user)) {
                    _sheet.setHide(true);
                } else {
                    _sheet.setHide(false);
                    isShowSheet = true;
                }
            } else {
                _sheet.setHide(true);
            }
        }
        return isShowSheet;
    }

    public static boolean hideSheet(Sheet _sheet, Map sheetPer, String user, String sheetCreaterID) {
        String sheetCreater = null;
        boolean isShowSheet = false;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign((Sheet)_sheet))) {
            _sheet.setHide(false);
            isShowSheet = true;
        } else {
            sheetCreater = StringUtils.isEmpty((String)sheetCreaterID) ? (String)_sheet.getUserObjectValue("SHEET_CREATER_ID") : sheetCreaterID;
            boolean isContinue = false;
            if (sheetCreater != null) {
                try {
                    isContinue = BgPermissionFactory.getRemoteInstance().isLimitedPermissionUse(user);
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
                if (BgSHelper.isBgTemplatePerimissionForUse()) {
                    if (isContinue) {
                        if (!sheetCreater.equals(user)) {
                            _sheet.setHide(true);
                        } else {
                            _sheet.setHide(false);
                            isShowSheet = true;
                        }
                    } else {
                        _sheet.setHide(false);
                        isShowSheet = true;
                    }
                } else if (!sheetCreater.equals(user)) {
                    _sheet.setHide(true);
                } else {
                    _sheet.setHide(false);
                    isShowSheet = true;
                }
            } else {
                _sheet.setHide(true);
            }
        }
        return isShowSheet;
    }
}

