/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGatherFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNEnumGatherInfo;
import com.kingdee.eas.ma.nbudget.BgNEnumInfo;
import com.kingdee.eas.ma.nbudget.BgNEnumerateHelper;
import com.kingdee.eas.ma.nbudget.BgNEnumerateInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import java.awt.Rectangle;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgGatherHelper {
    private static final Logger logger = Logger.getLogger(BgGatherHelper.class);
    public static final String GATHER_TYPE = "GATHER_TYPE";
    public static final String GATHER_TYPE_EXT = "GATHER_TYPE_EXT";
    public static final String GATHER_ORGUNIT = "GATHER_ORGUNIT";
    public static final String GATHER_CELL = "GATHER_CELL";
    public static final String GATHER_FORMULA = "GATHER_FORMULA";
    public static final String GATHER_ENUMERATE = "GATHER_ENUMERATE";
    public static final String GATHER_BUDGET = "GATHER_BUDGET";
    public static final String GATHER_ACTUAL = "GATHER_ACTUAL";
    public static final String GATHER_ADD_ACTUAL = "GATHER_ADD_ACTUAL";
    public static final String GATHER_TMPDATA = "GATHER_TMPDATA";
    public static final String GATHER_SHOW_MSG = "GATHER_SHOW_MSG";
    public static final String GATHER_CLEAR_FORMULA = "GATHER_CLEAR_FORMULA";
    public static final String GATHER_SCHEME_FORMULA = "GATHER_SCHEME_FORMULA";
    public static final String GATHER_SHEET = "GATHER_SHEET";
    public static final String GATHER_SHEET_ID = "GATHER_SHEET_ID";
    public static final String GATHER_SORT = "GATHER_SORT";
    public static final String GATHER_PERIOD = "GATHER_PERIOD";
    public static final String GATHER_PERIOD_ID = "GATHER_PERIOD_ID";
    public static final String GATHER_VIEW = "GATHER_VIEW";
    public static final String GATHER_VIEW_COMPANY = "GATHER_VIEW_COMPANY";
    public static final String GATHER_VIEW_CI = "GATHER_VIEW_CI";
    public static final String GATHER_VIEW_IC = "GATHER_VIEW_IC";
    public static final String GATHER_BGSCHEME = "GATHET_BGSCHEME";
    public static final String GATHER_BGFORM = "GATHER_BGFORM";
    public static final int INEOKE_PARAM_COUNT = 4;
    public static final String RES_GATHER = "com.kingdee.eas.ma.budget.BgGatherResource";
    public static final String GATHER_IS_BUDGET = "GATHER_IS_BUDGET";

    public static void removeGatherSignBook(Book[] books, Map enumsInfo, int state) {
        if (books == null || books.length < 3 || enumsInfo == null) {
            return;
        }
        Sheet[] _sheets = new Sheet[3];
        int in = books[0].getSheetCount();
        for (int i = 0; i < in; ++i) {
            _sheets[0] = books[0].getSheet(i);
            _sheets[1] = books[1].getSheet(i);
            _sheets[2] = books[2].getSheet(i);
            BgGatherHelper.removeGatherSignSheet(_sheets, enumsInfo, state);
        }
    }

    public static void removeGatherSignSheet(Sheet[] sheets, Map enumsInfo, int state) {
        if (sheets == null || enumsInfo == null) {
            return;
        }
        Object _obj = null;
        String _dataSource = null;
        Rectangle _rect = null;
        BgNEnumerateInfo _enumInfo = null;
        BgNEnumGatherInfo _enumGatherInfo = null;
        List _enumsInfo = null;
        List _enumsGatherInfo = null;
        Row _row = null;
        Cell _cell = null;
        _enumsInfo = BgNEnumerateHelper.getBgEnumInfo((String)sheets[0].getID(), (Map)enumsInfo);
        if (_enumsInfo != null) {
            int in = _enumsInfo.size();
            for (int i = 0; i < in; ++i) {
                _enumInfo = (BgNEnumerateInfo)_enumsInfo.get(i);
                if (_enumInfo.getGatherEnumInfo().isEmpty()) continue;
                _enumsGatherInfo = _enumInfo.getGatherEnumInfo();
                int jn = _enumsGatherInfo.size();
                for (int j = 0; j < jn; ++j) {
                    _enumGatherInfo = (BgNEnumGatherInfo)_enumsGatherInfo.get(j);
                    _rect = BgNEnumerateHelper.getEnumArea((Sheet)sheets[0], (BgNEnumInfo)_enumGatherInfo);
                    int rowCount = _rect.x;
                    int colIndex = _rect.y;
                    int colCount = _rect.width;
                    for (int rowIndex = _rect.height; rowIndex >= rowCount; --rowIndex) {
                        _row = sheets[0].getRow(rowIndex, false);
                        if (_row == null) continue;
                        _obj = BgNFSHelper.getRowSource((Row)_row);
                        if (_obj != null) {
                            if ("DATA_SOURCE_COLLECT".equals(_obj)) {
                                if (BgGatherHelper.checkHasEnumSign(_row)) {
                                    for (colIndex = _rect.y; colIndex <= colCount; ++colIndex) {
                                        _cell = _row.getCell(colIndex, false);
                                        BgGatherHelper.removeGatherSignCell(_cell);
                                    }
                                    continue;
                                }
                                BgNFSHelper.removeRow((Sheet)sheets[0], (int)rowIndex);
                                BgNFSHelper.removeRow((Sheet)sheets[1], (int)rowIndex);
                                BgNFSHelper.removeRow((Sheet)sheets[2], (int)rowIndex);
                                continue;
                            }
                            if ("DATA_SOURCE_EDIT".equals(_obj)) {
                                if (state != 1) continue;
                                _obj = BgNFSHelper.getRowObject((Row)_row, (String)"SIGN_DATA_SOURCE_OTHER");
                                if ("DATA_SOURCE_COLLECT".equals(_obj)) {
                                    BgNFSHelper.removeRow((Sheet)sheets[0], (int)rowIndex);
                                    BgNFSHelper.removeRow((Sheet)sheets[1], (int)rowIndex);
                                    BgNFSHelper.removeRow((Sheet)sheets[2], (int)rowIndex);
                                    continue;
                                }
                                for (colIndex = _rect.y; colIndex <= colCount; ++colIndex) {
                                    _cell = _row.getCell(colIndex, false);
                                    if (BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) {
                                        _dataSource = BgNFSHelper.getCellSource((Cell)_cell);
                                        if (_dataSource == null || !"DATA_SOURCE_COLLECT".equals(_dataSource)) continue;
                                        BgGatherHelper.removeGatherSignCell(_cell);
                                        continue;
                                    }
                                    _obj = BgNFSHelper.getUserObject((Cell)_cell, (String)"SIGN_DATA_SOURCE");
                                    if (_obj == null || !"DATA_SOURCE_COLLECT".equals(_obj)) continue;
                                    BgGatherHelper.removeGatherSignCell(_cell);
                                }
                                continue;
                            }
                            if (BgNFSHelper.checkIsEmptyRow((Row)_row) || BgNFSHelper.checkHasNullSign((Row)_row)) {
                                BgNFSHelper.removeRow((Sheet)sheets[0], (int)rowIndex);
                                BgNFSHelper.removeRow((Sheet)sheets[1], (int)rowIndex);
                                BgNFSHelper.removeRow((Sheet)sheets[2], (int)rowIndex);
                                continue;
                            }
                            for (colIndex = _rect.y; colIndex <= colCount; ++colIndex) {
                                _cell = _row.getCell(colIndex, false);
                                if (BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) {
                                    _dataSource = BgNFSHelper.getCellSource((Cell)_cell);
                                    if (_dataSource == null || !"DATA_SOURCE_COLLECT".equals(_dataSource)) continue;
                                    BgGatherHelper.removeGatherSignCell(_cell);
                                    continue;
                                }
                                _obj = BgNFSHelper.getUserObject((Cell)_cell, (String)"SIGN_DATA_SOURCE");
                                if (_obj == null || !"DATA_SOURCE_COLLECT".equals(_obj)) continue;
                                BgGatherHelper.removeGatherSignCell(_cell);
                            }
                            continue;
                        }
                        if (!BgNFSHelper.checkIsEmptyRow((Row)_row)) continue;
                        BgNFSHelper.removeRow((Sheet)sheets[0], (int)rowIndex);
                        BgNFSHelper.removeRow((Sheet)sheets[1], (int)rowIndex);
                        BgNFSHelper.removeRow((Sheet)sheets[2], (int)rowIndex);
                    }
                }
            }
        }
    }

    public static void removeGatherSignCell(Cell cell) {
        if (cell == null) {
            return;
        }
        cell.setValue(Variant.nullVariant);
        cell.setFormula(null);
        BgNFSHelper.removeItemFormula((Cell)cell);
        BgNFSHelper.removeCellAllData((Cell)cell);
        BgNFSHelper.removeCellAllExtData((Cell)cell);
    }

    public static void removeAreaData(Sheet sheet, BgNEnumerateInfo enumInfo) {
        if (sheet == null || enumInfo == null) {
            return;
        }
        Object _obj = null;
        Rectangle _rect = null;
        BgNEnumGatherInfo _enumGatherInfo = null;
        List _enumsGatherInfo = null;
        Row _row = null;
        Cell _cell = null;
        if (!enumInfo.getGatherEnumInfo().isEmpty()) {
            _enumsGatherInfo = enumInfo.getGatherEnumInfo();
            int jn = _enumsGatherInfo.size();
            for (int j = 0; j < jn; ++j) {
                _enumGatherInfo = (BgNEnumGatherInfo)_enumsGatherInfo.get(j);
                _rect = BgNEnumerateHelper.getEnumArea((Sheet)sheet, (BgNEnumInfo)_enumGatherInfo);
                int rowCount = _rect.x;
                int colIndex = _rect.y;
                int colCount = _rect.width;
                for (int rowIndex = _rect.height; rowIndex >= rowCount; --rowIndex) {
                    _row = sheet.getRow(rowIndex, false);
                    if (_row == null) continue;
                    _obj = BgNFSHelper.getRowSource((Row)_row);
                    if (BgGatherHelper.checkHasEnumSign(_row)) {
                        if (!BgNFSHelper.checkHasFormula((Row)_row)) continue;
                        for (colIndex = _rect.y; colIndex <= colCount; ++colIndex) {
                            _cell = _row.getCell(colIndex, false);
                            BgGatherHelper.removeCellData(_cell);
                        }
                        continue;
                    }
                    if (!BgNFSHelper.checkHasFormula((Row)_row) && !"DATA_SOURCE_COLLECT".equals(_obj)) continue;
                    BgNFSHelper.removeRow((Sheet)sheet, (int)rowIndex);
                }
            }
        }
    }

    public static void removeCellData(Cell cell) {
        if (cell == null) {
            return;
        }
        cell.setValue(Variant.nullVariant);
        cell.setFormula(null);
        BgNFSHelper.removeItemFormula((Cell)cell);
        BgNFSHelper.removeCellAllData((Cell)cell);
        BgNFSHelper.removeCellAllExtData((Cell)cell);
    }

    public static boolean checkHasEnumSign(Row row) {
        Cell _cell = null;
        int colCount = row.getSheet().getMaxColIndex();
        for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
            _cell = row.getCell(colIndex, false);
            if (!BgNFSHelper.checkHasEnumerateOfCell((Cell)_cell)) continue;
            return true;
        }
        return false;
    }

    public static void updateAliasToTemp(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Object _sourceStr = null;
        Row _row = null;
        Column _column = null;
        Cell _cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            _row = sheet.getRow(rowIndex, false);
            if (_row == null || !BgNFSHelper.checkHasSign((Row)_row)) continue;
            _sourceStr = BgNFSHelper.getRowObject((Row)_row, (String)"SIGN_DATA_SOURCE");
            if ("DATA_SOURCE_COLLECT".equals(_sourceStr)) {
                BgNFSHelper.setRowSign((Row)_row);
                BgNFSHelper.setRowObject((Row)_row, (String)"SIGN_DATA_SOURCE", (Object)"DATA_SOURCE_TEMP");
                continue;
            }
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                _cell = _row.getCell(colIndex, false);
                BgGatherHelper.clearGatherCell(_cell);
            }
        }
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            _column = sheet.getColumn(colIndex, false);
            if (_column == null || !BgNFSHelper.checkHasSign((Column)_column) || !"DATA_SOURCE_COLLECT".equals(_sourceStr = BgNFSHelper.getColSource((Column)_column))) continue;
            BgNFSHelper.setColSign((Column)_column);
            BgNFSHelper.setColSource((Column)_column, (String)"DATA_SOURCE_TEMP");
        }
    }

    private static void clearGatherCell(Cell cell) {
        Object _sourceStr;
        if (cell == null) {
            return;
        }
        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell) && (_sourceStr = BgNFSHelper.getCellData((Cell)cell, (String)"SIGN_DATA_SOURCE")) != null && "DATA_SOURCE_COLLECT".equals(_sourceStr)) {
            BgNFSHelper.setValue((Cell)cell, null);
            BgNFSHelper.clearFormulaOfCell((Cell)cell);
        }
    }

    public static void removeCollRowsAndCols(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        String _source = null;
        Row _row = null;
        Column _column = null;
        Cell _cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (int rowIndex = rowCount; rowIndex >= 0; --rowIndex) {
            _row = sheet.getRow(rowIndex, false);
            if (_row == null || !BgNFSHelper.checkHasSign((Row)_row)) continue;
            _source = (String)BgNFSHelper.getRowSource((Row)_row);
            if ("DATA_SOURCE_COLLECT".equals(_source)) {
                BgGatherHelper.removeCellsOfRow(sheet, rowIndex, colCount);
                BgNFSHelper.removeRow((Sheet)sheet, (int)rowIndex);
                continue;
            }
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                _cell = _row.getCell(colIndex, false);
                BgGatherHelper.clearGatherCell(_cell);
            }
        }
        for (int colIndex = colCount; colIndex >= 0; --colIndex) {
            _column = sheet.getColumn(colIndex, false);
            if (_column == null || !BgNFSHelper.checkHasSign((Column)_column) || !"DATA_SOURCE_COLLECT".equals(_source = (String)BgNFSHelper.getColSource((Column)_column))) continue;
            BgGatherHelper.removeCellsOfCol(sheet, colIndex, rowCount);
            BgNFSHelper.removeColumn((Sheet)sheet, (int)colIndex);
        }
    }

    private static void removeCellsOfRow(Sheet sheet, int rowIndex, int colSize) {
        if (sheet == null) {
            return;
        }
        Cell _cell = null;
        for (int i = 0; i <= colSize; ++i) {
            _cell = sheet.getCell(rowIndex, i, false);
            if (_cell == null) continue;
            BgNFSHelper.setValue((Cell)_cell, null);
            BgNFSHelper.clearFormulaOfCell((Cell)_cell);
        }
    }

    private static void removeCellsOfCol(Sheet sheet, int colIndex, int rowSize) {
        if (sheet == null) {
            return;
        }
        Cell _cell = null;
        for (int i = 0; i < rowSize; ++i) {
            _cell = sheet.getCell(i, colIndex, false);
            if (_cell == null) continue;
            BgNFSHelper.setValue((Cell)_cell, null);
            BgNFSHelper.clearFormulaOfCell((Cell)_cell);
        }
    }

    public static BOSUuid getGatherAdjustId(Connection conn, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgFormId == null) {
            throw new BgException(BgException.NOOBJECT);
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BOSUuid rebgFormId = null;
        try {
            pstmt = conn.prepareStatement("select FID from T_BG_BgForm where FAdjustId = ? and FState = ?");
            pstmt.setString(1, bgFormId.toString());
            pstmt.setInt(2, 4);
            rst = pstmt.executeQuery();
            rebgFormId = rst.next() ? BOSUuid.read((String)rst.getString(1)) : bgFormId;
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return rebgFormId;
    }

    public static Row getLastUpdataRow(Book[] books, Sheet sheet, Rectangle rect, Row upRow, Set alias, int colIndex) {
        if (books == null || sheet == null || rect == null) {
            return null;
        }
        Row _row = null;
        String _sign = null;
        String rowKey1 = null;
        Object rowKey2 = null;
        int index = -1;
        int rowIndex = rect.x;
        int rowCount = rect.height;
        if (BgNFSHelper.checkHasSign((Row)upRow)) {
            int _rowIndex;
            _row = sheet.getRow(rowIndex, true);
            if (rect.height - rect.x == 1 && BgGatherHelper.checkHasNullRow(_row)) {
                return _row;
            }
            rowKey1 = BgNFSHelper.getRowSign((Row)upRow);
            if (rowKey1 != null && (index = BgGatherHelper.getfirstRowIndex(sheet, rect, rowKey1)) > 0 && BgNFSHelper.checkIsEmptyRow((Row)(_row = sheet.getRow(index, true)), (int)rect.y, (int)rect.width)) {
                return _row;
            }
            _sign = BgGatherHelper.getfirstRowSign(upRow, alias);
            if (_sign != null && (_rowIndex = BgGatherHelper.getfirstRowIndex(sheet, rect, _sign)) > 0) {
                Variant var = null;
                for (int i = _rowIndex; i < rowCount && (var = sheet.getCell(_rowIndex, colIndex, true).getValue()) != null && var.getValue() != null; ++i) {
                    ++_rowIndex;
                }
                _row = BgNFSHelper.addRow((Sheet)sheet, (int)_rowIndex, (boolean)true);
                BgNFSHelper.addRow((Sheet)books[1].getSheet(sheet.getSheetIndex()), (int)_rowIndex, (boolean)true);
                BgNFSHelper.addRow((Sheet)books[2].getSheet(sheet.getSheetIndex()), (int)_rowIndex, (boolean)true);
                BgNFSHelper.setRowSource((Row)_row, (String)"DATA_SOURCE_COLLECT");
                ++rect.height;
                return _row;
            }
        }
        while (rowIndex < rowCount) {
            _row = sheet.getRow(rowIndex, true);
            if (BgNFSHelper.checkIsEmptyRow((Row)_row, (int)rect.y, (int)rect.width)) {
                return _row;
            }
            ++rowIndex;
        }
        _row = BgNFSHelper.addRow((Sheet)sheet, (int)rowCount, (boolean)true);
        BgNFSHelper.addRow((Sheet)books[1].getSheet(sheet.getSheetIndex()), (int)rowCount, (boolean)true);
        BgNFSHelper.addRow((Sheet)books[2].getSheet(sheet.getSheetIndex()), (int)rowCount, (boolean)true);
        BgNFSHelper.setRowSource((Row)_row, (String)"DATA_SOURCE_COLLECT");
        ++rect.height;
        return _row;
    }

    public static Row getLastUpdataRow(Sheet sheet, Rectangle rect) {
        if (sheet == null || rect == null) {
            return null;
        }
        Row _row = null;
        int rowCount = rect.height;
        for (int rowIndex = rect.x; rowIndex < rowCount; ++rowIndex) {
            _row = sheet.getRow(rowIndex, true);
            if (!BgGatherHelper.hasUpdateRow(_row, rect)) continue;
            return _row;
        }
        _row = BgNFSHelper.addRow((Sheet)sheet, (int)rowCount);
        BgNFSHelper.setRowSource((Row)_row, (String)"DATA_SOURCE_COLLECT");
        ++rect.height;
        return _row;
    }

    private static boolean hasUpdateRow(Row row, Rectangle rect) {
        if (row == null) {
            return false;
        }
        Cell _cell = null;
        int colCount = rect.width;
        for (int colIndex = rect.y; colIndex <= colCount; ++colIndex) {
            _cell = row.getCell(colIndex, false);
            if (BgGatherHelper.checkIsEmptyCell(_cell)) continue;
            return false;
        }
        return true;
    }

    private static String getfirstRowSign(Row row, Set alias) {
        if (row == null || alias == null) {
            return null;
        }
        Sheet _sheet = null;
        Row _row = null;
        String _sign = null;
        _sheet = row.getSheet();
        int rowCount = _sheet.getMaxRowIndex();
        for (int rowIndex = row.getRow() + 1; rowIndex <= rowCount; ++rowIndex) {
            _row = _sheet.getRow(rowIndex, false);
            if (_row == null || !BgNFSHelper.checkHasSign((Row)_row) || !alias.contains(_sign = BgNFSHelper.getRowSign((Row)_row))) continue;
            return _sign;
        }
        return _sign;
    }

    private static int getfirstRowIndex(Sheet sheet, Rectangle rect, String sign) {
        if (sheet == null || rect == null || sign == null) {
            return -1;
        }
        Row _row = null;
        String _sign = null;
        int rowCount = rect.height;
        for (int rowIndex = rect.x; rowIndex <= rowCount; ++rowIndex) {
            _row = sheet.getRow(rowIndex, false);
            if (_row == null || !BgNFSHelper.checkHasSign((Row)_row) || !sign.equals(_sign = BgNFSHelper.getRowSign((Row)_row))) continue;
            return rowIndex;
        }
        return -1;
    }

    public static boolean checkHasFormula(Row row, Set formulaSet, Rectangle rect) {
        if (row == null || formulaSet == null || rect == null) {
            return false;
        }
        Cell _cell = null;
        String _formulaStr = null;
        int in = rect.width;
        for (int i = rect.y; i <= in; ++i) {
            _cell = row.getCell(i, false);
            if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell) || formulaSet.contains(_formulaStr = BgNFSHelper.getFormulaOfCell((Cell)_cell))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHasFormula(Row row, Rectangle rect) {
        if (row == null) {
            return false;
        }
        Cell _cell = null;
        int colCount = rect.width;
        for (int colIndex = rect.y; colIndex <= colCount; ++colIndex) {
            _cell = row.getCell(colIndex, false);
            if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHasEmptyFormulaData(Row row, Rectangle rect) {
        if (row == null || rect == null) {
            return false;
        }
        Cell _cell = null;
        int in = rect.width;
        for (int i = rect.y; i <= in; ++i) {
            _cell = row.getCell(i, false);
            if (!BgNFSHelper.checkHasGatFormulaOfCell((Cell)_cell) && !BgNFSHelper.checkHasFormulaOfCell((Cell)_cell) || BgNFSHelper.checkIsEmptyCell((Cell)_cell)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkHasValueData(Row row, Rectangle rect) {
        if (row == null || rect == null) {
            return false;
        }
        Cell _cell = null;
        int in = rect.width;
        for (int i = rect.y; i <= in; ++i) {
            _cell = row.getCell(i, false);
            if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell) && !BgNFSHelper.checkHasExpression((Cell)_cell) && !BgNFSHelper.checkHasBgItemInfo((Cell)_cell) && !BgNFSHelper.checkHasBgPeriodInfo((Cell)_cell) && !BgNFSHelper.checkHasBgElementInfo((Cell)_cell) && !BgNFSHelper.checkHasCurrencyInfo((Cell)_cell) && !BgNFSHelper.checkHasComment((Cell)_cell) && !BgNFSHelper.checkHasLinked((Cell)_cell) && !BgNFSHelper.checkHasEnumerateOfCell((Cell)_cell)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHasGatherFormula(Row row, Rectangle rect) {
        if (row == null || rect == null) {
            return false;
        }
        Cell _cell = null;
        int in = rect.width;
        for (int i = rect.y; i <= in; ++i) {
            _cell = row.getCell(i, false);
            if (!BgNFSHelper.checkHasGatFormulaOfCell((Cell)_cell)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHasEnumSign(Row row, Rectangle rect) {
        if (row == null || rect == null) {
            return false;
        }
        Cell _cell = null;
        int in = rect.width;
        for (int i = rect.y; i <= in; ++i) {
            _cell = row.getCell(i, false);
            if (!BgNFSHelper.checkHasComment((Cell)_cell)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHasNullRow(Row row) {
        if (row == null) {
            return true;
        }
        Cell _cell = null;
        int in = row.getSheet().getMaxColIndex();
        for (int i = 0; i <= in; ++i) {
            _cell = row.getCell(i, false);
            if (BgGatherHelper.checkIsEmptyCell(_cell)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkIsEmptyCell(Cell cell) {
        return BgNFSHelper.checkIsEmptyValue((Cell)cell) && !BgNFSHelper.checkHasFormulaOfCell((Cell)cell) && !BgNFSHelper.checkHasExpression((Cell)cell) && !BgNFSHelper.checkHasBgItemInfo((Cell)cell) && !BgNFSHelper.checkHasBgPeriodInfo((Cell)cell) && !BgNFSHelper.checkHasBgElementInfo((Cell)cell) && !BgNFSHelper.checkHasCurrencyInfo((Cell)cell) && !BgNFSHelper.checkHasComment((Cell)cell) && !BgNFSHelper.checkHasLinked((Cell)cell);
    }

    public static Set getAreaAlias(Sheet sheet, Rectangle rect, int state) {
        HashSet<String> _aliasSet = new HashSet<String>();
        if (sheet == null || rect == null) {
            return _aliasSet;
        }
        Row _row = null;
        String _sign = null;
        Object _obj = null;
        int rowCount = rect.height;
        for (int rowIndex = rect.x; rowIndex <= rowCount; ++rowIndex) {
            _row = sheet.getRow(rowIndex, false);
            if (_row == null || !BgNFSHelper.checkHasSign((Row)_row)) continue;
            _sign = BgNFSHelper.getRowSign((Row)_row);
            _obj = BgNFSHelper.getRowSource((Row)_row);
            if (state == 1) {
                if (!"DATA_SOURCE_TEMPLATE".equals(_obj)) continue;
                _aliasSet.add(_sign);
                continue;
            }
            if (!"DATA_SOURCE_TEMPLATE".equals(_obj) && !"DATA_SOURCE_EDIT".equals(_obj)) continue;
            _aliasSet.add(_sign);
        }
        return _aliasSet;
    }

    public Object invokeMethod4Batch(BgFormInfo bgForm, Map subResult, Map parameter, BgFormInfo nextBgForm) {
        String result;
        Object[] obj = new Object[3];
        if (nextBgForm != null) {
            obj[0] = BgGatherHelper.getMsg("progressTitle") + nextBgForm.getNumber() + "," + nextBgForm.getName();
        }
        if (bgForm == null || subResult == null || parameter == null || nextBgForm == null) {
            return obj;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(BgGatherHelper.getMsg("bgFormNumber"), bgForm.getNumber());
        map.put(BgGatherHelper.getMsg("bgFormName"), bgForm.getName());
        Map gatherOrgUnitMap = (Map)subResult.get("GATHER_CHECK_ORGUNIT");
        Map gatherBgSchemeMap = (Map)subResult.get("GATHER_CHECK_BGSCHEME_ID");
        Map gatherBgFormIdsMap = (Map)subResult.get("GATHER_CHECK_BGFORM_ID");
        if (Boolean.FALSE.equals(subResult.get("GATHER_CHECK_RESULT"))) {
            result = BgGatherHelper.getMsg("failCantCollect");
        } else {
            try {
                boolean isEnumerate = bgForm.getBgTemplate().getFormType().getValue() == 1;
                parameter.put(GATHER_ENUMERATE, new Boolean(isEnumerate));
                result = BgGatherFacadeFactory.getRemoteInstance().gatherInfo4Batch(bgForm.getId().toString(), gatherOrgUnitMap, gatherBgSchemeMap, gatherBgFormIdsMap, parameter);
                result = BgGatherHelper.getMsg(result);
            }
            catch (BOSException e) {
                logger.error((Object)"invokeMethod4Batch:", (Throwable)e);
                result = BgGatherHelper.getMsg("fail") + e.getMessage();
            }
            catch (EASBizException e) {
                logger.error((Object)"invokeMethod4Batch:", (Throwable)e);
                result = BgGatherHelper.getMsg("fail") + e.getMessage();
            }
        }
        map.put(BgGatherHelper.getMsg("result"), result);
        obj[1] = map;
        return obj;
    }

    public static SelectorItemCollection getSimpleSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        return selector;
    }

    public static BgFormInfo getInfoFromCol(BgFormCollection col, String bgFormId) {
        if (col != null && col.size() != 0 && bgFormId != null && !bgFormId.trim().equals("")) {
            bgFormId = bgFormId.trim();
            for (int i = 0; i < col.size(); ++i) {
                if (!bgFormId.equals(col.get(i).getId().toString())) continue;
                return col.get(i);
            }
        }
        return null;
    }

    public static String getMsg(String resKey) {
        return EASResource.getString((String)RES_GATHER, (String)resKey);
    }
}

