/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.util.ParmCodingRule;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFCHelper;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodException;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeNodeCollection;
import com.kingdee.eas.ma.budget.BgSchemeNodeFactory;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateException;
import com.kingdee.eas.ma.budget.IBgFormulaFacade;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgSchemeNode;
import com.kingdee.eas.ma.budget.VOComparator;
import com.kingdee.eas.mobile.convert.util.EmptyUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class BgHelper {
    public static final String BGDATABOSTYPE = "DDDDDDDD";
    public static final String BGITEMCOMBINE = "BGITEMCOMBINE";
    public static final String BGELEMENT = "BGELEMENT";
    public static final String BGCURRENCY = "BGCURRENCY";
    public static final String BGITEMCOMBINID = "BgItemCombinId";
    public static final String BGBALANCE = "BGBALANCE";
    public static final String UPBGBALANCE = "UPBGBALANCE";
    public static final String BILLINFO = "BILLINFO";
    public static final String BALANCE = "fbgvalue - fbizactual";
    public static final String COLLECT_DATA_ID = "COLLECT_DATA_ID";
    public static final String COLLECT_DATA_SOURCE = "COLLECT_DATA_SOURCE";
    public static final String COLLECT_SOURCE_EDIT = "COLLECT_SOURCE_EDIT";
    public static final String COLLECT_SOURCE_COLLECT = "COLLECT_SOURCE_COLLECT";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.BgHelper");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap buildHashMapByByte(byte[] data) throws IOException, ClassNotFoundException {
        HashMap map = null;
        if (data != null && data.length != 0) {
            ObjectInputStream objectInputStream;
            InputStream is = null;
            ObjectInputStream objectInputStream2 = null;
            try {
                is = ZipUtil.unpack((byte[])data);
                objectInputStream = new ObjectInputStream(is);
                map = (HashMap)objectInputStream.readObject();
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    objectInputStream2.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                objectInputStream.close();
            }
            catch (Exception exception) {}
        }
        Object _obj = null;
        Object var3_5 = null;
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                _obj = entry.getValue();
                if (_obj instanceof BgAdjustFormDiversityData || !(_obj instanceof BgFormDiversityData)) continue;
                entry.setValue(new BgAdjustFormDiversityData(_obj));
            }
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] storeHashMapToByte(HashMap map) throws IOException {
        if (map == null) {
            return null;
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(map);
            byte[] byArray = ZipUtil.pack((ByteArrayOutputStream)baos);
            return byArray;
        }
        finally {
            try {
                baos.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    public static BigDecimal getBigDecimal(Object obj) {
        BigDecimal value = null;
        if (obj == null) {
            return SysConstant.BIGZERO;
        }
        String s = obj.toString();
        if (s == null || s.trim().length() == 0) {
            value = SysConstant.BIGZERO;
            return value;
        }
        if (obj instanceof BigDecimal) {
            value = (BigDecimal)obj;
        } else if (BgSHelper.isNumerical(s)) {
            value = new BigDecimal(s);
        } else {
            throw new IllegalArgumentException("object is not BigDecimal type!");
        }
        return value;
    }

    public static boolean isFD(Context ctx) {
        String paramValue = null;
        try {
            paramValue = ctx == null ? ParamManager.getParamValue(null, null, (String)"BG007") : ParamManager.getParamValue((Context)ctx, null, (String)"BG007");
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (paramValue == null || paramValue.trim().equals("")) {
            return false;
        }
        return Boolean.valueOf(paramValue);
    }

    public static Vector getOrgViewTypes(OrgUnitInfo orgInfo) {
        Vector<OrgViewType> vec = new Vector<OrgViewType>();
        if (orgInfo.isIsAdminOrgUnit()) {
            vec.add(OrgViewType.ADMIN);
        }
        if (orgInfo.isIsCompanyOrgUnit()) {
            vec.add(OrgViewType.COMPANY);
        }
        if (orgInfo.isIsCompanyOrgUnit() || orgInfo.isIsProfitOrgUnit() || orgInfo.isIsCostOrgUnit()) {
            vec.add(OrgViewType.COSTCENTER);
        }
        if (orgInfo.isIsSaleOrgUnit()) {
            vec.add(OrgViewType.SALE);
        }
        if (orgInfo.isIsPurchaseOrgUnit()) {
            vec.add(OrgViewType.PURCHASE);
        }
        if (orgInfo.isIsStorageOrgUnit()) {
            vec.add(OrgViewType.STORAGE);
        }
        return vec;
    }

    public static BgTemplateCollection getBgTemplateCollByScheme(Context ctx, String schemeId) throws EASBizException, BOSException {
        IBgSchemeNode iBgSchemeNode = null;
        iBgSchemeNode = ctx == null ? BgSchemeNodeFactory.getRemoteInstance() : BgSchemeNodeFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme", (Object)schemeId));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("bgTemplate.id"));
        selector.add(new SelectorItemInfo("bgTemplate.name"));
        selector.add(new SelectorItemInfo("bgTemplate.number"));
        selector.add(new SelectorItemInfo("bgTemplate.creator.*"));
        selector.add(new SelectorItemInfo("bgTemplate.createTime"));
        selector.add(new SelectorItemInfo("bgTemplate.mapData"));
        selector.add(new SelectorItemInfo("bgTemplate.isAllowChange"));
        selector.add(new SelectorItemInfo("bgTemplate.rootId"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        BgSchemeNodeCollection bgSchemeNodeColl = iBgSchemeNode.getBgSchemeNodeCollection(viewInfo);
        BgTemplateCollection bgTemplateColl = null;
        if (bgSchemeNodeColl != null && bgSchemeNodeColl.size() > 0) {
            bgTemplateColl = new BgTemplateCollection();
            for (int i = 0; i < bgSchemeNodeColl.size(); ++i) {
                bgTemplateColl.add(bgSchemeNodeColl.get(i).getBgTemplate());
            }
        }
        return bgTemplateColl;
    }

    public static BgTemplateCollection getBgTemplateCollByScheme(String schemeId) throws EASBizException, BOSException {
        BgTemplateCollection bgTemplateColl = null;
        try {
            bgTemplateColl = BgHelper.getBgTemplateCollByScheme(null, schemeId);
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new EASBizException(BgTemplateException.GETTEMPLATEEX);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new EASBizException(BgTemplateException.GETTEMPLATEEX);
        }
        return bgTemplateColl;
    }

    public static boolean isEmpty(Object[] param) {
        return param == null || param.length == 0 || param[0] == null;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmpty(Object o) {
        return o == null || o.toString() == null || o.toString().trim().length() == 0;
    }

    public static Set tranArray2Set(String[] ids) {
        if (BgHelper.isEmpty(ids)) {
            return null;
        }
        HashSet<String> set = new HashSet<String>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        return set;
    }

    public static String[] getIds(Object value) {
        Object[] data = value instanceof Object[] ? (Object[])value : new Object[]{value};
        if (EmptyUtil.isEmpty((Object[])data)) {
            return null;
        }
        String[] result = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            CoreBaseInfo info = (CoreBaseInfo)data[i];
            result[i] = info.getId().toString();
        }
        return result;
    }

    public static String tranSet2String(Set idSet) {
        if (idSet == null || idSet.size() < 1) {
            return null;
        }
        String ids = null;
        Iterator iter = idSet.iterator();
        for (int i = 0; iter.hasNext() && i < 999; ++i) {
            ids = ids == null ? "('" + (String)iter.next() + "'" : ids + ", '" + (String)iter.next() + "'";
        }
        ids = ids + ")";
        return ids;
    }

    public static String tranSet2StringSpecial(Set idSet) {
        if (idSet == null || idSet.size() < 1) {
            return null;
        }
        String ids = null;
        Iterator iter = idSet.iterator();
        for (int i = 0; iter.hasNext() && i < 999; ++i) {
            ids = ids == null ? "(''" + (String)iter.next() + "''" : ids + ", ''" + (String)iter.next() + "''";
        }
        ids = ids + ")";
        return ids;
    }

    public static String tranVector2String(Vector idVector) {
        if (idVector == null || idVector.size() < 1) {
            return "('')";
        }
        String ids = null;
        Iterator iter = idVector.iterator();
        for (int i = 0; iter.hasNext() && i < 999; ++i) {
            ids = ids == null ? "('" + (String)iter.next() + "'" : ids + ", '" + (String)iter.next() + "'";
        }
        ids = ids + ")";
        return ids;
    }

    public static String tranArray2String(String[] idArray) {
        if (idArray == null || idArray.length < 1) {
            return "('')";
        }
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < idArray.length && i < 999; ++i) {
            if (i == 0) {
                strBuff.append("('" + idArray[i] + "'");
                continue;
            }
            strBuff.append(", '" + idArray[i] + "'");
        }
        strBuff.append(")");
        return strBuff.toString();
    }

    public static String tranArray2String4Pre(String[] idArray) {
        if (idArray == null || idArray.length < 1) {
            return "('')";
        }
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < idArray.length; ++i) {
            if (i == 0) {
                strBuff.append("(? ");
                continue;
            }
            strBuff.append(", ? ");
        }
        strBuff.append(")");
        return strBuff.toString();
    }

    public static void setParamString4Pre(int startIndex, String[] idArray, PreparedStatement pst) throws SQLException {
        if (idArray == null || idArray.length < 1) {
            return;
        }
        for (int i = 0; i < idArray.length; ++i) {
            pst.setString(startIndex + i + 1, idArray[i]);
        }
    }

    public static String tranArray2Int(String[] idArray) {
        if (idArray == null || idArray.length < 1) {
            return "()";
        }
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < idArray.length && i < 999; ++i) {
            if (i == 0) {
                strBuff.append("(" + idArray[i] + "");
                continue;
            }
            strBuff.append("," + idArray[i] + "");
        }
        strBuff.append(")");
        return strBuff.toString();
    }

    public static String tranArray2StringExcept(String[] idArray) {
        if (idArray == null || idArray.length < 1) {
            return "('')";
        }
        if (idArray.length == 1) {
            return "('" + idArray[0] + "')";
        }
        StringBuffer strBuff = new StringBuffer();
        for (int i = 0; i < idArray.length && i < 999; ++i) {
            if (i == 0) {
                strBuff.append("('" + idArray[i] + "'");
                continue;
            }
            strBuff.append(", '" + idArray[i] + "'");
        }
        strBuff.append(")");
        return strBuff.toString();
    }

    public static void addArray2Set(Set set, Object[] obj) {
        if (set == null) {
            set = new HashSet<Object>();
        }
        for (int i = 0; i < obj.length; ++i) {
            set.add(obj[i]);
        }
    }

    public static String getTimeString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Calendar.getInstance().get(1));
        sb.append(Calendar.getInstance().get(2));
        sb.append(Calendar.getInstance().get(5));
        sb.append(Calendar.getInstance().get(11));
        sb.append(Calendar.getInstance().get(12));
        sb.append(Calendar.getInstance().get(13));
        return sb.toString();
    }

    public static Vector tranColl2Vec(IObjectCollection objColl) {
        Vector<IObjectValue> vec = new Vector<IObjectValue>();
        if (objColl != null && objColl.size() > 0) {
            for (int i = 0; i < objColl.size(); ++i) {
                IObjectValue objVal = objColl.getObject(i);
                vec.add(objVal);
            }
        }
        return vec;
    }

    public static Map tranColl2Map(IObjectCollection objColl, String[] keys) {
        HashMap<String, IObjectValue> tranMap = new HashMap<String, IObjectValue>();
        int colSize = objColl.size();
        for (int i = 0; i < colSize; ++i) {
            IObjectValue objVal = objColl.getObject(i);
            tranMap.put(BgHelper.getKeyString(objVal, keys), objVal);
        }
        return tranMap;
    }

    public static String[] tranObjArray2StrArray(Object[] objs) {
        String[] strArray = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            strArray[i] = (String)objs[i];
        }
        return strArray;
    }

    public static String getKeyString(IObjectValue iter, String[] keys) {
        StringBuffer sb = new StringBuffer(keys.length * 10);
        for (int i = 0; i < keys.length; ++i) {
            Object val = iter.get(keys[i]);
            if (i != 0) {
                sb.append("_");
            }
            if (val == null) {
                sb.append("null");
                continue;
            }
            if (val instanceof IObjectValue) {
                IObjectValue new_val = (IObjectValue)val;
                Object pk = new_val.get("id");
                if (pk == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(pk);
                continue;
            }
            if (val instanceof BigDecimal) {
                NumberFormat fmt = NumberFormat.getInstance();
                sb.append(fmt.format(val));
                continue;
            }
            sb.append(val);
        }
        return sb.toString();
    }

    public static SelectorItemCollection getUnitSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CU"));
        return sic;
    }

    public static int compareBgPeriod(BgPeriodInfo beginBgPeriod, BgPeriodInfo endBgPeriod) {
        if (beginBgPeriod == null) {
            // empty if block
        }
        return endBgPeriod.getNumber().compareTo(beginBgPeriod.getNumber());
    }

    public static boolean compareBgPeriodBegin2End(BgPeriodInfo beginBgPeriod, BgPeriodInfo endBgPeriod) {
        return BgHelper.compareBgPeriod(beginBgPeriod, endBgPeriod) >= 0;
    }

    public static CurrencyInfo getCompanyBaseCurrency(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        return BgHelper.getCompanyBaseCurrency(null, company);
    }

    public static CurrencyInfo getCompanyBaseCurrency(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CurrencyInfo currency = null;
        if (company == null) {
            return null;
        }
        ICompanyOrgUnit corgUnit = null;
        corgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency");
        selectors.add("baseCurrency.id");
        selectors.add("baseCurrency.name");
        selectors.add("baseCurrency.number");
        selectors.add("baseCurrency.precision");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selectors);
        currency = info.getBaseCurrency();
        return currency;
    }

    public static Date getDayBegin(Date day) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }

    public static Date getDayEnd(Date day) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }

    public static BgPeriodCollection getBgPeriodCollection(int bgPeriodType, Date beginDate, Date endDate) throws Exception {
        return BgHelper.getBgPeriodCollection(null, bgPeriodType, beginDate, endDate);
    }

    public static BgPeriodCollection getBgPeriodCollection(Context ctx, int bgPeriodType, Date beginDate, Date endDate) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItem = filter.getFilterItems();
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(beginDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        switch (bgPeriodType) {
            case 1: {
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.GREATER_EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.LESS_EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                break;
            }
            case 2: {
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.GREATER_EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.LESS_EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filter.setMaskString("(#0 and #1 and #2)");
                break;
            }
            case 3: {
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.GREATER));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.LESS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("quarter", (Object)new Integer(BgHelper.getQuarterByMonth(beginCal.get(2))), CompareType.GREATER_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("quarter", (Object)new Integer(BgHelper.getQuarterByMonth(endCal.get(2))), CompareType.LESS_EQUALS));
                }
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("quarter", (Object)new Integer(BgHelper.getQuarterByMonth(endCal.get(2))), CompareType.LESS_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("quarter", (Object)new Integer(BgHelper.getQuarterByMonth(beginCal.get(2))), CompareType.GREATER_EQUALS));
                }
                if (beginCal.get(1) == endCal.get(1)) {
                    filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 and #6) or (#7 and #8 and #9 and #10) ");
                    break;
                }
                filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 ) or (#6 and #7 and #8) ");
                break;
            }
            case 4: {
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.GREATER));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.LESS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("month", (Object)new Integer(beginCal.get(2) + 1), CompareType.GREATER_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("month", (Object)new Integer(endCal.get(2) + 1), CompareType.LESS_EQUALS));
                }
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("month", (Object)new Integer(endCal.get(2) + 1), CompareType.LESS_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("month", (Object)new Integer(beginCal.get(2) + 1), CompareType.GREATER_EQUALS));
                }
                if (beginCal.get(1) == endCal.get(1)) {
                    filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 and #6) or (#7 and #8 and #9 and #10) ");
                    break;
                }
                filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 ) or (#6 and #7 and #8) ");
                break;
            }
            case 5: {
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.GREATER));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.LESS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.GREATER_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
                }
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.GREATER_EQUALS));
                }
                if (beginCal.get(1) == endCal.get(1)) {
                    filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 and #6) or (#7 and #8 and #9 and #10) ");
                    break;
                }
                filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 ) or (#6 and #7 and #8) ");
                break;
            }
            case 6: {
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.GREATER));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.LESS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(beginCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("month", (Object)new Integer(beginCal.get(2) + 1), CompareType.GREATER_EQUALS));
                filterItem.add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.GREATER_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("month", (Object)new Integer(endCal.get(2) + 1), CompareType.LESS_EQUALS));
                    filterItem.add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
                }
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("year", (Object)new Integer(endCal.get(1)), CompareType.EQUALS));
                filterItem.add(new FilterItemInfo("month", (Object)new Integer(endCal.get(2) + 1), CompareType.LESS_EQUALS));
                filterItem.add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
                if (beginCal.get(1) == endCal.get(1)) {
                    filterItem.add(new FilterItemInfo("month", (Object)new Integer(beginCal.get(2) + 1), CompareType.GREATER_EQUALS));
                    filterItem.add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.GREATER_EQUALS));
                }
                if (beginCal.get(1) == endCal.get(1)) {
                    filter.setMaskString("(#0 and #1 and #2) or (#3 and #4 and #5 and #6 and #7 and #8) or (#9 and #10 and #11 and #12 and #13 and #14) ");
                    break;
                }
                filter.setMaskString("(#0 and #1 and #2 ) or ( #3 and #4 and #5 and #6) or (#7 and #8 and #9 and #10) ");
                break;
            }
            default: {
                filterItem.add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.GREATER_EQUALS));
                filterItem.add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
                filterItem.add(new FilterItemInfo("periodType", (Object)BgPeriodEnum.getEnum(bgPeriodType), CompareType.EQUALS));
            }
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sort = viewInfo.getSorter();
        SorterItemInfo sortItemInfo = new SorterItemInfo("number");
        sortItemInfo.setSortType(SortType.ASCEND);
        sort.add(sortItemInfo);
        IBgPeriod iBgPeriod = null;
        iBgPeriod = ctx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance(ctx);
        BgPeriodCollection bgPeriodColl = null;
        bgPeriodColl = iBgPeriod.getBgPeriodCollection(viewInfo);
        return bgPeriodColl;
    }

    public static int getQuarterByMonth(int month) {
        int quarter = 1;
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                quarter = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                quarter = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                quarter = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                quarter = 4;
            }
        }
        return quarter;
    }

    public static void setInfoNumber(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        ICodingRuleManager icrm = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isExistRule = icrm.isExist((IObjectValue)model, companyInfo.getId().toString());
        if (isExistRule && (model.get("number") == null || model.get("number").equals(""))) {
            model.put("number", (Object)icrm.getNumber((IObjectValue)model, companyInfo.getId().toString()));
        }
        if (model.get("number") == null || model.get("number").equals("")) {
            throw new BgFormException(BgFormException.NONUMBER);
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)model.get("number").toString(), CompareType.EQUALS));
    }

    public static boolean hasNumber(CoreBaseInfo info, String companyId, ICodingRuleManager codingRuleManager) {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        try {
            if (codingRuleManager == null) {
                codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            }
            result = codingRuleManager.isExist((IObjectValue)info, companyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean hasNumber_server(CoreBaseInfo info, String companyId, Context ctx) {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = true;
        try {
            ICodingRuleManager codingRuleManager = null;
            codingRuleManager = ctx == null ? CodingRuleManagerFactory.getRemoteInstance() : CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist((IObjectValue)info, companyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void initNumber(CoreBaseInfo info, KDTextField txtField, String companyId) {
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        boolean rst = BgHelper.hasNumber(info, companyId, codingRuleManager);
        if (rst) {
            String number;
            txtField.setEnabled(false);
            if (BgHelper.hasDisplayNumber(info, companyId, codingRuleManager) && !StringUtils.isEmpty((String)(number = BgHelper.getDispNumber(info, companyId, codingRuleManager)))) {
                info.setString("number", number);
                txtField.setText(number);
            }
        } else {
            txtField.setEnabled(true);
        }
    }

    public static void setNumber(String companyId, CoreBaseInfo model, KDTextField txtField) throws EASBizException {
        if (companyId == null || model == null || txtField == null) {
            return;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        CodingRuleInfo codingRuleInfo = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist((IObjectValue)model, companyId);
            if (result) {
                txtField.setEnabled(false);
                codingRuleInfo = codingRuleManager.getCodingRule((IObjectValue)model, companyId);
                if (codingRuleInfo != null && codingRuleInfo.isIsAddView()) {
                    String number = null;
                    number = codingRuleManager.isUseIntermitNumber((IObjectValue)model, companyId) ? codingRuleManager.getNumber((IObjectValue)model, companyId) : codingRuleManager.getNumber((IObjectValue)model, companyId);
                    if (!StringUtils.isEmpty((String)number)) {
                        txtField.setText(number);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    public static boolean hasDisplayNumber(CoreBaseInfo info, String companyId, ICodingRuleManager codingRuleManager) {
        boolean isAddView = false;
        CodingRuleInfo codingRuleInfo = null;
        try {
            if (codingRuleManager == null) {
                codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            }
            isAddView = (codingRuleInfo = codingRuleManager.getCodingRule((IObjectValue)info, companyId)) != null && codingRuleInfo.isIsAddView();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isAddView;
    }

    public static boolean isUseIntermitNumber(CoreBaseInfo info, String companyId, ICodingRuleManager codingRuleManager) {
        boolean isUseIntermitNumber = false;
        CodingRuleInfo codingRuleInfo = null;
        try {
            if (codingRuleManager == null) {
                codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            }
            isUseIntermitNumber = (codingRuleInfo = codingRuleManager.getCodingRule((IObjectValue)info, companyId)) != null && codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isUseIntermitNumber;
    }

    public static void initNumber(CoreBaseInfo info, String companyId, Context ctx) {
        String number;
        boolean rst = BgHelper.hasNumber_server(info, companyId, ctx);
        if (rst && !StringUtils.isEmpty((String)(number = BgHelper.getDispNumber_server(info, companyId, ctx)))) {
            info.setString("number", number);
        }
    }

    public static void setSNumber(Context ctx, String companyId, CoreBaseInfo model) throws EASBizException {
        if (companyId == null || companyId.length() == 0 || model == null) {
            return;
        }
        boolean result = true;
        String number = null;
        ICodingRuleManager codingRuleManager = null;
        String tmpNumber = model.getString("number");
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist((IObjectValue)model, companyId);
            if (result) {
                boolean isAddNewShow = codingRuleManager.isAddView((IObjectValue)model, companyId);
                if (!isAddNewShow) {
                    number = codingRuleManager.getNumber((IObjectValue)model, companyId);
                } else if (isAddNewShow && StringUtils.isEmpty((String)tmpNumber)) {
                    number = codingRuleManager.getNumber((IObjectValue)model, companyId);
                }
                if (!StringUtils.isEmpty(number)) {
                    model.setString("number", number);
                }
            }
        }
        catch (Exception ex) {
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    public static void setSNumberByPro(Context ctx, String companyId, CoreBaseInfo model, String pro) throws EASBizException {
        if (companyId == null || companyId.length() == 0 || model == null) {
            return;
        }
        boolean result = true;
        String number = null;
        ICodingRuleManager codingRuleManager = null;
        ParmCodingRule pcr = new ParmCodingRule();
        pcr.setCustomProperty(pro);
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist((IObjectValue)model, companyId, pcr);
            if (result && !StringUtils.isEmpty((String)(number = codingRuleManager.getNumber((IObjectValue)model, companyId, pcr)))) {
                model.setString(pro, number);
            }
        }
        catch (Exception ex) {
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    public static void setSNumber(Context ctx, String companyId, CoreBaseInfo model, String properName) throws EASBizException {
        if (companyId == null || companyId.length() == 0 || model == null) {
            return;
        }
        boolean result = true;
        String number = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            ParmCodingRule pcr = new ParmCodingRule();
            pcr.setCustomProperty(properName);
            result = codingRuleManager.isExist((IObjectValue)model, null, pcr);
            if (result && !StringUtils.isEmpty(number)) {
                model.setString(properName, number);
            }
        }
        catch (Exception ex) {
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    public static String getDispNumber(CoreBaseInfo info, String companyId, ICodingRuleManager codingRuleManager) {
        String number = null;
        try {
            if (codingRuleManager == null) {
                codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            }
            number = !codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId) ? codingRuleManager.getNumber((IObjectValue)info, companyId) : codingRuleManager.readNumber((IObjectValue)info, companyId);
        }
        catch (BOSException bOSException) {
        }
        catch (CodingRuleException codingRuleException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return number;
    }

    private static String getDispNumber_server(CoreBaseInfo info, String companyId, Context ctx) {
        String number = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = ctx == null ? CodingRuleManagerFactory.getRemoteInstance() : CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            number = codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId) ? codingRuleManager.readNumber((IObjectValue)info, companyId) : codingRuleManager.getNumber((IObjectValue)info, companyId);
        }
        catch (BOSException bOSException) {
        }
        catch (CodingRuleException codingRuleException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return number;
    }

    public static OrgUnitInfo getGroupOrg(Context ctx) {
        OrgUnitInfo groupOrg = null;
        try {
            groupOrg = NewOrgUnitHelper.getRootCU((Context)ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return groupOrg;
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return;
        }
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist((IObjectValue)info, companyId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                boolean bl = codingRuleManager.recycleNumber((IObjectValue)info, companyId, info.getString("number"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sortCollection(AbstractObjectCollection coll, String[] strArray) {
        BgHelper.sortCollection(coll, strArray, true);
    }

    public static void sortCollection(AbstractObjectCollection coll, String[] strArray, boolean isASC) {
        VOComparator comp = new VOComparator(strArray, isASC);
        Object[] infoArray = coll.toArray();
        Arrays.sort(infoArray, comp);
        coll.clear();
        for (int i = 0; i < infoArray.length; ++i) {
            coll.addObject((IObjectValue)infoArray[i]);
        }
    }

    public String bgRefBgForm(Context ctx, String orgCode, String bgFormCode, String sheetName, String cellName) throws BOSException, EASBizException {
        IBgFormulaFacade iFormula = null;
        iFormula = ctx == null ? BgFormulaFacadeFactory.getRemoteInstance() : BgFormulaFacadeFactory.getLocalInstance(ctx);
        return iFormula.bgRefBgForm(orgCode, bgFormCode, sheetName, cellName);
    }

    public String bgRefBgTem(Context ctx, String orgCode, String bgSchemeCode, String bgTemCode, String bgPeriodCode, String sheetName, String cellName) throws BOSException, EASBizException {
        IBgFormulaFacade iFormula = null;
        iFormula = ctx == null ? BgFormulaFacadeFactory.getRemoteInstance() : BgFormulaFacadeFactory.getLocalInstance(ctx);
        return iFormula.bgRefBgTem(orgCode, bgSchemeCode, bgTemCode, bgPeriodCode, sheetName, cellName);
    }

    public BigDecimal BgActualFD(Context ctx, String orgNumber, String bgSchemeNumber, String bgElementNumber, String strItemCombinNum, String currencyNumber, String beginPeriodNumber, String endPeriodNumber) throws BOSException, EASBizException {
        IBgFormulaFacade iFormula = null;
        iFormula = ctx == null ? BgFormulaFacadeFactory.getRemoteInstance() : BgFormulaFacadeFactory.getLocalInstance(ctx);
        return iFormula.BgActualFD(orgNumber, bgSchemeNumber, bgElementNumber, strItemCombinNum, currencyNumber, beginPeriodNumber, endPeriodNumber);
    }

    public static String[] longNumberToNumber(String longNum, int level) {
        if (longNum == null && level == 0) {
            return null;
        }
        String longNumber = longNum + "!";
        String[] number = new String[level];
        if (longNumber.indexOf("!") < 0) {
            return null;
        }
        for (int i = 0; i < level; ++i) {
            number[i] = longNumber.substring(0, longNumber.indexOf("!"));
            longNumber = longNumber.substring(longNumber.indexOf("!") + 1);
        }
        return number;
    }

    public static void getInsulateItem(OrgUnitInfo orgUnit, FilterInfo filter) {
        String[] orgUnitNum = new String[orgUnit.getLevel()];
        if (orgUnit.getLevel() > 1 && orgUnit.getLongNumber().toString().indexOf("!") > 0) {
            orgUnitNum = BgHelper.longNumberToNumber(orgUnit.getLongNumber().toString(), orgUnit.getLevel());
            String maskString = "";
            for (int i = 0; i < orgUnit.getLevel(); ++i) {
                if (orgUnitNum[i] == null) continue;
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgUnitNum[i], CompareType.EQUALS));
                maskString = maskString + "(#" + String.valueOf(filter.getFilterItems().size() - 1) + ") OR ";
            }
            if (BgSHelper.isBgItemNumberRepeat()) {
                maskString = maskString.substring(0, maskString.length() - 3);
            } else {
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.longNumber", (Object)(orgUnit.getLongNumber().toString() + "!%"), CompareType.LIKE));
                maskString = maskString + "(#" + String.valueOf(filter.getFilterItems().size() - 1) + ") ";
            }
            filter.setMaskString("(" + filter.getMaskString() + ") AND (" + maskString + ")");
        } else if (BgSHelper.isBgItemNumberRepeat()) {
            String maskString = "";
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
            maskString = maskString + "(#" + String.valueOf(filter.getFilterItems().size() - 1) + ") ";
            filter.setMaskString("(" + filter.getMaskString() + ") AND (" + maskString + ")");
        }
    }

    public static void getInsulateItemForEntryData(OrgUnitInfo orgUnit, FilterInfo filter) {
        String[] orgUnitNum = new String[orgUnit.getLevel()];
        if (orgUnit.getLevel() > 1 && orgUnit.getLongNumber().toString().indexOf("!") > 0) {
            orgUnitNum = BgHelper.longNumberToNumber(orgUnit.getLongNumber().toString(), orgUnit.getLevel());
            String maskString = "";
            for (int i = 0; i < orgUnit.getLevel(); ++i) {
                if (orgUnitNum[i] == null) continue;
                filter.getFilterItems().add(new FilterItemInfo("CURORGUNITNUMBER", (Object)orgUnitNum[i], CompareType.EQUALS));
                maskString = maskString + "(#" + String.valueOf(filter.getFilterItems().size() - 1) + ") OR ";
            }
            if (BgSHelper.isBgItemNumberRepeat()) {
                maskString = maskString.substring(0, maskString.length() - 3);
            } else {
                filter.getFilterItems().add(new FilterItemInfo("CURORGUNITLONGNUMBER", (Object)(orgUnit.getLongNumber().toString() + "!%"), CompareType.LIKE));
                maskString = maskString + "(#" + String.valueOf(filter.getFilterItems().size() - 1) + ") ";
            }
            filter.setMaskString("(" + filter.getMaskString() + ") AND (" + maskString + ")");
        } else if (BgSHelper.isBgItemNumberRepeat()) {
            String maskString = "";
            filter.getFilterItems().add(new FilterItemInfo("CURORGUNITNUMBER", (Object)orgUnit.getNumber(), CompareType.EQUALS));
            maskString = maskString + "(#" + String.valueOf(filter.getFilterItems().size() - 1) + ") ";
            filter.setMaskString("(" + filter.getMaskString() + ") AND (" + maskString + ")");
        }
    }

    public static ICell formatCellForAnalyse(ICell cell, DecimalFormat decFormat) throws Exception {
        if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell) {
            RptCell rptCell = (RptCell)cell.getUserObject();
            String formulaString = rptCell.getItemFormulaLine();
            if (formulaString != null && formulaString.trim().length() > 0 && cell.getValue() != null) {
                String budgetValue = rptCell.getItemFormula().getExt("BG_BUDGET_VALUE");
                if (budgetValue != null && budgetValue.trim().length() > 0) {
                    cell.setValue((Object)budgetValue);
                }
            } else if (BgFCHelper.isNumericalOfCell(cell) && cell.getValue() != null) {
                try {
                    cell.setValue((Object)decFormat.format(new BigDecimal(cell.getValue().toString())));
                    cell.getStyleAttributes().setNumberFormat(null);
                }
                catch (Exception e) {
                    cell.setValue(cell.getValue());
                    cell.getStyleAttributes().setNumberFormat(null);
                }
            } else {
                cell.setValue(cell.getValue());
                cell.getStyleAttributes().setNumberFormat(null);
            }
        } else if (BgFCHelper.isNumericalOfCell(cell) && cell.getValue() != null) {
            try {
                cell.setValue((Object)decFormat.format(new BigDecimal(cell.getValue().toString())));
            }
            catch (Exception e) {
                cell.setValue(cell.getValue());
            }
        } else {
            cell.setValue(cell.getValue());
            cell.getStyleAttributes().setNumberFormat(null);
        }
        return cell;
    }

    public static String getRelativeBgPeriod(Context ctx, String currentBgPeriodNumber, int relativeValue) throws BOSException, EASBizException {
        int year;
        IBgPeriod iPeriod = null;
        iPeriod = ctx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance(ctx);
        BgPeriodInfo bgPeriod = null;
        try {
            bgPeriod = iPeriod.getBgPeriodInfo("select id, number, periodType, year, halfyear, quarter, month, week  where number = '" + currentBgPeriodNumber + "'");
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e);
        }
        if (bgPeriod == null) {
            throw new BgPeriodException(BgPeriodException.CURRENTPERIODERROR);
        }
        if (relativeValue == 0) {
            return currentBgPeriodNumber;
        }
        String newBgPeriodNumber = null;
        if (bgPeriod.getPeriodType().getValue() == 8) {
            return currentBgPeriodNumber;
        }
        if (bgPeriod.getPeriodType().getValue() == 1) {
            year = bgPeriod.getYear();
            newBgPeriodNumber = year + relativeValue + "Y";
        } else if (bgPeriod.getPeriodType().getValue() == 3) {
            year = bgPeriod.getYear();
            int quarter = bgPeriod.getQuarter();
            int newQuarter = quarter + relativeValue;
            int x = 0;
            int y = 0;
            if (relativeValue > 0) {
                x = newQuarter % 4;
                y = newQuarter / 4;
                if (x == 0) {
                    --y;
                }
            } else if (newQuarter == 0) {
                x = 0;
                y = -1;
            } else if (newQuarter < 0) {
                x = newQuarter % 4 + 4;
                y = newQuarter / 4 - 1;
            } else if (newQuarter > 0) {
                x = newQuarter;
                y = 0;
            }
            x = x == 0 ? 4 : x;
            newBgPeriodNumber = year + y + "Y.0" + x + "Q";
        } else if (bgPeriod.getPeriodType().getValue() == 4) {
            year = bgPeriod.getYear();
            int month = bgPeriod.getMonth();
            int newMonth = month + relativeValue;
            int x = 0;
            int y = 0;
            if (relativeValue > 0) {
                x = newMonth % 12;
                y = newMonth / 12;
                if (x == 0) {
                    --y;
                }
            } else if (newMonth == 0) {
                x = 0;
                y = -1;
            } else if (newMonth < 0) {
                x = newMonth % 12 + 12;
                y = newMonth / 12 - 1;
            } else if (newMonth > 0) {
                x = newMonth;
                y = 0;
            }
            x = x == 0 ? 12 : x;
            newBgPeriodNumber = year + y + "Y." + (x >= 10 ? x + "" : "0" + x) + "M";
        } else if (bgPeriod.getPeriodType().getValue() == 2) {
            year = bgPeriod.getYear();
            int hy = bgPeriod.getHalfYear();
            int newHy = hy + relativeValue;
            int x = 0;
            int y = 0;
            if (relativeValue > 0) {
                x = newHy % 2;
                y = newHy / 2;
                if (x == 0) {
                    --y;
                }
            } else if (newHy == 0) {
                x = 0;
                y = -1;
            } else if (newHy < 0) {
                x = newHy % 2 + 2;
                y = newHy / 2 - 1;
            } else if (newHy > 0) {
                x = newHy;
                y = 0;
            }
            x = x == 0 ? 2 : x;
            newBgPeriodNumber = year + y + "Y.0" + x + "HY";
        } else if (bgPeriod.getPeriodType().getValue() == 7) {
            newBgPeriodNumber = currentBgPeriodNumber;
        } else if (bgPeriod.getPeriodType().getValue() == 6) {
            newBgPeriodNumber = currentBgPeriodNumber;
        } else if (bgPeriod.getPeriodType().getValue() == 5) {
            newBgPeriodNumber = currentBgPeriodNumber;
        }
        try {
            bgPeriod = iPeriod.getBgPeriodInfo("select id where number = '" + newBgPeriodNumber + "'");
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e);
            throw new BgPeriodException(BgPeriodException.RELATIVEPERIODERROR);
        }
        return newBgPeriodNumber;
    }

    public static BgPeriodCollection getBgPeriodCollOnDate(Context ctx, int bgPeriodType, Date date) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItem = filter.getFilterItems();
        filterItem.add(new FilterItemInfo("periodType", (Object)new Integer(bgPeriodType), CompareType.EQUALS));
        filterItem.add(new FilterItemInfo("beginDate", (Object)date, CompareType.LESS_EQUALS));
        filterItem.add(new FilterItemInfo("endDate", (Object)date, CompareType.GREATER_EQUALS));
        viewInfo.setFilter(filter);
        SorterItemCollection sort = viewInfo.getSorter();
        SorterItemInfo sortItemInfo = new SorterItemInfo("number");
        sortItemInfo.setSortType(SortType.ASCEND);
        sort.add(sortItemInfo);
        IBgPeriod iBgPeriod = null;
        iBgPeriod = ctx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance(ctx);
        BgPeriodCollection bgPeriodColl = null;
        bgPeriodColl = iBgPeriod.getBgPeriodCollection(viewInfo);
        return bgPeriodColl;
    }

    public static BgPeriodCollection getBgPeriodCollOnDateBySQL(Context ctx, int bgPeriodType, Date date) throws Exception {
        BgPeriodCollection bgPeriodCol = new BgPeriodCollection();
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rst = null;
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FId,");
        kSql.append("        FNumber,");
        kSql.append("        FName_" + ctx.getLocale());
        kSql.append("   from T_BG_BgPeriod");
        kSql.append("  where FBeginDate <= ?");
        kSql.append("    and FEndDate >= ?");
        kSql.append("    and FPeriodType = ?");
        kSql.append("  order by FNumber asc");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(kSql.toString());
            java.sql.Date sqlDate = new java.sql.Date(date.getTime());
            statement.setDate(1, sqlDate);
            statement.setDate(2, sqlDate);
            statement.setInt(3, bgPeriodType);
            rst = statement.executeQuery();
            while (rst.next()) {
                String id = rst.getString(1);
                String number = rst.getString(2);
                String name = rst.getString(3);
                BgPeriodInfo info = new BgPeriodInfo();
                info.setId(BOSUuid.read((String)id));
                info.setNumber(number);
                info.setName(name);
                bgPeriodCol.add(info);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)statement, (Connection)conn);
        return bgPeriodCol;
    }

    public static BgPeriodCollection getBgPeriodCollOverDateRange(Context ctx, int bgPeriodType, Date date1, Date date2) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItem = filter.getFilterItems();
        filterItem.add(new FilterItemInfo("periodType", (Object)new Integer(bgPeriodType), CompareType.EQUALS));
        filterItem.add(new FilterItemInfo("beginDate", (Object)date1, CompareType.GREATER_EQUALS));
        filterItem.add(new FilterItemInfo("endDate", (Object)date2, CompareType.LESS_EQUALS));
        filterItem.add(new FilterItemInfo("beginDate", (Object)date1, CompareType.LESS_EQUALS));
        filterItem.add(new FilterItemInfo("endDate", (Object)date1, CompareType.GREATER_EQUALS));
        filterItem.add(new FilterItemInfo("beginDate", (Object)date2, CompareType.LESS_EQUALS));
        filterItem.add(new FilterItemInfo("endDate", (Object)date2, CompareType.GREATER_EQUALS));
        filter.setMaskString("#0 and ( (#1 and #2) or (#3 and #4) or (#5 and #6) )");
        viewInfo.setFilter(filter);
        SorterItemCollection sort = viewInfo.getSorter();
        SorterItemInfo sortItemInfo = new SorterItemInfo("number");
        sortItemInfo.setSortType(SortType.ASCEND);
        sort.add(sortItemInfo);
        IBgPeriod iBgPeriod = null;
        iBgPeriod = ctx == null ? BgPeriodFactory.getRemoteInstance() : BgPeriodFactory.getLocalInstance(ctx);
        BgPeriodCollection bgPeriodColl = null;
        bgPeriodColl = iBgPeriod.getBgPeriodCollection(viewInfo);
        return bgPeriodColl;
    }

    public static BgPeriodCollection getBgPeriodCollOverDateRangeBySQL(Context ctx, int bgPeriodType, Date date1, Date date2) throws Exception {
        BgPeriodCollection bgPeriodCol = new BgPeriodCollection();
        if (date1 == null || date2 == null) {
            return bgPeriodCol;
        }
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rst = null;
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FId,");
        kSql.append("        FNumber,");
        kSql.append("        FName_" + ctx.getLocale());
        kSql.append("   from T_BG_BgPeriod");
        kSql.append("  where FPeriodType = ?");
        kSql.append("    and (");
        kSql.append("          (FBeginDate >= ? and FEndDate <= ?)");
        kSql.append("          or");
        kSql.append("          (FBeginDate <= ? and FEndDate >= ?)");
        kSql.append("          or");
        kSql.append("          (FBeginDate <= ? and FEndDate >= ?)");
        kSql.append("         )");
        kSql.append("  order by FNumber asc");
        java.sql.Date beginDate = new java.sql.Date(date1.getTime());
        java.sql.Date endDate = new java.sql.Date(date2.getTime());
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(kSql.toString());
            statement.setInt(1, bgPeriodType);
            statement.setDate(2, beginDate);
            statement.setDate(3, endDate);
            statement.setDate(4, beginDate);
            statement.setDate(5, beginDate);
            statement.setDate(6, endDate);
            statement.setDate(7, endDate);
            rst = statement.executeQuery();
            while (rst.next()) {
                BgPeriodInfo info = new BgPeriodInfo();
                info.setId(BOSUuid.read((String)rst.getString("FId")));
                info.setNumber(rst.getString("FNumber"));
                info.setName(rst.getString(3));
                bgPeriodCol.add(info);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)statement, (Connection)conn);
        return bgPeriodCol;
    }

    public static String tranMap2String(Map idMap) {
        if (idMap == null || idMap.size() < 1) {
            return null;
        }
        String ids = null;
        Iterator iter = idMap.keySet().iterator();
        for (int i = 0; iter.hasNext() && i < 999; ++i) {
            ids = ids == null ? "('" + (String)iter.next() + "'" : ids + ", '" + (String)iter.next() + "'";
        }
        ids = ids + ")";
        return ids;
    }
}

