/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BgItemReferenceHelper {
    public static final int BATCH_SIZE = 200;
    private static final String BOS_TYPE = "81A2EA2C";
    public static final String REFERENCE_NUMS = "referenceNumbers";
    public static final String REFERENCE_ROOTIDS = "referenceRootIds";
    public static final String REFERENCE_NUMS_INNERFILLDATA = "innerFillDataRefNums";
    public static final String REFERENCE_NUMS_ELIMTEMPLATE = "elimTemplateRefNums";
    public static final String REFERENCE_NUMS_ELIMINATION = "eliminationRefNums";
    public static final String REFERENCE_NUMS_WORKPAPER = "workPaperRefNums";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getAllReferencedItemNumber(Context ctx, List itemIdS) throws BOSException, EASBizException {
        HashMap referenceMap;
        HashMap<String, String> rootNumMap;
        HashMap<String, String> longNumMap;
        HashMap<String, String> combinMap;
        ArrayList rootReferenceIdList;
        ArrayList<String> referenceNumList;
        String longNumber;
        String number;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        int pos;
        int count;
        int size;
        block53: {
            if (itemIdS == null || itemIdS.isEmpty()) {
                return null;
            }
            StringBuffer queryNumberSql = new StringBuffer("select FID,FNumber,FRefField,FLevel,FLongNumber from t_bg_bgitem where fid in (");
            for (int i = 1; i < 200; ++i) {
                queryNumberSql.append("?,");
            }
            queryNumberSql.append("? )");
            size = 0;
            count = 0;
            pos = 0;
            conn = null;
            pstmt = null;
            rst = null;
            HashMap numberMap = new HashMap();
            String refField2 = null;
            number = null;
            longNumber = null;
            String id = null;
            List<String> numList = null;
            referenceNumList = null;
            rootReferenceIdList = null;
            combinMap = new HashMap<String, String>();
            longNumMap = new HashMap<String, String>();
            rootNumMap = new HashMap<String, String>();
            referenceMap = new HashMap();
            int level = 0;
            pos = 0;
            size = itemIdS.size();
            count = (size - 1) / 200 + 1;
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(queryNumberSql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 200) {
                    if (pos < size) {
                        pstmt.setString(x, (String)itemIdS.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        refField2 = rst.getString("FRefField");
                        number = rst.getString("FNumber");
                        level = rst.getInt("FLevel");
                        longNumber = rst.getString("FLongNumber");
                        id = rst.getString("FID");
                        if (numberMap.containsKey(refField2)) {
                            numList = (List)numberMap.get(refField2);
                            numList.add(number);
                        } else {
                            numList = new ArrayList();
                            numList.add(number);
                            numberMap.put(refField2, numList);
                        }
                        if (level == 1) {
                            rootNumMap.put(number, id);
                            continue;
                        }
                        longNumMap.put(number, longNumber);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            SQLUtils.cleanup((Statement)pstmt);
            StringBuffer queryCombinSql = null;
            for (String refField2 : numberMap.keySet()) {
                numList = (ArrayList)numberMap.get(refField2);
                queryCombinSql = new StringBuffer("select FID, " + refField2 + " from T_BG_BgItemCombination where ");
                queryCombinSql.append(refField2 + " in (");
                for (int i = 1; i < 200; ++i) {
                    queryCombinSql.append("?,");
                }
                queryCombinSql.append("? )");
                pstmt = conn.prepareStatement(queryCombinSql.toString());
                pos = 0;
                size = numList.size();
                count = (size - 1) / 200 + 1;
                for (int index = 0; index < count; ++index) {
                    int x = 1;
                    while (x <= 200) {
                        if (pos < size) {
                            pstmt.setString(x, (String)numList.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    try {
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            combinMap.put(rst.getString("FID"), rst.getString(refField2));
                        }
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt);
            if (combinMap != null && !combinMap.isEmpty()) break block53;
            Iterator it = null;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return it;
        }
        try {
            int i;
            ArrayList combinList = new ArrayList();
            combinList.addAll(combinMap.keySet());
            referenceNumList = new ArrayList<String>();
            rootReferenceIdList = new ArrayList();
            StringBuffer queryReferenceSql = new StringBuffer("select FBgItemCombinID from T_BG_BillUsedItem where FBgItemCombinID in (");
            for (i = 1; i < 200; ++i) {
                queryReferenceSql.append("?,");
            }
            queryReferenceSql.append("? )");
            pstmt = conn.prepareStatement(queryReferenceSql.toString());
            pos = 0;
            size = combinList.size();
            count = (size - 1) / 200 + 1;
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 200) {
                    if (pos < size) {
                        pstmt.setString(x, (String)combinList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                try {
                    rst = pstmt.executeQuery();
                    block29: while (rst.next()) {
                        number = (String)combinMap.get(rst.getString("FBgItemCombinID"));
                        if (!referenceNumList.contains(number)) {
                            referenceNumList.add(number);
                        }
                        if (rootNumMap.containsKey(number)) {
                            rootReferenceIdList.add(rootNumMap.get(number));
                            rootNumMap.remove(number);
                        }
                        if (!longNumMap.containsKey(number)) continue;
                        longNumber = (String)longNumMap.get(number);
                        for (String key : rootNumMap.keySet()) {
                            if (!longNumber.startsWith(key + "!")) continue;
                            rootReferenceIdList.add(rootNumMap.get(key));
                            rootNumMap.remove(key);
                            continue block29;
                        }
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            queryReferenceSql = new StringBuffer("select foutbgitemnumber from T_NT_ReceivableBill where foutbgitemnumber in ( ");
            for (i = 1; i < 200; ++i) {
                queryReferenceSql.append("?,");
            }
            queryReferenceSql.append("? )");
            pstmt = conn.prepareStatement(queryReferenceSql.toString());
            pos = 0;
            size = combinMap.size();
            if (size > 0) {
                ArrayList numbers = new ArrayList(combinMap.values());
                count = (size - 1) / 200 + 1;
                for (int index = 0; index < count; ++index) {
                    int x = 1;
                    while (x <= 200) {
                        if (pos < size) {
                            pstmt.setString(x, (String)numbers.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    try {
                        rst = pstmt.executeQuery();
                        block34: while (rst.next()) {
                            number = rst.getString("foutbgitemnumber");
                            if (!referenceNumList.contains(number)) {
                                referenceNumList.add(number);
                            }
                            if (rootNumMap.containsKey(number)) {
                                rootReferenceIdList.add(rootNumMap.get(number));
                                rootNumMap.remove(number);
                            }
                            if (!longNumMap.containsKey(number)) continue;
                            longNumber = (String)longNumMap.get(number);
                            for (String key : rootNumMap.keySet()) {
                                if (!longNumber.startsWith(key + "!")) continue;
                                rootReferenceIdList.add(rootNumMap.get(key));
                                rootNumMap.remove(key);
                                continue block34;
                            }
                        }
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        referenceMap.put(REFERENCE_NUMS, referenceNumList);
        referenceMap.put(REFERENCE_ROOTIDS, rootReferenceIdList);
        return referenceMap;
    }

    public static Map getElimReferencedItemNumber(Context ctx, List itemIdS) throws BOSException, EASBizException {
        HashMap referenceMap;
        HashMap<String, String> rootNumMap;
        HashMap<String, String> longNumMap;
        HashMap<String, String> combinMap;
        ArrayList eliminationRootRefIdList;
        ArrayList<String> eliminationRefNumList;
        ArrayList elimTemplateRootRefIdList;
        ArrayList<String> elimTemplateRefNumList;
        ArrayList innerFillDataRootRefIdList;
        ArrayList<String> innerFillDataRefNumList;
        String longNumber;
        String number;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        int pos;
        int count;
        int size;
        block49: {
            if (itemIdS == null || itemIdS.isEmpty()) {
                return null;
            }
            StringBuffer queryNumberSql = new StringBuffer("select FID,FNumber,FRefField,FLevel,FLongNumber from t_bg_bgitem where fid in (");
            for (int i = 1; i < 200; ++i) {
                queryNumberSql.append("?,");
            }
            queryNumberSql.append("? )");
            size = 0;
            count = 0;
            pos = 0;
            conn = null;
            pstmt = null;
            rst = null;
            HashMap numberMap = new HashMap();
            String refField2 = null;
            number = null;
            longNumber = null;
            String id = null;
            List<String> numList = null;
            innerFillDataRefNumList = null;
            innerFillDataRootRefIdList = null;
            elimTemplateRefNumList = null;
            elimTemplateRootRefIdList = null;
            eliminationRefNumList = null;
            eliminationRootRefIdList = null;
            combinMap = new HashMap<String, String>();
            longNumMap = new HashMap<String, String>();
            rootNumMap = new HashMap<String, String>();
            referenceMap = new HashMap();
            int level = 0;
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(queryNumberSql.toString());
            pos = 0;
            size = itemIdS.size();
            count = (size - 1) / 200 + 1;
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 200) {
                    if (pos < size) {
                        pstmt.setString(x, (String)itemIdS.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    refField2 = rst.getString("FRefField");
                    number = rst.getString("FNumber");
                    level = rst.getInt("FLevel");
                    longNumber = rst.getString("FLongNumber");
                    id = rst.getString("FID");
                    if (numberMap.containsKey(refField2)) {
                        numList = (List)numberMap.get(refField2);
                        numList.add(number);
                    } else {
                        numList = new ArrayList();
                        numList.add(number);
                        numberMap.put(refField2, numList);
                    }
                    if (level == 1) {
                        rootNumMap.put(number, id);
                        continue;
                    }
                    longNumMap.put(number, longNumber);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            StringBuffer queryCombinSql = null;
            for (String refField2 : numberMap.keySet()) {
                numList = (ArrayList)numberMap.get(refField2);
                queryCombinSql = new StringBuffer("select FID, " + refField2 + " from T_BG_BgItemCombination where ");
                queryCombinSql.append(refField2 + " in (");
                for (int i = 1; i < 200; ++i) {
                    queryCombinSql.append("?,");
                }
                queryCombinSql.append("? )");
                pstmt = conn.prepareStatement(queryCombinSql.toString());
                pos = 0;
                size = numList.size();
                count = (size - 1) / 200 + 1;
                for (int index = 0; index < count; ++index) {
                    int x = 1;
                    while (x <= 200) {
                        if (pos < size) {
                            pstmt.setString(x, (String)numList.get(pos));
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        combinMap.put(rst.getString("FID"), rst.getString(refField2));
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            SQLUtils.cleanup((Statement)pstmt);
            if (combinMap != null && !combinMap.isEmpty()) break block49;
            Iterator it = null;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return it;
        }
        try {
            int index;
            int i;
            ArrayList combinList = new ArrayList();
            combinList.addAll(combinMap.keySet());
            innerFillDataRefNumList = new ArrayList<String>();
            innerFillDataRootRefIdList = new ArrayList();
            StringBuffer queryReferenceSql = new StringBuffer("select FBgItemId from T_BG_BgInnerFillDataEntry where FBgItemId in (");
            for (i = 1; i < 200; ++i) {
                queryReferenceSql.append("?,");
            }
            queryReferenceSql.append("? ) order by fbgitemnumber ");
            pstmt = conn.prepareStatement(queryReferenceSql.toString());
            pos = 0;
            size = combinList.size();
            count = (size - 1) / 200 + 1;
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 200) {
                    if (pos < size) {
                        pstmt.setString(x, (String)combinList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                block17: while (rst.next()) {
                    number = (String)combinMap.get(rst.getString("FBgItemId"));
                    if (!innerFillDataRefNumList.contains(number)) {
                        innerFillDataRefNumList.add(number);
                    }
                    if (rootNumMap.containsKey(number)) {
                        innerFillDataRootRefIdList.add(rootNumMap.get(number));
                        rootNumMap.remove(number);
                    }
                    if (!longNumMap.containsKey(number)) continue;
                    longNumber = (String)longNumMap.get(number);
                    for (String key : rootNumMap.keySet()) {
                        if (!longNumber.startsWith(key + "!")) continue;
                        innerFillDataRootRefIdList.add(rootNumMap.get(key));
                        rootNumMap.remove(key);
                        continue block17;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            elimTemplateRefNumList = new ArrayList<String>();
            elimTemplateRootRefIdList = new ArrayList();
            queryReferenceSql = new StringBuffer("select FBgItemId from t_bg_bgElimTemplateEntry where FBgItemId in (");
            for (i = 1; i < 200; ++i) {
                queryReferenceSql.append("?,");
            }
            queryReferenceSql.append("? ) order by fbgitemnumber");
            pstmt = conn.prepareStatement(queryReferenceSql.toString());
            pos = 0;
            size = combinList.size();
            count = (size - 1) / 200 + 1;
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 200) {
                    if (pos < size) {
                        pstmt.setString(x, (String)combinList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                block22: while (rst.next()) {
                    number = (String)combinMap.get(rst.getString("FBgItemId"));
                    if (!elimTemplateRefNumList.contains(number)) {
                        elimTemplateRefNumList.add(number);
                    }
                    if (rootNumMap.containsKey(number)) {
                        elimTemplateRootRefIdList.add(rootNumMap.get(number));
                        rootNumMap.remove(number);
                    }
                    if (!longNumMap.containsKey(number)) continue;
                    longNumber = (String)longNumMap.get(number);
                    for (String key : rootNumMap.keySet()) {
                        if (!longNumber.startsWith(key + "!")) continue;
                        elimTemplateRootRefIdList.add(rootNumMap.get(key));
                        rootNumMap.remove(key);
                        continue block22;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            eliminationRefNumList = new ArrayList<String>();
            eliminationRootRefIdList = new ArrayList();
            queryReferenceSql = new StringBuffer("select FBgItemId from t_bg_bgEliminationEntry where FBgItemId in (");
            for (i = 1; i < 200; ++i) {
                queryReferenceSql.append("?,");
            }
            queryReferenceSql.append("? ) order by fbgitemnumber");
            pstmt = conn.prepareStatement(queryReferenceSql.toString());
            pos = 0;
            size = combinList.size();
            count = (size - 1) / 200 + 1;
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= 200) {
                    if (pos < size) {
                        pstmt.setString(x, (String)combinList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                block27: while (rst.next()) {
                    number = (String)combinMap.get(rst.getString("FBgItemId"));
                    if (!eliminationRefNumList.contains(number)) {
                        eliminationRefNumList.add(number);
                    }
                    if (rootNumMap.containsKey(number)) {
                        eliminationRootRefIdList.add(rootNumMap.get(number));
                        rootNumMap.remove(number);
                    }
                    if (!longNumMap.containsKey(number)) continue;
                    longNumber = (String)longNumMap.get(number);
                    for (String key : rootNumMap.keySet()) {
                        if (!longNumber.startsWith(key + "!")) continue;
                        eliminationRootRefIdList.add(rootNumMap.get(key));
                        rootNumMap.remove(key);
                        continue block27;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        referenceMap.put(REFERENCE_NUMS_INNERFILLDATA, innerFillDataRefNumList);
        referenceMap.put(REFERENCE_NUMS_ELIMTEMPLATE, elimTemplateRefNumList);
        referenceMap.put(REFERENCE_NUMS_ELIMINATION, eliminationRefNumList);
        return referenceMap;
    }

    public static void signBgItemUsed(Context ctx, IObjectPK billPK, String[] bgItemCombinIdS) throws BOSException, EASBizException {
        if (billPK == null || bgItemCombinIdS == null || bgItemCombinIdS.length == 0) {
            return;
        }
        BgItemReferenceHelper.signBgItemUsed(ctx, billPK, Arrays.asList(bgItemCombinIdS));
    }

    public static void batchBgItemUsed(Context ctx, Map bgItemCombinIds) throws BOSException, EASBizException {
        if (ctx == null || bgItemCombinIds == null || bgItemCombinIds.isEmpty()) {
            return;
        }
        int batchIndex = 0;
        int batchSize = 100;
        Object var4_4 = null;
        IObjectPK _pk22 = null;
        String[] _bgItemIds = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            pstmt = conn.prepareStatement("delete from T_BG_BillUsedItem where FBillID = ?");
            for (IObjectPK _pk22 : bgItemCombinIds.keySet()) {
                if (_pk22 != null) {
                    pstmt.setString(1, _pk22.toString());
                    pstmt.addBatch();
                    ++batchIndex;
                }
                if (batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmt);
            batchIndex = 0;
            batchSize = 250;
            pstmt = conn.prepareStatement("INSERT INTO T_BG_BillUsedItem (FID, FBillID, FBgItemCombinID) values (?,?,?)");
            for (Map.Entry entry : bgItemCombinIds.entrySet()) {
                _pk22 = (IObjectPK)entry.getKey();
                _bgItemIds = (String[])entry.getValue();
                if (_pk22 == null || _bgItemIds == null || _bgItemIds.length <= 0) continue;
                int in = _bgItemIds.length;
                for (int i = 0; i < in; ++i) {
                    pstmt.setString(1, BOSUuid.create((String)BOS_TYPE).toString());
                    pstmt.setString(2, _pk22.toString());
                    pstmt.setString(3, _bgItemIds[i].toString());
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static void signBgItemUsed(Context ctx, IObjectPK billPK, List bgItemCombinIDS) throws BOSException, EASBizException {
        if (billPK == null || bgItemCombinIDS == null || bgItemCombinIDS.size() == 0) {
            return;
        }
        DbUtil.execute((Context)ctx, (String)"delete from T_BG_BillUsedItem where FBillID = ? ", (Object[])new Object[]{billPK.toString()});
        StringBuffer insertSql = new StringBuffer(1024);
        insertSql.append("insert into T_BG_BillUsedItem (FID,FBillID,FBgItemCombinID) values (?,?,?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(insertSql.toString());
            int count = 0;
            int size = bgItemCombinIDS.size();
            for (int i = 0; i < size; ++i) {
                pstmt.setString(1, BOSUuid.create((String)BOS_TYPE).toString());
                pstmt.setString(2, billPK.toString());
                pstmt.setString(3, bgItemCombinIDS.get(i).toString());
                pstmt.addBatch();
                if (++count != 200) continue;
                pstmt.executeBatch();
                count = 0;
            }
            if (count != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static void signBgItemRelease(Context ctx, IObjectPK billPK) throws BOSException, EASBizException {
        if (billPK == null) {
            return;
        }
        DbUtil.execute((Context)ctx, (String)"delete from T_BG_BillUsedItem where FBillID = ? ", (Object[])new Object[]{billPK.toString()});
    }

    public static void signBgItemRelease(Context ctx, IObjectPK[] billPKS) throws BOSException {
        if (billPKS == null || billPKS.length == 0) {
            return;
        }
        String deleteSql = "delete from T_BG_BillUsedItem where FBillID= ? ";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(deleteSql.toString());
            int count = 0;
            int size = billPKS.length;
            for (int i = 0; i < size; ++i) {
                pstmt.setString(1, billPKS[i].toString());
                pstmt.addBatch();
                if (++count != 200) continue;
                pstmt.executeBatch();
                count = 0;
            }
            if (count != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

