/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class BgPeriodNExprGetterHelper {
    private static final Logger logger = Logger.getLogger(BgPeriodNExprGetterHelper.class);
    private static final String RPTDATE_STR = "RPTDATE";
    private static final String BGRPTDATE_STR = "BGRPTDATE";
    private static final String BGGETORGNUM_STR = "BGGETORGNUM";
    private static final String BGFORMULA_STR = "BGFORMULA";
    private static final String BGACTUAL_STR = "BGACTUAL";
    private static final String BGACT_STR = "BGACT";
    private static final String BGBAL_STR = "BGBAL";
    private static final String BGACTUALS_STR = "BGACTUALS";
    private static final String BGACTUALEXT_STR = "BGACTUALEXT";
    private static final String BGREFBGTEM_STR = "BGREFBGTEM";
    private static final String BGADJUST_STR = "BGADJUST";
    private static final String BGAVLBAL_STR = "BGAVLBAL";

    public static String checkExpression(Cell cell, String expressions, final String periodNumber, final int bgFormPeriodType) {
        if (StringUtils.isEmpty((String)expressions) || periodNumber == null) {
            return null;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressions);
            if (cell != null && expression instanceof FunctionExpr) {
                BgPeriodNExprGetterHelper.checkFuncionName((FunctionExpr)expression, cell);
            }
            if (expression instanceof Ref3DExpr) {
                return expressions;
            }
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgPeriodNExprGetterHelper.checkExpression(expr, periodNumber, bgFormPeriodType);
                }
            });
            _expressions = '=' + expression.toString();
        }
        catch (Exception ex) {
            logger.error((Object)expressions);
            logger.error((Object)ex);
        }
        return _expressions;
    }

    private static void checkFuncionName(FunctionExpr expr, Cell cell) {
        String obj;
        if (expr == null || cell == null) {
            return;
        }
        String funcionName = expr.funcionName;
        if ((RPTDATE_STR.equalsIgnoreCase(funcionName) || BGRPTDATE_STR.equalsIgnoreCase(funcionName) || BGGETORGNUM_STR.equalsIgnoreCase(funcionName)) && ((obj = cell.getStyle().getNumberFormat()) == null || !"@".equals(obj))) {
            BgNFSHelper.setNumberFormat((Cell)cell, (String)"@");
        }
    }

    private static Expression checkExpression(Expression expression, String periodNumber, int bgFormPeriodType) {
        if (expression instanceof FunctionExpr) {
            expression = BgPeriodNExprGetterHelper.checkFunctionExpr((FunctionExpr)expression, periodNumber, bgFormPeriodType);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgPeriodNExprGetterHelper.checkBinaryOperationExpr((BinaryOperationExpr)expression, periodNumber, bgFormPeriodType);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = BgPeriodNExprGetterHelper.checkUnaryOperationExpr((UnaryOperationExpr)expression, periodNumber);
        }
        return expression;
    }

    private static Expression checkFunctionExpr(FunctionExpr funExpr, String periodNumber, int bgFormPeriodType) {
        String funcionName = funExpr.funcionName;
        try {
            if (BGFORMULA_STR.equalsIgnoreCase(funcionName) || BGACT_STR.equalsIgnoreCase(funcionName) || BGBAL_STR.equalsIgnoreCase(funcionName) || BGACTUALS_STR.equalsIgnoreCase(funcionName) || BGREFBGTEM_STR.equalsIgnoreCase(funcionName) || BGADJUST_STR.equalsIgnoreCase(funcionName) || BGAVLBAL_STR.equalsIgnoreCase(funcionName) || BGACTUALEXT_STR.equalsIgnoreCase(funcionName)) {
                FunctionExpr _expression = funExpr;
                Expression p0 = (Expression)funExpr.parameters.get(0);
                if (p0 instanceof StringExpr) {
                    StringExpr sp = (StringExpr)p0;
                    String valueStr = sp.value;
                    String[] pp = valueStr.split(";");
                    if (pp != null && pp.length > 1) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < pp.length; ++i) {
                            funExpr.parameters.set(0, new StringExpr(pp[i]));
                            if (sb.length() > 1) {
                                sb.append('+');
                            }
                            funExpr.output(sb);
                        }
                        _expression = ExcelFormulaPaserHelper.parse((String)sb.toString());
                        _expression = BgPeriodNExprGetterHelper.checkExpression((Expression)_expression, periodNumber, bgFormPeriodType);
                    }
                }
                if (_expression instanceof FunctionExpr) {
                    BgPeriodNExprGetterHelper.checkExpressionParam(_expression, periodNumber, bgFormPeriodType);
                }
                return _expression;
            }
            BgPeriodNExprGetterHelper.checkExpressionParam(funExpr, periodNumber, bgFormPeriodType);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return funExpr;
    }

    private static BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, String periodNumber, int bgFormPeriodType) {
        boExpr.left = BgPeriodNExprGetterHelper.checkExpression(boExpr.left, periodNumber, bgFormPeriodType);
        boExpr.right = BgPeriodNExprGetterHelper.checkExpression(boExpr.right, periodNumber, bgFormPeriodType);
        return boExpr;
    }

    private static UnaryOperationExpr checkUnaryOperationExpr(UnaryOperationExpr boExpr, String periodNumberl) {
        return boExpr;
    }

    private static void checkExpressionParam(FunctionExpr funExpr, String periodNumber, int bgFormPeriodType) {
        String funcionName = funExpr.funcionName;
        if (BGACTUAL_STR.equalsIgnoreCase(funcionName)) {
            BgPeriodNExprGetterHelper.checkBgActualParam(funExpr.parameters, periodNumber, bgFormPeriodType);
        } else if (BGFORMULA_STR.equalsIgnoreCase(funcionName) || BGACT_STR.equalsIgnoreCase(funcionName) || BGACTUALS_STR.equalsIgnoreCase(funcionName) || BGBAL_STR.equalsIgnoreCase(funcionName) || BGADJUST_STR.equalsIgnoreCase(funcionName)) {
            BgPeriodNExprGetterHelper.checkBgFormulaParam(funExpr.parameters, periodNumber, bgFormPeriodType);
        } else if (BGAVLBAL_STR.equalsIgnoreCase(funcionName)) {
            BgPeriodNExprGetterHelper.checkBgAvlBalFormulaParam(funExpr.parameters, periodNumber, bgFormPeriodType);
        } else if (BGREFBGTEM_STR.equalsIgnoreCase(funcionName)) {
            BgPeriodNExprGetterHelper.checkBgRefBgTemplateParam(funExpr.parameters, periodNumber, bgFormPeriodType);
        } else if (BGACTUALEXT_STR.equalsIgnoreCase(funcionName)) {
            BgPeriodNExprGetterHelper.checkBgActualExtFormulaParam(funExpr.parameters, periodNumber, bgFormPeriodType);
        }
    }

    private static void checkBgActualParam(List parameter, String periodNumber, int bgFormPeriodType) {
        if (parameter == null || parameter.size() != 6) {
            return;
        }
        StringExpr param4 = (StringExpr)parameter.get(4);
        StringExpr param5 = (StringExpr)parameter.get(5);
        try {
            param4.value = BgPeriodNVariableHelper.getBgPeriodByN(periodNumber, param4.value, bgFormPeriodType);
        }
        catch (BgFormException e) {
            logger.error((Object)e);
        }
        try {
            param5.value = BgPeriodNVariableHelper.getBgPeriodByN(periodNumber, param5.value, bgFormPeriodType);
        }
        catch (BgFormException e) {
            logger.error((Object)e);
        }
    }

    private static void checkBgRefBgTemplateParam(List parameter, String periodNumber, int bgFormPeriodType) {
        if (parameter == null || parameter.size() != 7) {
            return;
        }
        StringExpr param3 = (StringExpr)parameter.get(3);
        try {
            param3.value = BgPeriodNVariableHelper.getBgPeriodByN(periodNumber, param3.value, bgFormPeriodType);
        }
        catch (BgFormException e) {
            logger.error((Object)e);
        }
    }

    private static void checkBgFormulaParam(List parameter, String periodNumber, int bgFormPeriodType) {
        if (parameter == null || parameter.size() != 7) {
            return;
        }
        StringExpr param5 = (StringExpr)parameter.get(5);
        StringExpr param6 = (StringExpr)parameter.get(6);
        try {
            param5.value = BgPeriodNVariableHelper.getBgPeriodByN(periodNumber, param5.value, bgFormPeriodType);
        }
        catch (BgFormException e) {
            logger.error((Object)e);
        }
        try {
            param6.value = BgPeriodNVariableHelper.getBgPeriodByN(periodNumber, param6.value, bgFormPeriodType);
        }
        catch (BgFormException e) {
            logger.error((Object)e);
        }
    }

    private static void checkBgAvlBalFormulaParam(List parameter, String periodNumber, int bgFormPeriodType) {
        if (parameter == null || parameter.size() != 6) {
            return;
        }
        StringExpr param5 = (StringExpr)parameter.get(5);
        try {
            param5.value = BgPeriodNVariableHelper.getBgPeriodByN(periodNumber, param5.value, bgFormPeriodType);
        }
        catch (BgFormException e) {
            logger.error((Object)e);
        }
    }

    private static void checkBgActualExtFormulaParam(List parameter, String periodNumber, int bgFormPeriodType) {
        if (parameter == null || parameter.size() != 8) {
            return;
        }
        StringExpr param5 = (StringExpr)parameter.get(5);
        StringExpr param6 = (StringExpr)parameter.get(6);
        try {
            param5.value = BgPeriodNVariableHelper.getBgPeriodByN(periodNumber, param5.value, bgFormPeriodType);
            param6.value = BgPeriodNVariableHelper.getBgPeriodByN(periodNumber, param6.value, bgFormPeriodType);
        }
        catch (BgFormException e) {
            logger.error((Object)e);
        }
    }
}

