/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgPeriodNExprGetterHelper;
import com.kingdee.eas.ma.budget.BgPeriodNExprSetterHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Set;
import java.util.regex.Pattern;

public class BgPeriodNVariableHelper {
    public static final String NUMBER_N = "N";
    private static final String NUMBER_n = "n";
    public static final String ERROR_Matching = "PeriodTypeNotMatching";
    public static final String EMPTY_STR = "";
    private static final String DEFAULT_STR = "0";
    public static final String BGDATA_VALUE = "bgData";
    public static final String BGITEMFORMUAL_VALUE = "BGITEMFORMUAL";
    public static final String BGACTUAL_VALUE = "bgActual";
    public static final String BGACTUALADD_VALUE = "bgActualAdd";
    public static final String VALUE_VALUE = "bgValue";
    public static final String CONVERT_TYPE_ALL = "ALL";
    public static final String CONVERT_TYPE_PART = "PART";
    public static final String PATTERN_PERIOD_N = "(N[\\s]?|\\+\\d{1,3}|\\-\\d{1,3})+";

    public static void convertPeriodNvalue(Book book, String periodNumber, int viewType, int bgFormPeriodType) throws Exception {
        BgPeriodNVariableHelper.convertPeriodNvalue(book, periodNumber, viewType, bgFormPeriodType, null);
    }

    public static void convertPeriodNvalue(Book book, String periodNumber, int viewType, int bgFormPeriodType, Set sheetFilter) throws Exception {
        if (periodNumber == null || book == null) {
            return;
        }
        boolean isBySheet = false;
        if (sheetFilter != null && !sheetFilter.isEmpty()) {
            isBySheet = true;
        }
        BgNFSHelper.disableUndo((Book)book);
        BgNFSHelper.disableCal((Book)book);
        int sheetCount = book.getSheetCount();
        Sheet sheet = null;
        Cell cell = null;
        String formulaString = null;
        String[] param = null;
        String newFormula = null;
        String nValue = null;
        String expr = null;
        String newPeriod = null;
        for (int i = 0; i < sheetCount; ++i) {
            sheet = book.getSheet(i);
            if (sheet == null || isBySheet && !sheetFilter.contains(BgNFSHelper.getSheetSign((Sheet)sheet))) continue;
            int maxRowIndex = sheet.getMaxRowIndex();
            int maxColIndex = sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= maxRowIndex; ++rowIndex) {
                for (int colIndex = 0; colIndex <= maxColIndex; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null) continue;
                    if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                        formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell);
                        param = BgNFSHelper.parseFormulaPara(null, (String)formulaString);
                        if (param == null) continue;
                        nValue = param[1];
                        newPeriod = BgPeriodNVariableHelper.getBgPeriodByN(periodNumber, nValue, bgFormPeriodType);
                        if (param.length == 4) {
                            param[1] = newPeriod;
                            newFormula = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\")";
                        }
                        if (param.length == 6) {
                            param[1] = newPeriod;
                            newFormula = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\"," + param[4] + ",\"" + param[5] + "\")";
                        }
                        if (!newPeriod.equals(nValue)) {
                            BgNFSHelper.setFormulaOfCell((Cell)cell, newFormula);
                        }
                    }
                    if (!BgNTemplateHelper.CheckTemplateHaveDataFormula((Cell)cell)) continue;
                    expr = BgPeriodNExprGetterHelper.checkExpression(cell, BgNTemplateHelper.getBgDataValue((Cell)cell, (String)"BG_BUDGET_EXPRESSIONS"), periodNumber, bgFormPeriodType);
                    if (expr != null) {
                        BgNFSHelper.saveExpression((Cell)cell, (String)expr, (int)0);
                        if (0 == viewType) {
                            cell.setFormula(expr);
                        }
                    }
                    if ((expr = BgPeriodNExprGetterHelper.checkExpression(cell, BgNTemplateHelper.getBgDataValue((Cell)cell, (String)"BG_ACTUAL_EXPRESSIONS"), periodNumber, bgFormPeriodType)) != null) {
                        BgNFSHelper.saveExpression((Cell)cell, (String)expr, (int)1);
                        if (1 == viewType) {
                            cell.setFormula(expr);
                        }
                    }
                    if ((expr = BgPeriodNExprGetterHelper.checkExpression(cell, BgNTemplateHelper.getBgDataValue((Cell)cell, (String)"BG_ADD_EXPRESSIONS"), periodNumber, bgFormPeriodType)) == null) continue;
                    BgNFSHelper.saveExpression((Cell)cell, (String)expr, (int)2);
                    if (2 != viewType) continue;
                    cell.setFormula(expr);
                }
            }
        }
        BgNFSHelper.enableUndo((Book)book);
        BgNFSHelper.enableCal((Book)book);
    }

    public static void processPeriodNvalue(String viewType, Book book, String nValue, String convertType) throws Exception {
        if (viewType == null || book == null) {
            return;
        }
        BgNFSHelper.disableUndo((Book)book);
        BgNFSHelper.disableCal((Book)book);
        Sheet sheet = book.getActiveSheet();
        if (sheet != null) {
            Range range = sheet.getSelectionRange();
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int i = 0; i < range.size(); ++i) {
                CellBlock block = range.getBlock(i);
                int rowBegin = block.getRow() > maxRow ? maxRow : block.getRow();
                int rowEnd = block.getRow2() > maxRow ? maxRow : block.getRow2();
                int colBegin = block.getCol() > maxCol ? maxCol : block.getCol();
                int colEnd = block.getCol2() > maxCol ? maxCol : block.getCol2();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    for (int k = colBegin; k <= colEnd; ++k) {
                        Cell cell = sheet.getCell(j, k, false);
                        if (cell == null) continue;
                        if (BGITEMFORMUAL_VALUE.equals(viewType)) {
                            BgPeriodNVariableHelper.processBgItemFormulaView(cell, nValue, convertType);
                        } else if (BGACTUAL_VALUE.equals(viewType)) {
                            BgPeriodNVariableHelper.processBgActualView(cell, nValue, convertType);
                        } else if (BGDATA_VALUE.equals(viewType)) {
                            BgPeriodNVariableHelper.processBgDataView(cell, nValue, convertType);
                        } else if (BGACTUALADD_VALUE.equals(viewType)) {
                            BgPeriodNVariableHelper.processBgActualAddView(cell, nValue, convertType);
                        }
                        BgPeriodNVariableHelper.processBgPeriod(cell, nValue, convertType);
                    }
                }
            }
        }
        BgNFSHelper.enableUndo((Book)book);
        BgNFSHelper.enableCal((Book)book);
    }

    private static void processBgDataView(Cell cell, String nValue, String convertType) {
        if (cell != null && cell.isLocked()) {
            return;
        }
        if (BgNTemplateHelper.CheckTemplateHaveDataFormula((Cell)cell)) {
            String expr = BgPeriodNExprSetterHelper.checkExpression(cell, BgNTemplateHelper.getBgDataValue((Cell)cell, (String)"BG_BUDGET_EXPRESSIONS"), nValue, convertType);
            BgNFSHelper.saveExpression((Cell)cell, (String)expr, (int)0);
        }
    }

    private static void processBgActualView(Cell cell, String nValue, String convertType) {
        if (cell != null && cell.isLocked()) {
            return;
        }
        if (BgNTemplateHelper.CheckTemplateHaveDataFormula((Cell)cell)) {
            String expr = BgPeriodNExprSetterHelper.checkExpression(cell, BgNTemplateHelper.getBgDataValue((Cell)cell, (String)"BG_ACTUAL_EXPRESSIONS"), nValue, convertType);
            BgNFSHelper.saveExpression((Cell)cell, (String)expr, (int)1);
        }
    }

    private static void processBgActualAddView(Cell cell, String nValue, String convertType) {
        if (cell != null && cell.isLocked()) {
            return;
        }
        if (BgNTemplateHelper.CheckTemplateHaveDataFormula((Cell)cell)) {
            String expr = BgPeriodNExprSetterHelper.checkExpression(cell, BgNTemplateHelper.getBgDataValue((Cell)cell, (String)"BG_ADD_EXPRESSIONS"), nValue, convertType);
            BgNFSHelper.saveExpression((Cell)cell, (String)expr, (int)2);
        }
    }

    private static void processBgItemFormulaView(Cell cell, String nValue, String convertType) {
        if (cell != null && cell.isLocked()) {
            return;
        }
        String formulaString = null;
        String[] param = null;
        String newFormula = null;
        if (BgNFSHelper.checkHasItemFormula((Cell)cell)) {
            String isFormSuper;
            ItemFormula uItemFormual = BgNFSHelper.getItemFormula((Cell)cell);
            if (uItemFormual != null && "true".equals(isFormSuper = uItemFormual.getExt("isctrl_from_super_collection_form"))) {
                return;
            }
            formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell);
            param = BgNFSHelper.parseFormulaPara(null, (String)formulaString);
            if (param == null) {
                return;
            }
            String periodParam = null;
            if (param.length == 4) {
                periodParam = param[1];
                param[1] = BgPeriodNVariableHelper.getParamValue(periodParam, nValue, convertType);
                newFormula = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\")";
            }
            if (param.length == 6) {
                periodParam = param[1];
                param[1] = BgPeriodNVariableHelper.getParamValue(periodParam, nValue, convertType);
                newFormula = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\"," + param[4] + ",\"" + param[5] + "\")";
            }
            if (newFormula != null) {
                BgNFSHelper.setFormulaOfCell((Cell)cell, newFormula);
            }
        }
    }

    private static void processBgPeriod(Cell cell, String nValue, String convertType) {
        if (cell != null && cell.isLocked()) {
            return;
        }
        if (BgNFSHelper.checkHasBgPeriodInfo((Cell)cell)) {
            String[] periods = BgNFSHelper.getBgPeriodInfo((Cell)cell);
            String value = BgPeriodNVariableHelper.getParamValue(periods[1], nValue, convertType);
            cell.setValue(new Variant((Object)value));
            BgNFSHelper.setCellData((Cell)cell, (String)"bgFillValue", (Object)value);
        }
    }

    private static String getParamValue(String param, String nValue, String convertType) {
        if (CONVERT_TYPE_ALL.equals(convertType)) {
            return nValue;
        }
        if (CONVERT_TYPE_PART.equals(convertType)) {
            return BgPeriodNVariableHelper.getPartParaValue(param, nValue);
        }
        return null;
    }

    public static String getPartParaValue(String param, String nValue) {
        if (StringUtils.isEmpty((String)param) || StringUtils.isEmpty((String)nValue)) {
            return null;
        }
        String[] splitParam = param.split("\\.");
        String[] splitNValue = nValue.split("\\.");
        String retValue = null;
        if (splitParam.length == 1) {
            retValue = splitNValue.length == 2 || splitNValue.length == 1 && splitNValue[0].lastIndexOf("Y") > 0 ? splitNValue[0] : param;
        } else if (splitParam.length == 2) {
            if (splitNValue.length == 1 && splitNValue[0].lastIndexOf("Y") > 0) {
                retValue = nValue + param.substring(param.indexOf("."));
            }
            if (splitNValue.length == 1 && splitNValue[0].lastIndexOf("M") > 0) {
                retValue = splitParam[0] + "." + nValue;
            }
            if (splitNValue.length == 2) {
                retValue = nValue;
            }
        } else if (splitParam.length == 3) {
            if (splitNValue.length == 1 && splitNValue[0].lastIndexOf("Y") > 0) {
                retValue = nValue + param.substring(param.indexOf("."));
            }
            if (splitNValue.length == 1 && splitNValue[0].lastIndexOf("M") > 0) {
                retValue = splitParam[0] + "." + nValue + "." + splitParam[2];
            }
            if (splitNValue.length == 2) {
                retValue = nValue + "." + splitParam[2];
            }
        }
        return retValue;
    }

    public static boolean checkCanProcessPeriodNValue(String viewType) {
        if (viewType == null) {
            return false;
        }
        if (VALUE_VALUE.equals(viewType)) {
            return false;
        }
        return BGITEMFORMUAL_VALUE.equals(viewType) || BGACTUAL_VALUE.equals(viewType) || BGDATA_VALUE.equals(viewType) || BGACTUALADD_VALUE.equals(viewType);
    }

    public static String getBgPeriodByN(String bgFormPeriod, String nPeriodNum, int bgFormPeriodType) throws BgFormException {
        if (!BgPeriodNVariableHelper.checkCanConvert(nPeriodNum)) {
            return nPeriodNum;
        }
        if (8 == bgFormPeriodType) {
            return bgFormPeriod;
        }
        String[] nPeriodNums = nPeriodNum.split("\\.");
        String tempStr = null;
        String[] tempStrs = null;
        String periodType = null;
        String targetPeriod = new String(bgFormPeriod);
        if (nPeriodNums.length == 2 && Pattern.matches("[\\d]{1,6}D", nPeriodNums[1])) {
            tempStr = nPeriodNums[0];
            targetPeriod = BgPeriodNVariableHelper.processPeriodNVariable(tempStr, bgFormPeriodType, targetPeriod);
            try {
                int year = Integer.valueOf(targetPeriod.substring(0, 4));
                int period = Integer.valueOf(nPeriodNums[1].replaceAll("D", EMPTY_STR));
                targetPeriod = BgPeriodNVariableHelper.getPeriodByYearAndDay(year, period);
            }
            catch (Exception year) {
                // empty catch block
            }
            return targetPeriod;
        }
        int size = nPeriodNums.length;
        for (int i = 0; i < size; ++i) {
            tempStr = nPeriodNums[i];
            tempStrs = tempStr.split("!");
            if (tempStrs.length == 1) {
                if (i == 0) {
                    if (bgFormPeriod.length() > 5) {
                        targetPeriod = tempStr + targetPeriod.substring(5, bgFormPeriod.length());
                        continue;
                    }
                    targetPeriod = tempStr;
                    continue;
                }
                if (i == 1) {
                    periodType = tempStr.substring(2);
                    int index = targetPeriod.indexOf(periodType);
                    if (index > 1) {
                        targetPeriod = targetPeriod.replaceAll(targetPeriod.substring(index - 2, index) + periodType, tempStr);
                        continue;
                    }
                    throw new BgFormException(BgFormException.PERIODNVALUEISNOTVALID, new String[]{bgFormPeriod, nPeriodNum});
                }
                if (i != 2) continue;
                periodType = tempStr.substring(2);
                int index = targetPeriod.indexOf(periodType);
                if (index > 1) {
                    targetPeriod = targetPeriod.replaceAll(targetPeriod.substring(index - 2, index) + periodType, tempStr);
                    continue;
                }
                throw new BgFormException(BgFormException.PERIODNVALUEISNOTVALID, new String[]{bgFormPeriod, nPeriodNum});
            }
            if (tempStrs.length == 2) {
                try {
                    periodType = tempStrs[1];
                    String partPeriod = nPeriodNum.substring(nPeriodNum.indexOf(periodType) + periodType.length());
                    targetPeriod = BgPeriodNVariableHelper.processPeriodNVariable(tempStr, bgFormPeriodType, targetPeriod);
                    if (partPeriod.indexOf("!") != -1) {
                        targetPeriod = targetPeriod + bgFormPeriod.substring(bgFormPeriod.indexOf(periodType) + periodType.length());
                        targetPeriod = BgPeriodNVariableHelper.rebuildPeriod(targetPeriod);
                        continue;
                    }
                    targetPeriod = targetPeriod + nPeriodNum.substring(nPeriodNum.indexOf(periodType) + periodType.length());
                    continue;
                }
                catch (BgFormException e) {
                    throw new BgFormException(BgFormException.PERIODNVALUEISNOTVALID, new String[]{bgFormPeriod, nPeriodNum});
                }
            }
            throw new BgFormException(BgFormException.PERIODNVALUEISNOTVALID, new String[]{bgFormPeriod, nPeriodNum});
        }
        return BgPeriodNVariableHelper.rebuildPeriod(targetPeriod);
    }

    private static String rebuildPeriod(String targetPeriod) {
        int offset;
        if (targetPeriod == null || targetPeriod.trim().length() == 0) {
            return EMPTY_STR;
        }
        if (Pattern.matches("[\\d]{4}Y.[\\d]{2}W", targetPeriod)) {
            offset = Integer.valueOf(targetPeriod.substring(6, 8)) - 1;
            targetPeriod = targetPeriod.substring(0, 5) + "." + "01" + "W";
            targetPeriod = BgNPeriodHelper.getOffsetBgPeriodNumber((String)targetPeriod, (int)offset);
        }
        if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}D", targetPeriod)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, Integer.valueOf(targetPeriod.substring(0, 4)));
            calendar.set(2, Integer.valueOf(targetPeriod.substring(6, 8)) - 1);
            calendar.set(5, Integer.valueOf(targetPeriod.substring(10, 12)));
            targetPeriod = new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(calendar.getTime());
        }
        if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}MW", targetPeriod)) {
            offset = Integer.valueOf(targetPeriod.substring(10, 12)) - 1;
            targetPeriod = targetPeriod.substring(0, 9) + "." + "01" + "MW";
            targetPeriod = BgNPeriodHelper.getOffsetBgPeriodNumber((String)targetPeriod, (int)offset);
        }
        return targetPeriod;
    }

    private static String processPeriodNVariable(String nPeriodNum, int bgFormPeriodType, String bgFormPeriod) throws BgFormException {
        String targetPeriod = null;
        String[] params = nPeriodNum.split("!");
        if (params.length != 2) {
            return nPeriodNum;
        }
        String offSetStr = params[0].trim().replaceAll(NUMBER_N, EMPTY_STR).replaceAll(NUMBER_n, EMPTY_STR).replaceAll("\\+", EMPTY_STR);
        String periodType = params[1].trim();
        if (!BgPeriodNVariableHelper.checkPeriodTypeIsValid(bgFormPeriod, periodType)) {
            throw new BgFormException(BgFormException.PERIODNVALUEISNOTVALID, new String[]{bgFormPeriod, nPeriodNum});
        }
        if (EMPTY_STR.equals(offSetStr)) {
            offSetStr = DEFAULT_STR;
        }
        int offSet = 0;
        try {
            offSet = Integer.valueOf(offSetStr);
        }
        catch (Exception e) {
            return nPeriodNum;
        }
        targetPeriod = BgNPeriodHelper.getOffsetBgPeriodNumber((String)BgPeriodNVariableHelper.getCurrentPeriod(bgFormPeriod, periodType), (int)offSet);
        return targetPeriod;
    }

    private static boolean checkPeriodTypeIsValid(String bgFormPeriod, String periodType) {
        boolean isValid = false;
        if ("Y".equals(periodType)) {
            isValid = true;
        } else if ("HY".equals(periodType)) {
            if (bgFormPeriod.indexOf("HY") != -1 || bgFormPeriod.indexOf("Q") != -1 || bgFormPeriod.indexOf("M") != -1 || bgFormPeriod.indexOf("D") != -1 || bgFormPeriod.indexOf("TD") != -1 || bgFormPeriod.indexOf("MW") != -1) {
                isValid = true;
            }
        } else if ("Q".equals(periodType)) {
            if (bgFormPeriod.indexOf("Q") != -1 || bgFormPeriod.indexOf("M") != -1 || bgFormPeriod.indexOf("D") != -1 || bgFormPeriod.indexOf("TD") != -1 || bgFormPeriod.indexOf("MW") != -1) {
                isValid = true;
            }
        } else if ("M".equals(periodType)) {
            if (bgFormPeriod.indexOf("M") != -1 || bgFormPeriod.indexOf("D") != -1 || bgFormPeriod.indexOf("TD") != -1 || bgFormPeriod.indexOf("MW") != -1) {
                isValid = true;
            }
        } else if ("TD".equals(periodType)) {
            if (bgFormPeriod.indexOf("TD") != -1 || bgFormPeriod.indexOf("D") != -1) {
                isValid = true;
            }
        } else if ("D".equals(periodType)) {
            if (bgFormPeriod.indexOf("TD") != -1) {
                isValid = false;
            } else if (bgFormPeriod.indexOf("D") != -1) {
                isValid = true;
            }
        } else if (periodType.indexOf("W") != -1) {
            if (bgFormPeriod.indexOf("MW") != -1) {
                isValid = true;
            } else if (bgFormPeriod.indexOf("W") != -1 || bgFormPeriod.indexOf("D") != -1) {
                isValid = true;
            }
        }
        return isValid;
    }

    public static boolean checkCanConvert(String nValue) {
        if (nValue == null) {
            return false;
        }
        String[] nValues = nValue.split("\\.");
        String periodNum = null;
        String periodType = null;
        String[] tempStrs = null;
        boolean hasPeriodNVariable = false;
        int size = nValues.length;
        for (int i = 0; i < size; ++i) {
            tempStrs = nValues[i].split("!");
            if (tempStrs.length == 1) continue;
            if (tempStrs.length == 2) {
                periodNum = tempStrs[0];
                periodType = tempStrs[1];
                if (Pattern.matches(PATTERN_PERIOD_N, periodNum)) {
                    if (!"Y".equals(periodType) && !"HY".equals(periodType) && !"Q".equals(periodType) && !"M".equals(periodType) && !"D".equals(periodType) && !"W".equals(periodType) && !"TD".equals(periodType)) continue;
                    hasPeriodNVariable = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return hasPeriodNVariable;
    }

    private static String getCurrentPeriod(String bgFormPeriod, String periodType) {
        String currentPeriod = null;
        if (BgPeriodNVariableHelper.getBgFormPeriodLevel(bgFormPeriod) == 1) {
            currentPeriod = bgFormPeriod;
        } else if (bgFormPeriod.indexOf(periodType) != -1) {
            currentPeriod = bgFormPeriod.substring(0, bgFormPeriod.indexOf(periodType) + periodType.length());
        } else if ("HY".equals(periodType)) {
            if (bgFormPeriod.indexOf("Q") != -1) {
                String year = bgFormPeriod.substring(0, 5);
                int theQuarterNum = Integer.valueOf(bgFormPeriod.substring(6, 8));
                String theHalfYearNum = DEFAULT_STR + (theQuarterNum + 2 - 1) / 2;
                currentPeriod = year + "." + theHalfYearNum + "HY";
            } else if (bgFormPeriod.indexOf("M") != -1) {
                String year = bgFormPeriod.substring(0, 5);
                int theMonthNum = Integer.valueOf(bgFormPeriod.substring(6, 8));
                String theHalfYearNum = (theMonthNum + 6 - 1) / 6 + EMPTY_STR;
                if (theHalfYearNum.trim().length() == 1) {
                    theHalfYearNum = DEFAULT_STR + theHalfYearNum;
                }
                currentPeriod = year + "." + theHalfYearNum + "HY";
            }
        } else if ("Q".equals(periodType)) {
            if (bgFormPeriod.indexOf("M") != -1) {
                String year = bgFormPeriod.substring(0, 5);
                int theMonthNum = Integer.valueOf(bgFormPeriod.substring(6, 8));
                String theQuarterNum = DEFAULT_STR + (theMonthNum + 3 - 1) / 3;
                currentPeriod = year + "." + theQuarterNum + "Q";
            }
        } else if ("TD".equals(periodType)) {
            if (bgFormPeriod.indexOf("TD") == -1 && bgFormPeriod.indexOf("D") != -1) {
                String yearAndMonth = bgFormPeriod.substring(0, 9);
                int theDayNum = Integer.valueOf(bgFormPeriod.substring(10, 12));
                String theTenDayNum = null;
                theTenDayNum = theDayNum == 31 ? "03" : DEFAULT_STR + (theDayNum + 10 - 1) / 10;
                currentPeriod = yearAndMonth + "." + theTenDayNum + "TD";
            }
        } else if ("W".equals(periodType) && bgFormPeriod.indexOf("TD") == -1 && bgFormPeriod.indexOf("D") != -1) {
            Calendar calendar = Calendar.getInstance();
            int year = Integer.valueOf(bgFormPeriod.substring(0, 4));
            int month = Integer.valueOf(bgFormPeriod.substring(6, 8)) - 1;
            int day = Integer.valueOf(bgFormPeriod.substring(10, 12));
            String yearStr = bgFormPeriod.substring(0, 5);
            calendar.set(1, year);
            calendar.set(2, month);
            calendar.set(5, day);
            String theYearWeek = calendar.get(3) + EMPTY_STR;
            if (theYearWeek.trim().length() == 1) {
                theYearWeek = DEFAULT_STR + theYearWeek;
            }
            currentPeriod = yearStr + "." + theYearWeek + "W";
        }
        return currentPeriod;
    }

    private static int getBgFormPeriodLevel(String bgFormPeriod) {
        int level = 0;
        String[] parameter = null;
        parameter = bgFormPeriod.split("\\.");
        if (parameter != null) {
            level = parameter.length;
        }
        return level;
    }

    public static String getBgPeriod(int year, int period, RptPeriodTypeEnum periodType) {
        if (periodType == null) {
            return null;
        }
        String periodNumber = null;
        String yearStr = null;
        boolean yearIsTrue = false;
        if (year >= 1000) {
            yearIsTrue = true;
        }
        if (period > 0) {
            int offsetYear = 0;
            if (periodType.getValue() == 6) {
                if (yearIsTrue) {
                    yearStr = year + "Y";
                } else {
                    year = year < -100 ? -100 : year;
                    int n = year = year > 100 ? 100 : year;
                    yearStr = year == 0 ? "N!Y" : (year < 0 ? NUMBER_N + year + "!Y" : "N+" + year + "!Y");
                }
                periodNumber = yearStr;
            } else if (periodType.getValue() == 5) {
                offsetYear = period / 2;
                periodNumber = BgPeriodNVariableHelper.getBgPeriodNumber(yearIsTrue, year += offsetYear, period %= 2, periodType);
            } else if (periodType.getValue() == 4) {
                offsetYear = period / 4;
                periodNumber = BgPeriodNVariableHelper.getBgPeriodNumber(yearIsTrue, year += offsetYear, period %= 4, periodType);
            } else if (periodType.getValue() == 3) {
                offsetYear = period / 12;
                periodNumber = BgPeriodNVariableHelper.getBgPeriodNumber(yearIsTrue, year += offsetYear, period %= 12, periodType);
            } else if (periodType.getValue() == 2) {
                offsetYear = period / 52;
                periodNumber = BgPeriodNVariableHelper.getBgPeriodNumber(yearIsTrue, year += offsetYear, period %= 52, periodType);
            } else if (periodType.getValue() == 1) {
                if (yearIsTrue) {
                    periodNumber = BgPeriodNVariableHelper.getPeriodByYearAndDay(year, period);
                } else {
                    year = year < -100 ? -100 : year;
                    int n = year = year > 100 ? 100 : year;
                    yearStr = year == 0 ? "N!Y" : (year < 0 ? NUMBER_N + year + "!Y" : "N+" + year + "!Y");
                    periodNumber = yearStr + "." + period + "D";
                }
            }
        } else if (period <= 0) {
            if (year >= 1000 && period <= 0) {
                yearStr = year + "Y";
                yearIsTrue = true;
            } else if (period <= 0) {
                year = year < -100 ? -100 : year;
                int n = year = year > 100 ? 100 : year;
                yearStr = year == 0 ? "N!Y" : (year < 0 ? NUMBER_N + year + "!Y" : "N+" + year + "!Y");
            }
            if (period == 0) {
                periodNumber = 6 == periodType.getValue() ? yearStr : yearStr + ".N!" + BgPeriodNVariableHelper.getBgPeriodType(periodType);
            } else {
                period = period < -100 ? -100 : period;
                periodNumber = 6 == periodType.getValue() ? yearStr : yearStr + ".N" + period + "!" + BgPeriodNVariableHelper.getBgPeriodType(periodType);
            }
        }
        return periodNumber;
    }

    private static String getPeriodByYearAndDay(int year, int period) {
        String periodNumber = null;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(6, period);
        String yearStr = calendar.get(1) + "Y.";
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        String monthStr = null;
        String dayStr = null;
        monthStr = month < 10 ? DEFAULT_STR + month + "M." : month + "M.";
        dayStr = day < 10 ? DEFAULT_STR + day + "D" : day + "D";
        periodNumber = yearStr + monthStr + dayStr;
        return periodNumber;
    }

    private static String getBgPeriodNumber(boolean yearIsTrue, int year, int period, RptPeriodTypeEnum periodType) {
        String periodNumber = null;
        String yearStr = null;
        if (yearIsTrue) {
            yearStr = year + "Y";
        } else {
            year = year < -100 ? -100 : year;
            int n = year = year > 100 ? 100 : year;
            yearStr = year == 0 ? "N!Y" : (year < 0 ? NUMBER_N + year + "!Y" : "N+" + year + "!Y");
        }
        periodNumber = period < 10 && period > 0 ? yearStr + ".0" + period + BgPeriodNVariableHelper.getBgPeriodType(periodType) : (period >= 10 ? yearStr + "." + period + BgPeriodNVariableHelper.getBgPeriodType(periodType) : yearStr + ".N!" + BgPeriodNVariableHelper.getBgPeriodType(periodType));
        return periodNumber;
    }

    private static String getBgPeriodType(RptPeriodTypeEnum periodType) {
        String bgPeriodType = null;
        switch (periodType.getValue()) {
            case 6: {
                bgPeriodType = "Y";
                break;
            }
            case 5: {
                bgPeriodType = "HY";
                break;
            }
            case 4: {
                bgPeriodType = "Q";
                break;
            }
            case 3: {
                bgPeriodType = "M";
                break;
            }
            case 2: {
                bgPeriodType = "W";
                break;
            }
            case 1: {
                bgPeriodType = "D";
                break;
            }
            default: {
                bgPeriodType = "Y";
            }
        }
        return bgPeriodType;
    }

    private static boolean checkIsLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }
}

