/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.ma.budget.BgExpressionsParseOrgHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.OrgComparator;
import com.kingdee.eas.ma.budget.client.BgSelectCostCenterOrgViewF7;
import com.kingdee.eas.ma.nbudget.BgAreaFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgScriptHelper;
import com.kingdee.eas.ma.nbudget.BudgetProvider;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgScriptFillOrgHelper {
    private static final Logger logger = Logger.getLogger(BgScriptFillOrgHelper.class);

    public static void showOrgF7AndFill(IUIObject _uiObject, Book book, String operState, IBookProvider provider) {
        if (_uiObject == null || book == null || provider == null) {
            return;
        }
        if (!(provider instanceof BudgetProvider)) {
            return;
        }
        BudgetProvider bgProvider = (BudgetProvider)provider;
        if (!OprtState.ADDNEW.equals(operState) || !bgProvider.isScriptForm()) {
            return;
        }
        BgFormInfo bgFormInfo = bgProvider.getBudgetInfo();
        if (bgFormInfo == null) {
            return;
        }
        if (bgFormInfo.getOrgUnit() == null || bgFormInfo.getOrgUnit().getId() == null) {
            return;
        }
        BgSelectCostCenterOrgViewF7 orgF7 = new BgSelectCostCenterOrgViewF7(_uiObject);
        orgF7.setCuID(bgFormInfo.getOrgUnit().getId().toString());
        orgF7.setOrgMap(BgScriptFillOrgHelper.getOrgMap(bgFormInfo.getOrgUnit()));
        orgF7.setMultiSelect(true);
        orgF7.setTitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"98_BgScriptFillOrgHelper"));
        orgF7.show();
        OrgUnitInfo[] orgsf7 = (OrgUnitInfo[])orgF7.getData();
        if ((orgsf7 == null || orgsf7.length == 0) && _uiObject instanceof BgNFormProcessUI) {
            BgNFormProcessUI ui = (BgNFormProcessUI)_uiObject;
            ui.getSpreadManager().getModifyManager().discardAllEdits();
            SysUtil.abort();
        }
        BgScriptFillOrgHelper.fillOrgByCol(book, orgsf7);
    }

    private static Map getOrgMap(FullOrgUnitInfo orgInfo) {
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        orgMap.put(orgInfo.getId().toString(), null);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(orgInfo.getLongNumber() + "!%"), CompareType.LIKE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemInfo sore = new SorterItemInfo("longNumber");
        sore.setSortType(SortType.ASCEND);
        view.getSorter().add(sore);
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = null;
        CostCenterOrgUnitCollection costCenterOrgUnitColl = null;
        try {
            costCenterOrgUnitColl = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
            if (costCenterOrgUnitColl == null) {
                return orgMap;
            }
            int size = costCenterOrgUnitColl.size();
            for (int i = 0; i < size; ++i) {
                costCenterOrgUnitInfo = costCenterOrgUnitColl.get(i);
                if (costCenterOrgUnitInfo == null || costCenterOrgUnitInfo.getId() == null) continue;
                orgMap.put(costCenterOrgUnitInfo.getId().toString(), null);
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return orgMap;
    }

    private static void fillOrgByCol(Book book, OrgUnitInfo[] orgs) {
        if (book == null || orgs == null || orgs.length == 0) {
            return;
        }
        Arrays.sort(orgs, new OrgComparator());
        Sheet _sheet = null;
        Cell _cell = null;
        Cell styleCell = null;
        OrgUnitInfo orgInfo = null;
        String expressions = null;
        int[] rowAndCol = null;
        int colCount = orgs.length - 2;
        String[] costOrgNumbers = new String[orgs.length];
        int size = orgs.length;
        for (int i = 0; i < size; ++i) {
            costOrgNumbers[i] = orgs[i].getNumber();
        }
        Map mappingMap = null;
        try {
            mappingMap = BgAreaFacadeFactory.getRemoteInstance().getMappingInfo(costOrgNumbers);
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        HashMap<String, String> expressionsMap = null;
        HashMap sourceRangeMap = null;
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            expressionsMap = new HashMap<String, String>();
            sourceRangeMap = new HashMap();
            if (_sheet == null || expressionsMap == null || (rowAndCol = BgScriptHelper.getCellRowAndCol((Sheet)_sheet)) == null || rowAndCol.length != 2 || rowAndCol[0] == -1 || rowAndCol[1] == -1) continue;
            BgScriptHelper.removeScriptForSheet((Cell)_sheet.getCell(rowAndCol[0], rowAndCol[1], false));
            if (colCount > 0) {
                BgScriptFillOrgHelper.addColumns(_sheet, rowAndCol[1] + 1, colCount - 1);
            } else if (colCount == -1) {
                BgScriptFillOrgHelper.removeColumn(_sheet, rowAndCol[1] + 1);
            }
            int maxColIndex = orgs.length + rowAndCol[1] - 1;
            for (int colIndex = rowAndCol[1]; colIndex <= maxColIndex; ++colIndex) {
                orgInfo = orgs[colIndex - rowAndCol[1]];
                String orgNumber = orgInfo.getNumber();
                String orgName = orgInfo.getName();
                int maxRowIndex = _sheet.getMaxRowIndex();
                for (int rowIndex = rowAndCol[0]; rowIndex <= maxRowIndex; ++rowIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, true);
                    styleCell = _sheet.getCell(rowIndex, rowAndCol[1], false);
                    if (styleCell != null) {
                        StyleAttributes sa2;
                        StyleAttributes sa1 = sa2 = Styles.getEmptySA();
                        _sheet.getRange(styleCell).getStyle(sa1, sa2);
                        sa1.setDirty(sa1.getAllBits());
                        sa2.setDirty(sa1.getAllBits());
                        _sheet.getRange(_cell).setStyle(sa1, sa2);
                    }
                    if (rowIndex == rowAndCol[0]) {
                        _cell = _sheet.getCell(rowIndex, colIndex, true);
                        _cell.setValue(new Variant((Object)orgName));
                        continue;
                    }
                    if (colIndex == rowAndCol[1] && rowIndex != rowAndCol[0]) {
                        _cell = _sheet.getCell(rowIndex, colIndex, true);
                        if (!StringUtils.isEmpty((String)_cell.getFormula()) && BookFormulaHelper.isExcelFunction((Book)book, (Sheet)_sheet, (String)_cell.getFormula()) || BgExpressionsParseOrgHelper.checkHasTargetExpressions(_cell, true)) {
                            sourceRangeMap.put(rowIndex + "", null);
                        }
                        if (!BgExpressionsParseOrgHelper.checkHasTargetExpressions(_cell, false)) continue;
                        expressions = _cell.getFormula();
                        expressionsMap.put(rowIndex + "", expressions);
                        expressions = BgExpressionsParseOrgHelper.processExpressionsOrgParam(expressions, orgNumber, mappingMap, null);
                        _cell.setFormula(expressions);
                        continue;
                    }
                    _cell = _sheet.getCell(rowIndex, colIndex, true);
                    boolean isSimpleFormula = false;
                    if (sourceRangeMap.containsKey(rowIndex + "")) {
                        Range sourceRange = _sheet.getRange(_sheet.getCell(rowIndex, rowAndCol[1], false));
                        Range targetRange = _sheet.getRange(_cell);
                        if (sourceRange != null && targetRange != null) {
                            sourceRange.copy();
                            targetRange.setIgnoreProtected(true);
                            targetRange.paste(PasteMode.ALL);
                            _cell.setFormula(_sheet.getCell(rowIndex, rowAndCol[1], false).getFormula());
                        }
                        isSimpleFormula = true;
                    }
                    if (!StringUtils.isEmpty((String)(expressions = (String)expressionsMap.get(rowIndex + "")))) {
                        expressions = isSimpleFormula ? BgExpressionsParseOrgHelper.processExpressionsOrgParam(_cell.getFormula(), orgNumber, mappingMap, null) : BgExpressionsParseOrgHelper.processExpressionsOrgParam(expressions, orgNumber, mappingMap, null);
                        _cell.setFormula(expressions);
                    }
                    _cell.setValue(Variant.nullVariant);
                }
            }
        }
    }

    public static void addColumns(Sheet sheet, int colIndex, int colCont) {
        if (sheet == null || colIndex < 0) {
            return;
        }
        Range range = sheet.getColRange(colIndex, colIndex + colCont);
        range.setIgnoreProtected(true);
        range.insert();
    }

    public static boolean removeColumn(Sheet sheet, int colIndex) {
        if (sheet == null || colIndex < 0 || colIndex > sheet.getMaxColIndex()) {
            return false;
        }
        Range range = sheet.getColRange(colIndex, colIndex);
        range.setIgnoreProtected(true);
        boolean bDelete = range.delete();
        return bDelete;
    }
}

