/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;

public class BgTendencyAnalysisObjInfo
implements Serializable {
    private static final long serialVersionUID = -1679063803269331725L;
    private String orgUnitId;
    private String comparedBgItem;
    private Map orgUnitIdMap;

    public BgTendencyAnalysisObjInfo(String orgUnitId, BigDecimal budgetVal, BigDecimal actualVal, String comparedBgItem, Map orgUnitIdMap) {
        this.orgUnitId = orgUnitId;
        this.orgUnitIdMap = orgUnitIdMap;
        this.comparedBgItem = comparedBgItem;
        orgUnitIdMap.put(orgUnitId, new DataObj(budgetVal, actualVal));
    }

    public void addData(BigDecimal budgetVal, BigDecimal actualVal, String orgUnitId) {
        if (this.orgUnitIdMap.keySet().contains(orgUnitId)) {
            DataObj dataObj = (DataObj)this.orgUnitIdMap.get(orgUnitId);
            dataObj.addData(budgetVal, actualVal);
        } else {
            this.orgUnitIdMap.put(orgUnitId, new DataObj(budgetVal, actualVal));
        }
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public Map getOrgUnitIdMap() {
        return this.orgUnitIdMap;
    }

    public void setOrgUnitIdMap(Map orgUnitIdMap) {
        this.orgUnitIdMap = orgUnitIdMap;
    }

    public String getComparedBgItem() {
        return this.comparedBgItem;
    }

    public void setComparedBgItem(String comparedBgItem) {
        this.comparedBgItem = comparedBgItem;
    }

    public static class DataObj
    implements Serializable {
        private static final long serialVersionUID = 6582822414992949083L;
        private BigDecimal budgetVal;
        private BigDecimal actualVal;

        public DataObj(BigDecimal budgetVal, BigDecimal actualVal) {
            this.budgetVal = budgetVal;
            this.actualVal = actualVal;
        }

        public void addData(BigDecimal budgetVal, BigDecimal actualVal) {
            if (budgetVal != null) {
                this.setBudgetVal(this.getBudgetVal().add(budgetVal));
            }
            if (actualVal != null) {
                this.setActualVal(this.getActualVal().add(actualVal));
            }
        }

        public BigDecimal getActualVal() {
            return this.actualVal;
        }

        public void setActualVal(BigDecimal actualVal) {
            this.actualVal = actualVal;
        }

        public BigDecimal getBudgetVal() {
            return this.budgetVal;
        }

        public void setBudgetVal(BigDecimal budgetVal) {
            this.budgetVal = budgetVal;
        }
    }
}

