/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgUtilsHelper {
    public static final Logger logger = Logger.getLogger(BgUtilsHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeObject(Object obj) {
        if (obj == null) {
            return null;
        }
        byte[] objByte = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            objByte = ZipUtil.pack((ByteArrayOutputStream)baos);
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
        }
        return Base64.encodeBytes((byte[])objByte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object decodeObject(String objStr) {
        if (objStr == null || objStr.length() == 0) {
            return null;
        }
        Object obj = null;
        byte[] objByte = Base64.decode((String)objStr);
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])objByte);
            bais = new ObjectInputStream(is);
            obj = bais.readObject();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
        }
        return obj;
    }

    public static String getBalanceAuditInfoFromCollection(BgCtrlResultCollection collection, Context ctx, boolean isCanControlWithoutBudget) {
        HashMap checkMap = new HashMap();
        String resPath = "com.kingdee.eas.ma.budget.BudgetResource";
        if (collection == null || collection.isEmpty()) {
            return ResourceBase.getString((String)resPath, (String)"NotFindBudget", (Locale)ctx.getLocale());
        }
        String ret = "";
        for (int i = 0; i < collection.size(); ++i) {
            BgCtrlResultInfo info = collection.get(i);
            String billItemCmbAlias = info.getBillItemAlias();
            String bill = "";
            if (billItemCmbAlias != null && billItemCmbAlias.length() > 0) {
                String[] tmp = billItemCmbAlias.split("\\@");
                for (int x = 0; x < tmp.length; ++x) {
                    String[] _tmp = tmp[x].split("\\|");
                    String s = _tmp[0];
                    if (s.endsWith(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper"))) {
                        s = s.replaceAll(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"103_BgUtilsHelper"), "");
                    }
                    bill = x != tmp.length - 1 ? bill + s + "_" : bill + s;
                }
            } else {
                bill = "";
            }
            if (info.getBalance() == null) {
                if (checkMap.containsKey(info.getBgItemFormula())) continue;
                if (!isCanControlWithoutBudget) {
                    ret = ret + bill + "[" + info.getBillItemName2() + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"104_BgUtilsHelper") + info.getOrgUnitName() + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"105_BgUtilsHelper") + ResourceBase.getString((String)resPath, (String)"bgitem", (Locale)ctx.getLocale()) + "[" + info.getItemName() + "]" + ResourceBase.getString((String)resPath, (String)"NoBudget", (Locale)ctx.getLocale()) + ",";
                }
                checkMap.put(info.getBgItemFormula(), null);
                continue;
            }
            if (info.isIsBalanced() || !(info.getReqAmount().floatValue() > 0.0f)) continue;
            ret = ret + bill + "[" + info.getBillItemName2() + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"104_BgUtilsHelper") + info.getOrgUnitName() + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"105_BgUtilsHelper") + ResourceBase.getString((String)resPath, (String)"bgitem", (Locale)ctx.getLocale()) + "[" + info.getItemName() + "]" + ResourceBase.getString((String)resPath, (String)"BgItemBalanceLack", (Locale)ctx.getLocale()) + ",";
            checkMap.put(info.getBgItemFormula(), null);
        }
        if (ret.length() > 0) {
            return ret.substring(0, ret.length() - 1).replaceAll(",", "\\\n");
        }
        return ret;
    }
}

