/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.client.AbstractAssignSolutionUI;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.AssignSolutionSaveUI;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class AssignSolutionUI
extends AbstractAssignSolutionUI {
    public static final String SELFNAME = "selfPanelUiName";
    public static final String OPERATETYPE = "operateType";
    public static final String RESOURCE = "com.kingdee.eas.ma.budget.client.AssignSolutionResource";
    private static final Logger logger = CoreUIObject.getLogger(AssignSolutionUI.class);
    private JPanel panelChild = null;
    private boolean isViewNextTimeByThisDefaultSolution = false;
    private String uiName = null;
    private String currentPk = null;
    private String bgSchemeId = null;
    private String operateType = null;
    private AssignSolutionTypeEnum currentSolutionType = null;
    private AssignSolutionInfo assignSolutionInfo = null;
    protected static final String TOOLBAR = "TOOLBAR";
    protected static final int CONFIRM_ACTION = 0;
    protected static final int CANCEL_ACTION = 1;
    protected static final int CLOSE_WINDOW_ACTION = 2;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        if (this.panelChild instanceof CoreUI) {
            this.setUITitle(((CoreUI)this.panelChild).getUITitle());
        } else if (this.panelChild instanceof CustomerQueryPanel) {
            this.setUITitle(((CustomerQueryPanel)this.panelChild).getUITitle());
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void initTable() throws Exception {
        this.initButton();
        this.initChildUI();
        this.comboSolutionType.addItem((Object)AssignSolutionTypeEnum.PERSON);
        this.comboSolutionType.addItem((Object)AssignSolutionTypeEnum.ORG);
        this.comboSolutionType.addItem((Object)AssignSolutionTypeEnum.CU);
        this.comboSolutionType.addItem((Object)AssignSolutionTypeEnum.PUB);
        this.assignSolutionInfo = this.getSystemSoltuion();
        this.initSystemDefaultSolution();
        AssignSolutionInfo info = this.assignSolutionInfo;
        this.refreshSolutionList(info, true, true);
        this.assignSolutionInfo = info;
        this.setSolutionButtion();
        this.initListenerSelf();
        this.initUILayout();
        this.kDCheckBox1.setSelected(false);
    }

    private void initChildUI() throws Exception {
        String selfPanelUiName;
        Map uicontext = this.getUIContext();
        UIContext uiContextOrg = new UIContext((Object)this);
        if (uicontext.get("ID") != null) {
            this.bgSchemeId = (String)uicontext.get("ID");
        }
        if (uicontext.get(OPERATETYPE) != null) {
            this.operateType = (String)uicontext.get(OPERATETYPE);
        }
        for (String key : uicontext.keySet()) {
            uiContextOrg.put((Object)key, uicontext.get(key));
        }
        this.uiName = selfPanelUiName = (String)uiContextOrg.get((Object)SELFNAME);
        IUIObject uiObject = null;
        String oprt = this.getOprtState();
        String name = selfPanelUiName;
        long start = System.currentTimeMillis();
        logger.debug((Object)("Begin initUIObject " + name + " : " + start + "!"));
        Class<?> c = null;
        try {
            c = Class.forName(name);
            uiObject = (IUIObject)c.newInstance();
            long instanceCost = System.currentTimeMillis() - start;
            logger.info((Object)("UIObject " + name + " new instance : " + instanceCost + " ms."));
            IUIObject ui = uiObject.getInstance((Map)uiContextOrg);
            if (ui != null) {
                uiObject = ui;
            }
            if (uiObject instanceof Component) {
                this.panelChild = (JPanel)uiObject;
                this.panelChild.setName("panelChild");
                this.panelContent.add((Component)this.panelChild, null);
                this.panelChild.setLayout(null);
            }
            if (uiObject instanceof CoreUIObject) {
                CoreUIObject coreUIObj = (CoreUIObject)uiObject;
                coreUIObj.initLayout();
            }
        }
        catch (ClassNotFoundException exc) {
            logger.error((Object)exc);
            throw new AbortException();
        }
        catch (Exception exc) {
            if (exc instanceof AbortException) {
                throw (AbortException)exc;
            }
            throw new UIException(UIFrameResource.getString((String)"UIFactoryHelper_createUIError"), (Throwable)exc);
        }
        if (this.dataObjects != null && this.dataObjects.size() > 0) {
            for (Object key : this.dataObjects.keySet()) {
                uiObject.setDataObject(key, (IObjectValue)((AbstractObjectValue)this.dataObjects.get(key)));
            }
        }
        if (uiContextOrg != null && uiContextOrg.size() > 0) {
            for (Object key : uiContextOrg.keySet()) {
                uiObject.getUIContext().put(key, uiContextOrg.get(key));
            }
            uiObject.getUIContext().put("PANELUI", this);
        }
        if (oprt != null && !oprt.equals("")) {
            uiObject.setOprtState(oprt);
        }
        try {
            long onLoadStart = System.currentTimeMillis();
            uiObject.onLoad();
            long onLoadCost = System.currentTimeMillis() - onLoadStart;
            logger.info((Object)("UIObject " + name + " onLoad spent " + onLoadCost + " ms."));
        }
        catch (Exception exc) {
            try {
                uiObject.destroyWindow();
            }
            catch (Exception ex) {
                logger.error((Object)("destory window error:" + ex));
            }
            throw new UIException(UIFrameResource.getString((String)"UIFactoryHelper_onLoadError"), (Throwable)exc);
        }
        if (uiObject.isBindWorkFlow()) {
            uiObject.checkWfAssignment();
        }
        long end = System.currentTimeMillis();
        logger.debug((Object)("End initUIObject " + name + " : " + end + "!"));
        long cost = end - start;
        logger.info((Object)("InitUIObject " + name + " : " + cost + " ms!"));
    }

    private void initUILayout() {
        int childUIHeigtht = this.panelChild.getHeight();
        int childUIWigtht = this.panelChild.getWidth();
        this.setBounds(this.getX(), this.getY(), childUIWigtht + 186, childUIHeigtht - 20 + 20 + 20 + 22 + 10 + 10);
        this.panelContent.setBounds(new Rectangle(186, 10, childUIWigtht, childUIHeigtht));
        this.add((Component)this.panelContent, null);
        this.panelContent.setLayout(null);
        this.panelChild.setBounds(new Rectangle(0, 0, childUIWigtht, childUIHeigtht));
        this.panelChild.setLayout(null);
        this.kDPanel1.setBounds(new Rectangle(9, 14, 176, childUIHeigtht));
        this.add((Component)this.kDPanel1, null);
        this.kDPanel1.setLayout(null);
        this.kDPanel3.setBounds(new Rectangle(0, 21, 180, childUIHeigtht - this.kDPanel2.getHeight()));
        this.kDPanel1.add((Component)this.kDPanel3, null);
        this.solutionList.setBounds(new Rectangle(0, 0, 180, this.kDPanel3.getHeight()));
        this.kDPanel3.add((Component)this.solutionList, null);
        this.kDSeparator2.setBounds(new Rectangle(0, this.kDPanel1.getY() + this.kDPanel1.getHeight() + 13, this.getWidth(), 7));
        this.add((Component)this.kDSeparator2, null);
        this.kDPanel4.setBounds(new Rectangle(this.getWidth() - 160, this.kDSeparator2.getY() + this.kDSeparator2.getHeight() + 3, 150, 22));
        this.add((Component)this.kDPanel4, null);
        this.kDCheckBox1.setBounds(10, this.kDPanel4.getY(), this.kDCheckBox1.getWidth(), this.kDCheckBox1.getHeight());
    }

    private void initSystemDefaultSolution() throws Exception {
        AssignSolutionCollection assignSolutionCol;
        AssignSolutionTypeEnum solutionType = null;
        if (this.panelChild instanceof AssignSolutionInterface) {
            ((AssignSolutionInterface)((Object)this.panelChild)).clear();
        }
        solutionType = this.comboSolutionType.getSelectedItem() != null ? (AssignSolutionTypeEnum)((Object)this.comboSolutionType.getSelectedItem()) : AssignSolutionTypeEnum.PERSON;
        StringBuffer oql = new StringBuffer("where isSystemSolution =1 and solutionType=" + solutionType.getValue());
        if (solutionType.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (solutionType.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (solutionType.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (this.bgSchemeId != null) {
            oql.append(" and relativeObjId='" + this.bgSchemeId + "' ");
        }
        if (this.operateType != null) {
            oql.append(" and oprateObjType='" + this.operateType + "' ");
        }
        if (this.uiName != null) {
            oql.append(" and uiName='" + this.uiName + "' ");
        }
        if ((assignSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString())).size() <= 0) {
            AssignSolutionInfo info = new AssignSolutionInfo();
            info.setIsSystemSolution(true);
            info.setSolutionName(EASResource.getString((String)RESOURCE, (String)"default.system.solution"));
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setCuid(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            info.setOrgId(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            info.setUserId(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            info.setRelativeObjId(this.bgSchemeId);
            info.setOprateObjType(this.operateType);
            info.setSolutionType(solutionType);
            info.setUiName(this.uiName);
            AssignSolutionFactory.getRemoteInstance().addnew(info);
        }
    }

    public void initLayout() {
        super.initLayout();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    private void initButton() {
        this.btnAddnew.setBounds(new Rectangle(0, 0, 22, 19));
        this.kDPanel2.add((Component)this.btnAddnew, null);
        this.btnSave.setBounds(new Rectangle(25, 0, 22, 19));
        this.kDPanel2.add((Component)this.btnSave, null);
        this.btnSaveAs.setBounds(new Rectangle(50, 0, 22, 19));
        this.kDPanel2.add((Component)this.btnSaveAs, null);
        this.btnUpdate.setBounds(new Rectangle(100, 0, 22, 19));
        this.kDPanel2.add((Component)this.btnUpdate, null);
        this.btnDelete.setBounds(new Rectangle(75, 0, 22, 19));
        this.kDPanel2.add((Component)this.btnDelete, null);
        this.comboSolutionType.setBounds(new Rectangle(125, 0, 60, 19));
        this.kDPanel2.add((Component)this.comboSolutionType, null);
        this.btnAddnew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSaveAs.setIcon(EASResource.getIcon((String)"imgTbtn_saveas"));
        this.kDCheckBox1.setVisible(false);
        this.kDCheckBox1.setSelected(false);
    }

    private void setSolutionButtion() {
        boolean isSaveAs = false;
        AssignSolutionInfo selectInfo = null;
        selectInfo = (AssignSolutionInfo)this.solutionList.getSelectedValue();
        if (this.assignSolutionInfo != null && selectInfo == null || this.assignSolutionInfo != null && selectInfo != null && !selectInfo.getId().equals((Object)this.assignSolutionInfo.getId()) || selectInfo != null && selectInfo.isIsSystemSolution()) {
            isSaveAs = true;
        }
        if (isSaveAs) {
            this.btnAddnew.setEnabled(true);
            this.btnUpdate.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSaveAs.setEnabled(true);
        } else if (selectInfo != null) {
            this.btnAddnew.setEnabled(true);
            this.btnUpdate.setEnabled(true);
            this.btnDelete.setEnabled(true);
            this.btnSave.setEnabled(true);
            this.btnSaveAs.setEnabled(true);
        } else {
            this.btnAddnew.setEnabled(false);
            this.btnUpdate.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSaveAs.setEnabled(false);
        }
    }

    protected void setSelfPanel(JPanel comp) {
        this.panelChild = comp;
    }

    private void initListenerSelf() {
        this.btnAddnew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AssignSolutionUI.this.addSolutionAction();
                }
                catch (Exception ex) {
                    AssignSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AssignSolutionUI.this.saveSolutionAction();
                }
                catch (Exception ex) {
                    AssignSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AssignSolutionUI.this.saveAsSolutionAction();
                }
                catch (Exception ex) {
                    AssignSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AssignSolutionUI.this.deteleSolutionAction();
                }
                catch (Exception ex) {
                    AssignSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AssignSolutionUI.this.updateSolutionAction();
                }
                catch (Exception ex) {
                    AssignSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnConferm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AssignSolutionUI.this.confermSolutionAction();
                }
                catch (Exception ex) {
                    AssignSolutionUI.this.handleException(ex);
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AssignSolutionUI.this.cancelSolutionAction();
                }
                catch (Exception ex) {
                    AssignSolutionUI.this.handleException(ex);
                }
            }
        });
        this.solutionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                try {
                    AssignSolutionUI.this.solutionListClicked(arg0);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.comboSolutionType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    AssignSolutionUI.this.comboSolutionType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    AssignSolutionUI.this.handUIException(exc);
                }
            }
        });
    }

    private void solutionListClicked(ListSelectionEvent e) throws Exception {
        if (this.solutionList.getSelectedValue() != null && this.solutionList.getSelectedValue() instanceof AssignSolutionInfo) {
            if (this.panelChild instanceof AssignSolutionInterface) {
                ((AssignSolutionInterface)((Object)this.panelChild)).clear();
            }
            AssignSolutionInfo assingInfo = (AssignSolutionInfo)this.solutionList.getSelectedValue();
            this.refreshSolutionList(assingInfo, true, false);
            this.assignSolutionInfo = assingInfo;
            this.setSolutionButtion();
        }
    }

    protected void addSolutionAction() throws Exception {
        if (this.panelChild instanceof AssignSolutionInterface) {
            ((AssignSolutionInterface)((Object)this.panelChild)).clear();
        }
        this.assignSolutionInfo = new AssignSolutionInfo();
        this.currentPk = BOSUuid.create((BOSObjectType)this.assignSolutionInfo.getBOSType()).toString();
        this.assignSolutionInfo.setId(BOSUuid.read((String)this.currentPk));
        this.assignSolutionInfo.setCuid(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.assignSolutionInfo.setOrgId(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        this.assignSolutionInfo.setUserId(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        if (this.currentSolutionType == null) {
            this.currentSolutionType = (AssignSolutionTypeEnum)((Object)this.comboSolutionType.getSelectedItem());
            if (this.currentSolutionType == null) {
                this.currentSolutionType = AssignSolutionTypeEnum.PERSON;
            }
            this.comboSolutionType.setSelectedItem((Object)this.currentSolutionType);
        }
        this.assignSolutionInfo.setSolutionType(this.currentSolutionType);
        this.assignSolutionInfo.setUiName(this.uiName);
        this.solutionList.setSelectedIndex(0);
    }

    protected void comboSolutionType_itemStateChanged(ItemEvent e) throws Exception {
        this.initSystemDefaultSolution();
        AssignSolutionInfo info = null;
        this.refreshSolutionList(info, true, true);
        this.assignSolutionInfo = info;
    }

    private void clearSolutionList() throws Exception {
        this.solutionList.removeAllElements();
        if (this.panelChild instanceof AssignSolutionInterface) {
            ((AssignSolutionInterface)((Object)this.panelChild)).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSolutionList(AssignSolutionInfo assignInfo, boolean isUpdateSolutionData, boolean isUpdateSolutionList) throws Exception {
        if (isUpdateSolutionList) {
            this.clearSolutionList();
            AssignSolutionInfo solutionInfo = null;
            AssignSolutionTypeEnum typeEnum = (AssignSolutionTypeEnum)((Object)this.comboSolutionType.getSelectedItem());
            AssignSolutionCollection asSolutionCol = new AssignSolutionCollection();
            if (this.panelChild instanceof AssignSolutionInterface) {
                asSolutionCol = ((AssignSolutionInterface)((Object)this.panelChild)).solutionList(typeEnum);
            }
            Iterator iterator = asSolutionCol.iterator();
            while (iterator.hasNext()) {
                solutionInfo = (AssignSolutionInfo)iterator.next();
                if (assignInfo == null && solutionInfo.isIsSystemSolution()) {
                    assignInfo = solutionInfo;
                }
                this.solutionList.addElement((Object)solutionInfo);
            }
        }
        if (isUpdateSolutionData) {
            if (assignInfo != null) {
                if (this.panelChild instanceof AssignSolutionInterface) {
                    ((AssignSolutionInterface)((Object)this.panelChild)).clear();
                }
            } else {
                return;
            }
            this.solutionList.setSelectedValue((Object)assignInfo, true);
            this.kDCheckBox1.setSelected(assignInfo.isIsDefaultsolution());
            if (this.panelChild instanceof AssignSolutionInterface) {
                Object solutionData = null;
                ((AssignSolutionInterface)((Object)this.panelChild)).clear();
                byte[] byteSolution = AssignSolutionFactory.getRemoteInstance().getSolutionData(assignInfo.getId().toString());
                if (byteSolution != null) {
                    ByteArrayInputStream is = new ByteArrayInputStream(byteSolution);
                    ObjectInputStream bais = null;
                    try {
                        bais = new ObjectInputStream(new BufferedInputStream(is));
                        solutionData = bais.readObject();
                    }
                    catch (Exception e) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"UpdateSelectScheme"));
                        this.btnDelete.setEnabled(true);
                        SysUtil.abort();
                    }
                    finally {
                        try {
                            if (bais != null) {
                                bais.close();
                            }
                        }
                        catch (Exception e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                    }
                }
                ((AssignSolutionInterface)((Object)this.panelChild)).reloadSolution(solutionData);
            }
        }
        this.setSolutionButtion();
    }

    protected void saveSolutionAction() throws Exception {
        AssignSolutionInfo info = this.assignSolutionInfo;
        int selectedIndex = this.solutionList.getSelectedIndex();
        if (this.saveSolution(info)) {
            this.refreshSolutionList(info, false, true);
            this.assignSolutionInfo = info;
        }
        this.solutionList.setSelectedIndex(selectedIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveSolution(Object obj) throws Exception {
        AssignSolutionInfo assignInfo = (AssignSolutionInfo)obj;
        boolean isConfirm = false;
        if (assignInfo == null || assignInfo.getSolutionName() == null || assignInfo.getSolutionName().length() <= 0) {
            UIContext uiContext = new UIContext((Object)this);
            Map map = new HashMap(1);
            uiContext.put((Object)"this.is.for.input.return.value", map);
            IUIWindow window = null;
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                window = uiFactory.create(AssignSolutionSaveUI.class.getName(), (Map)uiContext, null, "");
                window.show();
            }
            catch (UIException e) {
                logger.error((Object)e);
            }
            map = (Map)uiContext.get((Object)"this.is.for.input.return.value");
            if (map.isEmpty() || map.get("solutionName") == null) {
                return false;
            }
            if (assignInfo == null || assignInfo.getId() == null) {
                if (this.currentPk == null) {
                    this.currentPk = BOSUuid.create((BOSObjectType)new AssignSolutionInfo().getBOSType()).toString();
                }
                if (assignInfo == null) {
                    assignInfo = new AssignSolutionInfo();
                }
                this.currentSolutionType = (AssignSolutionTypeEnum)((Object)this.comboSolutionType.getSelectedItem());
                if (this.currentSolutionType == null) {
                    this.currentSolutionType = AssignSolutionTypeEnum.PERSON;
                }
                assignInfo.setSolutionType(this.currentSolutionType);
                assignInfo.setId(BOSUuid.read((String)this.currentPk));
                assignInfo.setCuid(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                assignInfo.setOrgId(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
                assignInfo.setUserId(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
                assignInfo.setUiName(this.uiName);
            }
            assignInfo.setSolutionName((String)map.get("solutionName"));
        }
        assignInfo.setRelativeObjId(this.bgSchemeId);
        assignInfo.setOprateObjType(this.operateType);
        assignInfo.setIsDefaultsolution(this.kDCheckBox1.isSelected());
        Object solutionData = null;
        if (this.panelChild instanceof AssignSolutionInterface) {
            solutionData = ((AssignSolutionInterface)((Object)this.panelChild)).saveSolution();
        }
        AssignSolutionFactory.getRemoteInstance().save(assignInfo);
        if (solutionData != null) {
            byte[] objByte = null;
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(bao);
                out.writeObject(solutionData);
                objByte = bao.toByteArray();
            }
            catch (IOException e) {
                this.handleException(e);
                SysUtil.abort();
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
            }
            AssignSolutionFactory.getRemoteInstance().saveSolutionData(assignInfo.getId().toString(), objByte);
        }
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"save.success"));
        return true;
    }

    protected void saveAsSolutionAction() throws Exception {
        this.assignSolutionInfo = new AssignSolutionInfo();
        this.currentPk = BOSUuid.create((BOSObjectType)this.assignSolutionInfo.getBOSType()).toString();
        AssignSolutionInfo info = this.assignSolutionInfo;
        if (this.saveSolution(info)) {
            this.refreshSolutionList(info, false, true);
            this.assignSolutionInfo = info;
        }
        this.solutionList.setSelectedIndex(this.solutionList.getElementCount() - 1);
    }

    protected void deteleSolutionAction() throws Exception {
        if (this.solutionList.getSelectedIndex() >= 0 && this.solutionList.getSelectedValue() != null) {
            this.assignSolutionInfo = (AssignSolutionInfo)this.solutionList.getSelectedValue();
            this.solutionList.removeElement(this.solutionList.getSelectedValue());
        }
        if (this.assignSolutionInfo == null) {
            return;
        }
        AssignSolutionFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(this.assignSolutionInfo.getId()));
        this.refreshSolutionList(null, true, true);
    }

    protected void updateSolutionAction() {
        UIContext uiContext = new UIContext((Object)this);
        Map map = new HashMap(1);
        uiContext.put((Object)"this.is.for.input.return.value", map);
        IUIWindow window = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            window = uiFactory.create(AssignSolutionSaveUI.class.getName(), (Map)uiContext, null, "");
            window.show();
        }
        catch (UIException e) {
            logger.error((Object)e);
        }
        map = (Map)uiContext.get((Object)"this.is.for.input.return.value");
        if (map.isEmpty() || map.get("solutionName") == null) {
            return;
        }
        int selectedIndex = this.solutionList.getSelectedIndex();
        AssignSolutionInfo info = (AssignSolutionInfo)this.solutionList.getSelectedValue();
        info.setSolutionName((String)map.get("solutionName"));
        try {
            if (this.saveSolution(info)) {
                this.refreshSolutionList(info, false, true);
                this.solutionList.setSelectedIndex(selectedIndex);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void confermSolutionAction() throws Exception {
        if (this.panelChild instanceof AssignSolutionInterface && ((AssignSolutionInterface)((Object)this.panelChild)).conferm((Object)this) && this.isShowing()) {
            this.destroyWindow();
            return;
        }
    }

    protected void cancelSolutionAction() throws Exception {
        boolean cancel = ((AssignSolutionInterface)((Object)this.panelChild)).cancel();
        if (this.isShowing() && cancel) {
            this.destroyWindow();
        }
    }

    public Object getReturnData() throws Exception {
        return ((AssignSolutionInterface)((Object)this.panelChild)).getReturnData();
    }

    public boolean isViewNextTimeByThisDefaultSolution() {
        return this.isViewNextTimeByThisDefaultSolution;
    }

    public void setViewNextTimeByThisDefaultSolution(boolean isViewNextTimeByThisDefaultSolution) {
        this.isViewNextTimeByThisDefaultSolution = isViewNextTimeByThisDefaultSolution;
        if (isViewNextTimeByThisDefaultSolution) {
            try {
                if (AssignSolutionUI.getDefaultSolution(this.uiName, this.bgSchemeId, this.operateType) != null) {
                    this.confermSolutionAction();
                    this.destroyWindow();
                    return;
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            logger.info((Object)"assign invoking has not done");
            return;
        }
        this.kDCheckBox1.setVisible(isViewNextTimeByThisDefaultSolution);
    }

    public String getObjId() {
        return this.bgSchemeId;
    }

    public void setObjId(String objId) {
        this.bgSchemeId = objId;
    }

    public String getOperateType() {
        return this.operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public String getUiName() {
        return this.uiName;
    }

    public void setUiName(String uiName) {
        this.uiName = uiName;
    }

    public static AssignSolutionInfo getDefaultSolution(String uiName, String objID, String oprtType) throws Exception {
        return null;
    }

    private AssignSolutionInfo getSystemSoltuion() throws Exception {
        return null;
    }
}

