/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.client.AbstractBatchCtrlSetEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class BatchCtrlSetEditUI
extends AbstractBatchCtrlSetEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchCtrlSetEditUI.class);
    private boolean isFlexCtrl = false;
    private boolean isCancel = true;
    private BigDecimal flexCtrlParam = null;
    private int periodCtrlPolicy = -1;
    private String RESOURCE = "com.kingdee.eas.ma.budget.client.BgCtrlSetResource";
    private boolean isAllowAccess = true;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        this.checkFlexCtrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchCtrlSetEditUI.this.checkFlexCtrl_actionPerformed(e);
            }
        });
        this.checkFlexCtrl_actionPerformed(null);
    }

    @Override
    protected void checkFlexCtrl_actionPerformed(ActionEvent e) {
        if (this.checkFlexCtrl.isSelected()) {
            this.txtFlexParam.setEnabled(true);
            this.txtFlexParam.setText(this.getFlexCtrlParam() == null ? "" : this.getFlexCtrlParam().toString());
        } else {
            this.txtFlexParam.setEnabled(false);
            this.txtFlexParam.setText("");
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    private void setIcon() {
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        super.btnSave_actionPerformed(e);
        this.periodCtrlPolicy = this.raPeriod.isSelected() ? 10 : (this.raAddUp.isSelected() ? 11 : (this.raTotal.isSelected() ? 12 : (this.btnYearCtrl.isSelected() ? 20 : -1)));
        this.setFlexCtrl(this.checkFlexCtrl.isSelected());
        this.setAllowAccess(this.checkIsAllowAccess.isSelected());
        if (this.checkFlexCtrl.isSelected()) {
            String temp = this.txtFlexParam.getText().trim();
            try {
                float f = Float.parseFloat(temp);
            }
            catch (NumberFormatException e1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"flexCtrlParamInputNumber"));
                SysUtil.abort();
            }
            this.setFlexCtrlParam(new BigDecimal(temp));
        } else {
            this.setFlexCtrlParam(new BigDecimal("1.00"));
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"success"));
        this.setCancel(false);
    }

    public BigDecimal getFlexCtrlParam() {
        return this.flexCtrlParam;
    }

    public void setFlexCtrlParam(BigDecimal flexCtrlParam) {
        this.flexCtrlParam = flexCtrlParam;
    }

    public boolean isFlexCtrl() {
        return this.isFlexCtrl;
    }

    public void setFlexCtrl(boolean isFlexCtrl) {
        this.isFlexCtrl = isFlexCtrl;
    }

    public int getPeriodCtrlPolicy() {
        return this.periodCtrlPolicy;
    }

    public void setPeriodCtrlPolicy(int periodCtrlPolicy) {
        this.periodCtrlPolicy = periodCtrlPolicy;
    }

    public boolean isAllowAccess() {
        return this.isAllowAccess;
    }

    public void setAllowAccess(boolean isAllowAccess) {
        this.isAllowAccess = isAllowAccess;
    }
}

