/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.GeneralModifyingManager;
import com.kingdee.eas.fi.rpt.client.IModifyingManager;
import com.kingdee.eas.fi.rpt.client.RptCoreMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptMenuStrategy;
import com.kingdee.eas.fi.rpt.client.RptMuliReportModel;
import com.kingdee.eas.fi.rpt.client.RptStrategyManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgActualRecordException;
import com.kingdee.eas.ma.budget.BgActualRecordFacadeFactory;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgActualRecordStateEnum;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgActualRecord;
import com.kingdee.eas.ma.budget.IBgActualRecordFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.client.AbstractBgActualRecordEditUI;
import com.kingdee.eas.ma.budget.client.BgActualRecordEditMenuStrategy;
import com.kingdee.eas.ma.budget.client.BgActualRecordProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgActualRecordEditUI
extends AbstractBgActualRecordEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgActualRecordEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.ma.budget.client.BgActualRecordResource";
    protected RptStrategyManager rptStrategyManager = null;
    protected String RptMenuType = "budgetEditType";
    protected RptMuliReportModel rptMuliReportModel = new RptMuliReportModel();
    private BgFormInfo targetBgForm = null;
    protected IModifyingManager imm = null;

    public IModifyingManager getModifyingManager() {
        if (this.imm == null) {
            this.imm = new GeneralModifyingManager();
        }
        return this.imm;
    }

    public IObjectValue getEditDataObject() {
        return this.editData;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgActualRecordFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        BgActualRecordInfo info = new BgActualRecordInfo();
        return info;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.separatorFile1.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
    }

    public RptStrategyManager getRptStrategyManager() {
        if (this.rptStrategyManager == null) {
            this.rptStrategyManager = new RptStrategyManager();
            RptCoreMenuStrategy rptReportMenuStrategy = this.getRptMenuStrategy();
            this.rptStrategyManager.setRptMenuStartegy((RptMenuStrategy)rptReportMenuStrategy);
            this.rptStrategyManager.setRptMuliReportModel(this.rptMuliReportModel);
            this.rptStrategyManager.setCslParamStartegy(false);
        }
        return this.rptStrategyManager;
    }

    protected RptCoreMenuStrategy getRptMenuStrategy() {
        BgActualRecordEditMenuStrategy rptMenuStrategy = new BgActualRecordEditMenuStrategy();
        return rptMenuStrategy;
    }

    public boolean getIsCacl() {
        return this.getOprtState().equals("ADDNEW");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initMeasure();
        if (this.getOprtState().equals("ADDNEW")) {
            IUser iUser = UserFactory.getRemoteInstance();
            UserInfo user = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
            this.prmtLastUpdateUser.setData((Object)user);
            this.pkLastUpdateTime.setValue((Object)new Date(System.currentTimeMillis()));
            this.editData.setState(BgActualRecordStateEnum.Edited);
        } else {
            for (int i = 0; i < this.comboBgPeriod.getItemCount(); ++i) {
                if (!((BgPeriodInfo)this.comboBgPeriod.getItemAt(i)).getId().toString().equals(this.editData.getBgPeriod().getId().toString())) continue;
                this.comboBgPeriod.setSelectedIndex(i);
                break;
            }
        }
        this.setBgFormView();
        boolean openReport = false;
        if (this.getUIContext().get("OpenReport") != null) {
            openReport = (Boolean)this.getUIContext().get("OpenReport");
        }
        Boolean isWillAudit = (Boolean)this.getUIContext().get("isWillAudit");
        Boolean isWillUnAudit = (Boolean)this.getUIContext().get("isWillUnAudit");
        if (openReport) {
            String openReportState = this.getUIContext().get("OpenReportState").toString();
            this.openReportUI(openReportState, false, false, isWillAudit, isWillUnAudit);
        }
        if (this.getOprtState().equals("ADDNEW")) {
            this.getModifyingManager().setModifiedCount(1);
        }
        if (this.editData.getBgPeriod() != null && this.editData.getBgForm() != null) {
            String periodId = this.editData.getBgPeriod().getId().toString();
            this.comboBgPeriod.removeAllItems();
            BgFormInfo bgForm = this.editData.getBgForm();
            IBgForm iForm = BgFormFactory.getRemoteInstance();
            BgFormInfo tmpForm = iForm.getBgFormInfo("select bgPeriod.* where id='" + bgForm.getId() + "'");
            BgPeriodInfo period = tmpForm.getBgPeriod();
            if (period == null) {
                return;
            }
            BgPeriodCollection coll = this.getBgPeriodColl(period);
            this.comboBgPeriod.addItems(coll.toArray());
            for (int i = 0; i < coll.size(); ++i) {
                if (!((BgPeriodInfo)this.comboBgPeriod.getItemAt(i)).getId().toString().equals(periodId)) continue;
                this.comboBgPeriod.setSelectedIndex(i);
                break;
            }
        }
    }

    private void initMeasure() throws BOSException {
        IMeasureUnit iM = MeasureUnitFactory.getRemoteInstance();
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("id"));
        muView.getSorter().add(new SorterItemInfo("name"));
        muView.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection measureColl = iM.getMeasureUnitCollection(muView);
        if (measureColl != null && measureColl.size() != 0) {
            this.comboMeasure.addItems(measureColl.toArray());
        }
        if (!this.getOprtState().equals("ADDNEW") && this.editData != null && this.editData.getBgForm() != null) {
            String mearureId = this.editData.getMeasureUnit() == null ? this.editData.getBgForm().getMeasureUnit().getId().toString() : this.editData.getMeasureUnit().getId().toString();
            for (int i = 0; i < this.comboMeasure.getItemCount(); ++i) {
                if (!((MeasureUnitInfo)this.comboMeasure.getItemAt(i)).getId().toString().equals(mearureId)) continue;
                this.comboMeasure.setSelectedIndex(i);
            }
        }
    }

    public boolean isModify() {
        if (this.getOprtState().equals("FINDVIEW") || this.getOprtState().equals("VIEW")) {
            return false;
        }
        return this.getModifyingManager().isModified();
    }

    protected void setBgFormView() {
        String orgNumber = ((FullOrgUnitInfo)this.getUIContext().get("orgUnitInfo")).getNumber();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgNumber));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
        if (BgParamCHelper.isFodian()) {
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.periodType", (Object)new Integer(4), CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("state"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.name"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.number"));
        view.getSelector().add(new SelectorItemInfo("bgScheme.id"));
        view.getSelector().add(new SelectorItemInfo("bgScheme.name"));
        view.getSelector().add(new SelectorItemInfo("bgScheme.number"));
        view.getSelector().add(new SelectorItemInfo("bgPeriod.id"));
        view.getSelector().add(new SelectorItemInfo("bgPeriod.name"));
        view.getSelector().add(new SelectorItemInfo("bgPeriod.number"));
        view.getSelector().add(new SelectorItemInfo("currency.id"));
        view.getSelector().add(new SelectorItemInfo("currency.name"));
        view.getSelector().add(new SelectorItemInfo("currency.number"));
        this.prmtBgForm.setEntityViewInfo(view);
    }

    public VirtualSheetParamInfo save() throws Exception {
        if (!this.verifyInput()) {
            this.getUIWindow().show();
            if (this.getButtonAction() == 1) {
                this.save();
            } else {
                this.abort();
            }
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        if (((IBgActualRecord)this.getBizInterface()).exists((IObjectPK)pk)) {
            ((IBgActualRecord)this.getBizInterface()).update((IObjectPK)pk, (CoreBaseInfo)this.editData);
        } else {
            pk = ((IBgActualRecord)this.getBizInterface()).addnew((CoreBaseInfo)this.editData);
        }
        this.setOprtState("EDIT");
        this.setDataObject((IObjectValue)((IBgActualRecord)this.getBizInterface()).getBgActualRecordInfo((IObjectPK)pk, this.getSelectors()));
        this.save = true;
        this.txtNumber.setText(this.editData.getNumber());
        this.getModifyingManager().setModifiedCount(0);
        return this.editData;
    }

    private boolean verifyInput() {
        this.storeFields();
        return true;
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        this.check();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.uiWindow.hide();
            IBgForm iBgForm = BgFormFactory.getRemoteInstance();
            this.targetBgForm = iBgForm.getBgFormInfo("select data where id = '" + this.editData.getBgForm().getId() + "'");
            this.editData.setData(this.targetBgForm.getData());
            this.openReportUI(OprtState.ADDNEW, false, true, false, false);
        }
        this.setOprtState(OprtState.VIEW);
        this.getUIWindow().close();
    }

    private void check() throws BOSException, EASBizException, BgActualRecordException {
        String id = this.editData.getId() == null ? "" : this.editData.getId().toString();
        String number = this.editData.getNumber();
        String bgFormId = this.editData.getBgForm().getId().toString();
        String bgPeriodId = this.editData.getBgPeriod().getId().toString();
        IBgActualRecordFacade iActual = BgActualRecordFacadeFactory.getRemoteInstance();
        boolean isDup = iActual.checkDupNumber(id, number);
        if (isDup) {
            throw new BgActualRecordException(BgActualRecordException.DUPNUMBER);
        }
        boolean isCanInput = iActual.checkCanInputActual(id, bgFormId, bgPeriodId);
        if (!isCanInput) {
            throw new BgActualRecordException(BgActualRecordException.DUPACTUALRECORD);
        }
        if (this.comboBgPeriod.getSelectedItem() != null) {
            BgPeriodInfo period = (BgPeriodInfo)this.comboBgPeriod.getSelectedItem();
            BgActualRecordFactory.getRemoteInstance().checkBgPeriodAcross(id.trim().equals("") ? "xxx" : id, bgFormId, period.getBeginDate(), period.getEndDate());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            this.txtNumber.requestFocus();
            this.showWarning("numberIsNull");
        }
        if (this.txtName.getText() == null || this.txtName.getText().trim().length() == 0) {
            this.txtName.requestFocus();
            this.showWarning("nameIsNull");
        }
        if (this.prmtBgForm.getData() == null) {
            this.prmtBgForm.requestFocus();
            this.showWarning("bgFormIsNull");
        }
        if (this.comboBgPeriod.getSelectedItem() == null) {
            this.comboBgPeriod.requestFocus();
            this.showWarning("bgPeriodIsNull");
        }
    }

    private void showWarning(String key) {
        if (key == null) {
            return;
        }
        MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)key));
        SysUtil.abort();
    }

    protected void openReportUI(String reportState, boolean isActual, boolean dataIsFromBgForm, boolean isWillAudit, boolean isWillUnAudit) throws Exception {
        if (this.editData.getBgForm() != null && this.editData.getBgForm().getOrgUnit() != null) {
            this.editData.setCompany(this.getCompanyIdFromOrgUnit((OrgUnitInfo)this.editData.getBgForm().getOrgUnit()));
        }
        if (this.editData.getCurrency() == null && this.editData.getBgForm() != null && this.editData.getBgForm().getCurrency() != null) {
            this.editData.setCurrency(this.editData.getBgForm().getCurrency());
        }
        if (this.editData.getBgPeriod() != null) {
            this.editData.setBgPeriod(BgPeriodFactory.getRemoteInstance().getBgPeriodInfo((IObjectPK)new ObjectUuidPK(this.editData.getBgPeriod().getId())));
        }
        String reportID = this.getUIContext().get("ID") == null ? null : this.getUIContext().get("ID").toString();
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"ID", (Object)reportID);
        uiContext.put((Object)"self", (Object)this);
        uiContext.put((Object)"saveUI", (Object)this.getMetaDataPK().getFullName());
        uiContext.put((Object)"bgFormType", this.getUIContext().get("bgFormType"));
        uiContext.put((Object)"SYSTEMTIME", (Object)String.valueOf(System.currentTimeMillis()));
        boolean viewCollectInfo = false;
        if (this.getUIContext().get("viewCollectInfo") != null && this.getUIContext().get("viewCollectInfo") instanceof Boolean) {
            viewCollectInfo = (Boolean)this.getUIContext().get("viewCollectInfo");
        }
        if (isActual) {
            uiContext.put((Object)"isBizActual", (Object)Boolean.TRUE);
        } else {
            uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
        }
        uiContext.put((Object)"dataIsFromBgForm", (Object)dataIsFromBgForm);
        uiContext.put((Object)"isWillAudit", (Object)isWillAudit);
        uiContext.put((Object)"isWillUnAudit", (Object)isWillUnAudit);
        uiContext.put((Object)"orgUnitInfo", this.getUIContext().get("orgUnitInfo"));
        uiContext.put((Object)"OrgUnitCU", this.getUIContext().get("OrgUnitCU"));
        uiContext.put((Object)"IS_COLLECT", this.getUIContext().get("IS_COLLECT"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)(viewCollectInfo ? this.getUIModal1() : this.getUIModal())).create(this.getReportUIName(), (Map)uiContext, null, reportState);
        uiWindow.show();
    }

    private String getUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    private String getUIModal1() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("bgForm.id"));
        sic.add(new SelectorItemInfo("bgForm.state"));
        sic.add(new SelectorItemInfo("bgForm.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgForm.bgMeasureUnit.id"));
        sic.add(new SelectorItemInfo("bgForm.bgPeriod.id"));
        sic.add(new SelectorItemInfo("bgForm.currency.id"));
        sic.add(new SelectorItemInfo("bgForm.currency.name"));
        sic.add(new SelectorItemInfo("bgForm.currency.number"));
        sic.add(new SelectorItemInfo("bgForm.currency.precision"));
        sic.add(new SelectorItemInfo("bgForm.bgScheme.number"));
        sic.add(new SelectorItemInfo("bgForm.orgUnit.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("currency"));
        return sic;
    }

    private CompanyOrgUnitInfo getCompanyIdFromOrgUnit(OrgUnitInfo orgUnitInfo2) throws BOSException, EASBizException {
        if (orgUnitInfo2.isIsCompanyOrgUnit()) {
            return (CompanyOrgUnitInfo)orgUnitInfo2.cast(CompanyOrgUnitInfo.class);
        }
        INewOrgViewFacade iNewOrgFacade = NewOrgViewFacadeFactory.getRemoteInstance();
        OrgUnitInfo parent = iNewOrgFacade.getParent(orgUnitInfo2.getId().toString(), OrgViewType.COSTCENTER);
        if (parent == null) {
            return null;
        }
        return this.getCompanyIdFromOrgUnit(parent);
    }

    public String getReportUIName() {
        return BgActualRecordProcessUI.class.getName();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    @Override
    protected void prmtBgForm_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtBgForm.getData() != null) {
            this.comboBgPeriod.removeAllItems();
            BgFormInfo bgForm = (BgFormInfo)this.prmtBgForm.getData();
            BgPeriodInfo period = bgForm.getBgPeriod();
            if (period == null) {
                return;
            }
            BgPeriodCollection coll = this.getBgPeriodColl(period);
            this.comboBgPeriod.addItems(coll.toArray());
            ICurrency ic = CurrencyFactory.getRemoteInstance();
            this.prmtCurrency.setData((Object)ic.getValue((IObjectPK)new ObjectUuidPK(bgForm.getCurrency().getId())));
            String mearureId = bgForm.getMeasureUnit().getId().toString();
            for (int i = 0; i < this.comboMeasure.getItemCount(); ++i) {
                if (!((MeasureUnitInfo)this.comboMeasure.getItemAt(i)).getId().toString().equals(mearureId)) continue;
                this.comboMeasure.setSelectedIndex(i);
            }
        } else {
            this.comboBgPeriod.removeAllItems();
            this.prmtCurrency.setData(null);
            this.comboMeasure.setSelectedIndex(0);
        }
    }

    private Date rebuildDate(Date date, boolean isMin) {
        int year = date.getYear();
        int month = date.getMonth();
        int _date = date.getDate();
        if (isMin) {
            return new Date(year, month, _date, 0, 0, 0);
        }
        return new Date(year, month, _date, 23, 59, 59);
    }

    private BgPeriodCollection getBgPeriodColl(BgPeriodInfo period) throws BOSException, EASBizException {
        IBgPeriod iPeriod = BgPeriodFactory.getRemoteInstance();
        period = iPeriod.getBgPeriodInfo("select longNumber ,periodType,beginDate,endDate where id = '" + period.getId() + "'");
        String longNumber = period.getLongNumber();
        int type = period.getPeriodType().getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (type == 8) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)period.getId()));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)this.rebuildDate(period.getBeginDate(), true), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)this.rebuildDate(period.getEndDate(), false), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("periodtype", (Object)new Integer(1)));
            filter.setMaskString("#0 or ( #1 and #2 and #3 )");
            SorterItemInfo sort1 = new SorterItemInfo("periodtype");
            sort1.setSortType(SortType.DESCEND);
            SorterItemInfo sort2 = new SorterItemInfo("longNumber");
            sort2.setSortType(SortType.ASCEND);
            view.getSorter().add(sort1);
            view.getSorter().add(sort2);
        } else {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1");
            view.getSorter().add(new SorterItemInfo("longNumber"));
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("beginDate"));
        view.getSelector().add(new SelectorItemInfo("endDate"));
        BgPeriodCollection coll = iPeriod.getBgPeriodCollection(view);
        return coll;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        Boolean isGather = (Boolean)this.getUIContext().get("IS_COLLECT");
        Boolean isGatherCell = (Boolean)this.getUIContext().get("GATHER_CELL");
        Boolean isGatherEnumErate = (Boolean)this.getUIContext().get("GATHER_ENUMERATE");
        Boolean isGatherAdjust = (Boolean)this.getUIContext().get("GATHER_TMPDATA");
        if (isGather != null && isGather.booleanValue()) {
            int[] parameter = new int[6];
            boolean isActual = true;
            Hashtable schemeMap = (Hashtable)this.getUIContext().get("COLLECT_SCHEME");
            List orgList = (List)this.getUIContext().get("COLLECT_ORGUNIT");
            parameter[0] = isActual ? 0 : 1;
            parameter[1] = isGatherCell != null && isGatherCell != false ? 1 : 0;
            parameter[2] = isGatherEnumErate != null && isGatherEnumErate != false ? 1 : 0;
            parameter[5] = isGatherAdjust != null && isGatherAdjust != false ? 1 : 0;
            return ((IBgActualRecord)this.getBizInterface()).getActualRecordCollectValue(pk, this.getSelectors(), schemeMap, orgList, parameter);
        }
        return this.getBizInterface().getValue(pk, this.getSelectors());
    }
}

