/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TablePorperts;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.fi.rpt.util.RptFormulaParser;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgActualRecordFacadeFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFCHelper;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgMeasureUnitCollection;
import com.kingdee.eas.ma.budget.BgMeasureUnitFactory;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.IBgActualRecordFacade;
import com.kingdee.eas.ma.budget.IBgMeasureUnit;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.client.AbstractBgActualRecordProcessUI;
import com.kingdee.eas.ma.budget.client.AssignSolutionUI;
import com.kingdee.eas.ma.budget.client.BgActualCollectViewUI;
import com.kingdee.eas.ma.budget.client.BgActualKDTReportTableAgent;
import com.kingdee.eas.ma.budget.client.BgActualRecordListUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgDefCellEditer;
import com.kingdee.eas.ma.budget.client.BgSubOrgUnitSelectUIForActual;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JFormattedTextField;
import org.apache.log4j.Logger;

public class BgActualRecordProcessUI
extends AbstractBgActualRecordProcessUI {
    public static final String BG_PERIOD_ID = "bgPeriodId";
    private static final Logger logger = CoreUIObject.getLogger(BgActualRecordProcessUI.class);
    private MeasureUnitInfo defaultMeasure = null;

    @Override
    protected void loadBudgetFormInfo() {
        if (this.editDataUI != null) {
            this.editData = (BgActualRecordInfo)this.editDataUI.getEditDataObject();
            this.bgFormInfo = this.editData.getBgForm();
        }
    }

    @Override
    protected void initSystemOfOther() {
        this.btnReplaceGroup.add((AbstractButton)this.itemRadReplace);
        this.btnReplaceGroup.add((AbstractButton)this.itemRadMearReplace);
        this.itemRadReplace.setSelected(true);
        this.btnProcessGroup.add((AbstractButton)this.itemRadValue);
        this.btnProcessGroup.add((AbstractButton)this.itemRadExpressions);
        this.btnProcessGroup.add((AbstractButton)this.itemRadAll);
        this.itemRadValue.setSelected(true);
        if (this.calendarhelper == null) {
            this.calendarhelper = new CalendarHelper();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void saveDataBefore() throws Exception {
        super.saveDataBefore();
        this.editDataUI.setDataObject((IObjectValue)this.editData);
    }

    @Override
    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object svalue) {
        return super.formatCellDisplay(rowIndex, colIndex, cell, svalue);
    }

    public void actionFileSave_actionPerformed(ActionEvent e) throws Exception {
        this.beforeFileSave();
        super.actionFileSave_actionPerformed(e);
        IBgActualRecordFacade iActual = BgActualRecordFacadeFactory.getRemoteInstance();
        this.editData = (BgActualRecordInfo)this.editDataUI.getEditDataObject();
        String bgFormId = this.editData.getBgForm().getId().toString();
        Hashtable bgActualMap = this.getNumValue();
        Hashtable bgPeriodMap = iActual.getBgPeridMapFromBgForm(bgFormId, bgActualMap);
        String bgActualRecordId = this.editData.getId().toString();
        iActual.writeBgActual(bgFormId, bgActualMap, bgPeriodMap, bgActualRecordId);
        this.afterFileSave();
        this.getModifyingManager().setModifiedCount(0);
        BgFormHelper.refreshBgFormList((CoreUI)this.editDataUI);
    }

    protected void rptBackCalculate(int[] calIndex) throws Exception {
        super.rptBackCalculate(calIndex);
    }

    @Override
    public void onLoad() throws Exception {
        boolean isWillUnAudit;
        SelectorItemCollection sic;
        super.onLoad();
        if (this.getOprtState().equals("ADDNEW")) {
            this.btnOrgCollect.setEnabled(false);
            this.btnOrgCollect.setVisible(false);
            this.btnViewOrgCollect.setEnabled(false);
            this.btnViewOrgCollect.setVisible(false);
        }
        this.measureMap = new HashMap();
        this.formulaMap = new HashMap();
        this.editorMap = new HashMap();
        this.alias = new HashMap();
        if (this.defaultMeasure == null) {
            this.defaultMeasure = this.editData.getMeasureUnit();
            if (this.defaultMeasure == null) {
                this.defaultMeasure = this.editData.getBgForm().getMeasureUnit();
            }
            IMeasureUnit iMea = null;
            try {
                iMea = MeasureUnitFactory.getRemoteInstance();
                this.defaultMeasure = iMea.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(this.defaultMeasure.getId()));
            }
            catch (BOSException e1) {
                logger.error((Object)"budget error:", (Throwable)e1);
            }
            catch (EASBizException e2) {
                logger.error((Object)"budget error:", (Throwable)e2);
            }
            this.editData.getBgForm().setMeasureUnit(this.defaultMeasure);
        }
        if (this.editData.getBgForm().getCurrency() != null) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("precision"));
            ICurrency ic = CurrencyFactory.getRemoteInstance();
            CurrencyInfo currency = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.editData.getBgForm().getCurrency().getId()), sic);
            this.editData.getBgForm().setCurrency(currency);
        }
        if (this.editData.getBgForm().getOrgUnit() != null) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            IFullOrgUnit iOrg = FullOrgUnitFactory.getRemoteInstance();
            FullOrgUnitInfo org = iOrg.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.editData.getBgForm().getOrgUnit().getId()), sic);
            this.editData.getBgForm().setOrgUnit(org);
        }
        if (this.editData.getBgForm().getBgScheme() != null) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            IBgScheme iScheme = BgSchemeFactory.getRemoteInstance();
            BgSchemeInfo scheme = iScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(this.editData.getBgForm().getBgScheme().getId()), sic);
            this.editData.getBgForm().setBgScheme(scheme);
        }
        if (this.measureMap == null || this.measureMap.isEmpty()) {
            if ((this.editData.getBgForm().getBgMeasureUnit() == null || this.editData.getBgForm().getBgMeasureUnit().isEmpty()) && this.editData.getBgForm().getId() != null) {
                try {
                    BgFormInfo tmp = BgFormFactory.getRemoteInstance().getBgFormInfo("select bgMeasureUnit.* where id = '" + this.editData.getBgForm().getId() + "'");
                    this.editData.getBgForm().getBgMeasureUnit().addCollection(tmp.getBgMeasureUnit());
                }
                catch (ObjectNotFoundException tmp) {
                    // empty catch block
                }
            }
            if (this.editData.getBgForm().getBgMeasureUnit() != null && !this.editData.getBgForm().getBgMeasureUnit().isEmpty()) {
                String bgElementNumber = null;
                BgMeasureUnitInfo mcInfo = null;
                BgMeasureUnitCollection mcCol = this.editData.getBgForm().getBgMeasureUnit();
                SelectorItemCollection sic2 = new SelectorItemCollection();
                sic2.add(new SelectorItemInfo("id"));
                sic2.add(new SelectorItemInfo("bgForm.id"));
                sic2.add(new SelectorItemInfo("bgElement.id"));
                sic2.add(new SelectorItemInfo("bgElement.number"));
                sic2.add(new SelectorItemInfo("measureUnit.*"));
                IBgMeasureUnit iBgMea = null;
                try {
                    iBgMea = BgMeasureUnitFactory.getRemoteInstance();
                }
                catch (BOSException e1) {
                    logger.error((Object)"budget error:", (Throwable)e1);
                }
                Iterator iter = mcCol.iterator();
                while (iter.hasNext()) {
                    mcInfo = (BgMeasureUnitInfo)iter.next();
                    try {
                        mcInfo = (BgMeasureUnitInfo)iBgMea.getValue((IObjectPK)new ObjectUuidPK(mcInfo.getId()), sic2);
                    }
                    catch (EASBizException e1) {
                        logger.error((Object)"budget error:", (Throwable)e1);
                    }
                    catch (BOSException e1) {
                        logger.error((Object)"budget error:", (Throwable)e1);
                    }
                    if (mcInfo.getBgElement() == null || this.measureMap.containsKey(bgElementNumber = mcInfo.getBgElement().getNumber())) continue;
                    this.measureMap.put(bgElementNumber, mcInfo);
                }
            }
        }
        this.initTableKeyboardListener(this.pnlTables.getCurrentPage());
        this.setIcon();
        boolean dataIsFromBgForm = this.getUIContext().get("dataIsFromBgForm") == null ? false : (Boolean)this.getUIContext().get("dataIsFromBgForm");
        boolean isWillAudit = this.getUIContext().get("isWillAudit") == null ? false : (Boolean)this.getUIContext().get("isWillAudit");
        boolean bl = isWillUnAudit = this.getUIContext().get("isWillUnAudit") == null ? false : (Boolean)this.getUIContext().get("isWillUnAudit");
        if (isWillAudit && !isWillUnAudit) {
            this.actionAuditActual.setVisible(true);
            this.actionAuditActual.setEnabled(true);
            this.actionUnAuditActual.setVisible(false);
            this.actionUnAuditActual.setEnabled(false);
        } else if (!isWillAudit && isWillUnAudit) {
            this.actionAuditActual.setVisible(false);
            this.actionAuditActual.setEnabled(false);
            this.actionUnAuditActual.setVisible(true);
            this.actionUnAuditActual.setEnabled(true);
        } else {
            this.actionAuditActual.setVisible(false);
            this.actionAuditActual.setEnabled(false);
            this.actionUnAuditActual.setVisible(false);
            this.actionUnAuditActual.setEnabled(false);
        }
        if (isWillAudit || isWillUnAudit) {
            this.actionOrgCollect.setVisible(false);
            this.actionSheetCalculate.setVisible(false);
            this.actionOrgCollect.setEnabled(false);
            this.actionSheetCalculate.setEnabled(false);
        }
        this.clearNumValueAndLockCell(dataIsFromBgForm);
        this.dealWithIncrementBgActualFormula();
        KDTable table = this.pnlTables.getSheet(0).getTable();
        ActionMap am = table.getActionMap();
        am.put("Delete", (Action)((Object)new BgActualKDTReportTableAgent(table, 2, this.pnlTables)));
        this.isProcess = true;
    }

    private void dealWithIncrementBgActualFormula() throws Exception {
        if (!this.getOprtState().equals("ADDNEW")) {
            return;
        }
        KDTable table = this.pnlTables.getSheet(0).getTable();
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                ICell cell = table.getCell(i, j);
                if (cell == null) continue;
                cell.setExpressions(null);
                if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || ((RptCell)cell.getUserObject()).getItemFormula() == null || ((RptCell)cell.getUserObject()).getItemFormula().getExt("BGFORMULA_ACTUAL_ADD_EXPRESSIONS") == null) continue;
                String formula = ((RptCell)cell.getUserObject()).getItemFormula().getExt("BGFORMULA_ACTUAL_ADD_EXPRESSIONS");
                formula = this.dealExpressions(formula);
                cell.setExpressions(formula);
            }
        }
    }

    private String dealExpressions(String formula) {
        try {
            formula = "=" + BgClientHelper.splitFormula(formula);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String result = new String(formula);
        try {
            if (formula != null && formula.length() > 0) {
                if (formula.charAt(0) == '=') {
                    formula = "value" + formula;
                }
                ExprStmt stmt = RptFormulaParser.parse((String)formula);
                BinaryOpExpr expr = (BinaryOpExpr)stmt.expr;
                CodeExpr codeExpr = expr.right;
                try {
                    this.editData.getBgForm().setBgPeriod(this.editData.getBgPeriod());
                    result = "=" + this.subDealFormula(codeExpr, this.editData.getBgForm());
                }
                catch (IllegalArgumentException ex) {
                    logger.error((Object)ex.getMessage());
                }
            }
        }
        catch (ParserException ex) {
            logger.error((Object)ex.getMessage());
        }
        return result;
    }

    protected void setIcon() {
        this.btnAuditActual.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnUnAuditActual.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.btnRefCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnOrgCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnViewOrgCollect.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
        this.itemJisuan.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.itemActualCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.itemOrgView.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
    }

    private void clearNumValueAndLockCell(boolean is) {
        KDTable table = this.pnlTables.getCurrentPage();
        int rowCount = table.getExpandedRowCount();
        int colCount = table.getExpandedColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                ICell cell = table.getCell(r, c);
                if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell) {
                    RptCell rptCell = (RptCell)cell.getUserObject();
                    String formulaString = rptCell.getItemFormulaLine();
                    if (formulaString != null && formulaString.trim().length() > 0) {
                        if (is) {
                            cell.setValue(null);
                            cell.getStyleAttributes().setLocked(false);
                        }
                        this.processCellOfFormatInput(cell, null);
                        continue;
                    }
                    cell.getStyleAttributes().setLocked(false);
                    continue;
                }
                cell.getStyleAttributes().setLocked(false);
            }
        }
    }

    private Hashtable getNumValue() throws BOSException, EASBizException {
        Hashtable<String, BigDecimal> result = new Hashtable<String, BigDecimal>();
        BigDecimal zero = new BigDecimal("0.00");
        KDTable table = this.pnlTables.getCurrentPage();
        int rowCount = table.getExpandedRowCount();
        int colCount = table.getExpandedColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                RptCell rptCell;
                String formulaString;
                ICell cell = table.getCell(r, c);
                if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (formulaString = (rptCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) == null || formulaString.trim().length() <= 0) continue;
                Object obj = cell.getValue();
                BigDecimal actualValue = zero;
                try {
                    actualValue = obj != null && !obj.toString().trim().equals("") && !(obj instanceof BigDecimal) ? new BigDecimal(obj.toString()) : (BigDecimal)obj;
                }
                catch (NumberFormatException e) {
                    actualValue = zero;
                }
                if (actualValue == null) continue;
                result.put(formulaString, actualValue);
            }
        }
        return result;
    }

    @Override
    public void actionAuditActual_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        String bgFormId = this.editData.getBgForm().getId().toString();
        IBgActualRecordFacade iActual = BgActualRecordFacadeFactory.getRemoteInstance();
        iActual.auditBgActual(id, bgFormId);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgActualRecordResource", (String)"auditSuccess"));
        BgFormHelper.refreshBgFormList((CoreUI)this.editDataUI);
    }

    @Override
    public void actionUnAuditActual_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        String bgFormId = this.editData.getBgForm().getId().toString();
        IBgActualRecordFacade iActual = BgActualRecordFacadeFactory.getRemoteInstance();
        iActual.unAuditBgActual(id, bgFormId);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgActualRecordResource", (String)"unAuditSuccess"));
        BgFormHelper.refreshBgFormList((CoreUI)this.editDataUI);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIContext().get("IS_COLLECT") != null && this.getUIContext().get("IS_COLLECT") instanceof Boolean && ((Boolean)this.getUIContext().get("IS_COLLECT")).booleanValue()) {
            this.getModifyingManager().setModifiedCount(1);
        }
    }

    @Override
    public void actionSheetCalculate_actionPerformed(ActionEvent e) throws Exception {
        this.processCurrPageCalculate(e);
    }

    protected void beforeBackCalCurrPage() {
        super.beforeBackCalCurrPage();
        this.isProcess = false;
    }

    protected void afterBackCalCurrPage() {
        super.afterBackCalCurrPage();
        this.isProcess = true;
    }

    @Override
    protected void processCurrPageCalculate(ActionEvent e) throws Exception {
        RptSheetParamCollection infoCol;
        BgPeriodInfo period = this.editData.getBgPeriod();
        int year = this.editData.getBgPeriod().getYear();
        int halfYear = period.getHalfYear();
        int month = period.getMonth();
        int quart = period.getQuarter();
        int periodStartYear = -10000;
        int periodEndYear = 10000;
        int periodStartMonth = -10000;
        int periodEndMonth = 10000;
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.editData.getCompany().getId()));
        if (company != null) {
            PeriodInfo endPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            if (startPeriod != null && endPeriod != null) {
                periodStartMonth = startPeriod.getPeriodNumber();
                periodEndMonth = endPeriod.getPeriodNumber();
            }
        } else {
            periodEndYear = year;
            periodStartYear = year;
            periodStartMonth = 1;
            periodEndMonth = 12;
        }
        BgPeriodEnum periodType = period.getPeriodType();
        if (periodType.getValue() == 1) {
            this.editData.setPeriodType(RptPeriodTypeEnum.YEARLY);
            infoCol = this.editData.getSheetParam();
            if (infoCol == null || infoCol.size() <= 0) {
                RptSheetParamInfo info = new RptSheetParamInfo();
                info.setStartYear(year);
                info.setEndYear(year);
                info.setStartPeriod(1);
                info.setEndPeriod(1);
                info.setReport((VirtualSheetParamInfo)this.editData);
                info.setSheetID(this.pnlTables.getCurrentPage().getID());
                info.setSheetName(this.pnlTables.getCurrentPage().getName());
                if (infoCol == null) {
                    logger.error((Object)"bgFormInfo.getSheetParam() is null");
                } else {
                    infoCol.add(info);
                }
            } else {
                int size = infoCol.size();
                for (int i = 0; i < size; ++i) {
                    RptSheetParamInfo info = infoCol.get(i);
                    info.setStartYear(year);
                    info.setEndYear(year);
                    info.setStartPeriod(1);
                    info.setEndPeriod(1);
                    info.setReport((VirtualSheetParamInfo)this.editData);
                    info.setSheetID(this.pnlTables.getCurrentPage().getID());
                    info.setSheetName(this.pnlTables.getCurrentPage().getName());
                }
            }
        } else if (periodType.getValue() == 2) {
            this.editData.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
            infoCol = this.editData.getSheetParam();
            if (infoCol == null || infoCol.size() <= 0) {
                RptSheetParamInfo info = new RptSheetParamInfo();
                info.setStartYear(year);
                info.setEndYear(year);
                info.setStartPeriod(halfYear);
                info.setEndPeriod(halfYear);
                info.setReport((VirtualSheetParamInfo)this.editData);
                info.setSheetID(this.pnlTables.getCurrentPage().getID());
                info.setSheetName(this.pnlTables.getCurrentPage().getName());
                if (infoCol == null) {
                    logger.error((Object)"bgFormInfo.getSheetParam() is null");
                } else {
                    infoCol.add(info);
                }
            } else {
                int size = infoCol.size();
                for (int i = 0; i < size; ++i) {
                    RptSheetParamInfo info = infoCol.get(i);
                    info.setStartYear(year);
                    info.setEndYear(year);
                    info.setStartPeriod(halfYear);
                    info.setEndPeriod(halfYear);
                    info.setSheetID(this.pnlTables.getCurrentPage().getID());
                    info.setSheetName(this.pnlTables.getCurrentPage().getName());
                }
            }
        } else if (periodType.getValue() == 3) {
            this.editData.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
            infoCol = this.editData.getSheetParam();
            if (infoCol == null || infoCol.size() <= 0) {
                RptSheetParamInfo info = new RptSheetParamInfo();
                info.setStartYear(year);
                info.setEndYear(year);
                info.setStartPeriod(quart);
                info.setEndPeriod(quart);
                info.setReport((VirtualSheetParamInfo)this.editData);
                info.setSheetName(this.pnlTables.getCurrentPage().getName());
                info.setSheetID(this.pnlTables.getCurrentPage().getID());
                if (infoCol == null) {
                    logger.error((Object)"editData.getSheetParam() is null");
                } else {
                    infoCol.add(info);
                }
            } else {
                int size = infoCol.size();
                for (int i = 0; i < size; ++i) {
                    RptSheetParamInfo info = infoCol.get(i);
                    info.setStartYear(year);
                    info.setEndYear(year);
                    info.setSheetName(this.pnlTables.getCurrentPage().getName());
                    info.setStartPeriod(quart);
                    info.setEndPeriod(quart);
                    info.setSheetID(this.pnlTables.getCurrentPage().getID());
                }
            }
        } else if (periodType.getValue() == 4) {
            this.editData.setPeriodType(RptPeriodTypeEnum.MONTHLY);
            infoCol = this.editData.getSheetParam();
            if (infoCol == null || infoCol.size() <= 0) {
                RptSheetParamInfo info = new RptSheetParamInfo();
                info.setStartYear(year);
                info.setEndYear(year);
                info.setStartPeriod(month);
                info.setEndPeriod(month);
                info.setReport((VirtualSheetParamInfo)this.editData);
                info.setSheetID(this.pnlTables.getCurrentPage().getID());
                info.setSheetName(this.pnlTables.getCurrentPage().getName());
                if (infoCol == null) {
                    logger.error((Object)"editData.getSheetParam() is null");
                } else {
                    infoCol.add(info);
                }
            } else {
                int size = infoCol.size();
                for (int i = 0; i < size; ++i) {
                    RptSheetParamInfo info = infoCol.get(i);
                    info.setStartYear(year);
                    info.setEndYear(year);
                    info.setStartPeriod(month);
                    info.setEndPeriod(month);
                    info.setSheetID(this.pnlTables.getCurrentPage().getID());
                    info.setSheetName(this.pnlTables.getCurrentPage().getName());
                }
            }
        }
        this.actionBackCalcCurrPage_actionPerformed(e);
    }

    @Override
    protected ReportBaseInfo getCalculateObject() throws BOSException {
        ArrayList sheets = this.getAllKDTable();
        ArrayList<Object> sheetKeys = new ArrayList<Object>(sheets.size());
        RptSheetParamInfo rptSheetRpt = null;
        if (this.editData != null && this.editData.getSheetParam().size() > 0) {
            rptSheetRpt = this.editData.getSheetParam().get(0);
        }
        RptSheetParamCollection sheetParams = new RptSheetParamCollection();
        if (sheets != null && sheets.size() > 0) {
            int count = sheets.size();
            for (int i = 0; i < count; ++i) {
                RptSheet sheetTemp = (RptSheet)sheets.get(i);
                KDTable tbl = sheetTemp.getTable();
                TablePorperts p = (TablePorperts)tbl.getUserObject();
                if (p != null) {
                    sheetKeys.add(p.get((Object)"keys"));
                }
                RptSheetParamInfo rptSheetInfo = null;
                rptSheetInfo = sheetTemp.getParams() != null ? sheetTemp.getParams() : new RptSheetParamInfo();
                rptSheetInfo.setSheetID(sheetTemp.getId());
                rptSheetInfo.setSheetName(sheetTemp.getName());
                if (rptSheetRpt != null) {
                    rptSheetInfo.setStartYear(rptSheetRpt.getStartYear());
                    rptSheetInfo.setEndYear(rptSheetRpt.getEndYear());
                    rptSheetInfo.setStartPeriod(rptSheetRpt.getStartPeriod());
                    rptSheetInfo.setEndPeriod(rptSheetRpt.getEndPeriod());
                    rptSheetInfo.setReport(rptSheetInfo.getReport());
                }
                sheetParams.add(rptSheetInfo);
            }
        }
        ReportInfo info = null;
        if (this.editData instanceof ReportBaseInfo) {
            info = new ReportInfo();
            BgActualRecordInfo report = this.editData;
            info.setName(report.getName());
            info.setNumber(report.getNumber());
            info.setStartDate(report.getStartDate());
            info.setEndDate(report.getEndDate());
            info.setYear(report.getYear());
            info.setPeriod(report.getPeriod());
            if (report.getPeriodType() != null) {
                info.setPeriodType(report.getPeriodType());
            }
            info.setCompany(report.getCompany());
            info.setCurrency(report.getCurrency());
            info.setId(report.getId());
            info.getOrgRela().addCollection(report.getOrgRela());
            info.getSheetParam().addCollection(sheetParams);
            RptSrcTypeEnum type = report.getSourceType();
            if (type != null) {
                info.setSourceType(report.getSourceType());
            }
            info.put("myBgPeriod", this.editData.get("bgPeriod"));
            info.put("myBgOrgUnit", this.editData.getBgForm().get("orgUnit"));
            info.put("myState", this.editData.get("state"));
        }
        if (info != null) {
            info.put("keys", sheetKeys);
        }
        return info;
    }

    private void initTableKeyboardListener(KDTable table) {
        if (table == null) {
            return;
        }
        table.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent e) {
                if (!BgActualRecordProcessUI.this.alias.containsKey(TableToolkit.xy2range((int)e.getRowIndex(), (int)e.getColIndex()))) {
                    BgActualRecordProcessUI.this.table_propertyChange(e);
                }
            }
        });
        table.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
                BgActualRecordProcessUI.this.table_EditStarting(e);
            }

            public void editStarted(KDTEditEvent e) {
                BgActualRecordProcessUI.this.table_EditStarted(e);
            }

            public void editValueChanged(KDTEditEvent e) {
                BgActualRecordProcessUI.this.table_EditValueChanged(e);
            }

            public void editStopping(KDTEditEvent e) {
                BgActualRecordProcessUI.this.table_EditStopping(e);
            }

            public void editStopped(KDTEditEvent e) {
                BgActualRecordProcessUI.this.table_EditStopped(e);
            }

            public void editCanceled(KDTEditEvent e) {
                BgActualRecordProcessUI.this.table_EditCanceled(e);
            }
        });
    }

    private void table_propertyChange(KDTPropertyChangeEvent e) {
        if (!this.isProcess) {
            return;
        }
        ICell cell = null;
        String formulaString = null;
        String[] parameter = null;
        BgMeasureUnitInfo muInfo = null;
        BigDecimal value = null;
        if ((this.measureMap == null || this.measureMap.isEmpty()) && this.editData.getBgForm().getBgMeasureUnit() != null && !this.editData.getBgForm().getBgMeasureUnit().isEmpty()) {
            String bgElementNumber = null;
            BgMeasureUnitInfo mcInfo = null;
            BgMeasureUnitCollection mcCol = this.editData.getBgForm().getBgMeasureUnit();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("bgForm.id"));
            sic.add(new SelectorItemInfo("bgElement.id"));
            sic.add(new SelectorItemInfo("bgElement.number"));
            sic.add(new SelectorItemInfo("measureUnit.*"));
            IBgMeasureUnit iBgMea = null;
            try {
                iBgMea = BgMeasureUnitFactory.getRemoteInstance();
            }
            catch (BOSException e1) {
                logger.error((Object)"budget error:", (Throwable)e1);
            }
            Iterator iter = mcCol.iterator();
            while (iter.hasNext()) {
                mcInfo = (BgMeasureUnitInfo)iter.next();
                try {
                    mcInfo = (BgMeasureUnitInfo)iBgMea.getValue((IObjectPK)new ObjectUuidPK(mcInfo.getId()), sic);
                }
                catch (EASBizException e1) {
                    logger.error((Object)"budget error:", (Throwable)e1);
                }
                catch (BOSException e1) {
                    logger.error((Object)"budget error:", (Throwable)e1);
                }
                if (mcInfo.getBgElement() == null || this.measureMap.containsKey(bgElementNumber = mcInfo.getBgElement().getNumber())) continue;
                this.measureMap.put(bgElementNumber, mcInfo);
            }
        }
        cell = this.pnlTables.getCurrentPage().getCell(e.getRowIndex(), e.getColIndex());
        if (e.getNewValue() == null || e.getNewValue().toString().trim().length() == 0) {
            return;
        }
        this.alias.put(TableToolkit.xy2range((int)e.getRowIndex(), (int)e.getColIndex()), null);
        if (BgFSHelper.checkHasFormulaOfCell(cell)) {
            formulaString = BgFSHelper.getFormulaOfCell(cell);
            parameter = this.getFormulaInfo(this.formulaMap, formulaString);
            if (parameter != null && parameter[this.paraElement] != null && parameter[this.paraElement].trim().length() > 0) {
                if (this.measureMap.containsKey(parameter[this.paraElement])) {
                    muInfo = (BgMeasureUnitInfo)this.measureMap.get(parameter[this.paraElement]);
                    try {
                        value = new BigDecimal(e.getNewValue().toString());
                        value = value.multiply(muInfo.getMeasureUnit().getCoefficient()).setScale(this.decimal, 4);
                    }
                    catch (Exception ex) {
                        value = BgConstants.BIGZERO;
                    }
                    cell.setValue((Object)value.toString());
                } else if (this.editData.getBgForm().getMeasureUnit() != null && BgSHelper.isNumerical(e.getNewValue())) {
                    try {
                        value = new BigDecimal(e.getNewValue().toString());
                        value = value.multiply(this.defaultMeasure.getCoefficient()).setScale(this.decimal, 4);
                    }
                    catch (Exception ex) {
                        value = BgConstants.BIGZERO;
                    }
                    cell.setValue((Object)value.toString());
                }
            }
        } else if (this.defaultMeasure != null && BgSHelper.isNumerical(e.getNewValue())) {
            try {
                value = new BigDecimal(e.getNewValue().toString());
                value = value.multiply(this.defaultMeasure.getCoefficient()).setScale(this.decimal, 4);
            }
            catch (Exception ex) {
                value = BgConstants.BIGZERO;
            }
            cell.setValue((Object)value.toString());
        }
    }

    protected void table_EditStarting(KDTEditEvent e) {
    }

    protected void table_EditStarted(KDTEditEvent e) {
    }

    protected void table_EditValueChanged(KDTEditEvent e) {
    }

    protected void table_EditStopping(KDTEditEvent e) {
    }

    protected void table_EditStopped(KDTEditEvent e) {
        ICell cell = this.pnlTables.getCurrentPage().getCell(e.getRowIndex(), e.getColIndex());
        if (this.editData.getBgForm().getMeasureUnit() != null && cell.getEditor() == null && !this.checkHasFormulaOfCell(cell) && !BgFSHelper.checkIsLinkCell(cell) && BgSHelper.isNumerical(e.getValue()) && BgFCHelper.isNumericalOfCell(cell)) {
            BigDecimal value = null;
            try {
                value = new BigDecimal(e.getValue().toString().trim().replaceAll(",", ""));
            }
            catch (NumberFormatException e1) {
                SysUtil.abort();
            }
            if (value != null) {
                value = value.multiply(this.defaultMeasure.getCoefficient()).setScale(this.decimal, 4);
                this.processCellOfBgFormEditor(cell, "CELL_MEASUNIT", true);
                cell.setValue((Object)value.toString());
            }
        }
        this.getModifyingManager().addModifiedCount(1L);
        this.alias.clear();
    }

    protected void table_EditCanceled(KDTEditEvent e) {
    }

    @Override
    public void processCellOfBgFormEditor(ICell cell, String bgElementNumber, boolean isCell) {
        int precision = this.decimal;
        BgMeasureUnitInfo muInfo = (BgMeasureUnitInfo)this.measureMap.get(bgElementNumber);
        if (this.editorMap.containsKey(bgElementNumber)) {
            cell.setEditor((ICellEditor)this.editorMap.get(bgElementNumber));
        } else {
            KDFormattedTextField formattedTextField = new KDFormattedTextField();
            formattedTextField.setDataType(1);
            formattedTextField.setPrecision(this.decimal);
            formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
            BgDefCellEditer bgCellEditor = null;
            if (isCell) {
                if (this.defaultMeasure != null) {
                    bgCellEditor = new BgDefCellEditer((JFormattedTextField)formattedTextField, this.defaultMeasure.getCoefficient(), precision);
                }
            } else {
                bgCellEditor = new BgDefCellEditer((JFormattedTextField)formattedTextField, muInfo.getMeasureUnit().getCoefficient(), precision);
            }
            cell.setEditor(bgCellEditor);
            this.editorMap.put(bgElementNumber, bgCellEditor);
        }
    }

    @Override
    public void actionOrgCollect_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrgCollect_actionPerformed(e);
        Object obj = this.getUIContext().get("Owner");
        if (obj == null || !(obj instanceof BgActualRecordListUI)) {
            return;
        }
        BgActualRecordListUI ui = (BgActualRecordListUI)((Object)this.getUIContext().get("Owner"));
        FullOrgUnitInfo org = this.editData.getBgForm().getOrgUnit();
        FullOrgUnitInfo tmpOrg = null;
        if (this.editData.getId() == null) {
            this.editData.setId(BOSUuid.create((BOSObjectType)this.editData.getBOSType()));
        }
        String bgActualRecordId = this.editData.getId().toString();
        String bgFormId = this.editData.getBgForm().getId().toString();
        BOSUuid bgActualId = this.editData.getId();
        BOSUuid bgFId = this.editData.getBgForm().getId();
        BOSUuid bgActualPeriodId = this.editData.getBgPeriod().getId();
        INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getRemoteInstance();
        OrgUnitCollection orgUnitCol = iNew.getChildren(org.getId().toString(), OrgViewType.COSTCENTER);
        if (orgUnitCol != null && !orgUnitCol.isEmpty()) {
            int i;
            FullOrgUnitCollection orgRangesColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
            HashMap<String, String> orgRangesMap = new HashMap<String, String>();
            for (i = 0; i < orgRangesColl.size(); ++i) {
                orgRangesMap.put(orgRangesColl.get(i).getId().toString(), orgRangesColl.get(i).getId().toString());
            }
            for (i = orgUnitCol.size() - 1; i >= 0; --i) {
                String tmpid = orgUnitCol.get(i).getId().toString();
                if (orgRangesMap.containsKey(tmpid)) continue;
                orgUnitCol.removeObject(i);
            }
        }
        if (orgUnitCol == null || orgUnitCol.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"NoSubOrgNotCollect"));
            return;
        }
        UIContext uiContextOrg = new UIContext((Object)this);
        uiContextOrg.put((Object)"EditOrg", (Object)orgUnitCol);
        uiContextOrg.put((Object)"CUID", (Object)org.getId().toString());
        uiContextOrg.put((Object)"ID", (Object)bgFormId);
        uiContextOrg.put((Object)"selfPanelUiName", (Object)BgSubOrgUnitSelectUIForActual.class.getName());
        IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContextOrg, null, null);
        orgSelectorUI.show();
        HashMap returnData = (HashMap)((AssignSolutionUI)orgSelectorUI.getUIObject()).getReturnData();
        if (returnData == null || returnData.get("returnValue") == null || ((ArrayList)returnData.get("returnValue")).size() == 0) {
            return;
        }
        ArrayList<FullOrgUnitInfo> subOrgs = (ArrayList<FullOrgUnitInfo>)returnData.get("returnValue");
        HashMap<BOSUuid, Object> orgUnitMap = new HashMap<BOSUuid, Object>();
        int n = subOrgs.size();
        for (int i = 0; i < n; ++i) {
            tmpOrg = (FullOrgUnitInfo)subOrgs.get(i);
            orgUnitMap.put(tmpOrg.getId(), null);
        }
        Hashtable map = new Hashtable();
        map.putAll(BgActualRecordFacadeFactory.getRemoteInstance().filterBgActualCollectInfo(bgFId, orgUnitMap, bgActualPeriodId));
        if (!map.isEmpty()) {
            ArrayList<FullOrgUnitInfo> newOrgs = new ArrayList<FullOrgUnitInfo>();
            int n2 = subOrgs.size();
            for (int i = 0; i < n2; ++i) {
                tmpOrg = (FullOrgUnitInfo)subOrgs.get(i);
                if (!map.containsKey(tmpOrg.getId().toString())) continue;
                newOrgs.add(tmpOrg);
            }
            if (newOrgs == null || newOrgs.isEmpty()) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgActualRecordResource", (String)"cantCollect"));
                SysUtil.abort();
            }
            subOrgs.clear();
            subOrgs = newOrgs;
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgActualRecordResource", (String)"cantCollect"));
            SysUtil.abort();
        }
        ui.openCollectReport(e, bgActualRecordId, map, subOrgs);
        this.getModifyingManager().setModifiedCount(0);
        this.getUIWindow().close();
    }

    @Override
    public void actionViewOrgCollect_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewOrgCollect_actionPerformed(e);
        Map aliasMap = null;
        Hashtable<String, String> bgSchemeMap = null;
        ArrayList<OrgUnitInfo> orgUnitList = null;
        boolean collectType = false;
        String formulaString = this.getFormulaOfCell(null);
        if (formulaString != null && formulaString.trim().length() > 0) {
            String[] parameter;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"COLLECT_FORMULA", (Object)formulaString);
            String[] str = null;
            String[] orgStr = null;
            String[] bgSchemeStr = null;
            OrgUnitInfo orgInfo = null;
            orgUnitList = new ArrayList<OrgUnitInfo>();
            bgSchemeMap = new Hashtable<String, String>();
            KDTable table = this.pnlTables.getCurrentPage();
            if (table.getUserObject() != null && table.getUserObject() instanceof HashMap) {
                aliasMap = (Map)table.getUserObject();
                if (aliasMap.containsKey("IS_COLLECT_ADJUST")) {
                    collectType = (Boolean)aliasMap.get("IS_COLLECT_ADJUST");
                }
                if (aliasMap.containsKey("COLLECT_ORGUNIT")) {
                    str = (String[])aliasMap.get("COLLECT_ORGUNIT");
                    int in = str.length;
                    for (int i = 0; i < in; ++i) {
                        orgInfo = new OrgUnitInfo();
                        orgStr = str[i].split("_");
                        orgInfo.setId(BOSUuid.read((String)orgStr[0]));
                        orgInfo.setName(orgStr[1]);
                        orgUnitList.add(orgInfo);
                    }
                }
                if (aliasMap.containsKey("COLLECT_SCHEME")) {
                    str = (String[])aliasMap.get("COLLECT_SCHEME");
                    int jn = str.length;
                    for (int j = 0; j < jn; ++j) {
                        bgSchemeStr = str[j].split("_");
                        bgSchemeMap.put(bgSchemeStr[0], bgSchemeStr[1]);
                    }
                }
            }
            if ((parameter = this.getFormulaInfo(this.formulaMap, formulaString)) != null && parameter[this.paraElement] != null && this.measureMap.containsKey(parameter[this.paraElement])) {
                BgMeasureUnitInfo muInfo = (BgMeasureUnitInfo)this.measureMap.get(parameter[this.paraElement]);
                uiContext.put((Object)"COLLECT_MEASUREUNIT", (Object)muInfo.getMeasureUnit().getCoefficient());
            } else if (this.bgFormInfo.getMeasureUnit() != null) {
                uiContext.put((Object)"COLLECT_MEASUREUNIT", (Object)this.bgFormInfo.getMeasureUnit().getCoefficient());
            }
            uiContext.put((Object)"COLLECT_ORGUNIT", orgUnitList);
            uiContext.put((Object)"COLLECT_SCHEME", bgSchemeMap);
            uiContext.put((Object)"COLLECT_DATA_TYPE", (Object)Boolean.FALSE);
            uiContext.put((Object)"IS_COLLECT_ADJUST", (Object)new Boolean(collectType));
            uiContext.put((Object)BG_PERIOD_ID, (Object)this.editData.getBgPeriod().getId().toString());
            uiContext.put((Object)"orgUnitInfo", this.getUIContext().get("orgUnitInfo"));
            uiContext.put((Object)"OrgUnitCU", this.getUIContext().get("OrgUnitCU"));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgActualCollectViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"checkFormulaNoCollectView"));
        }
    }

    @Override
    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUDGETMANAGEMENT;
    }

    public void actionViewData_actionPerformed(ActionEvent e) throws Exception {
        boolean isWillUnAudit;
        super.actionViewData_actionPerformed(e);
        this.actionFileSave.setEnabled(true);
        this.actionSheetCalculate.setEnabled(true);
        this.actionOrgCollect.setEnabled(true);
        this.actionViewOrgCollect.setEnabled(true);
        this.actionAuditActual.setEnabled(true);
        this.actionUnAuditActual.setEnabled(true);
        boolean isWillAudit = this.getUIContext().get("isWillAudit") == null ? false : (Boolean)this.getUIContext().get("isWillAudit");
        boolean bl = isWillUnAudit = this.getUIContext().get("isWillUnAudit") == null ? false : (Boolean)this.getUIContext().get("isWillUnAudit");
        if (isWillAudit && !isWillUnAudit) {
            this.actionAuditActual.setVisible(true);
            this.actionAuditActual.setEnabled(true);
            this.actionUnAuditActual.setVisible(false);
            this.actionUnAuditActual.setEnabled(false);
        } else if (!isWillAudit && isWillUnAudit) {
            this.actionAuditActual.setVisible(false);
            this.actionAuditActual.setEnabled(false);
            this.actionUnAuditActual.setVisible(true);
            this.actionUnAuditActual.setEnabled(true);
        } else {
            this.actionAuditActual.setVisible(false);
            this.actionAuditActual.setEnabled(false);
            this.actionUnAuditActual.setVisible(false);
            this.actionUnAuditActual.setEnabled(false);
        }
        if (isWillAudit || isWillUnAudit) {
            this.actionOrgCollect.setVisible(false);
            this.actionSheetCalculate.setVisible(false);
            this.actionOrgCollect.setEnabled(false);
            this.actionSheetCalculate.setEnabled(false);
        }
    }

    public void actionViewFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewFormula_actionPerformed(e);
        this.actionFileSave.setEnabled(false);
        this.actionSheetCalculate.setEnabled(false);
        this.actionOrgCollect.setEnabled(false);
        this.actionViewOrgCollect.setEnabled(false);
        this.actionAuditActual.setEnabled(false);
        this.actionUnAuditActual.setEnabled(false);
    }
}

