/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.multiapprove.IMultiApproveManage;
import com.kingdee.eas.base.multiapprove.MultiApproveManageFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveResultInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.IBgFacade;
import com.kingdee.eas.ma.budget.VisualItemCollection;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAdjustBillTDDataProvider
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.BgAdjustBillTDDataProvider");
    private IMetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.ma.budget.BgAdjustBillTDQuery");
    public static final String[] col = new String[]{"name", "approveIdea", "time", "approveResult"};
    private Set ids = null;
    private IBgFacade ibgFacade = null;

    public BgAdjustBillTDDataProvider() {
    }

    public BgAdjustBillTDDataProvider(Set id) {
        this.ids = id;
    }

    public BgAdjustBillTDDataProvider(List id) {
        this.ids = new HashSet(id);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        if ("BgAdjustBillTDQuery".equalsIgnoreCase(ds.getID().toString())) {
            try {
                IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.queryPK);
                exec.option().isAutoTranslateEnum = true;
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
                ev.setFilter(filter);
                exec.setObjectView(ev);
                iRowSet = exec.executeQuery();
                while (iRowSet.next()) {
                    iRowSet.updateBigDecimal("entry.adjustBefore", iRowSet.getBigDecimal("entry.adjustBefore").setScale(2, 4));
                    iRowSet.updateBigDecimal("entry.adjustApply", iRowSet.getBigDecimal("entry.adjustApply").setScale(2, 4));
                    iRowSet.updateBigDecimal("entry.adjustPass", iRowSet.getBigDecimal("entry.adjustPass").setScale(2, 4));
                    iRowSet.updateBigDecimal("entry.adjustAfter", iRowSet.getBigDecimal("entry.adjustAfter").setScale(2, 4));
                    this.processBgItemCmbName(iRowSet);
                }
                iRowSet.beforeFirst();
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
            }
        } else if ("approveidea".equalsIgnoreCase(ds.getID().toString())) {
            try {
                return this.getRowSet(ds.getID());
            }
            catch (SQLException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return iRowSet;
    }

    private void processBgItemCmbName(IRowSet iRowSet) throws EASBizException, BOSException, Exception {
        if (iRowSet == null || iRowSet.size() == 0) {
            return;
        }
        String bgItemCmbId = iRowSet.getString("entry.bgItemId");
        if (bgItemCmbId == null || bgItemCmbId.length() == 0) {
            return;
        }
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put(iRowSet.getString("entry.bgItemId"), "");
        VisualItemCollection visItemCol = null;
        String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        visItemCol = this.getFacadeInterface().getVisualItemCollection(map, orgUnitId);
        if (visItemCol == null || visItemCol.size() != 1) {
            return;
        }
        VisualItemInfo visItemInfo = null;
        visItemInfo = (VisualItemInfo)visItemCol.iterator().next();
        if (visItemInfo == null) {
            return;
        }
        iRowSet.updateString("entry.bgItemId", visItemInfo.getName());
        iRowSet.updateString("bgItemSpNum", visItemInfo.getSpecialNumber());
    }

    private IBgFacade getFacadeInterface() throws Exception {
        if (this.ibgFacade == null) {
            this.ibgFacade = BgFacadeFactory.getRemoteInstance();
        }
        return this.ibgFacade;
    }

    protected IRowSet getRowSet(String id) throws SQLException {
        DynamicRowSet drs = null;
        try {
            int colCount = col.length;
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            if (this.ids == null || this.ids.size() == 0) {
                return null;
            }
            IMultiApproveManage ma = MultiApproveManageFactory.getRemoteInstance();
            List list = ma.getMultiApproveResult(this.ids.iterator().next().toString());
            int listCount = list.size();
            for (int i = listCount - 1; i >= 0; --i) {
                drs.moveToInsertRow();
                MultiApproveResultInfo resultInfo = (MultiApproveResultInfo)list.get(i);
                IUser iuser = UserFactory.getRemoteInstance();
                iuser.getValue((IObjectPK)new ObjectUuidPK(resultInfo.getApproverId()));
                drs.updateString("name", iuser.getUserInfo((IObjectPK)new ObjectUuidPK(resultInfo.getApproverId())).getName());
                drs.updateString("approveIdea", resultInfo.getOption());
                drs.updateString("time", resultInfo.getApproveDate().toString());
                drs.updateString("approveResult", resultInfo.getApproveResult().getAlias());
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return drs;
    }
}

