/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.ma.budget.BgAdjustDiversityData;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.client.BgAdjustBillEditUI;
import com.kingdee.eas.ma.budget.client.BgFormProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class BgAdjustFormProcessUI
extends BgFormProcessUI {
    protected BgAdjustBillEditUI processUI = null;
    protected Map adjustCtrlMap = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSubmit.setVisible(false);
        this.actionFormSubmit.setEnabled(false);
        this.btnAdjustSubmit.setVisible(true);
        this.actionAdjustSubmit.setEnabled(true);
        this.btnAdjustSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnAdjustSubmit.setTextIconDisStyle((short)3);
        this.btnFileExport.setTextIconDisStyle((short)3);
        this.btnPreView.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"115_BgAdjustFormProcessUI"));
        this.btnPreView.setTextIconDisStyle((short)3);
        this.btnPrint.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"116_BgAdjustFormProcessUI"));
        this.btnPrint.setTextIconDisStyle((short)3);
        if (this.getUIContext().get("Owner") != null) {
            this.processUI = (BgAdjustBillEditUI)((Object)this.getUIContext().get("Owner"));
        }
        int n = this.pnlTables.getSheets().size();
        for (int i = 0; i < n; ++i) {
            this.pnlTables.getSheet(i).getTable().getStyleAttributes().setLocked(true);
        }
    }

    @Override
    protected void initSystemOfOther() {
        super.initSystemOfOther();
        this.adjustMap = new HashMap();
        this.adjustCtrlMap = new HashMap();
    }

    @Override
    public void actionAdjustSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdjustSubmit_actionPerformed(e);
        if (this.processUI != null) {
            int j;
            int jn;
            int x;
            int xn;
            int i;
            ICell cell = null;
            RptCell rptCell = null;
            String formulaString = null;
            String[] parameter = null;
            BgAdjustDiversityData divData = null;
            IBlock block = null;
            KDTable table = this.pnlTables.getCurrentPage();
            KDTRange range = table.getSelectManager().toRange();
            boolean hasItem = false;
            int n = range.size();
            for (i = 0; i < n; ++i) {
                block = (IBlock)range.get(i);
                xn = block.getBottom();
                block3: for (x = block.getTop(); x <= xn; ++x) {
                    jn = block.getRight();
                    for (j = block.getLeft(); j <= jn; ++j) {
                        cell = table.getCell(x, j);
                        if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || ((RptCell)cell.getUserObject()).getItemFormulaLine() == null) continue;
                        hasItem = true;
                        continue block3;
                    }
                }
            }
            if (!hasItem) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAdjustBillResource", (String)"noItemError"));
                SysUtil.abort();
            }
            n = range.size();
            for (i = 0; i < n; ++i) {
                block = (IBlock)range.get(i);
                xn = block.getBottom();
                for (x = block.getTop(); x <= xn; ++x) {
                    jn = block.getRight();
                    for (j = block.getLeft(); j <= jn; ++j) {
                        cell = table.getCell(x, j);
                        if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (formulaString = (rptCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) == null || formulaString.trim().length() <= 0) continue;
                        parameter = this.getFormulaInfo(this.formulaMap, formulaString);
                        divData = new BgAdjustDiversityData();
                        divData.setFormula(formulaString);
                        if (cell.getValue() != null && cell.getValue().toString().trim().length() > 0) {
                            divData.setNewValue(new BigDecimal(cell.getValue().toString().trim()));
                        } else {
                            divData.setNewValue(BgConstants.BIGZERO);
                        }
                        divData.setParameter(parameter);
                        this.adjustMap.put(formulaString, divData);
                        HashMap tmp = new HashMap();
                        this.setCtrlMap(rptCell, tmp);
                        this.adjustCtrlMap.put(formulaString, tmp);
                    }
                }
            }
            this.processUI.setReportInfo(this.bgFormInfo);
            this.processUI.setAdjustInfo(this.adjustMap);
            this.processUI.setAdjustCtrlMap((HashMap)this.adjustCtrlMap);
            this.processUI.updateAdjustMapInfo();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAdjustBillResource", (String)"submitAdjustInfo"));
        }
    }

    private void setCtrlMap(RptCell rCell, HashMap map) {
        Boolean isCtrl = rCell.getItemFormula().getExt("isCtrl") == null ? Boolean.FALSE : new Boolean(rCell.getItemFormula().getExt("isCtrl").toString());
        Boolean isFlexCtrl = rCell.getItemFormula().getExt("isFlexCtrl") == null ? Boolean.FALSE : new Boolean(rCell.getItemFormula().getExt("isFlexCtrl").toString());
        BigDecimal flexCtrlParam = rCell.getItemFormula().getExt("flexCtrlParam") == null ? new BigDecimal("1.00") : new BigDecimal(rCell.getItemFormula().getExt("flexCtrlParam").toString());
        Integer periodCtrlPolicy = rCell.getItemFormula().getExt("periodCtrlPolicy") == null ? new Integer(-1) : new Integer(rCell.getItemFormula().getExt("periodCtrlPolicy").toString());
        Boolean isGroupCtrl = rCell.getItemFormula().getExt("isGroupCtrl") == null ? Boolean.FALSE : new Boolean(rCell.getItemFormula().getExt("isGroupCtrl").toString());
        Integer groupNo = new Integer(-1);
        if (rCell.getItemFormula().getExt("groupCtrlNo") != null) {
            try {
                groupNo = new Integer(rCell.getItemFormula().getExt("groupCtrlNo").toString());
            }
            catch (NumberFormatException e) {
                groupNo = new Integer(-1);
            }
        }
        Boolean isAllowAccess = rCell.getItemFormula().getExt("isAllowAccess") == null ? Boolean.TRUE : new Boolean(rCell.getItemFormula().getExt("isAllowAccess").toString());
        map.put("isCtrl", isCtrl);
        map.put("isFlexCtrl", isFlexCtrl);
        map.put("flexCtrlParam", flexCtrlParam);
        map.put("periodCtrlPolicy", periodCtrlPolicy);
        map.put("isGroupCtrl", isGroupCtrl);
        map.put("groupCtrlNo", groupNo);
        map.put("isAllowAccess", isAllowAccess);
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
    }
}

