/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgBudgetFacadeFactory;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormWFAdjustDataInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgOperationEnum;
import com.kingdee.eas.ma.budget.BgPastRecordFactory;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.IBgPastRecord;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.PrintConfigInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgAdjustViewUI;
import com.kingdee.eas.ma.nbudget.BgCourseFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.IBgCourseFacade;
import com.kingdee.eas.ma.nbudget.client.BgNFProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.ma.view.client.BgReportViewProcessUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAdjustViewUI
extends AbstractBgAdjustViewUI {
    private static final long serialVersionUID = 1803615943844542891L;
    private static final Logger logger = CoreUIObject.getLogger(BgAdjustViewUI.class);
    private static final String SIGN_ID = "WwXVbwEZEADgAAAawKgSC6vNEjQ=";
    boolean isEdit = false;
    boolean isSave = true;
    private DecimalFormat formater = BgNationalFormatUIUtil.getDecimalFormat(2);

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadPrintConfigInfo();
        this.initloadformulaInfo();
        this.initloadAdjustInfo();
        this.initreadAdjustInfo();
        this.initAdjustFromWFAudit();
        this.initLoadCourseInfo();
        Object state = this.getUIContext().get("states");
        if (state != null) {
            boolean stateBol = Boolean.valueOf(state.toString());
            this.tblMain.checkParsed();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                this.tblMain.getRow(i).getStyleAttributes().setLocked(!stateBol);
            }
        }
        if (this.getUIContext().get("curBgFormProcessUI") instanceof BgReportViewProcessUI) {
            this.tblMain.getColumn("orgUnitId").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("orgUnitId").getStyleAttributes().setHided(true);
        }
        if (this.getUIContext().get("curBgFormProcessUI") instanceof BgNFormProcessUI) {
            this.btnSave.setEnabled(false);
            this.btnSave.setVisible(true);
            this.tblMain.getColumn("adjustReason").getStyleAttributes().setLocked(true);
            this.tblMain.getStyleAttributes().setWrapText(true);
            this.tblMain.setDefaultRowHeight(this.tblMain.getDefaultRowHeight() * 2);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.btnSubmit.setEnabled(false);
        this.btnSubmit.setVisible(false);
        this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"117_BgAdjustViewUI"));
        this.btnSave.setEnabled(true);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        Object state = this.getUIContext().get("states");
        if (state != null && state instanceof Boolean) {
            this.btnSave.setEnabled(Boolean.valueOf(state.toString()).booleanValue());
        }
    }

    @Override
    public void actionSaveReson_actionPerformed(ActionEvent e) throws Exception {
        if (this.isSave && this.isEdit) {
            Map adjustMap = null;
            if (this.getUIContext().get("bgFormAdjust") != null) {
                adjustMap = (Map)this.getUIContext().get("bgFormAdjust");
            }
            if (adjustMap != null) {
                BgAdjustFormDiversityData date = null;
                boolean isEntre = false;
                for (int i = 0; i < this.tblMain.getBody().size(); ++i) {
                    date = null;
                    Object formulaObj = this.tblMain.getCell(i, "formulaString").getValue();
                    Object adjustReson = this.tblMain.getCell(i, "adjustReason").getValue();
                    if (this.getUIContext().get("curBgFormProcessUI") instanceof BgReportViewProcessUI) {
                        Object orgId = this.tblMain.getCell(i, "orgUnitId").getUserObject();
                        if (adjustMap.containsKey(orgId)) {
                            date = (BgAdjustFormDiversityData)((Map)adjustMap.get(orgId)).get(formulaObj);
                        }
                    } else if (adjustMap.containsKey(formulaObj)) {
                        date = (BgAdjustFormDiversityData)adjustMap.get(formulaObj);
                    }
                    if (date != null) {
                        if (adjustReson != null) {
                            date.setAdjustReson(adjustReson.toString());
                        } else {
                            date.setAdjustReson(null);
                        }
                    }
                    isEntre = true;
                }
                if (isEntre) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgFormMsgResource", (String)"successOk"));
                    if (this.getUIContext().get("Owner") instanceof BgNFProcessUI) {
                        ((BgNFProcessUI)this.getUIContext().get("Owner")).getSpreadManager().getModifyManager().setModified();
                    }
                }
                this.isEdit = false;
            }
        }
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
        this.isEdit = true;
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        this.isEdit = true;
    }

    public boolean destroyWindow() {
        if (this.isEdit) {
            this.tblMain.getEditManager().stopEditing();
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgFormMsgResource", (String)"isSave")) == 0) {
                this.saveAdjustReson();
            }
        }
        this.isSave = false;
        return super.destroyWindow();
    }

    private void saveAdjustReson() {
        Map adjustMap = null;
        if (this.getUIContext().get("bgFormAdjust") != null) {
            adjustMap = (Map)this.getUIContext().get("bgFormAdjust");
        }
        if (adjustMap != null) {
            BgAdjustFormDiversityData date = null;
            boolean isEntre = false;
            for (int i = 0; i < this.tblMain.getBody().size(); ++i) {
                Object formulaObj = this.tblMain.getCell(i, "formulaString").getValue();
                Object adjustReson = this.tblMain.getCell(i, "adjustReason").getValue();
                if (adjustMap.containsKey(formulaObj)) {
                    date = (BgAdjustFormDiversityData)adjustMap.get(formulaObj);
                    if (adjustReson != null) {
                        date.setAdjustReson(adjustReson.toString());
                    } else {
                        date.setAdjustReson(null);
                    }
                }
                isEntre = true;
            }
            if (isEntre) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgFormMsgResource", (String)"successOk"));
                if (this.getUIContext().get("Owner") instanceof BgNFProcessUI) {
                    ((BgNFProcessUI)this.getUIContext().get("Owner")).getSpreadManager().getModifyManager().setModified();
                }
            }
            this.isEdit = false;
        }
        this.isSave = true;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
        this.savePrintConfigInfo();
    }

    protected void savePrintConfigInfo() {
        KDF _kdf = new KDF();
        _kdf.addTable((IDObject)this.tblMain);
        this.tblMain.getPrintManager().saveToKDF(_kdf);
        byte[] _bytes = null;
        try {
            _bytes = ZipKDF.pack((KDF)_kdf);
            PrintConfigInfo info = new PrintConfigInfo();
            info.setData(_bytes);
            this.getAnalyseInterface().setPrintConfig(BOSUuid.read((String)SIGN_ID).toString(), info);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    protected void loadPrintConfigInfo() throws Exception {
        byte[] _bytes = null;
        try {
            PrintConfigInfo info = null;
            info = (PrintConfigInfo)this.getAnalyseInterface().getPrintConfig(BOSUuid.read((String)SIGN_ID).toString());
            _bytes = info.getData();
            if (_bytes != null && _bytes.length > 0) {
                KDF _kdf = ZipKDF.unpack((byte[])_bytes);
                this.tblMain.getPrintManager().setFromKDF(_kdf);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    protected IBgAnalyseFacade getAnalyseInterface() throws Exception {
        return BgAnalyseFacadeFactory.getRemoteInstance();
    }

    protected void initloadformulaInfo() throws BOSException, EASBizException {
        String formulaString = null;
        BOSUuid bgFormId = null;
        BOSUuid orgUnitId = null;
        BOSUuid bgSchemeId = null;
        if (this.getUIContext().get("formulaRecord") != null) {
            formulaString = (String)this.getUIContext().get("formulaRecord");
            bgFormId = (BOSUuid)this.getUIContext().get("formulaFormId");
            orgUnitId = (BOSUuid)this.getUIContext().get("formulaOrgUnit");
            bgSchemeId = (BOSUuid)this.getUIContext().get("formulaScheme");
            if (formulaString == null || orgUnitId == null || bgSchemeId == null) {
                return;
            }
        } else {
            return;
        }
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        IBgPastRecord bgPastRecord = BgPastRecordFactory.getRemoteInstance();
        if (bgPastRecord == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        IRow row = null;
        String[] para = null;
        int i = 0;
        int j = 0;
        int n = 0;
        List prInfo = bgPastRecord.getValue(bgFormId, orgUnitId, bgSchemeId, formulaString);
        if (prInfo != null && !prInfo.isEmpty()) {
            n = prInfo.size();
            for (i = 0; i < n; ++i) {
                para = (String[])prInfo.get(i);
                row = this.insertRow(para[0]);
                for (j = 0; j < para.length; ++j) {
                    if (j == 4 || j == 5 || j == 6) {
                        this.setValueOfCell(row.getCell(j), para[j]);
                        continue;
                    }
                    row.getCell(j + 1).setValue((Object)para[j]);
                }
            }
        }
    }

    protected void initloadAdjustInfo() throws EASBizException, BOSException {
        String bgFormInfoId = null;
        String formulaString = null;
        if (this.getUIContext().get("bgFormPastRecord") == null) {
            return;
        }
        bgFormInfoId = (String)this.getUIContext().get("bgFormPastRecord");
        if (this.getUIContext().get("hisFormula") != null) {
            formulaString = (String)this.getUIContext().get("hisFormula");
        }
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        IBgPastRecord bgPastRecord = BgPastRecordFactory.getRemoteInstance();
        if (bgPastRecord == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        IRow row = null;
        String[] para = null;
        int i = 0;
        int j = 0;
        int n = 0;
        List prInfo = null;
        prInfo = this.getUIContext().get("curBgFormProcessUI") instanceof BgReportViewProcessUI ? bgPastRecord.getValue(bgFormInfoId, (ArrayList)this.getUIContext().get("formulas")) : bgPastRecord.getValue(BOSUuid.read((String)bgFormInfoId), formulaString);
        if (prInfo != null && !prInfo.isEmpty()) {
            Collections.sort(prInfo, new ComparatorUser());
            n = prInfo.size();
            for (i = 0; i < n; ++i) {
                para = (String[])prInfo.get(i);
                row = this.insertRow(para[1]);
                for (j = 0; j < para.length; ++j) {
                    if (j == 5 || j == 6 || j == 7) {
                        this.setValueOfCell(row.getCell(j), para[j]);
                        continue;
                    }
                    row.getCell(j).setValue((Object)para[j]);
                }
            }
        }
    }

    protected void initreadAdjustInfo() throws BOSException, EASBizException {
        block15: {
            int n;
            int j;
            int i;
            String[] para;
            IRow row;
            DateFormat format;
            Timestamp auditTime;
            String auditor;
            IBgPastRecord bgPastRecord;
            BgOperationEnum type;
            String formulaString;
            Map adjustMap;
            block14: {
                adjustMap = null;
                formulaString = null;
                if (this.getUIContext().get("bgFormAdjust") == null) {
                    return;
                }
                adjustMap = (Map)this.getUIContext().get("bgFormAdjust");
                if (this.getUIContext().get("formulaRecord") != null) {
                    formulaString = (String)this.getUIContext().get("formulaRecord");
                }
                type = BgOperationEnum.ADJUST;
                if (this.getUIContext().get("bgRecordType") != null) {
                    type = (IntEnum)this.getUIContext().get("bgRecordType");
                }
                this.tblMain.checkParsed();
                this.tblMain.getSelectManager().setSelectMode(2);
                this.tblMain.getGroupManager().setGroup(true);
                this.tblMain.getMergeManager().setMergeMode(5);
                this.tblMain.getGroupManager().group();
                bgPastRecord = BgPastRecordFactory.getRemoteInstance();
                auditor = (String)this.getUIContext().get("auditor");
                auditTime = (Timestamp)this.getUIContext().get("auditTime");
                format = BgNationalFormatUIUtil.getNationalDateFormat();
                if (bgPastRecord == null) {
                    throw new BgException(BgException.NOINSTANCE);
                }
                row = null;
                para = null;
                i = 0;
                j = 0;
                n = 0;
                if (!(this.getUIContext().get("curBgFormProcessUI") instanceof BgReportViewProcessUI)) break block14;
                Map orgMap = BgPastRecordFactory.getRemoteInstance().getBudgetOrgInfo(new ArrayList(adjustMap.keySet()));
                for (Object o : adjustMap.keySet()) {
                    String orgName = ((CostCenterOrgUnitInfo)orgMap.get(o)).getName();
                    List prInfo = bgPastRecord.getValue((Map)adjustMap.get(o), formulaString);
                    if (prInfo == null || prInfo.isEmpty()) continue;
                    Collections.sort(prInfo, new ComparatorUser());
                    n = prInfo.size();
                    for (i = 0; i < n; ++i) {
                        para = (String[])prInfo.get(i);
                        row = this.insertRow(para[0]);
                        for (j = 0; j < para.length; ++j) {
                            if (j == 3) {
                                row.getCell(j + 1).setValue((Object)type.getAlias());
                                continue;
                            }
                            if (j == 4 || j == 5 || j == 6) {
                                this.setValueOfCell(row.getCell(j + 1), para[j]);
                                continue;
                            }
                            row.getCell(j + 1).setValue((Object)para[j]);
                        }
                        row.getCell("adjustor").setValue((Object)auditor);
                        if (auditTime != null) {
                            row.getCell("adjustTime").setValue((Object)format.format(new Date(auditTime.getTime())));
                        }
                        row.getCell("orgUnitId").setValue((Object)orgName);
                        row.getCell("orgUnitId").setUserObject(o);
                    }
                }
                break block15;
            }
            List prInfo = bgPastRecord.getValue(adjustMap, formulaString);
            if (prInfo == null || prInfo.isEmpty()) break block15;
            Collections.sort(prInfo, new ComparatorUser());
            n = prInfo.size();
            for (i = 0; i < n; ++i) {
                para = (String[])prInfo.get(i);
                row = this.insertRow(para[0]);
                for (j = 0; j < para.length; ++j) {
                    if (j == 3) {
                        row.getCell(j + 1).setValue((Object)type.getAlias());
                        continue;
                    }
                    if (j == 4 || j == 5 || j == 6) {
                        this.setValueOfCell(row.getCell(j + 1), para[j]);
                        continue;
                    }
                    row.getCell(j + 1).setValue((Object)para[j]);
                }
                row.getCell("adjustor").setValue((Object)auditor);
                if (auditTime == null) continue;
                row.getCell("adjustTime").setValue((Object)format.format(new Date(auditTime.getTime())));
            }
        }
    }

    protected void initAdjustFromWFAudit() throws BOSException, EASBizException {
        Object owner = this.getUIContext().get("Owner");
        if (owner == null || !(owner instanceof BgNFormProcessUI) && !(owner instanceof BgReportViewProcessUI)) {
            return;
        }
        BgFormInfo bgFormInfo = null;
        BgNFormProcessUI bgNFormProcessUI = null;
        BgReportViewProcessUI reportViewProcessUI = null;
        if (this.getUIContext().get("bgFormInfo") == null) {
            return;
        }
        bgFormInfo = (BgFormInfo)this.getUIContext().get("bgFormInfo");
        Object processObj = this.getUIContext().get("curBgFormProcessUI");
        if (processObj != null && processObj instanceof BgNFormProcessUI) {
            bgNFormProcessUI = (BgNFormProcessUI)this.getUIContext().get("curBgFormProcessUI");
        } else if (processObj != null && processObj instanceof BgReportViewProcessUI) {
            reportViewProcessUI = (BgReportViewProcessUI)this.getUIContext().get("curBgFormProcessUI");
        } else {
            return;
        }
        Map valueMap = new HashMap();
        IBgFormFacade facade = BgFormFacadeFactory.getRemoteInstance();
        String formulaString = (String)this.getUIContext().get("hisFormula");
        valueMap = reportViewProcessUI != null ? facade.getAdjustFromWFAudit(bgFormInfo.getId().toString(), (ArrayList)this.getUIContext().get("formulas")) : (formulaString == null || formulaString.length() == 0 ? facade.getAdjustFromWFAudit((IObjectValue)bgFormInfo, null, true) : facade.getAdjustFromWFAudit((IObjectValue)bgFormInfo, formulaString, false));
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        IRow row = null;
        Set formulaSet = valueMap.keySet();
        Iterator iterator = formulaSet.iterator();
        DateFormat format = BgNationalFormatUIUtil.getNationalDateFormat();
        while (iterator.hasNext()) {
            String formula = iterator.next().toString();
            List valueList = (List)valueMap.get(formula);
            if (valueList == null) continue;
            for (int i = 0; valueList != null && i < valueList.size(); ++i) {
                BgFormWFAdjustDataInfo info = (BgFormWFAdjustDataInfo)valueList.get(i);
                String[] paramter = null;
                if (bgNFormProcessUI != null) {
                    paramter = BgNFSHelper.parseFormulaPara((Map)bgNFormProcessUI.getFormulaMap(), (String)info.getFormula());
                } else if (reportViewProcessUI != null) {
                    paramter = BgNFSHelper.parseFormulaPara((Map)reportViewProcessUI.getFormulaMap(), (String)info.getFormula());
                }
                if (paramter == null) continue;
                String bgItemNumber = paramter[BgSHelper.paraItem];
                Map _tmpMap = new HashMap<String, Object>();
                _tmpMap.put(bgItemNumber.replaceAll(",", "_"), null);
                _tmpMap = BgBudgetFacadeFactory.getRemoteInstance().getSelectBgItemCombinName(_tmpMap, bgFormInfo.getOrgUnit().getId().toString());
                String bgItemName = (String)_tmpMap.get(bgItemNumber.replaceAll(",", "_"));
                String elementNumber = paramter[BgSHelper.paraElement];
                IBgElement iBgElement = BgElementFactory.getRemoteInstance();
                BgElementInfo elementInfo = iBgElement.getBgElementInfo(" select name where number = '" + elementNumber + "'");
                String periodNumber = paramter[BgSHelper.paraPeriod];
                IBgPeriod iBgPeriod = BgPeriodFactory.getRemoteInstance();
                BgPeriodInfo bgPeriodInfo = iBgPeriod.getBgPeriodInfo(" select name where number='" + periodNumber + "'");
                UserInfo adjustor = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK(info.getAdjustorId()));
                UserInfo creator = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK(info.getCreatorId()));
                row = this.insertRow(bgItemName == null ? "" : bgItemName);
                row.getCell("item").setValue((Object)(bgItemName == null ? "" : bgItemName));
                row.getCell("element").setValue((Object)elementInfo.getName());
                row.getCell("period").setValue((Object)bgPeriodInfo.getName());
                row.getCell("operation").setValue((Object)BgPastSourceEnum.WFAUDITADJUST.getAlias());
                row.getCell("oldValue").setValue((Object)info.getBgBalance().setScale(2, 4).toString());
                row.getCell("adjustValue").setValue((Object)info.getBgPastValue().setScale(2, 4).toString());
                row.getCell("difValue").setValue((Object)info.getAdjustValue().setScale(2, 4).toString());
                row.getCell("creator").setValue((Object)adjustor.getName());
                row.getCell("createTime").setValue((Object)info.getAdjustTime());
                row.getCell("adjustor").setValue((Object)creator.getName());
                row.getCell("adjustTime").setValue((Object)format.format(new Date(info.getCreateTiem().getTime())));
                row.getCell("orgUnitId").setValue((Object)info.getOrgName());
                row.getCell("orgUnitId").setUserObject((Object)info.getOrgId());
                row.getCell("adjustReason").setValue((Object)info.getAdjustReason());
            }
        }
    }

    private IRow insertRow(String info) {
        int index;
        int size = this.tblMain.getRowCount();
        for (index = 0; index < size && info.compareTo(this.tblMain.getCell(index, 1).getValue().toString()) >= 0; ++index) {
        }
        return this.tblMain.addRow(index);
    }

    private void setValueOfCell(ICell cell, String value) {
        if (cell == null || value == null || value.length() == 0) {
            return;
        }
        boolean isNumber = true;
        BigDecimal numberValue = null;
        try {
            numberValue = new BigDecimal(value);
        }
        catch (Exception ex) {
            isNumber = false;
        }
        if (!isNumber) {
            return;
        }
        cell.setValue((Object)this.formater.format(numberValue));
    }

    private String getNumberFormat(String str, int number) {
        if (str == null || number <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    protected void initLoadCourseInfo() throws Exception {
        String bgFormId = (String)this.getUIContext().get("BGFORM_ID");
        String formulaStr = (String)this.getUIContext().get("FORMULA");
        if (StringUtils.isEmpty((String)bgFormId)) {
            bgFormId = (String)this.getUIContext().get("bgFormPastRecord");
            formulaStr = (String)this.getUIContext().get("hisFormula");
        }
        Map formulaMap = (Map)this.getUIContext().get("COURSE_VALUE");
        Object _obj = this.getUIContext().get("CURRENCY_PRECISION");
        int _precision = 2;
        if (_obj != null && _obj instanceof Integer) {
            _precision = (Integer)_obj;
        }
        DecimalFormat _format = BgNationalFormatUIUtil.getDecimalFormat(_precision);
        if (StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        List _re = this.getCourseInterface().viewDiffInfo(bgFormId, formulaStr, formulaMap);
        if (_re != null) {
            IRow row = null;
            List _info = null;
            int colCount = this.tblMain.getColumnCount();
            int in = _re.size();
            for (int i = 0; i < in; ++i) {
                _info = (List)_re.get(i);
                row = this.tblMain.addRow();
                int jn = _info.size();
                for (int j = 0; j < jn; ++j) {
                    _obj = _info.get(j);
                    if (j >= colCount) continue;
                    if (_obj != null && _obj instanceof BigDecimal) {
                        row.getCell(j + 1).setValue((Object)_format.format(((BigDecimal)_obj).doubleValue()));
                        continue;
                    }
                    row.getCell(j + 1).setValue(_obj);
                }
            }
        }
    }

    protected IBgCourseFacade getCourseInterface() throws Exception {
        return BgCourseFacadeFactory.getRemoteInstance();
    }

    class ComparatorUser
    implements Comparator {
        ComparatorUser() {
        }

        public int compare(Object arg0, Object arg1) {
            String[] _obj1 = (String[])arg0;
            String[] _obj2 = (String[])arg1;
            String[] _tmpItemNumner1 = _obj1[1].split("_");
            String[] _tmpItemNumner2 = _obj2[1].split("_");
            int re = 0;
            if (_tmpItemNumner1 != null && _tmpItemNumner1.length > 0 && _tmpItemNumner2 != null && _tmpItemNumner2.length > 0) {
                re = _tmpItemNumner1[0].compareTo(_tmpItemNumner2[0]);
            }
            if (re == 0 && (re = _obj1[2].compareTo(_obj2[2])) == 0 && (re = _obj1[3].compareTo(_obj2[3])) == 0) {
                re = _obj1[9].compareTo(_obj2[9]);
            }
            return re;
        }
    }
}

