/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormWFAdjustDataInfo;
import com.kingdee.eas.ma.budget.BgPastDataCollection;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgAdjustWFAuditEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNFProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class BgAdjustWFAuditEditUI
extends AbstractBgAdjustWFAuditEditUI {
    private static final long serialVersionUID = 1686212214131684294L;
    public static final String WF_AUDIT_ADJUSTMAP = "wfAuditAdjustMap";
    public static final String CUR_CELL_BGITEM_NAME = "curBgItemName";
    public static final String CUR_CELL_VALUE = "curCellValue";
    public static final String CUR_BGFORM = "curBgFormInfo";
    public static final String CUR_FORMULA = "curFormula";
    public static final String CUR_PROCESSUI_REF = "curProcessUIRef";
    public static final String CUR_MEASUREUNIT = "CUR_MEASUREUNIT";
    private Map context = null;
    protected BigDecimal curCellValue = null;
    protected BigDecimal adjValue = null;
    protected BigDecimal balanceVlaue = null;
    protected Map wfAuditAdjustMap = null;
    protected String curFormula = null;
    protected BgNFProcessUI currentProcessUI = null;
    protected BgPastDataCollection bgPastDatas = null;
    protected BgFormInfo curBgFormInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"updateBgData"));
        this.context = this.getUIContext();
        this.currentProcessUI = (BgNFProcessUI)this.context.get(CUR_PROCESSUI_REF);
        this.curBgFormInfo = (BgFormInfo)this.context.get(CUR_BGFORM);
        this.curFormula = this.context.get(CUR_FORMULA).toString();
        this.wfAuditAdjustMap = (Map)this.context.get(WF_AUDIT_ADJUSTMAP);
        this.loadCurrentCellInfo();
        this.loadHistoryListInfo();
    }

    protected void loadCurrentCellInfo() throws Exception {
        String bgItemName = "";
        if (this.context.get(CUR_CELL_BGITEM_NAME) != null) {
            bgItemName = (String)this.context.get(CUR_CELL_BGITEM_NAME);
        }
        if (this.context.get(CUR_CELL_VALUE) != null) {
            this.curCellValue = (BigDecimal)this.context.get(CUR_CELL_VALUE);
        }
        this.txtBgItem.setText(bgItemName);
        this.txtBeforeAdj.setText(this.curCellValue.setScale(2, 4).toString());
        this.txtAdj.requestFocus();
    }

    protected void loadHistoryListInfo() throws Exception {
        IBgFormFacade facade = BgFormFacadeFactory.getRemoteInstance();
        Map valueMap = facade.getAdjustFromWFAudit((IObjectValue)this.curBgFormInfo, this.curFormula, false);
        List valueList = (List)valueMap.get(this.curFormula);
        this.table.checkParsed();
        this.table.getSelectManager().setSelectMode(2);
        IRow row = null;
        for (int i = 0; i < valueList.size(); ++i) {
            BgFormWFAdjustDataInfo value = (BgFormWFAdjustDataInfo)valueList.get(i);
            row = this.table.addRow(i);
            row.getCell("adjTiem").setValue((Object)value.getAdjustTime());
            row.getCell("adjBefore").setValue((Object)value.getBgBalance());
            row.getCell("adjAfter").setValue((Object)value.getBgPastValue());
            row.getCell("adj").setValue((Object)value.getAdjustValue());
            row.getCell("adjReason").setValue((Object)value.getAdjustReason());
            UserInfo userInfo = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK(value.getAdjustorId()));
            row.getCell("adjPerson").setValue((Object)userInfo.getName());
        }
    }

    @Override
    protected void txtAdj_focusLost(FocusEvent e) {
        if (this.txtAdj.getText() != null && this.txtAdj.getText().length() > 0) {
            String adjStr = this.txtAdj.getText();
            this.adjValue = new BigDecimal(adjStr);
            this.balanceVlaue = new BigDecimal(this.curCellValue.toString()).add(this.adjValue);
            this.txtAfterAdj.setText(this.balanceVlaue.setScale(2, 4).toString());
        }
    }

    @Override
    protected void txtAfterAdj_focusLost(FocusEvent e) throws Exception {
        if (this.txtAfterAdj.getText() != null && this.txtAfterAdj.getText().length() > 0) {
            String afterAdjStr = this.txtAfterAdj.getText();
            this.balanceVlaue = new BigDecimal(afterAdjStr);
            this.adjValue = new BigDecimal(this.balanceVlaue.toString()).subtract(this.curCellValue);
            this.txtAdj.setText(this.adjValue.setScale(2, 4).toString());
        }
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        this.currentProcessUI.callBack_BgAdjustWFAuditEditUI(this.curCellValue, this.balanceVlaue, this.adjValue, this.txtReason.getText(), null);
        this.actionExitCurrent_actionPerformed(e);
    }

    private void verifyInput() throws Exception {
        if (this.txtAdj.getText() == null || this.txtAdj.getText().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("pleaseInputAdjVal"));
            this.txtAdj.requestFocus();
            SysUtil.abort();
        }
        if (this.txtAfterAdj.getText() == null || this.txtAfterAdj.getText().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("pleaseInputAfterAdjVal"));
            this.txtAfterAdj.requestFocus();
            SysUtil.abort();
        }
        if (this.txtReason.getText() == null || this.txtReason.getText().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getString("pleaseInputAdjReason"));
            this.txtReason.requestFocus();
            SysUtil.abort();
        }
    }

    private String getString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)key);
    }
}

