/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgBudgetFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormWFAdjustDataInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgAdjustWFAuditViewUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFProcessUI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgAdjustWFAuditViewUI
extends AbstractBgAdjustWFAuditViewUI {
    private static final long serialVersionUID = -8543324312073013145L;
    public static final String CUR_BGFORM = "curBgFormInfo";
    public static final String CUR_FORMULA = "curFormula";
    public static final String IS_ALL = "isAll";
    public static final String CUR_PROCESSUI_REF = "curProcessUIRef";
    protected BgFormInfo curBgFormInfo = null;
    protected String curFormula = null;
    protected boolean isAll = false;
    protected Map context = null;
    protected Map valueMap = null;
    protected BgNFProcessUI currentProcessUI = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initInfoFromParent();
        this.initloadformulaInfo();
    }

    protected void initInfoFromParent() throws BOSException, EASBizException {
        this.context = this.getUIContext();
        this.curBgFormInfo = (BgFormInfo)this.context.get(CUR_BGFORM);
        this.currentProcessUI = (BgNFProcessUI)this.context.get(CUR_PROCESSUI_REF);
        Object object = this.context.get(CUR_FORMULA);
        this.curFormula = object == null ? null : (String)object;
        this.isAll = (Boolean)this.context.get(IS_ALL);
        IBgFormFacade facade = BgFormFacadeFactory.getRemoteInstance();
        this.valueMap = this.isAll ? facade.getAdjustFromWFAudit((IObjectValue)this.curBgFormInfo, null, true) : facade.getAdjustFromWFAudit((IObjectValue)this.curBgFormInfo, this.curFormula, false);
    }

    protected void initloadformulaInfo() throws BOSException, EASBizException {
        if (this.curBgFormInfo == null) {
            return;
        }
        if (this.valueMap == null || this.valueMap.size() == 0) {
            return;
        }
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        IRow row = null;
        Set formulaSet = this.valueMap.keySet();
        Iterator iterator = formulaSet.iterator();
        while (iterator.hasNext()) {
            String formula = iterator.next().toString();
            List valueList = (List)this.valueMap.get(formula);
            if (valueList == null) continue;
            for (int i = 0; valueList != null && i < valueList.size(); ++i) {
                BgFormWFAdjustDataInfo info = (BgFormWFAdjustDataInfo)valueList.get(i);
                String[] paramter = BgNFSHelper.parseFormulaPara((Map)this.currentProcessUI.getFormulaMap(), (String)info.getFormula());
                String bgItemNumber = paramter[BgSHelper.paraItem];
                Map _tmpMap = new HashMap<String, Object>();
                _tmpMap.put(bgItemNumber.replaceAll(",", "_"), null);
                _tmpMap = BgBudgetFacadeFactory.getRemoteInstance().getSelectBgItemCombinName(_tmpMap, this.curBgFormInfo.getOrgUnit().getId().toString());
                String _bgItemName = (String)_tmpMap.get(bgItemNumber.replaceAll(",", "_"));
                UserInfo adjustor = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK(info.getAdjustorId()));
                row = this.insertRow(_bgItemName);
                row.getCell("bgItem").setValue((Object)_bgItemName);
                row.getCell("adjBefore").setValue((Object)info.getBgBalance());
                row.getCell("adjValue").setValue((Object)info.getAdjustValue());
                row.getCell("adjBalance").setValue((Object)info.getBgPastValue());
                row.getCell("adjPerson").setValue((Object)adjustor.getName());
                row.getCell("adjTime").setValue((Object)info.getAdjustTime());
                row.getCell("adjReason").setValue((Object)info.getAdjustReason());
            }
        }
    }

    private IRow insertRow(String info) {
        int index;
        int size = this.tblMain.getRowCount();
        for (index = 0; index < size && info.compareTo(this.tblMain.getCell(index, 0).getValue().toString()) >= 0; ++index) {
        }
        return this.tblMain.addRow(index);
    }
}

