/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.budget.BgAnalyseContInfo;
import com.kingdee.eas.ma.budget.BgAnalyseContrastFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgAnalyseInfo;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgAnalyseContrastMainUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseContrastFilterUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BgAnalyseContrastMainUI
extends AbstractBgAnalyseContrastMainUI {
    private static final long serialVersionUID = -5899547426765297962L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseContrastMainUI.class);
    private BigDecimal defMeasureUnit = null;
    private int decimal = 10;
    private DecimalFormat decFormat = null;
    private LongTimeDialog dialog = null;
    private Map fileMap = null;
    private String selSheetId = null;
    private String oldSelSheetId = null;
    private KDTable selSheet = null;
    private ChangeListener changeListener = null;
    private static final String CONT_DATA = "CONT_DATA";
    private static final String BGITEM_PARAM = "BGITEM_PARAM";
    private static final String BGITEMS_PARAM = "BGITEMS_PARAM";

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected void setUITitle() {
        this.setUITitle(BgAnalyseHelper.getMessage("bgContrastTitle"));
    }

    @Override
    protected String getQueryMainName() {
        return BgAnalyseContrastMainUI.class.getName();
    }

    @Override
    protected BgAnalyseFilterBaseUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new BgAnalyseContrastFilterUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        return this.defaultFilterUI;
    }

    @Override
    protected void clearAnalyseSheet() {
        if (this.changeListener != null) {
            this.getMainTabPane().removeChangeListener(this.changeListener);
        }
        super.clearAnalyseSheet();
        BgAnalyseHelper.clearAllFile(this.getFileMap());
    }

    @Override
    protected int getHeightOfDialog() {
        return 310;
    }

    protected ICostCenterOrgUnit getCCorgUnitInterface() throws Exception {
        return CostCenterOrgUnitFactory.getRemoteInstance();
    }

    public Map getFileMap() {
        return this.fileMap;
    }

    public void setFileMap(Map fileMap) {
        this.fileMap = fileMap;
    }

    public String getOldSelSheetId() {
        return this.oldSelSheetId;
    }

    public void setOldSelSheetId(String oldSelSheetId) {
        this.oldSelSheetId = oldSelSheetId;
    }

    public KDTable getSelSheet() {
        return this.selSheet;
    }

    public void setSelSheet(KDTable selSheet) {
        this.selSheet = selSheet;
    }

    public String getSelSheetId() {
        return this.selSheetId;
    }

    public void setSelSheetId(String selSheetId) {
        this.selSheetId = selSheetId;
    }

    protected void initTabPaneListener() {
        if (this.getMainTabPane() != null) {
            this.changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    try {
                        BgAnalyseContrastMainUI.this.tabPane_stateChanged(e);
                    }
                    catch (Exception ex) {
                        BgAnalyseContrastMainUI.this.handUIExceptionAndAbort(ex);
                    }
                }
            };
            this.getMainTabPane().addChangeListener(this.changeListener);
        }
    }

    protected void tabPane_stateChanged(ChangeEvent e) throws Exception {
        Object _obj = this.getSelectSheet();
        if (_obj == null || !(_obj instanceof KDTable)) {
            return;
        }
        this.setSelSheet((KDTable)_obj);
        if (this.getSelSheet() != null && !StringUtils.isEmpty((String)this.getSelSheet().getID())) {
            this.setSelSheetId(this.getSelSheet().getID());
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
            if (this.dialog != null) {
                this.dialog.setLongTimeTask(new ILongTimeTask(){

                    public Object exec() throws Exception {
                        if (!BgAnalyseContrastMainUI.this.getSelSheetId().equals(BgAnalyseContrastMainUI.this.getOldSelSheetId())) {
                            BgAnalyseContrastMainUI.this.removeSheetAllRows(BgAnalyseContrastMainUI.this.getSelSheetId());
                            BgAnalyseContrastMainUI.this.setOldSelSheetId(BgAnalyseContrastMainUI.this.getSelSheetId());
                        }
                        if (BgAnalyseContrastMainUI.this.getFileMap().containsKey(BgAnalyseContrastMainUI.this.getSelSheetId())) {
                            BgAnalyseContrastMainUI.this.loadAnalyseInfo(BgAnalyseContrastMainUI.this.getSelSheetId(), BgAnalyseContrastMainUI.this.getSelSheet());
                        } else {
                            BgAnalyseContrastMainUI.this.executeBudgetVSActualByOrgUnit(BOSUuid.read((String)BgAnalyseContrastMainUI.this.getSelSheetId()), (BgAnalyseContrastFilterParam)BgAnalyseContrastMainUI.this.defaultFilterParam, BgAnalyseContrastMainUI.this.getSelSheet());
                        }
                        return null;
                    }

                    public void afterExec(Object result) throws Exception {
                    }
                });
                this.dialog.show();
            } else {
                if (!this.getSelSheetId().equals(this.getOldSelSheetId())) {
                    this.removeSheetAllRows(this.getSelSheetId());
                    this.setOldSelSheetId(this.getSelSheetId());
                }
                if (this.getFileMap().containsKey(this.getSelSheetId())) {
                    this.loadAnalyseInfo(this.getSelSheetId(), this.getSelSheet());
                } else {
                    this.executeQuery(BOSUuid.read((String)this.getSelSheetId()), (BgAnalyseContrastFilterParam)this.defaultFilterParam, this.getSelSheet());
                }
            }
        }
    }

    protected void removeSheetAllRows(String sheetId) {
        if (StringUtils.isEmpty((String)sheetId) || this.getMainTabPane() == null) {
            return;
        }
        Component comp = null;
        KDPanel panel = null;
        KDTable sheet = null;
        int compSize = this.getMainTabPane().getComponentCount();
        for (int compIndex = 0; compIndex < compSize; ++compIndex) {
            comp = this.getMainTabPane().getComponent(compIndex);
            if (comp == null || !(comp instanceof KDPanel)) continue;
            panel = (KDPanel)comp;
            int panelSize = panel.getComponentCount();
            for (int panelIndex = 0; panelIndex < panelSize; ++panelIndex) {
                comp = panel.getComponent(panelIndex);
                if (comp == null || !(comp instanceof KDTable) || StringUtils.isEmpty((String)(sheet = (KDTable)comp).getID()) || !sheetId.equals(sheet.getID())) continue;
                sheet.removeRows();
                return;
            }
        }
    }

    @Override
    protected void executeQuery() {
        if (this.defaultFilterParam == null || !(this.defaultFilterParam instanceof BgAnalyseContrastFilterParam)) {
            return;
        }
        if (this.getFileMap() == null) {
            this.setFileMap(new HashMap());
        } else {
            BgAnalyseHelper.clearAllFile(this.getFileMap());
        }
        BgAnalyseContrastFilterParam _filter = (BgAnalyseContrastFilterParam)this.defaultFilterParam;
        if (_filter.getMeasureUnit() != null) {
            this.defMeasureUnit = _filter.getMeasureUnit().getCoefficient();
        }
        if (_filter.getCurrency() != null) {
            this.decimal = _filter.getCurrency().getPrecision();
            this.decFormat = this.decimal == 0 ? new DecimalFormat("#,##0") : new DecimalFormat("#,##0." + BgFormHelper.getNumberFormat("0", this.decimal));
        }
        this.clearAnalyseSheet();
        if (_filter.getAnalyseType() == 0) {
            this.executeBudgetVSActual(_filter);
        } else if (_filter.getAnalyseType() == 1) {
            this.executeBatchBgscheme(_filter);
        }
    }

    protected void executeQuery(BOSUuid ccOrgUnitId, BgAnalyseContrastFilterParam filter, KDTable sheet) {
        if (filter == null) {
            return;
        }
        this.executeBudgetVSActualByOrgUnit(ccOrgUnitId, filter, sheet);
    }

    protected void initBudgetVSActualTitle(BgAnalyseContrastFilterParam filter, KDTable sheet) {
        if (sheet == null) {
            return;
        }
        String formateString = null;
        String rateString = "0.00%";
        int precision = filter.getCurrency().getPrecision();
        formateString = precision != 0 ? "#,##0." + BgFormHelper.getNumberFormat("0", precision) : "#,##0";
        IRow row = null;
        sheet.checkParsed(true);
        sheet.setRefresh(false);
        sheet.addColumns(10);
        sheet.getColumn(0).setWidth(150);
        sheet.getColumn(1).setWidth(100);
        sheet.getColumn(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(2).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(3).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(3).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(4).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(4).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(5).getStyleAttributes().setNumberFormat(rateString);
        sheet.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(6).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(7).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(7).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(8).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(8).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(9).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(9).getStyleAttributes().setNumberFormat(rateString);
        row = sheet.addHeadRow();
        row.getCell(0).setValue((Object)BgAnalyseHelper.getMessage("bgitem"));
        row.getCell(1).setValue((Object)BgAnalyseHelper.getMessage("bgPeriod"));
        row.getCell(2).setValue((Object)BgAnalyseHelper.getMessage("periodAnalyse"));
        row.getCell(6).setValue((Object)BgAnalyseHelper.getMessage("totalAnalyse"));
        row = sheet.addHeadRow();
        row.getCell(2).setValue((Object)((BgElementInfo)filter.getBgElements()[0]).getName());
        row.getCell(6).setValue((Object)((BgElementInfo)filter.getBgElements()[0]).getName());
        row = sheet.addHeadRow();
        row.getCell(2).setValue((Object)BgAnalyseHelper.getMessage("periodBudget"));
        row.getCell(3).setValue((Object)BgAnalyseHelper.getMessage("periodActual"));
        row.getCell(4).setValue((Object)BgAnalyseHelper.getMessage("executeDiff"));
        row.getCell(5).setValue((Object)BgAnalyseHelper.getMessage("executeDiffRate"));
        row.getCell(6).setValue((Object)BgAnalyseHelper.getMessage("totalInitBudget"));
        row.getCell(7).setValue((Object)BgAnalyseHelper.getMessage("totalActual"));
        row.getCell(8).setValue((Object)BgAnalyseHelper.getMessage("totalDiff"));
        row.getCell(9).setValue((Object)BgAnalyseHelper.getMessage("totalDiffRate"));
        sheet.getHeadMergeManager().mergeBlock(0, 0, 2, 0);
        sheet.getHeadMergeManager().mergeBlock(0, 1, 2, 1);
        sheet.getHeadMergeManager().mergeBlock(0, 2, 0, 5);
        sheet.getHeadMergeManager().mergeBlock(0, 6, 0, 9);
        sheet.getHeadMergeManager().mergeBlock(1, 2, 1, 5);
        sheet.getHeadMergeManager().mergeBlock(1, 6, 1, 9);
        sheet.setRefresh(true);
        sheet.reLayoutAndPaint();
    }

    protected void initBatchBgschemeTitle(BgAnalyseContrastFilterParam filter, KDTable sheet) {
        if (sheet == null) {
            return;
        }
        String formateString = null;
        String rateString = "0.00%";
        int precision = filter.getCurrency().getPrecision();
        formateString = precision != 0 ? "#,##0." + BgFormHelper.getNumberFormat("0", precision) : "#,##0";
        IRow row = null;
        sheet.checkParsed(true);
        sheet.setRefresh(false);
        sheet.addColumns(10);
        sheet.getColumn(0).setWidth(150);
        sheet.getColumn(1).setWidth(100);
        sheet.getColumn(2).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(2).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(3).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(3).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(4).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(4).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(5).getStyleAttributes().setNumberFormat(rateString);
        sheet.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(6).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(7).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(7).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(8).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(8).getStyleAttributes().setNumberFormat(formateString);
        sheet.getColumn(9).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(9).getStyleAttributes().setNumberFormat(rateString);
        row = sheet.addHeadRow();
        row.getCell(0).setValue((Object)BgAnalyseHelper.getMessage("bgitem"));
        row.getCell(1).setValue((Object)BgAnalyseHelper.getMessage("bgPeriod"));
        row.getCell(2).setValue((Object)BgAnalyseHelper.getMessage("periodAnalyse"));
        row.getCell(6).setValue((Object)BgAnalyseHelper.getMessage("totalAnalyse"));
        row = sheet.addHeadRow();
        row.getCell(2).setValue((Object)((BgElementInfo)filter.getBgElements()[0]).getName());
        row.getCell(6).setValue((Object)((BgElementInfo)filter.getBgElements()[0]).getName());
        row = sheet.addHeadRow();
        row.getCell(2).setValue((Object)filter.getBgSchemes()[0].getName());
        row.getCell(3).setValue((Object)filter.getBgSchemes()[1].getName());
        row.getCell(4).setValue((Object)BgAnalyseHelper.getMessage("budgetDiff"));
        row.getCell(5).setValue((Object)BgAnalyseHelper.getMessage("budgetDiffRate"));
        row.getCell(6).setValue((Object)filter.getBgSchemes()[0].getName());
        row.getCell(7).setValue((Object)filter.getBgSchemes()[1].getName());
        row.getCell(8).setValue((Object)BgAnalyseHelper.getMessage("totalDiff"));
        row.getCell(9).setValue((Object)BgAnalyseHelper.getMessage("totalDiffRate"));
        sheet.getHeadMergeManager().mergeBlock(0, 0, 2, 0);
        sheet.getHeadMergeManager().mergeBlock(0, 1, 2, 1);
        sheet.getHeadMergeManager().mergeBlock(0, 2, 0, 5);
        sheet.getHeadMergeManager().mergeBlock(0, 6, 0, 9);
        sheet.getHeadMergeManager().mergeBlock(1, 2, 1, 5);
        sheet.getHeadMergeManager().mergeBlock(1, 6, 1, 9);
        sheet.setRefresh(true);
        sheet.reLayoutAndPaint();
    }

    protected void executeBudgetVSActual(BgAnalyseContrastFilterParam filter) {
        if (filter == null) {
            return;
        }
        KDTable sheet = null;
        OrgUnitInfo[] orgUnits = null;
        CostCenterOrgUnitInfo ccOrgUnit = null;
        orgUnits = filter.getOrgUnits();
        if (filter.getIsGather()) {
            ccOrgUnit = (CostCenterOrgUnitInfo)orgUnits[0];
            sheet = this.addAnalyseSheet(ccOrgUnit.getId().toString(), BgAnalyseHelper.getMessage("gather") + " - " + ccOrgUnit.getName());
            this.initBudgetVSActualTitle(filter, sheet);
            this.executeBudgetVSActualByGather(filter, sheet, ccOrgUnit.getId().toString());
        } else {
            int in = orgUnits.length;
            for (int i = 0; i < in; ++i) {
                ccOrgUnit = (CostCenterOrgUnitInfo)orgUnits[i];
                sheet = this.addAnalyseSheet(ccOrgUnit.getId().toString(), ccOrgUnit.getName().trim());
                if (i == 0) {
                    this.initBudgetVSActualTitle(filter, sheet);
                    this.executeBudgetVSActualByOrgUnit(ccOrgUnit, filter, sheet);
                    continue;
                }
                this.initBudgetVSActualTitle(filter, sheet);
            }
            this.initTabPaneListener();
        }
    }

    protected void executeBudgetVSActualByOrgUnit(BOSUuid ccOrgUnitId, BgAnalyseContrastFilterParam filter, KDTable sheet) {
        CostCenterOrgUnitInfo ccOrgUnitInfo = null;
        try {
            ccOrgUnitInfo = this.getCCorgUnitInterface().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(ccOrgUnitId));
            this.executeBudgetVSActualByOrgUnit(ccOrgUnitInfo, filter, sheet);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeBudgetVSActualByOrgUnit(CostCenterOrgUnitInfo ccOrgUnitInfo, BgAnalyseContrastFilterParam filter, KDTable sheet) {
        Map dataMap = null;
        try {
            dataMap = this.getAllData(ccOrgUnitInfo, filter);
            this.fillStyleOfSheet(sheet, dataMap, filter);
            this.saveAnlayseInfo(ccOrgUnitInfo.getId(), sheet);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeBudgetVSActualByGather(BgAnalyseContrastFilterParam filter, KDTable sheet, String orgUnitId) {
        Map dataMap = null;
        try {
            dataMap = this.getAllData(filter, orgUnitId);
            this.fillStyleOfSheet(sheet, dataMap, filter);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    protected Map getAllData(CostCenterOrgUnitInfo ccOrgUnitInfo, BgAnalyseContrastFilterParam filter) throws Exception {
        if (ccOrgUnitInfo == null || filter == null) {
            return new HashMap();
        }
        HashMap<String, List> dataMap = new HashMap<String, List>();
        List data = null;
        data = this.getInterface().getContData(ccOrgUnitInfo.getId(), filter);
        dataMap.put(CONT_DATA, data);
        this.getBgItemData(dataMap, data, ccOrgUnitInfo.getId().toString());
        return dataMap;
    }

    protected Map getAllData(BgAnalyseContrastFilterParam filter, String orgUnitId) throws Exception {
        if (filter == null) {
            return new HashMap();
        }
        HashMap<String, List> dataMap = new HashMap<String, List>();
        List data = null;
        data = filter.getAnalyseType() == null || filter.getAnalyseType() == 0 ? this.getInterface().getContData(filter) : this.getInterface().getContBatchData(filter);
        dataMap.put(CONT_DATA, data);
        this.getBgItemData(dataMap, data, orgUnitId);
        return dataMap;
    }

    protected void getBgItemData(Map dataMap, List data, String orgUnitId) throws Exception {
        if (dataMap == null || data == null) {
            return;
        }
        HashMap<String, VisualItemInfo> _bgItemComMap = new HashMap<String, VisualItemInfo>();
        HashMap _tmpBgItemMap = new HashMap();
        HashMap _bgItemMap = null;
        BgAnalyseInfo analyse = null;
        VisualItemInfo visItemInfo = null;
        String bgItemNumber2 = null;
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            analyse = (BgAnalyseInfo)data.get(i);
            bgItemNumber2 = analyse.getBgItemNumber();
            if (_tmpBgItemMap.containsKey(bgItemNumber2)) continue;
            _tmpBgItemMap.put(bgItemNumber2, null);
        }
        try {
            _bgItemMap = BgSHelper.getBgItemsInfo(null, _tmpBgItemMap, null, null, orgUnitId);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            _bgItemMap = new HashMap();
        }
        for (String bgItemNumber2 : _tmpBgItemMap.keySet()) {
            try {
                visItemInfo = BgSHelper.getBgItemCombinInfo(null, bgItemNumber2, _bgItemMap, orgUnitId);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            if (visItemInfo == null) continue;
            _bgItemComMap.put(bgItemNumber2, visItemInfo);
        }
        dataMap.put(BGITEM_PARAM, _bgItemComMap);
        dataMap.put(BGITEMS_PARAM, _bgItemMap);
    }

    protected void fillStyleOfSheet(KDTable sheet, Map dataMap, BgAnalyseContrastFilterParam filter) {
        if (sheet == null || dataMap == null) {
            return;
        }
        List data = null;
        HashMap<String, BgAnalyseContInfo> GatherMap = new HashMap<String, BgAnalyseContInfo>();
        Map _bgItemMap = null;
        BgAnalyseContInfo analyse = null;
        BgAnalyseContInfo gather = null;
        VisualItemInfo visItemInfo = null;
        IRow row = null;
        int bgItemRowIndex = 0;
        String bgItemNumber = null;
        sheet.getStyleAttributes().setLocked(true);
        if (dataMap.containsKey(CONT_DATA)) {
            data = (List)dataMap.get(CONT_DATA);
            _bgItemMap = (Map)dataMap.get(BGITEM_PARAM);
            if (data == null || data.isEmpty()) {
                return;
            }
            int in = data.size();
            for (int i = 0; i < in; ++i) {
                analyse = (BgAnalyseContInfo)data.get(i);
                row = sheet.addRow();
                if (_bgItemMap.containsKey(analyse.getBgItemNumber())) {
                    visItemInfo = (VisualItemInfo)_bgItemMap.get(analyse.getBgItemNumber());
                    row.getCell(0).setValue((Object)visItemInfo.getName());
                } else {
                    row.getCell(0).setValue((Object)analyse.getBgItemNumber());
                }
                row.getCell(0).setUserObject((Object)analyse.getBgItemNumber());
                row.getCell(1).setValue((Object)analyse.getBgPeriodName());
                row.getCell(2).setValue((Object)analyse.getValue());
                row.getCell(3).setValue((Object)analyse.getAValue());
                row.getCell(4).setValue((Object)analyse.getDiffValue());
                row.getCell(5).setValue((Object)analyse.getDiffRate());
                if (GatherMap.containsKey(analyse.getBgItemCombinId())) {
                    gather = (BgAnalyseContInfo)GatherMap.get(analyse.getBgItemCombinId());
                    gather.setValue(gather.getValue().add(analyse.getValue()));
                    gather.setAValue(gather.getAValue().add(analyse.getAValue()));
                } else {
                    gather = new BgAnalyseContInfo();
                    gather.setBgItemCombinId(analyse.getBgItemCombinId());
                    gather.setValue(analyse.getValue());
                    gather.setAValue(analyse.getAValue());
                    GatherMap.put(gather.getBgItemCombinId(), gather);
                }
                row.getCell(6).setValue((Object)gather.getValue());
                row.getCell(7).setValue((Object)gather.getAValue());
                row.getCell(8).setValue((Object)gather.getDiffValue());
                row.getCell(9).setValue((Object)gather.getDiffRate());
                if (bgItemNumber != null) {
                    if (bgItemNumber.equals(analyse.getBgItemNumber())) continue;
                    sheet.getMergeManager().mergeBlock(bgItemRowIndex, 0, row.getRowIndex() - 1, 0);
                    bgItemRowIndex = row.getRowIndex();
                    bgItemNumber = analyse.getBgItemNumber();
                    continue;
                }
                bgItemNumber = analyse.getBgItemNumber();
                bgItemRowIndex = 0;
            }
            if (row != null) {
                sheet.getMergeManager().mergeBlock(bgItemRowIndex, 0, row.getRowIndex(), 0);
            }
        }
    }

    protected void fillBatchSchemeStyleOfSheet(KDTable sheet, Map dataMap, BgAnalyseContrastFilterParam filter) {
        if (sheet == null || dataMap == null) {
            return;
        }
        List data = null;
        HashMap<String, IRow> bgItemRowMap = new HashMap<String, IRow>();
        HashMap<String, BgAnalyseContInfo> GatherMap = new HashMap<String, BgAnalyseContInfo>();
        Map _bgItemMap = null;
        BgAnalyseContInfo analyse = null;
        BgAnalyseContInfo gather = null;
        BgAnalyseContInfo tmp = new BgAnalyseContInfo();
        VisualItemInfo visItemInfo = null;
        IRow row = null;
        int bgItemRowIndex = 0;
        String bgItemNumber = null;
        sheet.getStyleAttributes().setLocked(true);
        if (dataMap.containsKey(CONT_DATA)) {
            data = (List)dataMap.get(CONT_DATA);
            _bgItemMap = (Map)dataMap.get(BGITEM_PARAM);
            if (data == null || data.isEmpty()) {
                return;
            }
            String bgSchemeOneId = filter.getBgSchemes()[0].getId().toString();
            String bgSchemeTwoId = filter.getBgSchemes()[1].getId().toString();
            int in = data.size();
            for (int i = 0; i < in; ++i) {
                analyse = (BgAnalyseContInfo)data.get(i);
                if (!bgItemRowMap.containsKey(analyse.getBgItemNumber() + "_" + analyse.getBgPeriodId())) {
                    row = sheet.addRow();
                    if (_bgItemMap.containsKey(analyse.getBgItemNumber())) {
                        visItemInfo = (VisualItemInfo)_bgItemMap.get(analyse.getBgItemNumber());
                        row.getCell(0).setValue((Object)visItemInfo.getName());
                    } else {
                        row.getCell(0).setValue((Object)analyse.getBgItemNumber());
                    }
                    row.getCell(0).setUserObject((Object)analyse.getBgItemNumber());
                    row.getCell(1).setValue((Object)analyse.getBgPeriodName());
                    if (bgSchemeOneId.equals(analyse.getBgSchemeId())) {
                        row.getCell(2).setValue((Object)analyse.getValue());
                    } else if (bgSchemeTwoId.equals(analyse.getBgSchemeId())) {
                        row.getCell(3).setValue((Object)analyse.getValue());
                    }
                    row.getCell(4).setValue((Object)analyse.getDiffValue());
                    row.getCell(5).setValue((Object)analyse.getDiffRate());
                    if (GatherMap.containsKey(analyse.getBgSchemeId() + "_" + analyse.getBgItemCombinId())) {
                        gather = (BgAnalyseContInfo)GatherMap.get(analyse.getBgSchemeId() + "_" + analyse.getBgItemCombinId());
                        gather.setValue(gather.getValue().add(analyse.getValue()));
                    } else {
                        gather = new BgAnalyseContInfo();
                        gather.setBgSchemeId(analyse.getBgSchemeId());
                        gather.setBgItemCombinId(analyse.getBgItemCombinId());
                        gather.setValue(analyse.getValue());
                        gather.setAValue(BgConstants.BIGZERO);
                        GatherMap.put(analyse.getBgSchemeId() + "_" + gather.getBgItemCombinId(), gather);
                    }
                    if (bgSchemeOneId.equals(analyse.getBgSchemeId())) {
                        row.getCell(6).setValue((Object)gather.getValue());
                        row.getCell(8).setValue((Object)gather.getDiffValue());
                        row.getCell(9).setValue((Object)BgConstants.ONE);
                    } else if (bgSchemeTwoId.equals(analyse.getBgSchemeId())) {
                        row.getCell(7).setValue((Object)gather.getValue());
                    }
                    if (bgItemNumber != null) {
                        if (!bgItemNumber.equals(analyse.getBgItemNumber())) {
                            sheet.getMergeManager().mergeBlock(bgItemRowIndex, 0, row.getRowIndex() - 1, 0);
                            bgItemRowIndex = row.getRowIndex();
                            bgItemNumber = analyse.getBgItemNumber();
                        }
                    } else {
                        bgItemNumber = analyse.getBgItemNumber();
                        bgItemRowIndex = 0;
                    }
                    bgItemRowMap.put(analyse.getBgItemNumber() + "_" + analyse.getBgPeriodId(), row);
                    continue;
                }
                row = (IRow)bgItemRowMap.get(analyse.getBgItemNumber() + "_" + analyse.getBgPeriodId());
                if (bgSchemeOneId.equals(analyse.getBgSchemeId())) {
                    row.getCell(2).setValue((Object)analyse.getValue());
                    if (row.getCell(3).getValue() != null) {
                        tmp.setValue(analyse.getValue());
                        tmp.setAValue((BigDecimal)row.getCell(3).getValue());
                        row.getCell(4).setValue((Object)tmp.getDiffValue());
                        row.getCell(5).setValue((Object)tmp.getDiffRate());
                    }
                } else if (bgSchemeTwoId.equals(analyse.getBgSchemeId())) {
                    row.getCell(3).setValue((Object)analyse.getValue());
                    if (row.getCell(2).getValue() != null) {
                        tmp.setValue((BigDecimal)row.getCell(2).getValue());
                        tmp.setAValue(analyse.getValue());
                        row.getCell(4).setValue((Object)tmp.getDiffValue());
                        row.getCell(5).setValue((Object)tmp.getDiffRate());
                    }
                }
                if (GatherMap.containsKey(analyse.getBgSchemeId() + "_" + analyse.getBgItemCombinId())) {
                    gather = (BgAnalyseContInfo)GatherMap.get(analyse.getBgSchemeId() + "_" + analyse.getBgItemCombinId());
                    gather.setValue(gather.getValue().add(analyse.getValue()));
                } else {
                    gather = new BgAnalyseContInfo();
                    gather.setBgSchemeId(analyse.getBgSchemeId());
                    gather.setBgItemCombinId(analyse.getBgItemCombinId());
                    gather.setValue(analyse.getValue());
                    GatherMap.put(analyse.getBgSchemeId() + "_" + gather.getBgItemCombinId(), gather);
                }
                if (bgSchemeOneId.equals(gather.getBgSchemeId())) {
                    row.getCell(6).setValue((Object)gather.getValue());
                    if (row.getCell(7).getValue() == null) continue;
                    tmp.setValue(gather.getValue());
                    tmp.setAValue((BigDecimal)row.getCell(7).getValue());
                    row.getCell(8).setValue((Object)tmp.getDiffValue());
                    row.getCell(9).setValue((Object)tmp.getDiffRate());
                    continue;
                }
                if (!bgSchemeTwoId.equals(gather.getBgSchemeId())) continue;
                row.getCell(7).setValue((Object)gather.getValue());
                if (row.getCell(6).getValue() == null) continue;
                tmp.setValue((BigDecimal)row.getCell(2).getValue());
                tmp.setAValue(gather.getValue());
                row.getCell(8).setValue((Object)tmp.getDiffValue());
                row.getCell(9).setValue((Object)tmp.getDiffRate());
            }
            if (row != null) {
                sheet.getMergeManager().mergeBlock(bgItemRowIndex, 0, row.getRowIndex(), 0);
            }
        }
    }

    protected void saveAnlayseInfo(BOSUuid orgUnitId, KDTable sheet) {
        if (sheet == null) {
            return;
        }
        byte[] bytes = null;
        KDF kdf = new KDF();
        kdf.addTable((IDObject)sheet);
        Random random = new Random();
        DecimalFormat df = new DecimalFormat("0000000");
        String filename = System.getProperty("user.dir") + "/BgContAnlay" + df.format(random.nextInt(999999)) + ".kdf";
        try {
            bytes = ZipKDF.pack((KDF)kdf);
            if (BgAnalyseHelper.saveToFile(filename, bytes, 4096)) {
                this.getFileMap().put(orgUnitId.toString(), filename);
            }
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
    }

    protected void loadAnalyseInfo(String sheetId, KDTable sheet) {
        String filename = (String)this.fileMap.get(sheetId);
        byte[] bytes = BgAnalyseHelper.loadFormFile(filename);
        KDF kdf = null;
        KDTable tmpSheet = null;
        if (bytes != null && bytes.length > 0) {
            try {
                kdf = ZipKDF.unpack((byte[])bytes);
                if (kdf.getAllTable().size() > 0) {
                    tmpSheet = (KDTable)kdf.getTableByIndex(0);
                    this.loadStyleFormSheet(sheet, tmpSheet);
                }
                kdf = null;
            }
            catch (Exception ex) {
                this.handUIExceptionAndAbort(ex);
            }
        }
    }

    protected void loadStyleFormSheet(KDTable tSheet, KDTable fSheet) {
        if (tSheet == null || fSheet == null) {
            return;
        }
        ICell tCell = null;
        ICell fCell = null;
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = fSheet.getExpandedRowCount();
        int colCount = fSheet.getExpandedColumnCount();
        tSheet.setRefresh(false);
        tSheet.addRows(rowCount);
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                tCell = tSheet.getCell(rowIndex, colIndex);
                fCell = fSheet.getCell(rowIndex, colIndex);
                if (tCell == null || fCell == null) continue;
                tCell.setValue(fCell.getValue());
                tCell.getStyleAttributes().setNumberFormat(fCell.getStyleAttributes().getNumberFormat());
            }
        }
        if (fSheet.getMergeManager().getMergeBlockList() != null) {
            KDTMergeBlock mergeBlock = null;
            List mergeList = fSheet.getMergeManager().getMergeBlockList();
            int in = mergeList.size();
            for (int i = 0; i < in; ++i) {
                mergeBlock = (KDTMergeBlock)mergeList.get(i);
                tSheet.getMergeManager().mergeBlock(mergeBlock.getTop(), mergeBlock.getLeft(), mergeBlock.getBottom(), mergeBlock.getRight());
            }
        }
        tSheet.setRefresh(true);
        tSheet.reLayoutAndPaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeBatchBgscheme(BgAnalyseContrastFilterParam filter) {
        if (filter == null) {
            return;
        }
        Map dataMap = null;
        KDTable sheet = null;
        OrgUnitInfo ccOrgUnit = null;
        try {
            ccOrgUnit = filter.getOrgUnits()[0];
            sheet = this.addAnalyseSheet(ccOrgUnit.getId().toString(), ccOrgUnit.getName());
            dataMap = this.getAllData(filter, ccOrgUnit.getId().toString());
            this.initBatchBgschemeTitle(filter, sheet);
            this.fillBatchSchemeStyleOfSheet(sheet, dataMap, filter);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    @Override
    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if ((colIndex >= 2 && colIndex <= 4 || colIndex >= 6 && colIndex <= 8) && this.defMeasureUnit != null && value != null) {
            Object obj = null;
            BigDecimal tmpValue = null;
            try {
                tmpValue = new BigDecimal(value.toString().trim().replaceAll(",", ""));
                tmpValue = tmpValue.divide(this.defMeasureUnit, this.decimal, 4);
                obj = this.decFormat.format(tmpValue.doubleValue());
            }
            catch (Exception ex) {
                obj = value;
            }
            return obj;
        }
        return super.formatCellDisplay(rowIndex, colIndex, cell, value);
    }

    @Override
    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            BgAnalyseHelper.clearAllFile(this.fileMap);
        }
        return re;
    }
}

