/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseMainBaseUI;
import com.kingdee.eas.ma.budget.client.BgTendencyAnalysisFilter2UI;
import com.kingdee.eas.ma.budget.client.BgTendencyAnalysisFilterUI;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnalysisFilterUI;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnaylsisFilter2UI;
import com.kingdee.eas.ma.nbudget.BgCustomerParamsFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.IBgCustomerParamsFacade;
import com.kingdee.eas.ma.nbudget.client.BgCombinDataFilter2UI;
import com.kingdee.eas.ma.nbudget.client.BgCombinDataFilterUI;
import com.kingdee.eas.ma.nbudget.client.BgDataAnalyseForSpecialFilter2UI;
import com.kingdee.eas.ma.nbudget.client.BgDataAnalyseForSpecialFilterUI;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;

public class BgAnalyseFilterBaseUI
extends AbstractBgAnalyseFilterBaseUI {
    private static final long serialVersionUID = 895655141851028953L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseFilterBaseUI.class);
    protected Object ui = null;
    private final String NEW_SCHEME_KEY = "NEW_SCHEME_KEY";

    public BgAnalyseFilterBaseUI() throws Exception {
    }

    public BgAnalyseFilterBaseUI(Object ui) throws Exception {
        this.ui = ui;
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public String getUITitle() {
        return BgAnalyseHelper.getMessage("filterTitle");
    }

    public void clear() {
        super.clear();
    }

    protected boolean hasNewScheme() {
        return false;
    }

    private String getNEW_SCHEME_KEY() {
        return "NEW_SCHEME_KEY";
    }

    public CustomerParams getCustomerParams() {
        String crtClsName;
        CustomerParams cp = super.getCustomerParams();
        if (cp == null) {
            cp = new CustomerParams();
        }
        if ((crtClsName = this.getMetaDataPK().getFullName()).equals(NewBgCompareAndAnalysisFilterUI.class.getName()) || crtClsName.equals(NewBgCompareAndAnaylsisFilter2UI.class.getName()) || crtClsName.equals(BgTendencyAnalysisFilterUI.class.getName()) || crtClsName.equals(BgTendencyAnalysisFilter2UI.class.getName()) || crtClsName.equals(BgCombinDataFilterUI.class.getName()) || crtClsName.equals(BgCombinDataFilter2UI.class.getName()) || crtClsName.equals(BgDataAnalyseForSpecialFilterUI.class.getName()) || crtClsName.equals(BgDataAnalyseForSpecialFilter2UI.class.getName())) {
            return cp;
        }
        if (this.hasNewScheme()) {
            FilterParam filterParam = this.createNewFilterParam();
            this.setFilterParam(filterParam);
            if (this.ui != null && this.ui instanceof BgAnalyseMainBaseUI) {
                filterParam = this.getFilterParam(((BgAnalyseMainBaseUI)((Object)this.ui)).getFilterParam(), filterParam);
            }
            this.saveCustomerParams(cp, filterParam);
        } else {
            FilterParam filterParam = null;
            filterParam = cp.getCustomerParam("FILTERPARAM") == null ? this.createNewFilterParam() : (FilterParam)this.getFilterObject(cp);
            if (this.ui != null && this.ui instanceof BgAnalyseMainBaseUI) {
                filterParam = this.getFilterParam(((BgAnalyseMainBaseUI)((Object)this.ui)).getFilterParam(), filterParam);
            }
            if (filterParam == null) {
                filterParam = this.createNewFilterParam();
            }
            this.setFilterParam(filterParam);
            this.setFilterObject(cp, filterParam);
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        if (this.hasNewScheme() && cp.getBoolean(this.getNEW_SCHEME_KEY())) {
            FilterParam filterParam = this.createNewFilterParam();
            if (filterParam != null) {
                this.loadCustomerParams(cp, filterParam);
                filterParam = this.loadFilterParam(filterParam);
                this.getFilterParam(filterParam);
            }
        } else if (cp.getCustomerParam("FILTERPARAM") != null) {
            FilterParam filterParam = (FilterParam)this.getFilterObject(cp);
            this.getFilterParam(filterParam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFilterObject(CustomerParams cp, String key) {
        if (cp == null) {
            return null;
        }
        if (this.hasNewScheme() && cp.getBoolean(this.getNEW_SCHEME_KEY())) {
            FilterParam filterParam = this.createNewFilterParam();
            this.loadCustomerParams(cp, filterParam);
            filterParam = this.loadFilterParam(filterParam);
            return filterParam;
        }
        FilterParam param = null;
        String objStr = null;
        objStr = key == null || key.length() == 0 ? cp.getCustomerParam("FILTERPARAM") : cp.getCustomerParam(key);
        if (objStr == null) {
            return null;
        }
        byte[] objByte = Base64.decode((String)objStr);
        if (objByte == null || objByte.length == 0) {
            return null;
        }
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])objByte);
            bais = new ObjectInputStream(is);
            param = (FilterParam)bais.readObject();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return param;
    }

    public Object getFilterObject(CustomerParams cp) {
        return this.getFilterObject(cp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterObject(CustomerParams cp, Object param, String key) {
        if (cp == null || param == null) {
            return;
        }
        byte[] objByte = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(param);
            objByte = ZipUtil.pack((ByteArrayOutputStream)baos);
        }
        catch (IOException iOException) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!StringUtils.isEmpty((String)key)) {
            cp.addCustomerParam(key, Base64.encodeBytes(objByte));
        } else {
            cp.addCustomerParam("FILTERPARAM", Base64.encodeBytes(objByte));
        }
    }

    public void setFilterObject(CustomerParams cp, Object param) {
        this.setFilterObject(cp, param, null);
    }

    protected void setFilterParam(FilterParam filterParam) {
    }

    protected void getFilterParam(FilterParam filterParam) {
    }

    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        return null;
    }

    protected FilterParam createNewFilterParam() {
        return null;
    }

    protected void saveFilterParam(CustomerParams cp) {
    }

    protected IBgAnalyseFacade getInterface() throws Exception {
        return BgAnalyseFacadeFactory.getRemoteInstance();
    }

    protected IBgCustomerParamsFacade getCPInterface() throws Exception {
        return BgCustomerParamsFacadeFactory.getRemoteInstance();
    }

    protected FilterParam loadFilterParam(FilterParam filterParam) {
        try {
            filterParam = this.getCPInterface().loadCustomerParams(filterParam);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
        return filterParam;
    }

    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
    }

    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        if (cp != null) {
            cp.addCustomerParam(this.getNEW_SCHEME_KEY(), BgNConstants.TRUE_STE);
        }
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.removeNotify();
        }
        return re;
    }
}

